﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices;  // for DllImport

namespace fusen
{
    public partial class MainForm : Form
    {
        private IFusenStore fusenStore;
        private IFusenLog fusenLog;

        public MainForm(IFusenStore fusenStore, IFusenLog fusenLog)
        {
            InitializeComponent();
            this.fusenStore = fusenStore;
            this.fusenLog = fusenLog;
        }

        private void MainForm_Load(object sender, EventArgs e)
        {
            this.Size = new Size(0, 0);
            this.Visible = false;

            fusenLoad();
        }

        private void notifyIcon_Click(object sender, EventArgs e)
        {
            if (((MouseEventArgs)e).Button == MouseButtons.Left)
                this.Activate();
        }

        private void 新規NToolStripMenuItem_Click(object sender, EventArgs e)
        {
            FusenForm fusen = new FusenForm(fusenLog, writeFusen);
            fusen.Show();
            this.AddOwnedForm(fusen);
            fusen.Activate();
        }

        private void 終了XToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        [DllImport("user32.dll")]
        extern static IntPtr GetWindow(IntPtr hWnd, uint uCmd);

        [DllImport("user32.dll")]
        extern static IntPtr GetForegroundWindow();

        private void writeFusen()
        {
            List<FusenForm> fusenFormList = new List<FusenForm>();
            const int GW_HWNDNEXT = 2;
            IntPtr hwnd = GetForegroundWindow();
            while (hwnd != IntPtr.Zero) {
                FusenForm f = (FusenForm)this.OwnedForms.FirstOrDefault(e => e.Handle == hwnd);
                if (f != null)
                    fusenFormList.Add(f);
                hwnd = GetWindow(hwnd, GW_HWNDNEXT);
            }

            List<Fusen> fusenList = new List<Fusen>();
            foreach (FusenForm fusenForm in fusenFormList) {
                Fusen fusen = new Fusen();
                fusen.Text = fusenForm.getMemo();
                fusen.Left = fusenForm.Left;
                fusen.Top = fusenForm.Top;
                fusen.Width = fusenForm.Width;
                fusen.Height = fusenForm.Height;
                fusenList.Add(fusen);
            }
            fusenStore.Save(fusenList);
        }

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            writeFusen();
        }

        private void fusenLoad()
        {
            IList<Fusen> fusenList = fusenStore.Load();
            foreach (Fusen fusen in fusenList.Reverse()) {
                FusenForm fusenForm = new FusenForm(fusenLog, writeFusen);
                fusenForm.Show();
                fusenForm.setMemo(fusen.Text);
                fusenForm.Left = fusen.Left;
                fusenForm.Top = fusen.Top;
                fusenForm.Width = fusen.Width;
                fusenForm.Height = fusen.Height;
                this.AddOwnedForm(fusenForm);
            }
        }

        private void ログ表示LToolStripMenuItem_Click(object sender, EventArgs e)
        {
            fusenLog.ShowLog();
        }

    }
}
