﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace fusen
{
    public interface IFusenPath
    {
        string DataFolder { get; }
        string FusenFilename { get; }
        string FusenLogFilename { get; }
    }

    class FusenPath : IFusenPath
    {
        private const string AppDataFolder = "KKFusen";
        private const string DataFilename = "fusen.dat";
        private const string LogFilename = "fusenLog.txt";

        public string DataFolder
        {
            get
            {
                string folder = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData);
                return Path.Combine(folder, AppDataFolder);
            }
        }

        public string FusenFilename
        {
            get
            {
                return Path.Combine(DataFolder, DataFilename);
            }
        }

        public string FusenLogFilename
        {
            get
            {
                return Path.Combine(DataFolder, LogFilename);
            }
        }
    }
}
