package jp.kirikiri.tvp2.visual;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.env.NativeImageBuffer;
import jp.kirikiri.tvp2.msg.Message;

public class ScanLineProviderForBaseBitmap implements ScanLineProvider {
	private boolean mOwn;
	BaseBitmap mBitmap;

	public ScanLineProviderForBaseBitmap( BaseBitmap bmp ) {
		this(bmp,false);
	}
	public ScanLineProviderForBaseBitmap( BaseBitmap bmp, boolean own ) {
		mOwn = own;
		mBitmap = bmp;
	}

	/**
	 * attach bitmap
	 * @param bmp
	 */
	public void attach( BaseBitmap bmp ) {
		mBitmap = bmp;
	}
	@Override
	public int getWidth() {
		return mBitmap.getWidth();
	}

	@Override
	public int getHeight() {
		return mBitmap.getHeight();
	}

	@Override
	public int getPixelFormat() {
		return mBitmap.getBPP();
	}

	@Override
	public int getPitchBytes() {
		return mBitmap.getPitchBytes();
	}

	@Override
	public NativeImageBuffer getScanLine() {
		return mBitmap.getBitmap();
	}

	@Override
	public NativeImageBuffer getScanLineForWrite() {
		mBitmap.independ();
		return mBitmap.getBitmap();
	}
	@Override
	public void copyFrom(ScanLineProvider src) throws TJSException {
		if( src instanceof ScanLineProviderForBaseBitmap ) {
			ScanLineProviderForBaseBitmap s = (ScanLineProviderForBaseBitmap)src;
			mBitmap = s.mBitmap;
			mOwn = s.mOwn;
		} else {
			Message.throwExceptionMessage(Message.InternalError);
		}
	}
}
