///@brief Lua̎xNXȂ
///@date 2011/03/01 09:53:40()
#ifndef KFX_LUASCRIPT_H
#define KFX_LUASCRIPT_H
#include"../kernel/pointer/scoped_ptr.h"
struct lua_State;

namespace KFX{
///LuabsOĂ邾
///NXB
///lua_StateێƂ̂
///ʓ|ȂߍNX
///ɎgȂ΂ȂȂ킯łȂ

///LuaX^bNċ@\oĂ
class KLuaStack{
	private:
		lua_State* _state;
	public:
		KLuaStack(lua_State* state):_state(state){}
		
		///X^bN菜
		///@param num 菜X^bN̐
		///@remarks 菜̃ftHg͂P
		void Pop(int num=1);
		
		///X^bNgbvɏ悹
		///@param strX^bNgbvɏ悹镶
		void Push(const char* str="");

		///X^bNgbṽCfNXԂ
		///@retval X^bNgbvCfbNX
		///@note ̒l̓X^bNɂ܂Ăvf̐ɓ
		///܂A̒lOȂ΃X^bN͋ł
		int GetTop();

};

///LuaXNvgւ̑
///lua_Stateێ̂ʓ|Ȃ̂ŃNXɂ
///@remarks ̃IuWFNg͐邽тLuaIuWFNg
///@note O[oϐLXbhASStateL
///߂̎dg݂Ȃ΂ȂȂȂ
class KLuaScript{
	private:
		lua_State* _state;
		ScopedPtr<KLuaStack> _stack;
	public:
		KLuaScript(const wchar_t* path);
		KLuaStack& Stack() const{return *_stack;}
		///X^bN
		///@param numOfArgs ̐
		///@param numOfResults ߂l̐
		void Call(int numOfArgs=0,int numOfResults=0);
		
		

		///w肵CfNX̒l𐮐^ƂĕԂ
		///@param idx lقCfNX
		///@retval ̏ꏊɂl(l)
		///@remarks ftHg̓X^bNgbvl
		int ToInteger(int idx=-1);
		
		///w肵CfNX̒l𕶎ƂĕԂ
		///@param idx lm肽X^bNCfNX
		///@remarks ftHg̓X^bNgbvl 
		const char* ToString(int idx=-1);

		bool ToBoolean(int idx=-1);

		///e[ulo
		///@param name ʖ
		///@param idx oe[uID
		///@remarks ftHgłidxLUA_GLOBALSINDEXƂȂĂB
		void GetField(const char* name);
		void GetField(const char* name , int idx);


};

}//end of namespace KFX
#endif
