﻿///@brief
///@author ryu
///@date 2011/03/15 11:37:48(火)
///@note 64ビット整数は・・・いらねぇだろ。必要になったら作ります。
#ifndef KFX_ATOMIC_H
#define KFX_ATOMIC_H
#include"../../type/KFXType.h"
namespace KFX{


///整数型アトミック
class KAtomicInt{
	private:
		volatile Sint32_t _value;
	public:
		///@note とりあえず当面必要っぽい演算のみ定義。
		///必要になったらあとで作る
		void operator=(Sint32_t value);
		bool operator==(Sint32_t value)const;
		Sint32_t operator+(Sint32_t value);
		Sint32_t operator+=(Sint32_t value);
		Sint32_t operator++();//全置インクリメント
		Sint32_t operator++(int);//後置インクリメント
		Sint32_t operator-(Sint32_t value);
		Sint32_t operator-=(Sint32_t value);
		Sint32_t operator--();//全置インクリメント
		Sint32_t operator--(int);//後置インクリメント
		
};
///これもポインタ交換命令のstatic関数セット
class KAtomicVoidPtr{
public:
	///スレッドセーフにポインタを交換する
	///@param target 交換先ポインタへのポインタ
	///@param value 代入したいポインタ値
	///@return 交換前のtarget値が返される
	static void* Exchange(void** target,void* value);

	///スレッドセーフにポインタを交換する
	///@param target 交換先ポインタへのポインタ
	///@param value 代入したいポインタ値
	///@param compare 比較ポインタ値
	///@return 交換前のtarget値が返される
	///@remarks targetポインタの値がcompareの値と等しい場合にのみ交換を行う
	static void* CompareExchange(void** target,void* value,void* compare);
};

///アトミック操作できるポインタ型
template<typename T>
class KAtomicPtr{
private:
	volatile T* _ptr;
public:
	KAtomicPtr(){
	}
	KAtomicPtr(T* ptr){
		KAtomicVoidPtr::Exchange(&_ptr,ptr);
	}
	KAtomicPtr(const KAtomicPtr<T>& copy){
		KAtomicVoidPtr::Exchange(&_ptr,copy.Get());
	}
	KAtomicPtr& operator=(const KAtomicPtr<T>& val){
		KAtomicVoidPtr::Exchange(&_ptr,val);
		return *this;
	}
	void operator=(T* val){
		KAtomicVoidPtr::Exchange(&_ptr,val);
	}
	T* Get(){
		return _ptr;
	}
};
}//end of namespace KFX
#endif
