﻿///@brief
///@author ryu
///@date 2011/03/15 11:37:48(火)

#include"atomic.h"
#include<Windows.h>
namespace KFX{

void 
KAtomicInt::operator=(Sint32_t value){
	::InterlockedExchange(&_value,value);
}
bool 
KAtomicInt::operator==(Sint32_t value)const{
	return value==_value;
}


Sint32_t
KAtomicInt::operator+=(Sint32_t value){
	return ::InterlockedExchangeAdd(&_value,value);
}

Sint32_t 
KAtomicInt::operator++(){
	//インクリメント後の値を返す
	return ::InterlockedIncrement(&_value);
}

Sint32_t
KAtomicInt::operator++(int){
	//インクリメント前の値を返す
	return ::InterlockedExchangeAdd(&_value,1);
}


Sint32_t 
KAtomicInt::operator-=(Sint32_t value){
	return ::InterlockedExchangeAdd(&_value,-value);
}

Sint32_t
KAtomicInt::operator--(){
	return ::InterlockedDecrement(&_value);
}

Sint32_t
KAtomicInt::operator--(int){
	return ::InterlockedExchangeAdd(&_value,-1);
}
		

void* 
KAtomicVoidPtr::Exchange(void** target,void* value){
	return InterlockedExchangePointer(target,value);
}

void*
KAtomicVoidPtr::CompareExchange(void** target,void* value,void* compare){
	return ::InterlockedCompareExchangePointer(target,value,compare);
}


}//end of namespace KFX
