﻿#include"file.h"
#include<windows.h>
namespace KFX{

///IFileのWindows実装
///こいつはブロックリード
class KReaderWindowsBlock : public IResourceReader{
	private:
		HANDLE _hFile;//Windowsファイルシステムにおけるファイルハンドル
		bool _isAvailable;
	public:
		KReaderWindowsBlock(HANDLE hFile );

		long long FileSize()const;
		
		//読み込みリクエスト
		bool Request(void* address,long long reqSize, size_t& actualSize);
	
		//スレッドに乗せないので、特に何もしない
		TaskResult Execute();
		
		//ブロックリードなので、常にtrue
		bool IsAvailable() const{return true;};
};

KReaderWindowsBlock::KReaderWindowsBlock(HANDLE hFile):_hFile(hFile){
}

bool
KReaderWindowsBlock::Request(void* address,long long reqSize, size_t& actualSize){
	DWORD retsize;
	bool result = (::ReadFile(_hFile,
				address,
				static_cast<DWORD>(reqSize),
				&retsize,
				NULL)==TRUE);
	if( result ){
		actualSize = retsize;
		//エラー時処理
	}
	return result;
}

long long 
KReaderWindowsBlock::FileSize()const{
	LARGE_INTEGER li;
	::GetFileSizeEx(_hFile,&li);
	return li.QuadPart;
}

TaskResult
KReaderWindowsBlock::Execute(){
	return TR_SUCCEEDED;
}

KResourceReaderProvider& 
KResourceReaderProvider::Instance(){
	class KResourceReaderProviderImpl : public KResourceReaderProvider{
		private:
		public:
			IResourceReader* Create(const wchar_t* path,bool async,IFileListener* listener){
				HANDLE hFile = ::CreateFile(path,
					GENERIC_READ,
					FILE_SHARE_READ,
					NULL,
					OPEN_EXISTING,
					FILE_ATTRIBUTE_NORMAL,
					NULL);
				if( hFile==INVALID_HANDLE_VALUE){
					return NULL;
				}else{
					return new KReaderWindowsBlock(hFile);
				}
			}
	};
	static KResourceReaderProviderImpl instance;
	return instance;
}

}//end of namespace KFX
