﻿///@brief
///@author
///@date 2011/03/14 15:55:25(月)
#ifndef KFX_GAME_INPUT_H
#define KFX_GAME_INPUT_H
#include<vector>
#include"peripheral.h"
#include"../kernel/pointer/shared_ptr.h"
namespace KFX{


///ゲーム入力を管理する
class GameInput{
	private:
		std::vector<SharedPtr<IPeripheral> >& _peripherals;
		GameInput();
		GameInput(const GameInput&);
		GameInput& operator=(const GameInput&);
	public:
		static GameInput& Instance();

		///@param id 入力機器ID
		///@param listener 入力とバインドしたいオブジェクト
		void AddListener(int id,KInputListener* listener);
		void RemoveListener(KInputListener* listener);

		///持っている入力機器を全巡回する
		///これはゲーム側(クライアント側)から呼び出される
		void Update();
	
		///管理中の周辺機器数
		unsigned int PeripheralsNum() const;
	
		///参加表明機器数
		unsigned int EntriedPeripheralsNum() const;
};
}//end of namespace KFX
#endif
