﻿#include"animation_mesh_object.h"
#include<d3dx9mesh.h>
#include<vector>
#include"../../kernel/device/device_wrapper.h"
#include"../../debugutil/debugconsole.h"
#include"../texture.h"
namespace KFX{

//2011/12/30追記
//★明らかにスキンメッシュ間違ってるので、来年にかけて書き直す★
	
//SkinnedMeshサンプルでは、D3DXFRAMEをそのまま使用するのではなく、これから派生したD3DXFRAME_DERIVEDを使用している。
//単にConbinedMatrixを追加しているだけだが、なるほどここに合成後のマトリクスを入れておけば管理も楽である。
//合成後マトリクスは、AnimationMeshObjectD3D::DrawFrameHierarchyにて再帰的に変換され、
//最終的にワールド座標にとして表現される。
///カスタムD3DXFRAME構造体
///@note ちなみにD3DXLoadMeshHierarchyを使う際に「D3DXFRAMEから継承したクラスを使う」ってな作法は
///MSのサンプルでもそうだし「げーむつくろー」や海外のガイドブック等を見てもそういうやり方
///なので、スタンダードな手法なんだと思われる。
struct Bone : public D3DXFRAME{
	D3DXMATRIXA16 combinedMatrix;//合成行列
};

///カスタムD3DXFRAME構造体
struct BoneMesh : public D3DXMESHCONTAINER{
	ID3DXMesh* originalMesh;
	std::vector<D3DMATERIAL9> materials;
	std::vector<IDirect3DTexture9*> textures;
	DWORD numAttributeGroups;
	D3DXATTRIBUTERANGE* attributeTable;
	D3DXMATRIX** boneMatrixPtrs;
	D3DXMATRIX* boneOffsetMatrices;
	D3DXMATRIX* currentBoneMatrices;
	std::vector<Bone*> frames;
};

//アニメーションメッシュをロードするには、D3DXLoadMeshHierarchyFromXってな関数を使えばいいのだけど
//なにぶん、Direct３Dのヘルプにはこう書いてある。
//
//「ID3DXAllocateHierarchy は、このような割り当てと割り当て解除の関数のアプリケーションでの定義方法を記述するインターフェイスです。
//このインターフェイスを使用するには、まずアプリケーションで ID3DXAllocateHierarchy から派生したクラスを定義する必要があります」
//
//だとさ
//仕方ないので、実装クラスを定義する。
///メッシュコンテナオブジェクトの割り当て、解放を行うID3DXAllocateHierarchyの実装
///@note CreateFrame,CreateMeshContainer,DestroyFrame,DestroyMeshContainerが純粋仮想なので
///かならず実装する必要があるっぽい。
class BoneHierarchyLoader : public ID3DXAllocateHierarchy{
public:
	//ヘルプにはHRESULT CreateFrameと書いてあるが、それだと戻り値の型が違うのでコンパイルエラーが出る。
	//なんかムカつくけど、__declspecおよび__stdcallが必要っぽい
	//ちなみに書いておくと、__declspecは、Microsoft独自の拡張属性を定義する構文であって、
	//__declspec(nothrow)だと、呼び出し元に例外を伝播しないという約束事になる。つまりこの関数内で例外を発生させんなってことを
	//暗に約束させられていると思う。
	//そして、__stdcallもMicrosoft構文で、WIN32 APIの呼び出し規約で、スタックの解放を呼ばれた側が行いますよってこと
	//このように、基底クラスがいろんなことを約束させる使用になっている。
	//恐らくは、Direct3DのDLL側から呼ばれるメソッドだからだと考えられる。深く考えてはいけない。
	//本当はMSのD3Dのサンプルでは STDMETHOD( CreateFrame )( THIS_ LPCSTR Name, LPD3DXFRAME *ppNewFrame );
	//などとマクロ定義されているが、これだと「え？なにこれ関数宣言なの？」と混乱する可能性があるのであえて展開しておいた。
	//
	//そして実装なんだけど、大したことする必要もなく…なんでこれをクライアントに実装させるのかの理由がよくわからない。
	//
	//説明のためにD3DXFRAME構造体をここにコピっとく
	//struct  D3DXFRAME{
	//	LPSTR                   Name;
	//	D3DXMATRIX              TransformationMatrix;
	//	LPD3DXMESHCONTAINER     pMeshContainer;
	//	struct _D3DXFRAME       *pFrameSibling;
	//	struct _D3DXFRAME       *pFrameFirstChild;
	//}
	//
	//NameはCreateFrameの第一引数をあてときゃいい。pMeshContainerの中身はCreateMeshContainerで入れるのでCreateFrameで
	//入れる必要もないし、入れてはいけない。
	//兄弟や子ノードに関しては、Xファイルをパースする際に勝手に割り当てられるので、設定しない。
	//SkinnedMeshサンプルでは独自のD3DXFRAME_DERIVEDを定義してそれを返しているが
	//これは継承する必要はない(つまりD3DXFRAMEのままでいい)と考えている。必要になったらやればいい。

	///フレームオブジェクトを生成して返す
	///@param name 作成するフレームの名前
	///@param [out]frame 作成されたフレームオブジェクト
	///@note これがD3D_OK以外を返せば当然D3DXLoadMeshHierarchyFromXもエラーを返す。
	///つまるところ、この関数はframeオブジェクトを生成して返すことを期待されている。対応するのがDestroyFrameであろう。
	///と考えると要はframeをnewして名前つけて返せばいい。
	virtual __declspec(nothrow) HRESULT _stdcall CreateFrame(LPCSTR name, LPD3DXFRAME* frame){
		if(name==NULL){
			frame=NULL;
			return D3DERR_INVALIDCALL;
		}
		Bone* ret=new Bone();//生成して
		if(ret==NULL){
			frame=NULL;
			return E_OUTOFMEMORY;
		}
		memset(ret,0,sizeof(*ret));
		//ret->Name=nameとやりたいところだが、引数のnameは別のスコープで管理されてる
		//寿命の分からないnameなのでコピーしなきゃいけない。そしてnameは単なるポインタなのでこれも
		//newしたらんとあかんわけや。('A`;)ああマンドクセ
		ret->Name=new char[strlen(name)+1];
		if(ret->Name==NULL){
			frame=NULL;
			return E_OUTOFMEMORY;
		}
		strcpy(ret->Name,name);
		::D3DXMatrixIdentity(&ret->TransformationMatrix);//行列は初期化しとく
		::D3DXMatrixIdentity(&ret->combinedMatrix);
		*frame=ret;
		return D3D_OK;
	}

	///メッシュコンテナオブジェクトを生成して返す
	///@param name メッシュ名
	///@param meshData メッシュオブジェクト
	///@param materials メッシュに使用されるマテリアル配列
	///@param effectInstance メッシュに使用されるエフェクトインスタンス配列
	///@param numMaterials マテリアル数
	///@param adjacency メッシュ構成ポリゴンインデクスの配列
	///@param skinInfo スキン情報(NULLならスキン情報がないってこと)
	///@note こいつもつまるところメッシュオブジェクトを生成して返してやりゃいい
	///例によって、オブジェクト生成→名前のコピーから始まる
	///adjacencyに関して、リファレンスには「隣接性配列」としか書いていないんだが、
	///サンプルを見る限り、これはメッシュを構成するトライアングルの頂点インデックスが入る配列らしい。
	///
	///結局この関数もCreateFrameと同様に引数のデータをメッシュコンテナのメンバにコピるだけの簡単なお仕事
	///だからデフォルトクラス用意しといて、クライアントのご要望に合わせて挿げ替えられるように
	///しときゃいいのに…MSのこーゆーところがよーわからん。
	///
	///@attention ここでは コンテナ名、マテリアル、マテリアルに付随するテクスチャ名、隣接ポリゴンインデクス
	///を確保しているため、DestroyMeshContainerで解放する必要がある。ああマンドクセ('A`;)
	virtual __declspec(nothrow) HRESULT _stdcall CreateMeshContainer(LPCSTR name,
		const D3DXMESHDATA* meshData,
		const D3DXMATERIAL* materials,
		const D3DXEFFECTINSTANCE* effectInstances,
		DWORD numMaterials,
		const DWORD* adjacency,
		LPD3DXSKININFO skinInfo,
		LPD3DXMESHCONTAINER* meshContainer){
		BoneMesh* ret=new BoneMesh();
		if(ret==NULL){
			return E_OUTOFMEMORY;
		}
		memset(ret,0,sizeof(*ret));
		//例によって名前登録
		ret->Name = new char[strlen(name)+1];
		if(ret->Name==NULL){
			return E_OUTOFMEMORY;
		}
		strcpy(ret->Name,name);
		ret->MeshData.Type=meshData->Type;
		//この時点でメッシュオブジェクトの参照カウンタを１あげておかないと、
		//関数を抜ける際にデクリメントされてしまう。らしい。
		//なんでそんな仕様になっているかというと、メッシュオブジェクトが不必要なときは
		//ここで参照カウンタを上げなければ削除させたいわけ。
		//要は事実上、スマポの所有権がこちらに移動しているってわけ

		//メッシュタイプは通常メッシュ、プログレッシブメッシュ、パッチメッシュの3種類あるらしい
		//SkinnedMeshサンプルだと、通常メッシュしか実装してないが、実際はどうなるかわからんので
		//全て対応しておく
		switch(ret->MeshData.Type){
			case D3DXMESHTYPE_MESH:
				ret->MeshData.pMesh=meshData->pMesh;
				meshData->pMesh->AddRef();//参照数が増えたのでpMeshの参照カウンタをあげとく
				break;
			case D3DXMESHTYPE_PMESH:
				ret->MeshData.pPMesh=meshData->pPMesh;
				meshData->pPMesh->AddRef();//参照数が増えたのでpMeshの参照カウンタをあげとく
				break;
			case D3DXMESHTYPE_PATCHMESH:
				ret->MeshData.pPatchMesh=meshData->pPatchMesh;
				meshData->pPatchMesh->AddRef();
				break;
			default:
				return D3DERR_INVALIDCALL;
		}
		//マテリアル設定
		ret->NumMaterials=numMaterials;
		//マテリアルもまた空なので動的確保をしてやらんといかん。
		ret->pMaterials=new D3DXMATERIAL[numMaterials];
		if(ret->pMaterials==NULL){
			return E_OUTOFMEMORY;
		}
		///@attention ループ内で文字配列を何度も確保しているので、DestroyMeshContainer時に
		///きちんと解放するのを忘れないようにしなければならない!
		for(unsigned int i=0; i<numMaterials; ++i){
			ret->pMaterials[i].MatD3D=materials[i].MatD3D;
			if(materials[i].pTextureFilename!=NULL){
				ret->pMaterials[i].pTextureFilename=new char[strlen(materials[i].pTextureFilename)+1];
				if(ret->pMaterials[i].pTextureFilename==NULL){
					return E_OUTOFMEMORY;
				}
				strcpy(ret->pMaterials[i].pTextureFilename,materials[i].pTextureFilename);
				
			}
		}

		//エフェクト設定…は、必要になってからでいいや。少なくとも今の僕には必要ない。めんどくさい。

		//隣接ポリゴンインデクス設定
		int numPolygon=meshData->pMesh->GetNumFaces();
		ret->pAdjacency=new DWORD[numPolygon*3];//トライアングルなんで*3な
		if(ret->pAdjacency==NULL){
			return E_OUTOFMEMORY;
		}
		memcpy(ret->pAdjacency,adjacency,sizeof(DWORD)*numPolygon*3);
		
		//スキン情報があるならコピー
		if(skinInfo!=NULL){
			ret->pSkinInfo=skinInfo;
			skinInfo->AddRef();
		}

		//ConvertToBlendMeshは、ボーンとメッシュ頂点の位置に応じて、第一引数のメッシュをいい感じに
		//並び替えて、最後の引数として返すものである。
		HRESULT result = skinInfo->ConvertToBlendedMesh(meshData->pMesh,
			D3DXMESH_MANAGED|D3DXMESHOPT_VERTEXCACHE, 
			adjacency,
			NULL, //フェースや頂点のリマップは今のところ必要ない
			NULL, 
			NULL,
			&ret->maxFaceInfl,
			&ret->numBoneCobinations,
			&ret->boneCombinations,
			&ret->MeshData.pMesh
		);


		*meshContainer=ret;
		return D3D_OK;

	}
	
	///CreateFrameで生成したD3DXFRAMEオブジェクトを解放する
	///@param frame 解放すべきframeオブジェクト
	///動的に色々確保したのでホイホイ解放してやる。
	virtual __declspec(nothrow) HRESULT _stdcall DestroyFrame(LPD3DXFRAME frame){
		delete[] frame->Name;
		delete frame;
		return D3D_OK;
	}

	///CreateMeshContainerで確保したメッシュコンテナ情報を解放する
	virtual __declspec(nothrow) HRESULT _stdcall DestroyMeshContainer(LPD3DXMESHCONTAINER container){
		//コンテナ名、マテリアル、マテリアルに付随するテクスチャ名、隣接ポリゴンインデクスの解放
		delete[] container->Name;
		container->MeshData.pMesh->Release();
		for(unsigned int i=0;i<container->NumMaterials;++i){
			if(container->pMaterials[i].pTextureFilename!=NULL){
				delete[] container->pMaterials[i].pTextureFilename;
			}
		}
		delete[] container->pMaterials;
		delete[] container->pAdjacency;
		container->pSkinInfo->Release();
		delete container;
		return D3D_OK;
	}
};



///アニメーションメッシュオブジェクトのDirect3D実装
class AnimationMeshObjectD3D: public KMeshObject{
	private:
		D3DXMATRIXA16 _world;
		KDeviceWrapper& _dev;
		LPD3DXBUFFER _adj;
		LPD3DXBUFFER _materialsBuffer;
		std::vector<D3DMATERIAL9> _materials;
		std::vector<SharedPtr<ITexture>> _textures;
		LPD3DXBUFFER _effectInstances;
		DWORD _materialsNum;
		BoneHierarchyLoader _allocator;
		//アニメーションメッシュ用
		Bone* _frameRoot;
		ID3DXAnimationController* _animController;

		///いちいち_dev.GetDevice()って書きたくないので…
		///@return デバイスへの生ポインタ
		LPDIRECT3DDEVICE9 Device(){
			return static_cast<LPDIRECT3DDEVICE9>(_dev.GetDevice());
		}

		///ボーンツリーを構築する
		///@param frame frameオブジェクト
		///@retval false 構築失敗
		///@retval true 構築成功
		bool SetupBoneTree(Bone* frame);

		///フレーム階層を再帰的に描画する
		///@note 複数のボーンが含まれる場合には、行列が階層構造になっている。
		///このため描画の際に再帰的に現在の頂点座標に対し変換行列を乗算してやる必要がある。
		///フレームオブジェクト
		void DrawFrameHierarchy(Bone* frame,const D3DXMATRIXA16& parentMatrix);
		///メッシュコンテナを描画する
		void DrawMeshContainer(D3DXMESHCONTAINER& meshContainer,D3DXFRAME* frame);

		///(親階層の)行列を合成行列に乗算する
		///@param [in,out]bone どっかしらの階層のボーン(フレーム)
		///@param matrix 乗算したい行列
		///@note 自分の子供をじぇ～んぶ再計算します。なんで多用すると重いかも
		void CalculateWorldMatrices(Bone& bone,const D3DXMATRIXA16& matrix);

	public:
		AnimationMeshObjectD3D();
		~AnimationMeshObjectD3D();
		void InitMatrix();
		void RotateX(const float rad);
		void RotateY(const float rad);
		void RotateZ(const float rad);
		void RotateRollYawPitch(const float roll,const float yaw, const float pitch);
		void Move(const Vector3D& vec);
		SharedPtr<ITexture> Texture(const unsigned int idx){return NULL;}
		void LoadFromFile(const wchar_t* );
		void Draw();
		void PostDraw();
		void AdvanceTime();
		void SetTime(const double time);
		void SetFrameIndex(const unsigned int);
		KMeshObject& Mesh();
};

///メッシュローダ
AnimationMeshObjectD3D::AnimationMeshObjectD3D():_dev(KDeviceWrapper::Instance()){
	InitMatrix();
}

AnimationMeshObjectD3D::~AnimationMeshObjectD3D(){
	_allocator.DestroyFrame(_frameRoot);
}

void
AnimationMeshObjectD3D::InitMatrix(){
	::D3DXMatrixIdentity(&_world);
}

void 
AnimationMeshObjectD3D::RotateX(const float rad){
	D3DXMATRIXA16 world;
	::D3DXMatrixRotationX(&world,rad);
	_world*=world;
}

void 
AnimationMeshObjectD3D::RotateY(const float rad){
	D3DXMATRIXA16 world;
	::D3DXMatrixRotationY(&world,rad);
	_world*=world;
}

void 
AnimationMeshObjectD3D::RotateZ(const float rad){
	D3DXMATRIXA16 world;
	::D3DXMatrixRotationZ(&world,rad);
	_world*=world;
}

void
AnimationMeshObjectD3D::RotateRollYawPitch(const float roll, const float yaw, const float pitch){
	D3DXMATRIXA16 world;
	::D3DXMatrixRotationYawPitchRoll(&world,yaw,pitch,roll);
	_world*=world;
}

void
AnimationMeshObjectD3D::Move(const Vector3D& vec){
	D3DXMATRIXA16 world;
	::D3DXMatrixTranslation(&world,vec.x,vec.y,vec.z);
	_world*=world;
}

void 
AnimationMeshObjectD3D::LoadFromFile(const wchar_t* filename){
	//Direct3Dのメッシュ(アニメーションありXファイル)を読み込む
	_animController=NULL;
	HRESULT result = ::D3DXLoadMeshHierarchyFromX(filename,
		D3DXMESH_MANAGED,
		static_cast<LPDIRECT3DDEVICE9>(_dev.GetDevice()),
		&_allocator,
		NULL,
		(LPD3DXFRAME*)(&_frameRoot),
		&_animController);
	//階層構造の取得が成功していれば、再帰的に構築してってあげないといけない。
	if( result==D3D_OK ){
		if(_animController){
			_animController->SetTrackSpeed(0,60.f/4800.f);
		}
		SetupBoneTree(_frameRoot);
	}
}

void 
AnimationMeshObjectD3D::AdvanceTime(void){
	if(_animController!=NULL){
		_animController->AdvanceTime(0.1,NULL);
	}
}

void
AnimationMeshObjectD3D::SetTime(const double time){
}

void 
AnimationMeshObjectD3D::SetFrameIndex(const unsigned int){
	;
}

void
AnimationMeshObjectD3D::CalculateWorldMatrices(Bone& bone,const D3DXMATRIXA16& matrix){
	D3DXMatrixMultiply(&bone.combinedMatrix,&bone.TransformationMatrix,&matrix);
	if(bone.pFrameSibling){
		CalculateWorldMatrices(*(Bone*)(bone.pFrameSibling),matrix);
	}
	if(bone.pFrameFirstChild){
		CalculateWorldMatrices(*(Bone*)(bone.pFrameFirstChild),matrix);
	}
}

void
AnimationMeshObjectD3D::Draw(){
	LPDIRECT3DDEVICE9 dev = Device();
	dev->SetTransform(D3DTS_WORLD,&_world);
	DrawFrameHierarchy(_frameRoot,_world);
}

void
AnimationMeshObjectD3D::DrawFrameHierarchy(Bone* frame,const D3DXMATRIXA16& parentMatrix){
	LPD3DXMESHCONTAINER meshContainer=frame->pMeshContainer;
	const D3DXMATRIXA16& combinedMatrix = frame->combinedMatrix=frame->TransformationMatrix*parentMatrix;
	//連結するメッシュがなくなるまで描画
	while(meshContainer!=NULL){
		DrawMeshContainer(*meshContainer,frame);
		meshContainer=meshContainer->pNextMeshContainer;
	}
	if(frame->pFrameSibling!=NULL){
		Bone* sibling=static_cast<Bone*>(frame->pFrameSibling);
		DrawFrameHierarchy(sibling,combinedMatrix);
	}
	if(frame->pFrameFirstChild!=NULL){
		Bone* child=static_cast<Bone*>(frame->pFrameFirstChild);
		child->combinedMatrix=child->TransformationMatrix*frame->combinedMatrix;
		DrawFrameHierarchy(child,combinedMatrix);
	}
}

//SkinnedMeshサンプルのDrawMeshContainerの実装が長すぎてなんか…
void
AnimationMeshObjectD3D::DrawMeshContainer(D3DXMESHCONTAINER& container,
D3DXFRAME* frame){
	Bone* frm=static_cast<Bone*>(frame);
	LPDIRECT3DDEVICE9 dev=static_cast<LPDIRECT3DDEVICE9>(_dev.GetDevice());
	dev->SetTransform(D3DTS_WORLD,&frm->combinedMatrix);
	if(container.pSkinInfo==NULL){
		//dev->SetTransform(D3DTS_WORLD,&frm->combinedMatrix);
		for(int i=0;i<container.NumMaterials;++i){
			dev->SetMaterial(&container.pMaterials[i].MatD3D);
			;//ロードできてたらホントはここでSetTextureする
			container.MeshData.pMesh->DrawSubset(i);
		}

	}else{
		//dev->SetTransform(D3DTS_WORLD,&frm->combinedMatrix);
		for(int i=0;i<container.NumMaterials;++i){
			dev->SetTexture(0,NULL);

			container.pMaterials[i].MatD3D.Ambient = container.pMaterials[i].MatD3D.Diffuse;
			dev->SetMaterial(&container.pMaterials[i].MatD3D);
			;//ロードできてたらホントはここでSetTextureする
			container.MeshData.pMesh->DrawSubset(i);
		}
	}
}

void
AnimationMeshObjectD3D::PostDraw(){
	;
}

bool
AnimationMeshObjectD3D::SetupBoneTree(Bone* frame){
	if(frame->pFrameFirstChild!=NULL){
		//グラフ構築
		SetupBoneTree(static_cast<Bone*>(frame->pFrameFirstChild));
	}
	if(frame->pMeshContainer!=NULL){
		//メッシュ登録
	}
	return true;
}

KMeshObject*
KAnimationMeshObjectProvider::Create(){
	return new AnimationMeshObjectD3D();
}


}// using namespace KFX