﻿#include"text_info_node.h"
#include"../../debugutil/debugconsole.h"
#include"../../debugutil/debug_timer.h"
#include<d3d9.h>
#include<d3dx9.h>


#ifdef WIN32
//DirectDraw内で#define DrawText DrawTextWされてやがるので…OTL
#undef DrawText

namespace KFX{


///TextDrawerのDirect3D実装
class TextDrawerD3D : public ITextDrawer{
	private:
		D3DXFONT_DESC _fontdesc;
		LPD3DXFONT _font;
		Rect _rc;
		RECT GetRECT()const;
		void SetRect(const RECT& rc);
	public:
		TextDrawerD3D(bool useDefault);
		~TextDrawerD3D();
		//文字を描画する
		void DrawText(const wchar_t* str);
		void DrawText(const wchar_t*,TextColorBase& col,FontBase& font);
		void DrawText(const wchar_t*,int x, int y);
		void DrawText(const wchar_t*,int x, int y , TextColorBase& col,FontBase& font);
		
		//矩形を計算する
		Rect CalculateRect(const wchar_t* str);
		Rect CalculateRect(const wchar_t*,FontBase& font);
		Rect CalculateRect(const wchar_t*,int x, int y);
		Rect CalculateRect(const wchar_t*,int x, int y , FontBase& font);

		//
		void SetPosition(int, int);
		void SetRect(int , int ,int , int );
		void SetRect(const Rect& rect);
		void SetFont(const FontBase& );
		void SetAlignment(TextAlign);
		void SetTextColor(TextColorBase&);
};

TextDrawerD3D::TextDrawerD3D(bool useDefault) : _font(NULL){
	//フォント、文字のデフォルトを使用する
	if( useDefault ){
		D3DXFONT_DESC desc= {48,0,500,1,0,SHIFTJIS_CHARSET,OUT_TT_ONLY_PRECIS,PROOF_QUALITY,DEFAULT_PITCH|FF_DONTCARE,L"MS ゴシック"};				
		_fontdesc = desc;
		RECT rc;
		::SetRect(&rc,0,0,640,480);
		this->SetRect(rc);
		//フォントの生成
		HRESULT result = ::D3DXCreateFontIndirect(static_cast<LPDIRECT3DDEVICE9>(KDeviceWrapper::Instance().GetDevice()),
			&_fontdesc,
			&_font);
		if( result!=D3D_OK ){
			DebugConsole::Instance().Out("Font Failed");
			_font=NULL;
		}
	}
}

void
TextDrawerD3D::SetFont(const FontBase& font){
	if( _font!=NULL ){//フォントはいったん削除して
		_font->Release();
	}
	_fontdesc.Height=font.size;
	_fontdesc.Width=0;
	_fontdesc.Weight=500;
	_fontdesc.MipLevels=0;
	_fontdesc.Italic=font.italic;
	_fontdesc.CharSet=SHIFTJIS_CHARSET;
	_fontdesc.OutputPrecision=OUT_TT_ONLY_PRECIS;
	_fontdesc.Quality=PROOF_QUALITY;
	_fontdesc.PitchAndFamily=DEFAULT_PITCH|FF_DONTCARE;		
	std::copy(font.name.begin(),font.name.end(), _fontdesc.FaceName );
	
	//フォントの生成
	HRESULT result = ::D3DXCreateFontIndirect(static_cast<LPDIRECT3DDEVICE9>(KDeviceWrapper::Instance().GetDevice()),
		&_fontdesc,
		&_font);
	if( result!=D3D_OK ){
		DebugConsole::Instance().Out("Font Failed");
		_font=NULL;
	}
}

TextDrawerD3D::~TextDrawerD3D(){
	_font->Release();
}

void
TextDrawerD3D::SetTextColor(KFX::TextColorBase& col){
}


void
TextDrawerD3D::SetAlignment(TextAlign /*alignment*/ ){
	
}

void
TextDrawerD3D::SetPosition(int x, int y){
	
}


Rect 
TextDrawerD3D::CalculateRect(const wchar_t* str){
	RECT rect=this->GetRECT();
	_font->DrawTextW(NULL,
		str,
		-1,
		&rect,
		DT_CALCRECT,
		NULL);
	return Rect(rect.left,rect.top,rect.right,rect.bottom);
}

Rect 
TextDrawerD3D::CalculateRect(const wchar_t* str,FontBase& font){
	this->SetFont(font);
	RECT rect=this->GetRECT();
	_font->DrawTextW(NULL,
		str,
		-1,
		&rect,
		DT_CALCRECT,
		NULL);
	
	return Rect(rect.left,rect.top,rect.right,rect.bottom);
}

Rect 
TextDrawerD3D::CalculateRect(const wchar_t* str,int x, int y){
	RECT rect={x,y,0,0};
	_font->DrawTextW(NULL,
		str,
		-1,
		&rect,
		DT_CALCRECT,
		NULL);
	return Rect(rect.left,rect.top,rect.right,rect.bottom);
}

Rect
TextDrawerD3D::CalculateRect(const wchar_t* str,int x, int y , FontBase& font){
	this->SetFont(font);
	RECT rect={x,y,0,0};
	_font->DrawTextW(NULL,
		str,
		-1,
		&rect,
		DT_CALCRECT,
		NULL);
	
	return Rect(rect.left,rect.top,rect.right,rect.bottom);
}

void
TextDrawerD3D::SetRect(int left, int top, int width, int height){
	_rc.Set(left,top,left+width,top+height);
}

void
TextDrawerD3D::SetRect(const Rect& rect){
	_rc = rect;
}

void 
TextDrawerD3D::SetRect(const RECT& rc){
	_rc.Set(rc.left,rc.top,rc.right,rc.bottom);
}
RECT
TextDrawerD3D::GetRECT()const{
	RECT rc={_rc.left,_rc.top,_rc.right,_rc.bottom};
	return rc;
}

void
TextDrawerD3D::DrawText(const wchar_t* str){
	if( _font==NULL ){
		return;
	}
	_font->DrawTextW(NULL,
		str,
		-1,
		&this->GetRECT(),
		DT_CENTER|DT_SINGLELINE,
		D3DCOLOR_XRGB(0xFF,0xFF,0xFF));
}

void
TextDrawerD3D::DrawText(const wchar_t* str,int x, int y){
	if( _font==NULL ){
		return;
	}
	//幅、高さは保持
	int width=_rc.right-_rc.left;
	int height=_rc.bottom - _rc.top;
	
	_rc.left=x;
	_rc.top=y;
	_rc.right=x+width;
	_rc.bottom=y+height;
	_font->DrawTextW(NULL,
		str,
		-1,
		&this->GetRECT(),
		DT_CENTER|DT_SINGLELINE,
		D3DCOLOR_XRGB(0xFF,0xFF,0xFF));
}

void
TextDrawerD3D::DrawText(const wchar_t* str,TextColorBase& color, FontBase& font ){

}

void
TextDrawerD3D::DrawText(const wchar_t* str, int x , int y , TextColorBase& color, FontBase& font ){
	
}



TextDrawerFactory&
TextDrawerFactory::Instance(){
	static TextDrawerFactory instance;
	return instance;
}

///
ITextDrawer*
TextDrawerFactory::CreateTextDrawer(bool useDefault){
	return new TextDrawerD3D(useDefault);
}
//デフォルトのデバッグ文字はMSゴシックの48にしている
TextInfoNode::TextInfoNode():_fpsFlg(false),
_debugTimer(IDebugTimerFactory::Instance().CreateTimer()),
_textDrawer(TextDrawerFactory::Instance().CreateTextDrawer(true)){
	
}

TextInfoNode&
TextInfoNode::Out(const wchar_t* str){
	_str<<str;
	return *this;
}

TextInfoNode&
TextInfoNode::Out(const char* str){
	return *this;
}

TextInfoNode&
TextInfoNode::Out(const int num ){
	_str<<num;
	return *this;
}

TextInfoNode&
TextInfoNode::Out(const float dec ){
	_str<<dec;
	return *this;
}

TextInfoNode&
TextInfoNode::Linefeed(){
	_str<<std::endl;
	return *this;
}


void 
TextInfoNode::Update(){
	static int x=0;
	std::wostringstream ws;
	ws<<"FPS:" << _debugTimer->GetFPS();
	_textDrawer->DrawText(ws.str().c_str(),x,0);
	++x;
}

void 
TextInfoNode::DisplayFPS(const bool flg){
	_fpsFlg=flg;
}
bool 
TextInfoNode::DisplayFPS()const{
	return _fpsFlg;
}

}// end of namespace KFX

#endif//end of #ifdef WIN32 for DrawTextW