﻿#include"sprite_node.h"
#include"../../graphics/texture.h"
namespace KFX{
const float root2 = 0.707f;
const float normalSpeed=3.f;
SpriteNode::SpriteNode(const wchar_t* filename){
	ITexture* texture=ITextureBuilder::Instance().CreateTextureFromFile(filename);
	_sprite.Reset(ISpriteFactory::Instance().CreateSprite(texture));
}
void
SpriteNode::Update(){
	//スプライト描画処理
	_sprite->Draw();
}

void
SpriteNode::OnPressed(IPeripheral& periph){
	_sprite->MoveX(periph.AnalogValue(IPeripheral::THUMB_LX)/1000.f);
	_sprite->MoveY(-periph.AnalogValue(IPeripheral::THUMB_LY)/1000.f);

	switch( periph.CurrentDirection() ){
		case IPeripheral::DS_LEFT:
			_sprite->MoveX(-normalSpeed);
			break;
		case IPeripheral::DS_LEFTDOWN:
			_sprite->MoveX(-normalSpeed*root2);
			_sprite->MoveY(+normalSpeed*root2);
			break;
		case IPeripheral::DS_DOWN:
			_sprite->MoveY(+normalSpeed);
			break;
		case IPeripheral::DS_RIGHTDOWN:
			_sprite->MoveX(+normalSpeed*root2);
			_sprite->MoveY(+normalSpeed*root2);
			break;
		case IPeripheral::DS_RIGHT:
			_sprite->MoveX(normalSpeed);
			break;
		case IPeripheral::DS_RIGHTUP:
			_sprite->MoveX(normalSpeed*root2);
			_sprite->MoveY(-normalSpeed*root2);
			break;
		case IPeripheral::DS_UP:
			_sprite->MoveY(-normalSpeed);
			break;
		case IPeripheral::DS_LEFTUP:
			_sprite->MoveX(-normalSpeed*root2);
			_sprite->MoveY(-normalSpeed*root2);
			break;
		default:
			;
	}
	
}

	
}//end of namespace KFX