﻿#ifndef KFX_MESH_NODE_H_INCLUDED
#define KFX_MESH_NODE_H_INCLUDED
#include<vector>
#include"game_node.h"
#include"../../kernel/pointer/scoped_ptr.h"
#include"../../input/peripheral.h"
#include"../../graphics/Geometory/geometory.h"
namespace KFX{
class KMeshObject;
///メッシュ表示用ノード
class MeshNode : public GameNode,public KInputListener{
	private:
	protected:
		ScopedPtr<KMeshObject> _meshObject;
		///描画前処理
		void BeforeDraw();
	public:
		///メッシュのロードコール
		///@note 現在メッシュのロードは完了復帰にしているが、
		///将来的にはスレッドに投げて即時復帰にする予定
		void Load(const wchar_t* );
		virtual void OnLoaded(){}
		///メッシュノードが使用可能かどうか
		///@note メッシュをロードして使用可能なときtrueを返す。
		///@retval false メッシュノードが使用可能状態ではない
		///@retval true メッシュノードが使用可能
		bool IsAvailable();

		MeshNode(bool isAnim=false);
		virtual ~MeshNode(){};
		virtual void Update();
		virtual void OnPressed(IPeripheral& periph){}
		KMeshObject& Mesh(){return *_meshObject;}


		///メッシュを平行移動する
		///@param vec 移動ベクトル
		void Move(const Vector3D& vec);

		///メッシュ回転
		void RotateX(const float angle);
		void RotateY(const float angle);
		void RotateZ(const float angle);
		void RotateRollYawPitch(const float roll,
			const float yaw,
			const float pitch);
		void RotateRollYawPitch(const RollYawPitch& rollyawpitch);

};
}// end of namespace KFX
#endif
