﻿#include<windows.h>
#include<mmsystem.h>
#include"mesh_node.h"
#include"../../graphics/3d/animation_mesh_object.h"
#include<sstream>
#include<cmath>


namespace KFX{

MeshNode::MeshNode(bool isAnim){
	if(isAnim){
		_meshObject.Reset(KAnimationMeshObjectProvider::Instance().Create());
	}else{
		_meshObject.Reset(KMeshObjectProvider::Instance().Create());
	}
}

void 
MeshNode::BeforeDraw(){
	_meshObject->InitMatrix();
}

void
MeshNode::Update(){
	_meshObject->Draw();
	_meshObject->PostDraw();
	OnUpdated();
}

void
MeshNode::Load(const wchar_t* filename){
	_meshObject->LoadFromFile(filename);	
	OnLoaded();
}


void 
MeshNode::RotateX(const float angle){
	_meshObject->RotateX(angle);
}

void 
MeshNode::RotateY(const float angle){
	_meshObject->RotateY(angle);
}

void 
MeshNode::RotateZ(const float angle){
	_meshObject->RotateZ(angle);
}

void
MeshNode::RotateRollYawPitch(const float roll,
	const float yaw,
	const float pitch){
	_meshObject->RotateRollYawPitch(roll,yaw,pitch);
}

void
MeshNode::Move(const Vector3D& vec){
	_meshObject->Move(vec);
}
}// end of namespace KFX