﻿using System;
using System.Windows.Forms;
using System.Windows.Forms.Design;

namespace Kasuga
{
    [ToolStripItemDesignerAvailability(ToolStripItemDesignerAvailability.ToolStrip)]
    public class ToolStripTrackBar : ToolStripControlHost
    {
        public ToolStripTrackBar() : base(new TrackBar())
        {
            TrackBar trackBar = (TrackBar)this.Control;
            trackBar.AutoSize = false;
            trackBar.Height = 22;
            trackBar.TickStyle = TickStyle.None;
            trackBar.Scroll += new EventHandler(OnScroll);
            trackBar.ValueChanged += new EventHandler(OnValueChanged);
            this.AutoSize = false;
        }

        private TrackBar TrackBar
        {
            get { return (TrackBar)this.Control; }
        }

        public int Value
        {
            get { return TrackBar.Value; }
            set { TrackBar.Value = value; }
        }

        public int Maximum
        {
            get { return TrackBar.Maximum; }
            set { TrackBar.Maximum = value; }
        }

        public int Minimum
        {
            get { return TrackBar.Minimum; }
            set { TrackBar.Minimum = value; }
        }

        public int LargeChange
        {
            get { return TrackBar.LargeChange; }
            set { TrackBar.LargeChange = value; }
        }

        public int SmallChange
        {
            get { return TrackBar.SmallChange; }
            set { TrackBar.SmallChange = value; }
        }

        public event EventHandler Scroll;
        public event EventHandler ValueChanged;

        private void OnScroll(object sender, EventArgs e)
        {
            if (Scroll != null)
            {
                Scroll.Invoke(sender, e);
            }
        }

        private void OnValueChanged(object sender, EventArgs e)
        {
            if (ValueChanged != null)
            {
                ValueChanged.Invoke(sender, e);
            }
        }
    }
}
