﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Reflection;
using Kasuga.Ass;

namespace Kasuga.StandardPlugins.Formats
{
    public class Util
    {
        public static AssStyle CheckContainedStyle(
            List<AssStyle> styles,
            AssStyle style)
        {
            try
            {
                Predicate<AssStyle> predicate;
                {
                    predicate = (AssStyle containedStyle) =>
                    {
                        return containedStyle.EqualsExcludeName(style);
                    };
                }
                {
                    AssStyle containedStyle = styles.Find(predicate);
                    if (containedStyle == null)
                    {
                        styles.Add(style);
                    }
                    else
                    {
                        style = containedStyle;
                    }
                }
                return style;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }

        public static PointF GetIntersectionPoint(Corners corners)
        {
            try
            {
                float a1, b1, c1, a2, b2, c2;
                a1 = corners.BottomRight.Y - corners.TopLeft.Y;
                b1 = corners.TopLeft.X - corners.BottomRight.X;
                c1 = corners.BottomRight.X * corners.TopLeft.Y + corners.TopLeft.X * corners.BottomRight.Y;
                a2 = corners.BottomLeft.Y - corners.TopRight.Y;
                b2 = corners.TopRight.X - corners.BottomLeft.X;
                c2 = corners.BottomLeft.X * corners.TopRight.Y + corners.TopRight.X * corners.BottomLeft.Y;
                float x, y;
                x = (c1 * b2 - c2 * b1) / (a1 * b2 - b1 * a2);
                y = (a1 * c2 - a2 * c1) / (a1 * b2 - b1 * a2);
                return new PointF(x, y);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return PointF.Empty;
            }
        }
    }
}
