﻿using System;
using System.Collections.Generic;
using System.Reflection;

namespace Kasuga
{
    public class WordArrangementWrapper : PluginWrapper<IWordArrangement>
    {
        public WordArrangementWrapper() : base() { }
        public WordArrangementWrapper(string baseName, IWordArrangement plugin) : base(baseName, plugin) { }

        protected override IWordArrangement GetPluginByName(string name)
        {
            try
            {
                CatalogItem<IWordArrangement> item = CatalogManager.WordArrangementCatalog.Find((CatalogItem<IWordArrangement> listItem) =>
                {
                    return listItem.Name == name;
                });
                return item != null ? (IWordArrangement)item.Plugin.Clone() : null;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }
    }
}
