﻿using System;
using System.ComponentModel;
using System.Reflection;
using System.Windows.Forms;

namespace Kasuga
{
    public class WordArrangementPropertyDescriptor : PropertyDescriptor
    {
        public WordArrangementPropertyDescriptor(PropertyDescriptor descriptor)
            : base(descriptor)
        {
            try
            {
                _descriptor = descriptor;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        private PropertyDescriptor _descriptor;

        public override object GetValue(object component)
        {
            try
            {
                IHasWordArrangementDictionary element = (IHasWordArrangementDictionary)component;
                return element.WordArrangementDictionary[_descriptor.Name];
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }

        public override void SetValue(object component, object value)
        {
            try
            {
                IHasWordArrangementDictionary element = (IHasWordArrangementDictionary)component;
                element.SetWordArrangementProperty(_descriptor.Name, value, true);
                if (MessageBox.Show("該当ページの構成要素を再配置しますか？", "再配置", MessageBoxButtons.YesNo) == DialogResult.Yes)
                {
                    if (element is KsgSubtitle)
                    {
                        ((KsgSubtitle)element).PageArrange();
                    }
                    else if (element is KsgPart)
                    {
                        ((KsgPart)element).PageArrange();
                    }
                    else if (element is KsgPage)
                    {
                        ((KsgPage)element).PageArrange();
                    }
                    else if (element is KsgLine)
                    {
                        ((KsgLine)element).ParentPage.PageArrange();
                    }
                    else if (element is KsgWord)
                    {
                        ((KsgWord)element).ParentPage.PageArrange();
                    }
                }
                else if (MessageBox.Show("該当行の構成要素を再配置しますか？", "再配置", MessageBoxButtons.YesNo) == DialogResult.Yes)
                {
                    if (element is KsgSubtitle)
                    {
                        ((KsgSubtitle)element).LineArrange();
                    }
                    else if (element is KsgPart)
                    {
                        ((KsgPart)element).LineArrange();
                    }
                    else if (element is KsgPage)
                    {
                        ((KsgPage)element).LineArrange();
                    }
                    else if (element is KsgLine)
                    {
                        ((KsgLine)element).LineArrange();
                    }
                    else if (element is KsgWord)
                    {
                        ((KsgWord)element).ParentLine.LineArrange();
                    }
                }
                else if (MessageBox.Show("該当単語の構成要素を再配置しますか？", "再配置", MessageBoxButtons.YesNo) == DialogResult.Yes)
                {
                    if (element is KsgSubtitle)
                    {
                        ((KsgSubtitle)element).WordArrange();
                    }
                    else if (element is KsgPart)
                    {
                        ((KsgPart)element).WordArrange();
                    }
                    else if (element is KsgPage)
                    {
                        ((KsgPage)element).WordArrange();
                    }
                    else if (element is KsgLine)
                    {
                        ((KsgLine)element).WordArrange();
                    }
                    else if (element is KsgWord)
                    {
                        ((KsgWord)element).WordArrange();
                    }
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public override bool CanResetValue(object component)
        {
            try
            {
                IHasWordArrangementDictionary element = (IHasWordArrangementDictionary)component;
                return element.BaseWordArrangement != null;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return false;
            }
        }

        public override void ResetValue(object component)
        {
            try
            {
                IHasWordArrangementDictionary element = (IHasWordArrangementDictionary)component;
                IWordArrangement baseWordArrangement = element.BaseWordArrangement;
                if (baseWordArrangement != null)
                {
                    PropertyDescriptorCollection descriptors = TypeDescriptor.GetProperties(baseWordArrangement);
                    PropertyDescriptor descriptor = descriptors.Find(_descriptor.Name, true);
                    SetValue(component, descriptor.GetValue(baseWordArrangement));
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public override bool ShouldSerializeValue(object component)
        {
            try
            {
                IHasWordArrangementDictionary element = (IHasWordArrangementDictionary)component;
                IWordArrangement baseWordArrangement = element.BaseWordArrangement;
                if (baseWordArrangement == null)
                {
                    return true;
                }
                else
                {
                    PropertyDescriptorCollection descriptors = TypeDescriptor.GetProperties(baseWordArrangement);
                    PropertyDescriptor descriptor = descriptors.Find(_descriptor.Name, true);
                    return !descriptor.GetValue(baseWordArrangement).Equals(GetValue(component));
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return false;
            }
        }

        public override Type ComponentType
        {
            get
            {
                try
                {
                    return typeof(IHasWordArrangementDictionary);
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }

        public override bool IsReadOnly
        {
            get
            {
                try
                {
                    return _descriptor.IsReadOnly;
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return false;
                }
            }
        }

        public override Type PropertyType
        {
            get
            {
                try
                {
                    return _descriptor.PropertyType;
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }
    }
}
