﻿using System;
using System.ComponentModel;
using System.Reflection;

namespace Kasuga
{
    public class PluginBaseNamePropertyDescriptor : PropertyDescriptor
    {
        public PluginBaseNamePropertyDescriptor(PropertyDescriptor descriptor)
            : base(descriptor)
        {
            try
            {
                _descriptor = descriptor;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        private PropertyDescriptor _descriptor;

        public override object GetValue(object component)
        {
            try
            {
                return _descriptor.GetValue(component);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }

        public override void SetValue(object component, object value)
        {
            try
            {
                _descriptor.SetValue(component, value);
                if (Name == "BaseFormatName")
                {
                    IHasFormatDictionary element = (IHasFormatDictionary)component;
                    element.RefreshFormatProperty(true, true);
                }
                else if (Name == "BaseWordArrangementName")
                {
                    IHasWordArrangementDictionary element = (IHasWordArrangementDictionary)component;
                    element.RefreshWordArrangementProperty(true, true);
                }
                else if (Name == "BaseLineArrangementName")
                {
                    IHasLineArrangementDictionary element = (IHasLineArrangementDictionary)component;
                    element.RefreshLineArrangementProperty(true, true);
                }
                else if (Name == "BasePageArrangementName")
                {
                    IHasPageArrangementDictionary element = (IHasPageArrangementDictionary)component;
                    element.RefreshPageArrangementProperty(true, true);
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public override bool CanResetValue(object component)
        {
            try
            {
                return false;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return false;
            }
        }

        public override void ResetValue(object component)
        {
            try
            {
                _descriptor.ResetValue(component);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public override bool ShouldSerializeValue(object component)
        {
            try
            {
                return _descriptor.ShouldSerializeValue(component);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return false;
            }
        }

        public override Type ComponentType
        {
            get
            {
                try
                {
                    return typeof(IHasFormatDictionary);
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }

        public override bool IsReadOnly
        {
            get
            {
                try
                {
                    return _descriptor.IsReadOnly;
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return false;
                }
            }
        }

        public override Type PropertyType
        {
            get
            {
                try
                {
                    return _descriptor.PropertyType;
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }
    }
}
