﻿using System;
using System.Reflection;
using System.Xml.Serialization;

namespace Kasuga
{
    [Serializable]
    public class PlayTimeSpan
    {
        [XmlText]
        public double TotalSeconds { get; private set; }

        public static PlayTimeSpan Zero = new PlayTimeSpan(0.0);

        public PlayTimeSpan()
        {
            try
            {
                TotalSeconds = 0;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public PlayTimeSpan(double totalSeconds)
        {
            try
            {
                TotalSeconds = totalSeconds;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public static PlayTimeSpan operator +(PlayTimeSpan span)
        {
            try
            {
                return new PlayTimeSpan(+span.TotalSeconds);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return PlayTimeSpan.Zero;
            }
        }

        public static PlayTimeSpan operator -(PlayTimeSpan span)
        {
            try
            {
                return new PlayTimeSpan(-span.TotalSeconds);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return PlayTimeSpan.Zero;
            }
        }

        public static PlayTimeSpan operator +(PlayTimeSpan span1, PlayTimeSpan span2)
        {
            try
            {
                return new PlayTimeSpan(span1.TotalSeconds + span2.TotalSeconds);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return PlayTimeSpan.Zero;
            }
        }

        public static PlayTimeSpan operator -(PlayTimeSpan span1, PlayTimeSpan span2)
        {
            try
            {
                return new PlayTimeSpan(span1.TotalSeconds - span2.TotalSeconds);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return PlayTimeSpan.Zero;
            }
        }

        public static PlayTimeSpan operator *(PlayTimeSpan span, double d)
        {
            try
            {
                return new PlayTimeSpan(span.TotalSeconds * d);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return PlayTimeSpan.Zero;
            }
        }

        public static PlayTimeSpan operator /(PlayTimeSpan span, double d)
        {
            try
            {
                return new PlayTimeSpan(span.TotalSeconds / d);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return PlayTimeSpan.Zero;
            }
        }

        public static bool operator ==(PlayTimeSpan span1, PlayTimeSpan span2)
        {
            try
            {
                return span1.TotalSeconds == span2.TotalSeconds;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return false;
            }
        }

        public static bool operator !=(PlayTimeSpan span1, PlayTimeSpan span2)
        {
            try
            {
                return span1.TotalSeconds != span2.TotalSeconds;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return false;
            }
        }

        public static bool operator <(PlayTimeSpan span1, PlayTimeSpan span2)
        {
            try
            {
                return span1.TotalSeconds < span2.TotalSeconds;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return false;
            }
        }

        public static bool operator <=(PlayTimeSpan span1, PlayTimeSpan span2)
        {
            try
            {
                return span1.TotalSeconds <= span2.TotalSeconds;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return false;
            }
        }

        public static bool operator >(PlayTimeSpan span1, PlayTimeSpan span2)
        {
            try
            {
                return span1.TotalSeconds > span2.TotalSeconds;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return false;
            }
        }

        public static bool operator >=(PlayTimeSpan span1, PlayTimeSpan span2)
        {
            try
            {
                return span1.TotalSeconds >= span2.TotalSeconds;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return false;
            }
        }

        public override bool Equals(object obj)
        {
            return base.Equals(obj);
        }

        public override int GetHashCode()
        {
            return base.GetHashCode();
        }
    }
}
