﻿using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Reflection;

namespace Kasuga
{
    public class Corners
    {
        public Corners()
        {
            try
            {
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public Corners(PointF topLeft, PointF topRight, PointF bottomRight, PointF bottomLeft)
        {
            try
            {
                _topLeft = topLeft;
                _topRight = topRight;
                _bottomRight = bottomRight;
                _bottomLeft = bottomLeft;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        private PointF _topLeft;
        private PointF _topRight;
        private PointF _bottomRight;
        private PointF _bottomLeft;
        [DisplayName("左上")]
        [TypeConverter(typeof(PointFConverter))]
        public PointF TopLeft
        {
            get
            {
                try
                {
                    return _topLeft;
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return PointF.Empty;
                }
            }
        }
        [DisplayName("右上")]
        [TypeConverter(typeof(PointFConverter))]
        public PointF TopRight
        {
            get
            {
                try
                {
                    return _topRight;
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return PointF.Empty;
                }
            }
        }
        [DisplayName("右下")]
        [TypeConverter(typeof(PointFConverter))]
        public PointF BottomRight
        {
            get
            {
                try
                {
                    return _bottomRight;
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return PointF.Empty;
                }
            }
        }
        [DisplayName("左下")]
        [TypeConverter(typeof(PointFConverter))]
        public PointF BottomLeft
        {
            get
            {
                try
                {
                    return _bottomLeft;
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return PointF.Empty;
                }
            }
        }

        [Browsable(false)]
        public GraphicsPath Path
        {
            get
            {
                try
                {
                    PointF[] points =
                    {
                        TopLeft,
                        TopRight,
                        BottomRight,
                        BottomLeft,
                        TopLeft
                    };
                    byte[] types =
                    {
                        (byte)PathPointType.Start,
                        (byte)PathPointType.Line,
                        (byte)PathPointType.Line,
                        (byte)PathPointType.Line,
                        (byte)PathPointType.Line
                    };
                    return new GraphicsPath(points, types);
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }
    }
}
