﻿using System;
using System.Drawing;
using System.Globalization;
using System.Reflection;
using System.Text;
using System.Text.RegularExpressions;

namespace Kasuga.Ass
{
    public static class AssColorConverter
    {
        public static string ConvertToAssAbgrString(Color value)
        {
            try
            {
                StringBuilder builder = new StringBuilder();
                builder.Append("&H");
                builder.Append((byte.MaxValue - value.A).ToString("X2"));
                builder.Append(value.B.ToString("X2"));
                builder.Append(value.G.ToString("X2"));
                builder.Append(value.R.ToString("X2"));
                builder.Append("&");
                return builder.ToString();
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return string.Empty;
            }
        }

        public static bool CanConvertFromAssAbgrString(string value)
        {
            try
            {
                Regex regex = new Regex(@"^\&H([0-9A-Fa-f]{1,8})\&?$");
                Match match = regex.Match(value);
                return match.Success;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return false;
            }
        }

        public static Color ConvertFromAssAbgrString(string value)
        {
            try
            {
                Regex regex = new Regex(@"^\&H([0-9A-Fa-f]{1,8})\&?$");
                Match match = regex.Match(value);
                string str;
                if (match.Success)
                {
                    str = match.Groups[1].Value;
                    if (str.Length < 8)
                    {
                        str = str.PadLeft(8, '0');
                    }
                }
                else
                {
                    int i;
                    if (int.TryParse(value, out i))
                    {
                        str = i.ToString("X8");
                    }
                    else
                    {
                        throw new FormatException();
                    }
                }
                int alpha, blue, green, red;
                alpha = byte.MaxValue - int.Parse(str.Substring(0, 2), NumberStyles.HexNumber);
                blue = int.Parse(str.Substring(2, 2), NumberStyles.HexNumber);
                green = int.Parse(str.Substring(4, 2), NumberStyles.HexNumber);
                red = int.Parse(str.Substring(6, 2), NumberStyles.HexNumber);
                return Color.FromArgb(alpha, red, green, blue);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return Color.Empty;
            }
        }

        public static string ConvertToAssBgrString(Color value)
        {
            try
            {
                StringBuilder builder = new StringBuilder();
                builder.Append("&H");
                builder.Append(value.B.ToString("X2"));
                builder.Append(value.G.ToString("X2"));
                builder.Append(value.R.ToString("X2"));
                builder.Append("&");
                return builder.ToString();
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return string.Empty;
            }
        }

        public static bool CanConvertFromAssBgrString(string value)
        {
            try
            {
                Regex regex = new Regex(@"^\&H([0-9A-Fa-f]{1,6})\&$");
                Match match = regex.Match(value);
                return match.Success;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return false;
            }
        }

        public static Color ConvertFromAssBgrString(string value)
        {
            try
            {
                Regex regex = new Regex(@"^\&H([0-9A-Fa-f]{1,6})\&$");
                Match match = regex.Match(value);
                string str;
                if (match.Success)
                {
                    str = match.Groups[1].Value;
                    if (str.Length < 6)
                    {
                        str = str.PadLeft(6, '0');
                    }
                }
                else
                {
                    int i;
                    if (int.TryParse(value, out i))
                    {
                        str = i.ToString("X6");
                    }
                    else
                    {
                        throw new FormatException();
                    }
                }
                int blue, green, red;
                blue = int.Parse(str.Substring(0, 2), NumberStyles.HexNumber);
                green = int.Parse(str.Substring(2, 2), NumberStyles.HexNumber);
                red = int.Parse(str.Substring(4, 2), NumberStyles.HexNumber);
                return Color.FromArgb(red, green, blue);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return Color.Empty;
            }
        }

        public static string ConvertToAssAlphaString(byte value)
        {
            try
            {
                StringBuilder builder = new StringBuilder();
                builder.Append("&H");
                builder.Append((byte.MaxValue - value).ToString("X2"));
                builder.Append("&");
                return builder.ToString();
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return string.Empty;
            }
        }

        public static bool CanConvertFromAssAlphaString(string value)
        {
            try
            {
                Regex regex = new Regex(@"^\&H([0-9A-Fa-f]{1,2})\&$");
                Match match = regex.Match(value);
                return match.Success;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return false;
            }
        }

        public static byte ConvertFromAssAlphaString(string value)
        {
            try
            {
                Regex regex = new Regex(@"^\&H([0-9A-Fa-f]{1,2})\&$");
                Match match = regex.Match(value);
                if (match.Success)
                {
                    return byte.Parse(match.Groups[1].Value, NumberStyles.HexNumber);
                }
                else
                {
                    byte b;
                    if (byte.TryParse(value, out b))
                    {
                        return (byte)(byte.MaxValue - b);
                    }
                    else
                    {
                        throw new FormatException();
                    }
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return byte.MinValue;
            }
        }
    }
}
