//  C DLL t@CłB

#include "stdafx.h"
#include "Kasuga.DirectShow.h"

using namespace System;
using namespace System::Reflection;
using namespace System::Runtime::InteropServices;
using namespace Kasuga;
using namespace Kasuga::DirectShow;

AudioPlayer::AudioPlayer(IntPtr hwnd, int wmGraphNotify)
{
	try
	{
		_graphBuilder = NULL;
		_mediaControl = NULL;
		_mediaEventEx = NULL;
		_mediaSeeking = NULL;
		_basicAudio = NULL;
		_hwnd = (OAHWND)(void*)hwnd;
		_wmGraphNotify = wmGraphNotify;
	}
	catch (Exception^ exception)
	{
		Debug::Show(
			exception,
			Assembly::GetExecutingAssembly(),
			MethodBase::GetCurrentMethod());
	}
}

AudioPlayer::~AudioPlayer()
{
	try
	{
		AudioPlayer::!AudioPlayer();
	}
	catch (Exception^ exception)
	{
		Debug::Show(
			exception,
			Assembly::GetExecutingAssembly(),
			MethodBase::GetCurrentMethod());
	}
}

AudioPlayer::!AudioPlayer()
{
	try
	{
		if (_graphBuilder != NULL)
		{
			_graphBuilder->Release();
			_graphBuilder = NULL;
		}
		if (_mediaControl != NULL)
		{
			_mediaControl->Release();
			_mediaControl = NULL;
		}
		if (_mediaEventEx != NULL)
		{
			_mediaEventEx->Release();
			_mediaEventEx = NULL;
		}
		if (_mediaSeeking != NULL)
		{
			_mediaSeeking->Release();
			_mediaSeeking = NULL;
		}
		if (_basicAudio != NULL)
		{
			_basicAudio->Release();
			_basicAudio = NULL;
		}
		CoUninitialize();
	}
	catch (Exception^ exception)
	{
		Debug::Show(
			exception,
			Assembly::GetExecutingAssembly(),
			MethodBase::GetCurrentMethod());
	}
}

FilterStateKind AudioPlayer::FilterState::get()
{
	try
	{
		if (_mediaControl == NULL)
		{
			return Stopped;
		}

		FILTER_STATE state;
		{
			HRESULT hr = _mediaControl->GetState(-1, (OAFilterState*)&state);
			if (FAILED(hr))
			{
				Marshal::ThrowExceptionForHR(hr);
			}
		}
		switch (state)
		{
			case State_Stopped:
				return Stopped;
			case State_Paused:
				return Paused;
			case State_Running:
				return Running;
			default:
				return Stopped;
		}
	}
	catch (Exception^ exception)
	{
		Debug::Show(
			exception,
			Assembly::GetExecutingAssembly(),
			MethodBase::GetCurrentMethod());
		return Stopped;
	}
}

PlayTimeSpan^ AudioPlayer::Duration::get()
{
	try
	{
		if (_mediaSeeking == NULL)
		{
			return PlayTimeSpan::Zero;
		}

		LONGLONG duration;
		{
			HRESULT hr = _mediaSeeking->GetDuration(&duration);
			if (FAILED(hr))
			{
				Marshal::ThrowExceptionForHR(hr);
			}
		}
		return gcnew PlayTimeSpan(duration * Math::Pow(10, -7));
	}
	catch (Exception^ exception)
	{
		Debug::Show(
			exception,
			Assembly::GetExecutingAssembly(),
			MethodBase::GetCurrentMethod());
		return PlayTimeSpan::Zero;
	}
}

PlayTime^ AudioPlayer::CurrentPosition::get()
{
	try
	{
		if (_mediaSeeking == NULL)
		{
			return PlayTime::Zero;
		}

		LONGLONG current;
		{
			HRESULT hr = _mediaSeeking->GetCurrentPosition(&current);
			if (FAILED(hr))
			{
				Marshal::ThrowExceptionForHR(hr);
			}
		}
		return gcnew PlayTime(current * Math::Pow(10, -7));
	}
	catch (Exception^ exception)
	{
		Debug::Show(
			exception,
			Assembly::GetExecutingAssembly(),
			MethodBase::GetCurrentMethod());
		return PlayTime::Zero;
	}
}

void AudioPlayer::CurrentPosition::set(PlayTime^ value)
{
	try
	{
		if (_mediaSeeking == NULL)
		{
			return;
		}

		LONGLONG current = (LONGLONG)(value->TotalSeconds / Math::Pow(10, -7));
		{
			HRESULT hr = _mediaSeeking->SetPositions(
				&current,
				AM_SEEKING_AbsolutePositioning,
				0,
				AM_SEEKING_NoPositioning);
			if (FAILED(hr))
			{
				Marshal::ThrowExceptionForHR(hr);
			}
		}
	}
	catch (Exception^ exception)
	{
		Debug::Show(
			exception,
			Assembly::GetExecutingAssembly(),
			MethodBase::GetCurrentMethod());
	}
}

double AudioPlayer::Rate::get()
{
	try
	{
		if (_mediaSeeking == NULL)
		{
			return 1;
		}

		double rate;
		{
			HRESULT hr = _mediaSeeking->GetRate(&rate);
			if (FAILED(hr))
			{
				Marshal::ThrowExceptionForHR(hr);
			}
		}
		return rate;
	}
	catch (Exception^ exception)
	{
		Debug::Show(
			exception,
			Assembly::GetExecutingAssembly(),
			MethodBase::GetCurrentMethod());
		return 1;
	}
}

void AudioPlayer::Rate::set(double value)
{
	try
	{
		if (_mediaSeeking == NULL)
		{
			return;
		}

		HRESULT hr = _mediaSeeking->SetRate(value);
		if (FAILED(hr))
		{
			Marshal::ThrowExceptionForHR(hr);
		}
	}
	catch (Exception^ exception)
	{
		Debug::Show(
			exception,
			Assembly::GetExecutingAssembly(),
			MethodBase::GetCurrentMethod());
	}
}

double AudioPlayer::Volume::get()
{
	try
	{
		if (_basicAudio == NULL)
		{
			return 0;
		}

		long volume;
		{
			HRESULT hr = _basicAudio->get_Volume(&volume);
			if (FAILED(hr))
			{
				Marshal::ThrowExceptionForHR(hr);
			}
		}
		return Math::Pow(10, volume / 2000.0);
	}
	catch (Exception^ exception)
	{
		Debug::Show(
			exception,
			Assembly::GetExecutingAssembly(),
			MethodBase::GetCurrentMethod());
		return 0;
	}
}

void AudioPlayer::Volume::set(double value)
{
	try
	{
		if (_basicAudio == NULL)
		{
			return;
		}

		long volume;
		if (value > 0)
		{
			volume = (int)(2000 * Math::Log10(value));
			if (volume < -10000)
			{
				volume = -10000;
			}
		}
		else
		{
			volume = -10000;
		}
		{
			HRESULT hr = _basicAudio->put_Volume(volume);
			if (FAILED(hr))
			{
				Marshal::ThrowExceptionForHR(hr);
			}
		}
	}
	catch (Exception^ exception)
	{
		Debug::Show(
			exception,
			Assembly::GetExecutingAssembly(),
			MethodBase::GetCurrentMethod());
	}
}

bool AudioPlayer::OpenFile(String^ fileName)
{
	try
	{
		if (_graphBuilder != NULL)
		{
			_graphBuilder->Release();
			_graphBuilder = NULL;
			if (_mediaControl != NULL)
			{
				_mediaControl->Release();
				_mediaControl = NULL;
			}
			if (_mediaEventEx != NULL)
			{
				_mediaEventEx->Release();
				_mediaEventEx = NULL;
			}
			if (_mediaSeeking != NULL)
			{
				_mediaSeeking->Release();
				_mediaSeeking = NULL;
			}
			if (_basicAudio != NULL)
			{
				_basicAudio->Release();
				_basicAudio = NULL;
			}
			CoUninitialize();
		}
		{
			HRESULT hr = CoInitialize(NULL);
			if (FAILED(hr))
			{
				Marshal::ThrowExceptionForHR(hr);
			}
		}
		{
			pin_ptr<IGraphBuilder*> p = &_graphBuilder;
			HRESULT hr = CoCreateInstance(CLSID_FilterGraph, NULL, CLSCTX_INPROC, IID_IGraphBuilder, (LPVOID*)p);
			if (FAILED(hr))
			{
				Marshal::ThrowExceptionForHR(hr);
			}
		}
		{
			pin_ptr<IMediaControl*> p = &_mediaControl;
			HRESULT hr = _graphBuilder->QueryInterface(IID_IMediaControl, (LPVOID*)p);
			if (FAILED(hr))
			{
				Marshal::ThrowExceptionForHR(hr);
			}
		}
		{
			pin_ptr<IMediaEventEx*> p = &_mediaEventEx;
			HRESULT hr = _graphBuilder->QueryInterface(IID_IMediaEventEx, (LPVOID*)p);
			if (FAILED(hr))
			{
				Marshal::ThrowExceptionForHR(hr);
			}
		}
		{
			HRESULT hr = _mediaEventEx->SetNotifyWindow(_hwnd, _wmGraphNotify, NULL);
			if (FAILED(hr))
			{
				Marshal::ThrowExceptionForHR(hr);
			}
		}
		{
			pin_ptr<IMediaSeeking*> p = &_mediaSeeking;
			HRESULT hr = _graphBuilder->QueryInterface(IID_IMediaSeeking, (LPVOID*)p);
			if (FAILED(hr))
			{
				Marshal::ThrowExceptionForHR(hr);
			}
		}
		{
			HRESULT hr = _mediaSeeking->SetTimeFormat(&TIME_FORMAT_MEDIA_TIME);
			if (FAILED(hr))
			{
				Marshal::ThrowExceptionForHR(hr);
			}
		}
		{
			pin_ptr<IBasicAudio*> p = &_basicAudio;
			HRESULT hr = _graphBuilder->QueryInterface(IID_IBasicAudio, (LPVOID*)p);
			if (FAILED(hr))
			{
				Marshal::ThrowExceptionForHR(hr);
			}
		}
		{
			HRESULT hr = _graphBuilder->RenderFile((LPCWSTR)(void*)Marshal::StringToHGlobalUni(fileName), NULL);
			if (FAILED(hr))
			{
				Marshal::ThrowExceptionForHR(hr);
			}
		}

		bool hasVideo = false;
		{
			IEnumFilters* enumFilters = NULL;
			{
				HRESULT hr = _graphBuilder->EnumFilters(&enumFilters);
				if (FAILED(hr))
				{
					Marshal::ThrowExceptionForHR(hr);
				}
			}
			IBaseFilter* baseFilters = NULL;
			while (enumFilters->Next(1, &baseFilters, NULL) == S_OK)
			{
				IEnumPins* enumPins = NULL;
				{
					HRESULT hr = baseFilters->EnumPins(&enumPins);
					if (FAILED(hr))
					{
						Marshal::ThrowExceptionForHR(hr);
					}
				}
				IPin* pins = NULL;
				while (enumPins->Next(1, &pins, NULL) == S_OK)
				{
					AM_MEDIA_TYPE mediaType;
					{
						HRESULT hr = pins->ConnectionMediaType(&mediaType);
						if (FAILED(hr))
						{
							Marshal::ThrowExceptionForHR(hr);
						}
					}
					if (mediaType.majortype == MEDIATYPE_Video)
					{
						hasVideo = true;
					}
					pins->Release();
					pins = NULL;
					if (hasVideo)
					{
						break;
					}
				}
				enumPins->Release();
				enumPins = NULL;
				baseFilters->Release();
				baseFilters = NULL;
				if (hasVideo)
				{
					break;
				}
			}
			enumFilters->Release();
			enumFilters = NULL;
		}
		if (hasVideo)
		{
			IVideoWindow* videoWindow;
			{
				pin_ptr<IVideoWindow*> p = &videoWindow;
				HRESULT hr = _graphBuilder->QueryInterface(IID_IVideoWindow, (LPVOID*)p);
				if (FAILED(hr))
				{
					Marshal::ThrowExceptionForHR(hr);
				}
			}
			{
				HRESULT hr = videoWindow->put_AutoShow(OAFALSE);
				if (FAILED(hr))
				{
					Marshal::ThrowExceptionForHR(hr);
				}
			}
			videoWindow->Release();
			videoWindow = NULL;
		}
		return true;
	}
	catch (Exception^ exception)
	{
		Debug::Show(
			exception,
			Assembly::GetExecutingAssembly(),
			MethodBase::GetCurrentMethod());
		return false;
	}
}

void AudioPlayer::Run()
{
	try
	{
		if (_mediaControl == NULL)
		{
			return;
		}

		HRESULT hr = _mediaControl->Run();
		if (FAILED(hr))
		{
			Marshal::ThrowExceptionForHR(hr);
		}
	}
	catch (Exception^ exception)
	{
		Debug::Show(
			exception,
			Assembly::GetExecutingAssembly(),
			MethodBase::GetCurrentMethod());
	}
}

void AudioPlayer::Pause()
{
	try
	{
		if (_mediaControl == NULL)
		{
			return;
		}

		HRESULT hr = _mediaControl->Pause();
		if (FAILED(hr))
		{
			Marshal::ThrowExceptionForHR(hr);
		}
	}
	catch (Exception^ exception)
	{
		Debug::Show(
			exception,
			Assembly::GetExecutingAssembly(),
			MethodBase::GetCurrentMethod());
	}
}

void AudioPlayer::Stop()
{
	try
	{
		if (_mediaControl == NULL)
		{
			return;
		}

		HRESULT hr = _mediaControl->Stop();
		if (FAILED(hr))
		{
			Marshal::ThrowExceptionForHR(hr);
		}
	}
	catch (Exception^ exception)
	{
		Debug::Show(
			exception,
			Assembly::GetExecutingAssembly(),
			MethodBase::GetCurrentMethod());
	}
}

void AudioPlayer::OnEvent(IntPtr wParam, IntPtr lParam, bool% complete)
{
	try
	{
		complete = false;
		if (_mediaEventEx == NULL)
		{
			return;
		}

		long eventCode, param1, param2;
		if (_mediaEventEx->GetEvent(&eventCode, &param1, &param2, 0) == S_OK)
		{
			switch (eventCode)
			{
				case EC_COMPLETE:
					Stop();
					CurrentPosition = PlayTime::Zero;
					complete = true;
					break;
			}
			{
				HRESULT hr =_mediaEventEx->FreeEventParams(eventCode, param1, param2);
				if (FAILED(hr))
				{
					Marshal::ThrowExceptionForHR(hr);
				}
			}
		}
	}
	catch (Exception^ exception)
	{
		Debug::Show(
			exception,
			Assembly::GetExecutingAssembly(),
			MethodBase::GetCurrentMethod());
	}
}
