﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Reflection;

namespace Kasuga
{
    public class WordArrangementTypeListConverter : TypeListConverter
    {
        public static Type[] Types;
        public static List<PluginTypeInfo> Plugins = new List<PluginTypeInfo>();

        protected WordArrangementTypeListConverter() : base(Types) { }

        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType)
        {
            try
            {
                if (destinationType == typeof(string))
                {
                    return true;
                }
                return base.CanConvertTo(context, destinationType);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return false;
            }
        }

        public override object ConvertTo(ITypeDescriptorContext context, System.Globalization.CultureInfo culture, object value, Type destinationType)
        {
            try
            {
                if (destinationType == typeof(string) && value is Type)
                {
                    foreach (PluginTypeInfo plugin in Plugins)
                    {
                        if ((Type)value == plugin.Type)
                        {
                            return plugin.Name;
                        }
                    }
                }
                return base.ConvertTo(context, culture, value, destinationType);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }

        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType)
        {
            try
            {
                if (sourceType == typeof(string))
                {
                    return true;
                }
                return base.CanConvertFrom(context, sourceType);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return false;
            }
        }

        public override object ConvertFrom(ITypeDescriptorContext context, System.Globalization.CultureInfo culture, object value)
        {
            try
            {
                if (value.GetType() == typeof(string))
                {
                    foreach (PluginTypeInfo plugin in Plugins)
                    {
                        if ((string)value == plugin.Name)
                        {
                            return plugin.Type;
                        }
                    }
                }
                return base.ConvertFrom(context, culture, value);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }
    }
}
