﻿using System;
using System.ComponentModel;
using System.Reflection;

namespace Kasuga
{
    public class PositionAndPlayTimeConverter : TypeConverter
    {
        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType)
        {
            try
            {
                if (destinationType == typeof(string))
                {
                    return true;
                }
                return base.CanConvertTo(context, destinationType);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return false;
            }
        }

        public override object ConvertTo(ITypeDescriptorContext context, System.Globalization.CultureInfo culture, object value, Type destinationType)
        {
            try
            {
                if (destinationType == typeof(string)
                    && value is PositionAndPlayTime)
                {
                    PositionAndPlayTime pp = (PositionAndPlayTime)value;
                    return pp.Position.ToString("F3") + ", " + pp.PlayTime.ToAssTimeString();
                }
                return base.ConvertTo(context, culture, value, destinationType);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }

        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType)
        {
            try
            {
                if (sourceType == typeof(string))
                {
                    return true;
                }
                return base.CanConvertFrom(context, sourceType);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return false;
            }
        }

        public override object ConvertFrom(ITypeDescriptorContext context, System.Globalization.CultureInfo culture, object value)
        {
            try
            {
                if (value.GetType() == typeof(string))
                {
                    PositionAndPlayTime pp = new PositionAndPlayTime();
                    string[] separator = { "," };
                    string[] splits = ((string)value).Split(separator, 2, StringSplitOptions.None);
                    if (splits.Length >= 2)
                    {
                        for (int i = 0; i < splits.Length; i++)
                        {
                            splits[i] = splits[i].Trim();
                        }
                        float f;
                        if (float.TryParse(splits[0], out f) && PlayTime.IsAssTimeString(splits[1]))
                        {
                            pp.Position = f;
                            pp.PlayTime = PlayTime.FromAssTimeString(splits[1]);
                            return pp;
                        }
                    }
                }
                return base.ConvertFrom(context, culture, value);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }
    }
}
