﻿using System;
using System.ComponentModel;
using System.Reflection;

namespace Kasuga
{
    [Serializable]
    public class PositionAndPlayTime
    {
        [DisplayName("地点")]
        public double Position { get; set; }
        [DisplayName("再生時間")]
        public PlayTime PlayTime { get; set; }

        public PositionAndPlayTime()
        {
            try
            {
                Position = 0;
                PlayTime = PlayTime.Zero;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public PositionAndPlayTime(double position, PlayTime playTime)
        {
            try
            {
                Position = position;
                PlayTime = playTime;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }
    }
}
