﻿using System;
using System.Collections.Generic;
using System.Reflection;

namespace Kasuga
{
    public class PageArrangementWrapper : PluginWrapper<IPageArrangement>
    {
        public PageArrangementWrapper() : base() { }
        public PageArrangementWrapper(string baseName, IPageArrangement plugin) : base(baseName, plugin) { }

        protected override IPageArrangement GetPluginByName(string name)
        {
            try
            {
                CatalogItem<IPageArrangement> item = CatalogManager.PageArrangementCatalog.Find((CatalogItem<IPageArrangement> listItem) =>
                {
                    return listItem.Name == name;
                });
                return item != null ? (IPageArrangement)item.Plugin.Clone() : null;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }
    }
}
