﻿using System;
using System.Collections.Generic;
using System.Reflection;

namespace Kasuga
{
    public class LineArrangementWrapper : PluginWrapper<ILineArrangement>
    {
        public LineArrangementWrapper() : base() { }
        public LineArrangementWrapper(string baseName, ILineArrangement plugin) : base(baseName, plugin) { }

        protected override ILineArrangement GetPluginByName(string name)
        {
            try
            {
                CatalogItem<ILineArrangement> item = CatalogManager.LineArrangementCatalog.Find((CatalogItem<ILineArrangement> listItem) =>
                {
                    return listItem.Name == name;
                });
                return item != null ? (ILineArrangement)item.Plugin.Clone() : null;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }
    }
}
