﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Reflection;
using System.Xml.Serialization;

namespace Kasuga
{
    [Serializable]
    [TypeConverter(typeof(KsgSubtitleElementConverter))]
    public class KsgPart : ISubtitleElement, IHasFormatDictionary, IHasWordArrangementDictionary, IHasLineArrangementDictionary, IHasPageArrangementDictionary
    {
        public KsgPart()
        {
            try
            {
                Pages = new List<KsgPage>();
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public void Initialize(KsgSubtitle parentSubtitle)
        {
            try
            {
                _parentSubtitle = parentSubtitle;
                foreach (KsgPage page in Pages)
                {
                    page.Initialize(this);
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        [Browsable(false)]
        public List<KsgPage> Pages { get; set; }
        private KsgSubtitle _parentSubtitle;

        [Browsable(false)]
        [XmlIgnore]
        public KsgSubtitle ParentSubtitle
        {
            get
            {
                try
                {
                    return _parentSubtitle;
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }

        [Browsable(false)]
        [XmlIgnore]
        public List<KsgLine> Lines
        {
            get
            {
                try
                {
                    List<KsgLine> lines = new List<KsgLine>();
                    foreach (KsgPage page in Pages)
                    {
                        lines.AddRange(page.Lines);
                    }
                    return lines;
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }

        [Browsable(false)]
        [XmlIgnore]
        public List<KsgWord> Words
        {
            get
            {
                try
                {
                    List<KsgWord> words = new List<KsgWord>();
                    foreach (KsgPage page in Pages)
                    {
                        words.AddRange(page.Words);
                    }
                    return words;
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }

        [Browsable(false)]
        [XmlIgnore]
        public List<KsgCharacter> MainTextCharacters
        {
            get
            {
                try
                {
                    List<KsgCharacter> characters = new List<KsgCharacter>();
                    foreach (KsgPage page in Pages)
                    {
                        characters.AddRange(page.MainTextCharacters);
                    }
                    return characters;
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }

        [Browsable(false)]
        [XmlIgnore]
        public List<KsgCharacter> RubyTextCharacters
        {
            get
            {
                try
                {
                    List<KsgCharacter> characters = new List<KsgCharacter>();
                    foreach (KsgPage page in Pages)
                    {
                        characters.AddRange(page.RubyTextCharacters);
                    }
                    return characters;
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }

        [Browsable(false)]
        [XmlIgnore]
        public List<KsgCharacter> Characters
        {
            get
            {
                try
                {
                    List<KsgCharacter> characters = new List<KsgCharacter>();
                    foreach (KsgPage page in Pages)
                    {
                        characters.AddRange(page.Characters);
                    }
                    return characters;
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }

        [Category("ページ内要素の配置")]
        [DisplayName("ベース")]
        [XmlIgnore]
        public string BasePageArrangementName
        {
            get
            {
                try
                {
                    return Elements.GetBasePageArrangementName(Pages);
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
            set
            {
                try
                {
                    Elements.SetBasePageArrangementName(Pages, value);
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                }
            }
        }

        [Browsable(false)]
        [XmlIgnore]
        public IPageArrangement BasePageArrangement
        {
            get
            {
                try
                {
                    return Elements.GetBasePageArrangement(this);
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }

        [Category("ページ内要素の配置")]
        [DisplayName("タイプ")]
        [TypeConverter(typeof(PageArrangementTypeListConverter))]
        [XmlIgnore]
        public Type PageArrangementType
        {
            get
            {
                try
                {
                    return Elements.GetPageArrangementType(Pages);
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }

        [XmlIgnore]
        public Dictionary<string, object> PageArrangementDictionary { get; set; }

        [Category("行内要素の配置")]
        [DisplayName("ベース")]
        [XmlIgnore]
        public string BaseLineArrangementName
        {
            get
            {
                try
                {
                    return Elements.GetBaseLineArrangementName(Lines);
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
            set
            {
                try
                {
                    Elements.SetBaseLineArrangementName(Lines, value);
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                }
            }
        }

        [Browsable(false)]
        [XmlIgnore]
        public ILineArrangement BaseLineArrangement
        {
            get
            {
                try
                {
                    return Elements.GetBaseLineArrangement(this);
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }

        [Category("行内要素の配置")]
        [DisplayName("タイプ")]
        [TypeConverter(typeof(LineArrangementTypeListConverter))]
        [XmlIgnore]
        public Type LineArrangementType
        {
            get
            {
                try
                {
                    return Elements.GetLineArrangementType(Lines);
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }

        [XmlIgnore]
        public Dictionary<string, object> LineArrangementDictionary { get; set; }

        [Category("単語内要素の配置")]
        [DisplayName("ベース")]
        [XmlIgnore]
        public string BaseWordArrangementName
        {
            get
            {
                try
                {
                    return Elements.GetBaseWordArrangementName(Words);
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
            set
            {
                try
                {
                    Elements.SetBaseWordArrangementName(Words, value);
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                }
            }
        }

        [Browsable(false)]
        [XmlIgnore]
        public IWordArrangement BaseWordArrangement
        {
            get
            {
                try
                {
                    return Elements.GetBaseWordArrangement(this);
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }

        [Category("単語内要素の配置")]
        [DisplayName("タイプ")]
        [TypeConverter(typeof(WordArrangementTypeListConverter))]
        [XmlIgnore]
        public Type WordArrangementType
        {
            get
            {
                try
                {
                    return Elements.GetWordArrangementType(Words);
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }

        [XmlIgnore]
        public Dictionary<string, object> WordArrangementDictionary { get; set; }

        [Category("書式")]
        [DisplayName("ベース")]
        [XmlIgnore]
        public string BaseFormatName
        {
            get
            {
                try
                {
                    return Elements.GetBaseFormatName(Characters);
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
            set
            {
                try
                {
                    Elements.SetBaseFormatName(Characters, value);
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                }
            }
        }

        [Browsable(false)]
        [XmlIgnore]
        public IFormat BaseFormat
        {
            get
            {
                try
                {
                    return Elements.GetBaseFormat(this);
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }

        [Category("書式")]
        [DisplayName("タイプ")]
        [TypeConverter(typeof(FormatTypeListConverter))]
        [XmlIgnore]
        public Type FormatType
        {
            get
            {
                try
                {
                    return Elements.GetFormatType(Characters);
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }

        [XmlIgnore]
        public Dictionary<string, object> FormatDictionary { get; set; }

        public void ExportToAss(
            List<Ass.AssStyle> styles,
            List<Ass.AssEvent> events)
        {
            try
            {
                foreach (KsgCharacter character in Characters)
                {
                    character.ExportToAss(styles, events);
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public void PageArrange()
        {
            try
            {
                foreach (KsgPage page in Pages)
                {
                    page.PageArrange();
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public void LineArrange()
        {
            try
            {
                foreach (KsgLine line in Lines)
                {
                    line.LineArrange();
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public void WordArrange()
        {
            try
            {
                foreach (KsgWord word in Words)
                {
                    word.WordArrange();
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public void SetFormatProperty(string propertyName, object value, bool tooParent)
        {
            try
            {
                foreach (KsgPage page in Pages)
                {
                    page.SetFormatProperty(propertyName, value, false);
                }
                RefreshFormatProperty(false, tooParent);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public void RefreshFormatProperty(bool tooChildren, bool tooParent)
        {
            try
            {
                if (tooChildren)
                {
                    foreach (KsgPage page in Pages)
                    {
                        page.RefreshFormatProperty(true, false);
                    }
                }
                FormatDictionary = Elements.GetFormat(Characters);
                if (tooParent && ParentSubtitle != null)
                {
                    ParentSubtitle.RefreshFormatProperty(false, true);
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public void SetWordArrangementProperty(string propertyName, object value, bool tooParent)
        {
            try
            {
                foreach (KsgPage page in Pages)
                {
                    page.SetWordArrangementProperty(propertyName, value, false);
                }
                RefreshWordArrangementProperty(false, tooParent);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public void RefreshWordArrangementProperty(bool tooChildren, bool tooParent)
        {
            try
            {
                if (tooChildren)
                {
                    foreach (KsgPage page in Pages)
                    {
                        page.RefreshWordArrangementProperty(true, false);
                    }
                }
                WordArrangementDictionary = Elements.GetWordArrangement(Words);
                if (tooParent && ParentSubtitle != null)
                {
                    ParentSubtitle.RefreshWordArrangementProperty(false, true);
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public void SetLineArrangementProperty(string propertyName, object value, bool tooParent)
        {
            try
            {
                foreach (KsgPage page in Pages)
                {
                    page.SetLineArrangementProperty(propertyName, value, false);
                }
                RefreshLineArrangementProperty(false, tooParent);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public void RefreshLineArrangementProperty(bool tooChildren, bool tooParent)
        {
            try
            {
                if (tooChildren)
                {
                    foreach (KsgPage page in Pages)
                    {
                        page.RefreshLineArrangementProperty(true, false);
                    }
                }
                LineArrangementDictionary = Elements.GetLineArrangement(Lines);
                if (tooParent && ParentSubtitle != null)
                {
                    ParentSubtitle.RefreshLineArrangementProperty(false, true);
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public void SetPageArrangementProperty(string propertyName, object value, bool tooParent)
        {
            try
            {
                foreach (KsgPage page in Pages)
                {
                    page.SetPageArrangementProperty(propertyName, value, false);
                }
                RefreshPageArrangementProperty(false, tooParent);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public void RefreshPageArrangementProperty(bool tooChildren, bool tooParent)
        {
            try
            {
                if (tooChildren)
                {
                    foreach (KsgPage page in Pages)
                    {
                        page.RefreshPageArrangementProperty(true, false);
                    }
                }
                PageArrangementDictionary = Elements.GetPageArrangement(Pages);
                if (tooParent && ParentSubtitle != null)
                {
                    ParentSubtitle.RefreshPageArrangementProperty(false, true);
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }
    }
}
