#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This file is part of Karesansui Core.
#
# Copyright (C) 2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#


from karesansui.lib.virt.virt import KaresansuiVirtConnection
from karesansui.lib.const import STORAGE_VOLUME_SIZE_MAX_LENGTH, STORAGE_VOLUME_UNIT


def get_storage_volume_max_size_by_unit(pool_name, unit=None):
    try:
        kvc = KaresansuiVirtConnection()
        pool_obj = kvc.search_kvn_storage_pools(pool_name)[0]
        pool_info = pool_obj.get_info()
    finally:
        kvc.close()

    if not pool_info['allocation'] or pool_info['allocation'] == 0:
        storage_volume_max_size = STORAGE_VOLUME_SIZE_MAX_LENGTH
    elif unit is None:
        storage_volume_max_size = long(pool_info['allocation'])
    else:
        storage_volume_max_size = long(pool_info['allocation']) / STORAGE_VOLUME_UNIT.get(unit, 1)

    return storage_volume_max_size

