#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This file is part of Karesansui Core.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#

import os
import re
import sys
import glob

from karesansui.lib.dict_op import DictOp
from karesansui.lib.parser.xml_like_conf_parser import xmlLikeConfParser as Parser
from karesansui.lib.utils import preprint_r


"""
Define Variables for This Parser
"""
PARSER_COLLECTD_PLUGIN_DIR="/etc/opt/hde/collectd.d"

class collectdpluginParser:

    _module = "collectdplugin"

    def __init__(self):
        self.dop = DictOp()
        self.dop.addconf(self._module,{})

        self.parser = Parser()
        self.parser.set_delim("[ \t]+")
        self.parser.set_new_delim("\t")
        self.parser.set_comment("#")
        self.base_parser_name = self.parser.__class__.__name__

        from karesansui.lib.parser.collectd import collectdParser
        collectdp = collectdParser()

        self.parser.set_opt_uni(collectdp.opt_uni)
        self.parser.set_opt_multi(collectdp.opt_multi)
        self.parser.set_opt_sect(collectdp.opt_sect)

        pass

    def set_footer(self, footer=""):
        self.parser.set_footer(footer)

    def source_file(self):
        retval = []

        glob_str = "%s/*.conf" % (PARSER_COLLECTD_PLUGIN_DIR,)
        for _afile in glob.glob(glob_str):
            retval.append(_afile)

        return retval

    def read_conf(self):
        retval = {}

        for _afile in self.source_file():

            plugin_name = re.sub("\.conf$","",os.path.basename(_afile))
            self.parser.set_source_file([_afile])
            conf_arr = self.parser.read_conf()
            try:
                self.dop.set(self._module,[plugin_name],conf_arr[_afile]['value'])
            except:
                pass

        self.dop.set(self._module,['@BASE_PARSER'],self.base_parser_name)
        #self.dop.preprint_r(self._module)
        return self.dop.getconf(self._module)

    def write_conf(self,conf_arr={},dryrun=False):
        retval = True

        for plugin_name,_v in conf_arr.iteritems():

            _afile = "%s/%s.conf" % (PARSER_COLLECTD_PLUGIN_DIR,plugin_name,)
            try:
                _v['action']
                if _v['action'] == "delete":
                    if os.path.exists(_afile):
                        os.unlink(_afile)
                        #pass
            except:
                continue

            try:
                _v['value']

                self.dop.addconf("parser",{})
                self.dop.set("parser",[_afile],_v['value'])
                #self.dop.preprint_r("parser")
                arr = self.dop.getconf("parser")
                self.parser.write_conf(arr,dryrun)
            except:
                pass

        return retval

"""
parser = collectdpluginParser()

# 読み込み
dop = DictOp()
dop.addconf("dum",parser.read_conf())

new_plugin_name = "takuma"

##########################################################
# Uniオプション (一箇所しか設定できないオプション) の追加
##########################################################
# 'Foo foo' を追加（設定値リスト形式モードよる addメソッド）
dop.add("dum",[new_plugin_name,"Foo"],["foo",[["comment foo1","comment foo2"],"comment foo3"]])

# 'Bar bar' を追加（設定値文字列形式モードによる cdp_setメソッド）
dop.cdp_set("dum",[new_plugin_name,"Bar"],"bar",multiple_file=True)
dop.cdp_set_pre_comment("dum",[new_plugin_name,"Bar"],["","comment bar1","comment bar2"],multiple_file=True)
dop.cdp_set_post_comment("dum",[new_plugin_name,"Bar"],"comment bar3",multiple_file=True)

##########################################################
# Multiオプション (複数設定できるオプション) の追加
##########################################################
# 'LoadPlugin target_hoge' を追加
dop.cdp_set("dum",[new_plugin_name,"LoadPlugin","target_hoge"],"target_hoge",multiple_file=True,is_opt_multi=True)
#import pdb; pdb.set_trace()
dop.cdp_set_pre_comment("dum",[new_plugin_name,"LoadPlugin","target_hoge"],["","Dis is target_hoge"],multiple_file=True)

##########################################################
# Sectオプション (<ブラケット>ディレクティブオプション) の追加
##########################################################
# 下記 を追加
# <Plugin "foobar">
#        <View "hoge">
#                SubOpt1         gege # post
#        </View>
#        Option2         false
#        Option1         true
# </Plugin>
dop.cdp_set("dum",[new_plugin_name,"Plugin","foobar","Option1"],"true",multiple_file=True)
dop.cdp_set("dum",[new_plugin_name,"Plugin","foobar","Option2"],"false",multiple_file=True)
dop.cdp_set_pre_comment("dum",[new_plugin_name,"Plugin","foobar","Option2"],"pre comment",multiple_file=True)
dop.cdp_set_post_comment("dum",[new_plugin_name,"Plugin","foobar","Option2"],"post comment",multiple_file=True)
dop.cdp_set("dum",[new_plugin_name,"Plugin","foobar","View","hoge","SubOpt1"],"gege",multiple_file=True)
dop.cdp_set_post_comment("dum",[new_plugin_name,"Plugin","foobar","View","hoge","SubOpt1"],"post",multiple_file=True)

print dop.get("dum",["filter","@ORDERS"],multiple_file=True)

# 複数ファイルを読み込むパーサーの場合は、is_parent_parser=Trueにすること
# '<Plugin foobar>' を 先頭にする
key = [new_plugin_name,"Plugin","foobar"]
dop.insert_order("dum",key,0,is_parent_parser=True)

# 'LoadPlugin target_hoge' を 先頭にする => '<Plugin foobar>' は２番目になる
key = [new_plugin_name,"LoadPlugin","target_hoge"]
dop.insert_order("dum",key,0,is_parent_parser=True)

# 'Foo foo' を 先頭にする => 'LoadPlugin target_hoge' は２番目になる
key = [new_plugin_name,"Foo"]
dop.insert_order("dum",key,0,is_parent_parser=True)

#print dop.get("dum",[new_plugin_name,"@ORDERS"],multiple_file=True)
#sys.exit()

# 配列確認
conf = dop.getconf("dum")
preprint_r(conf)

parser.write_conf(conf,dryrun=True)
"""
