#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This file is part of Karesansui Core.
#
# Copyright (C) 2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#

import karesansui
from karesansui import KaresansuiLibException
from karesansui.lib.utils import comma_split
from karesansui.lib.const import COLLECTD_VERSION

def get_collectd_version():
    return COLLECTD_VERSION

def create_plugin_selector(plugin_instance=None, type=None, type_instance=None):
    selector = ""

    if plugin_instance is not None:
        selector = selector + 'plugin_instance:' + plugin_instance + ','

    if type is not None:
        selector = selector + 'type:' + type + ','

    if type_instance is not None:
        selector = selector + 'type_instance:' + type_instance + ','

    selector = selector.rstrip(',')

    return str(selector)

def plugin_selector_to_dict(selector):
    selector_arr = comma_split(selector)
    selector_dict = dict()

    for select in selector_arr:
        (key, val) = select.split(':',2)
        selector_dict[key] = val

    return selector_dict

def create_value_selector(plugin_ds, value, bounds):
    selector = plugin_ds + ':' + value + ':' + bounds

    return selector

def value_selector_to_array(selector):
    arr = selector.split(':')

    return arr

def create_mail_of_db(body, mail_from=None, mail_to=None, subject=None):
    mail = ""
    if mail_from:
        mail += "From: " + mail_from + "\n"
    if mail_to:
        mail += "To: " + mail_to + "\n"
    if subject:
        mail += "Subject: " + subject + "\n"
    mail += "\n"
    mail += body

    return mail
