# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

import web

import karesansui
import karesansui.plus.updater
from karesansui.lib.rest import Rest, auth
from karesansui.lib.const import UPDATE_COMMAND_SOFTWARE
from pysilhouette.command import dict2command
from karesansui.db.model._2pysilhouette import Job, JobGroup
from karesansui.db.access.machine2jobgroup import new as m2j_new
from karesansui.db.access._2pysilhouette import save_job_collaboration
from karesansui.db.access.machine import findbyhost1

class HostBy1Updater(Rest):

    @auth
    def _GET(self, *param, **params):
        host_id = self.chk_hostby1(param)
        if host_id is None: return web.notfound()
        
        yu = karesansui.plus.updater.YumUpdater(karesansui.config)
        try:
            yu.refresh() # repository update
        except karesansui.plus.updater.KaresansuiYumRepoError, kyre:
            self.logger.info(str(kyre.args))
            return web.badrequest(str(kyre.args))

        self.view.rpm_details = yu.repos2rpms_details()
        self.view.repos = yu.repos
        self.view.pkgs = yu.pkgs()
        self.view.update_pkgs = yu.update_pkgs()
        return True

    @auth
    def _PUT(self, *param, **params):
        host_id = self.chk_hostby1(param)
        if host_id is None: return web.notfound()

        action_cmd = dict2command(
            "%s/%s" % (karesansui.config['application.bin.dir'],
                       UPDATE_COMMAND_SOFTWARE))
        
        cmdname = 'Update Software'
        _jobgroup = JobGroup(cmdname, karesansui.sheconf['env.uniqkey'])
        _job = Job('%s command' % cmdname, 0, action_cmd)
        _jobgroup.jobs.append(_job)
        host = findbyhost1(self.orm, host_id)
        
        _machine2jobgroup = m2j_new(machine=host,
                                    jobgroup_id=-1,
                                    uniq_key=karesansui.sheconf['env.uniqkey'],
                                    created_user=self.me,
                                    modified_user=self.me,
                                    )
        
        save_job_collaboration(self.orm,
                               self.pysilhouette.orm,
                               _machine2jobgroup,
                               _jobgroup,
                               )        
        return web.seeother(web.ctx.path)

urls = (
    '/host/(\d+)/updater[/]?(\.part)?$', HostBy1Updater,
    )

