# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

import web
from web.utils import Storage

import karesansui
from karesansui.lib.rest import Rest, auth
from karesansui.lib.virt.virt import KaresansuiVirtConnection
from karesansui.lib.const import VIRT_COMMAND_DELETE_STORAGE_VOLUME

from karesansui.db.access.machine import findbyhost1
from karesansui.db.access._2pysilhouette import save_job_collaboration
from karesansui.db.access.machine2jobgroup import new as m2j_new
from karesansui.db.model._2pysilhouette import JobGroup, Job

from pysilhouette.command import dict2command

def delete_storage_volume_job(obj, host, pool_name, volume_name, options={}):
    options['name'] = volume_name
    options['pool_name'] = pool_name

    _cmd = dict2command(
        "%s/%s" % (karesansui.config['application.bin.dir'], VIRT_COMMAND_DELETE_STORAGE_VOLUME), options)

    cmdname = u"Delete Storage Volume"
    _jobgroup = JobGroup(cmdname, karesansui.sheconf['env.uniqkey'])
    _jobgroup.jobs.append(Job("%s command" % cmdname, 0, _cmd))
    
    _machine2jobgroup = m2j_new(machine=host,
                                jobgroup_id=-1,
                                uniq_key=karesansui.sheconf['env.uniqkey'],
                                created_user=obj.me,
                                modified_user=obj.me,
                                )
    
    save_job_collaboration(obj.orm,
                           obj.pysilhouette.orm,
                           _machine2jobgroup,
                           _jobgroup,
                           )        
    return True

class HostBy1StoragePoolBy1StorageVolumeby1(Rest):

    @auth
    def _DELETE(self, *param, **params):
        host_id = self.chk_hostby1(param)
        if host_id is None: return web.notfound()

        self.view.host_id = host_id
        
        try:
            kvc = KaresansuiVirtConnection()
            inactive_pool = kvc.list_inactive_storage_pool()
            active_pool = kvc.list_active_storage_pool()
            pools = inactive_pool + active_pool
            pools.sort()
            self.view.pools = pools
            pools_obj = kvc.get_storage_pool_UUIDString2kvn_storage_pool(param[1])
            if len(pools_obj) <= 0:
                return web.notfound()

            pool_obj = pools_obj[0]
            pool_info = pool_obj.get_info()
            vols_info = []
            if pool_obj.is_active() is True:
                vols_obj = pool_obj.search_kvn_storage_volumes(kvc)
                
                for vol_obj in vols_obj:
                    vols_info.append(vol_obj.get_info())
        finally:
            kvc.close()

        model = findbyhost1(self.orm, host_id)

        vol_name = None
        for vol in vols_info:
            if param[2] == vol['name']:
                vol_name = param[2]
                break

        if vol_name is not None:
            if delete_storage_volume_job(self,model,pool_obj.get_storage_name(), vol_name) is True:
                #:TODO
                return web.accepted()
            else:
                #:TODO
                return False
        else:
            #:TODO
            return web.notfound()

urls = (
    '/host/(\d+)/storagepool/([a-z0-9]{8}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{12})/storagevolume/([-a-zA-Z0-9_\.]+)/?(\.part)$', HostBy1StoragePoolBy1StorageVolumeby1,
    )
