# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

import web

import karesansui
from karesansui.lib.rest import Rest, auth

from karesansui.db.model._2pysilhouette import Job, JobGroup, JOBGROUP_TYPE
from karesansui.db.access.machine import findbyhost1
from karesansui.db.access._2pysilhouette import jg_findby1, jg_save
from karesansui.db.access._2pysilhouette import save_job_collaboration
from karesansui.db.access.machine2jobgroup import new as m2j_new

from pysilhouette.command import dict2command

from karesansui.lib.utils import is_param
from karesansui.lib.const import ISCSI_COMMAND_START, ISCSI_COMMAND_STOP

NETWORK_STORAGE_START = "0"
NETWORK_STORAGE_STOP = "1"

class HostBy1NetworkStorageBy1Status(Rest):
    @auth
    def _PUT(self, *param, **params):
        host_id = self.chk_hostby1(param)
        if host_id is None: return web.notfound()

        host = findbyhost1(self.orm, host_id)

        iqn = self.input.iqn
        options = {'iqn' : iqn}

        status = self.input.status

        if status == NETWORK_STORAGE_START:
            network_storage_cmd = ISCSI_COMMAND_START
            cmd_name = u'Start iSCSI'
        elif status == NETWORK_STORAGE_STOP:
            network_storage_cmd = ISCSI_COMMAND_STOP
            cmd_name = u'Stop iSCSI'
        else:
            return web.internalerror('Internal Server Error. (Param)')

        _cmd = dict2command(
            "%s/%s" % (karesansui.config['application.bin.dir'], network_storage_cmd), options)
        jobgroup = JobGroup(cmd_name, karesansui.sheconf['env.uniqkey'])
        jobgroup.jobs.append(Job('%s command' % cmd_name, 0, _cmd))

        host = findbyhost1(self.orm, host_id)
        _machine2jobgroup = m2j_new(machine=host,
                                    jobgroup_id=-1,
                                    uniq_key=karesansui.sheconf['env.uniqkey'],
                                    created_user=self.me,
                                    modified_user=self.me,
                                    )

        save_job_collaboration(self.orm,
                               self.pysilhouette.orm,
                               _machine2jobgroup,
                               jobgroup,
                               )

        return web.accepted()

urls = (
    '/host/(\d+)/networkstorage/([^\./]+)/status/?(\.part)?$', HostBy1NetworkStorageBy1Status,
    )
