# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

import os.path
import re
import glob
import time

import web
import simplejson as json

import karesansui
from karesansui.gadget.guest import regist_guest
from karesansui.lib.rest import Rest, auth

from karesansui.lib.utils import chk_create_disk, json_dumps, is_param, \
  base64_encode, base64_decode, get_dom_list, get_dom_type, \
  string_from_uuid, generate_uuid, comma_split, uniq_sort

from karesansui.lib.const import \
    VIRT_COMMAND_IMPORT_GUEST, \
    VIRT_DOMAINS_DIR

from karesansui.lib.virt.virt import KaresansuiVirtConnection

from karesansui.db.access.machine import findbyhost1
from karesansui.db.access.machine2jobgroup import new as m2j_new
from karesansui.db.access._2pysilhouette import save_job_collaboration

from pysilhouette.command import dict2command
from karesansui.db.model._2pysilhouette import Job, JobGroup

from karesansui.lib.checker import Checker, \
    CHECK_EMPTY, CHECK_VALID, CHECK_ISDIR, CHECK_STARTROOT, CHECK_EXIST

from karesansui.lib.utils import get_xml_parse        as XMLParse
from karesansui.lib.utils import get_xml_xpath        as XMLXpath
from karesansui.lib.utils import get_nums_xml_xpath   as XMLXpathNum
from karesansui.lib.file.configfile import ConfigFile

def validates_guest_import(obj):
    checker = Checker()
    check = True

    _ = obj._
    checker.errors = []

    if not is_param(obj.input, 'b64dir'):
        check = False
        checker.add_error(_('Parameter b64dir does not exist.'))
    else:
        export_dir = base64_decode(str(obj.input.b64dir))
        check = checker.check_directory(
                _('Export Data'),
                export_dir,
                CHECK_EMPTY|CHECK_VALID|CHECK_ISDIR|CHECK_STARTROOT|CHECK_EXIST,
            ) and check

        info_file = "%s/info.xml" % (export_dir)
        if os.path.exists(info_file):
            doc = XMLParse("".join(ConfigFile(info_file).read()))
            name    = XMLXpath(doc,'/export/domain/text()')

            if name in get_dom_list():
                dom_type = get_dom_type(name)
                checker.add_error(_("The same domain name already exists for hypervisor '%s'.") % dom_type.upper())
                check = False

    obj.view.alert = checker.errors
    return check


class HostBy1GuestImport(Rest):

    @auth
    def _GET(self, *param, **params):

        #import pdb; pdb.set_trace()
        host_id = self.chk_hostby1(param)
        if host_id is None: return web.notfound()

        #if self.is_mode_input() is False:
        #    return web.nomethod()

        self.view.host_id = host_id
        self.view.pools = []
        self.view.exports = {}
        kvc = KaresansuiVirtConnection()
        try:

            active_pools   = kvc.list_active_storage_pool()
            inactive_pools = kvc.list_inactive_storage_pool()

            all_pools = sorted(active_pools + inactive_pools)
            #import pdb; pdb.set_trace()
            for pool_name in all_pools:
                files = {}
                try:
                    pool = kvc.search_kvn_storage_pools(pool_name)
                    path = pool[0].get_info()["target"]["path"]

                    if os.path.exists(path):
                        for _afile in glob.glob("%s/*/info.xml" % (path,)):
                            dir = os.path.dirname(_afile)
                            doc = XMLParse("".join(ConfigFile(_afile).read()))
                            uuid    = XMLXpath(doc,'/export/@id')
                            name    = XMLXpath(doc,'/export/domain/text()')
                            created = XMLXpath(doc,'/export/created/text()')
                            title   = XMLXpath(doc,'/export/title/text()')
                            if title != "":
                                title = re.sub("[\r\n]","",title)
                            if title == "":
                                title = _('untitled')

                            if created != "":
                                created_str = time.strftime("%Y/%m/%d %H:%M:%S",time.localtime(float(created)))
                            else:
                                created_str = _("N/A")

                            files[dir] = {
                                             "pool"    :pool_name,
                                             "b64dir"  :base64_encode(dir),
                                             "uuid"    :uuid,
                                             "name"    :name,
                                             "created" :int(created),
                                             "created_str" :created_str,
                                             "title"   :title,
                                            }
                except:
                    pass
                self.view.exports[pool_name] = files
                self.view.pools.append(pool_name)
        finally:
            kvc.close()

        return True


    @auth
    def _POST(self, *param, **params):
        host_id = self.chk_hostby1(param)
        if host_id is None: return web.notfound()

        model = findbyhost1(self.orm, host_id)

        if not validates_guest_import(self):
            return web.badrequest(self.view.alert)
            
        options = {}
        if is_param(self.input, 'b64dir'):
            export_dir = base64_decode(str(self.input.b64dir))
            options["dir"] = export_dir

        options["quiet"] = None

        # disk check
        #src_disk = "%s/%s/images/%s.img" % (VIRT_DOMAINS_DIR,options["name"],options["name"])
        #s_size = os.path.getsize(src_disk) / (1024 * 1024) # a unit 'MB'
        #if chk_create_disk(VIRT_DOMAINS_DIR, s_size) is False:
        #    return web.badrequest('Do not have enough free disk size.')


        # read info.xml
        info_file = "%s/info.xml" % (export_dir,)
        try:
            document = XMLParse("".join(ConfigFile(info_file).read()))
            uuid     = XMLXpath(document, '/export/@id')
            name     = XMLXpath(document, '/export/domain/text()')
            created  = XMLXpath(document, '/export/created/text()')
            title    = XMLXpath(document, '/export/title/text()')

            # extra
            for _attr in ["parent_id","notebook_id","created_user_id","modified_user_id","uniq_key","name","attribute","hypervisor","hostname","icon","tags_str","notebook.title","notebook.value"]:
                try:
                    exec("extra_%s = XMLXpath(document, '/export/extra/%s/text()')" % (_attr.replace(".","_"),_attr))
                except:
                    pass
        except:
            raise

        extra_uniq_key = string_from_uuid(generate_uuid())
        options["uuid"] = extra_uniq_key

        from karesansui.db.access.machine  import new as m_new
        from karesansui.db.access.notebook import new as n_new
        from karesansui.db.access.tag      import new as t_new
        from karesansui.db.access.machine  import findby1 as m_findby1
        from karesansui.db.access.notebook import findby1 as n_findby1
        from karesansui.db.access.tag      import findby1 as t_findby1
        from karesansui.db.access.tag      import samecount   as t_count
        from karesansui.db.access.tag      import findby1name as t_name

        try:
            #_notebook = n_findby1(self.orm,extra_notebook_id)
            notebook_title = ""
            try:
                if extra_notebook_title is not None:
                    notebook_title = extra_notebook_title
            except:
                pass

            notebook_value = ""
            try:
                if extra_notebook_value is not None:
                    notebook_value = extra_notebook_value
            except:
                pass
            if notebook_value == "":
               notebook_value = title
            else:
               notebook_value = "%s\n%s" % (notebook_value,title,)
            _notebook = n_new(notebook_title, notebook_value)
            #_notebook = n_new(title, "")
        except:
            _notebook = n_new(title, "")

        _tags = []
        try:
            tag_array = comma_split(extra_tags_str)
            tag_array = uniq_sort(tag_array)
            for x in tag_array:
                if t_count(self.orm, x) == 0:
                    _tags.append(t_new(x))
                else:
                    _tags.append(t_name(self.orm, x))
        except:
            _tags.append(t_new(""))

        parent = m_findby1(self.orm,extra_parent_id)
        dest_guest = m_new(created_user=self.me,
                           modified_user=self.me,
                           uniq_key=extra_uniq_key,
                           name=extra_name,
                           attribute=int(extra_attribute),
                           hypervisor=int(extra_hypervisor),
                           notebook=_notebook,
                           tags=_tags,
                           icon=extra_icon,
                           is_deleted=False,
                           parent=parent,
                           )

        ret = regist_guest(self,
                            dest_guest,
                            extra_icon,
                            VIRT_COMMAND_IMPORT_GUEST,
                            options,
                            ['Import Guest', 'Import Guest'],
                            {"name" : extra_name},
                            )

        if ret is True:
            return web.accepted()
        else:
            return False

urls = (
    '/host/(\d+)/guestimport/?(\.part)$', HostBy1GuestImport,
    )
