# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

import web

from karesansui.lib.rest import Rest, auth
from karesansui.lib.pager import Pager, validates_page
from karesansui.lib.search import validates_query
from karesansui.lib.const import \
    TAG_LIST_RANGE, TAG_MIN_LENGTH, TAG_MAX_LENGTH, \
    ID_MIN_LENGTH, ID_MAX_LENGTH

from karesansui.lib.checker import Checker, \
    CHECK_EMPTY, CHECK_VALID, \
    CHECK_LENGTH, CHECK_MIN, CHECK_MAX

from karesansui.db.access.tag import \
    findbyall, findby1, \
    findby1name, findbyand,\
    update, delete, save, new
from karesansui.lib.utils import is_param

def validates_watch(obj):
    check = True
    return check


class GuestBy1Watch(Rest):
    @auth
    def _GET(self, *param, **params):
        if self.is_mode_input():
            test = 1

        watchs = []

        test_watch = {
            'id' : 0,
            'name' : "sample",
            'target' : "cpu",
            }

        watchs.append(test_watch)

        self.view.watchs = watchs

        return True

    @auth
    def _POST(self, *param, **params):
        if not validates_watch(self):
            return web.badrequest(self.view.alert)

        return web.created(None)

urls = (
    '/host/(\d+)/guest/(\d+)/watch/?(\.part)$', GuestBy1Watch,
    )
