# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

import web

import karesansui
from karesansui.lib.rest import Rest, auth
from karesansui.lib.search import validates_jobsearch
from karesansui.lib.pager import Pager, validates_page
from karesansui.lib.utils import str2datetime, is_param, is_empty
from karesansui.lib.const import JOB_LIST_RANGE, DEFAULT_LANGS,\
    MACHINE_NAME_MIN_LENGTH, MACHINE_NAME_MAX_LENGTH,\
    USER_MIN_LENGTH, USER_MAX_LENGTH,\
    ID_MIN_LENGTH, ID_MAX_LENGTH, DEFAULT_LANGS, \
    MACHINE_HYPERVISOR
from karesansui.lib.checker import Checker, \
    CHECK_EMPTY, CHECK_LENGTH, CHECK_DICTVALUE, CHECK_VALID, CHECK_ONLYSPACE,\
    CHECK_MIN, CHECK_MAX
from karesansui.db.access.user import findbyname_BM
from karesansui.db.access.machine_machine2jobgroup import findbyhost as m2mj_findbyhost, \
    findbyall as m2mj_findbyall
from karesansui.db.model._2pysilhouette import JOBGROUP_STATUS

class GuestBy1Report(Rest):

    @auth
    def _GET(self, *param, **params):
        (host_id, guest_id) = self.chk_guestby1(param)
        if guest_id is None: return web.notfound()

        return True

urls = (
    '/host/(\d+)/guest/(\d+)/report/?(\.part)$', GuestBy1Report,
    )
