#!/bin/sh
#
# This file is part of Karesansui.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

export PYTHONPATH=/opt/hde/lib/python
export PATH=$PATH:/opt/hde/bin

__sed=`which sed`
__time=`date '+%Y%m%d%H%M%S'`

script_dir=`dirname $0`
pushd ${script_dir} >/dev/null 2>&1
# shell directory.
script_dir=`pwd`
popd >/dev/null 2>&1
pushd ${script_dir}/../ >/dev/null 2>&1
home_dir=`pwd`
popd >/dev/null 2>&1

echo "########################################################"
echo "    Karesansui Project                                      "
echo "            Babel (Internationalization) execute        "
echo "########################################################"
echo
echo "!!!!!!!!!!!!!!  Press <ENTER> to continue convert. !!!!!!!!!!!!!!!!!!!!"
echo "!!!!!!!!!!!!!!!!!!!!!!  Ctrl-C for aborting  !!!!!!!!!!!!!!!!!!!!!!!!!!"
read
echo
echo 

echo -n "Please input karesansui home directory(default:${home_dir}): "
read current_dir
if [ "x${current_dir}" = "x" ]; then
  current_dir=${home_dir}
fi

__pybabel=`which pybabel >/dev/null 2>&1`
if [ $? -eq 1 ]; then
  echo "Error:Babel(python) library is not installed."
  exit 1
fi

__babel_map="${home_dir}/tool/babel.map"
echo -n "Please input path to the extraction mapping file(default:${__babel_map}): "
read map
if [ "x${map}" = "x" ]; then
  map=${__babel_map}
fi

__messages_pot="${home_dir}/tool/messages.pot"
echo -n "Please input path to the extraction mapping file(default:${__messages_pot}): "
read pot
if [ "x${pot}" = "x" ]; then
  pot=${__messages_pot}
fi

target_dir="${home_dir}"
locale_dir="${target_dir}/installer/locale"
ja_po="${locale_dir}/ja/LC_MESSAGES/messages.po"
en_po="${locale_dir}/en/LC_MESSAGES/messages.po"

if [ -f "${pot}" ]; then
  if [ -f ${ja_po} ]; then
    pybabel update -l ja -i ${pot} -d ${locale_dir}
  else
    pybabel init -l ja -i ${pot} -d ${locale_dir}
  fi

  if [ -f ${en_po} ]; then 
    pybabel update -l en -i ${pot} -d ${locale_dir}
  else
    pybabel init -l en -i ${pot} -d ${locale_dir}
  fi
else
  pybabel extract -F ${map} -o ${pot} ${home_dir}
  echo "Please execute it again."
  exit 1
fi

# create .mo
pybabel compile -d ${locale_dir} -f
