#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

import os
import sys
import re
import grp
import traceback
import time

from installer.const import *
from installer.trans import _, N_
from installer.utils import *
from installer.rpmlib import RpmLib

karesansui_group = "kss"

def get_domain_data_dir():
    retval = None

    try:
        search_path = sh_config_read(DEFAULT_KARESANSUI_CONF)["application.search.path"]
    except:
        return retval

    """ Set search paths """
    for y in [x.strip() for x in search_path.split(',') if x]:
        if (y in sys.path) is False: sys.path.insert(0, y)

    try:
        import karesansui
        from karesansui.lib.const import VIRT_LIBVIRT_DATA_DIR, VIRT_DOMAINS_DIR
    except ImportError, e:
        return retval

    return VIRT_DOMAINS_DIR


def migrate(mode=0,log=None,test=False,verbose=False):
    retval = True

    if log is None:
        if verbose is True:
            log = "/dev/stdout"
        else:
            log = "/dev/null"

    logf = open(log,"a")

    domain_data_dir = get_domain_data_dir()
    if domain_data_dir is None:
        retval = False
        if verbose is True:
            sys.stderr.write("Error: VIRT_DOMAINS_DIR is undefined.")
        return retval

    data_dir = os.path.dirname(domain_data_dir)

    """ pre: define variables """
    old_images_dir     = "%s/images"   % (data_dir,)
    old_boot_dir       = "%s/boot"     % (data_dir,)
    old_disk_dir       = "%s/disk"     % (data_dir,)
    old_snapshot_dir   = "%s/snapshot" % (data_dir,)
    old_xml_config_dir = "%s/xen/xml"      % (VENDOR_SYSCONFDIR,)
    new_xml_config_dir = "%s/libvirt/qemu" % (VENDOR_SYSCONFDIR,)
    backup_dir         = "%s/v1.0_save"% (data_dir,)
    kss_config_file    = DEFAULT_KARESANSUI_CONF
    whitelist_file     = DEFAULT_SILHOUETTE_WHITELIST

    if os.path.exists(backup_dir):
        if verbose is True:
            logf.write("Notice: the backup directory for v1.0 old data exists. [%s]\n" % backup_dir)
        return retval

    if verbose is True:
        logf.write("old_images_dir  :%s\n" % (old_images_dir,))
        logf.write("old_boot_dir    :%s\n" % (old_boot_dir,))
        logf.write("old_disk_dir    :%s\n" % (old_disk_dir,))
        logf.write("old_snapshot_dir:%s\n" % (old_snapshot_dir,))
        logf.write("old_xml_config_dir :%s\n" % (old_xml_config_dir,))
        logf.write("new_xml_config_dir :%s\n" % (new_xml_config_dir,))
        logf.write("kss_config_file :%s\n" % (kss_config_file,))
        logf.write("whitelist_file  :%s\n" % (whitelist_file,))


    """ 1, os disk image """
    if verbose is True:
        logf.write("\n")
        logf.write("> Check the old disk image directory...\n")
    if os.path.exists(old_images_dir):
        if verbose is True:
            logf.write(">> old_images_dir '%s' is found.\n" % (old_images_dir,))

        for file in os.listdir(old_images_dir):
            if file[-4:] == ".img":
                domain_name = file[0:-4]

                if verbose is True:
                    logf.write(">> image file '%s' is found.\n" % (file,))

                new_images_dir = "%s/%s/images" % (domain_data_dir,domain_name,)
                new_images_path = "%s/%s.img" % (new_images_dir,domain_name,)
                old_images_path = "%s/%s"     % (old_images_dir,file,)

                if not os.path.exists(new_images_dir):
                    if test is True:
                        logf.write(">>>[test] os.makedirs('%s')\n" % (new_images_dir,))
                    else:
                        if verbose is True:
                            logf.write(">>> os.makedirs('%s')... " % (new_images_dir,))
                        os.makedirs(new_images_dir)
                        if verbose is True:
                            logf.write("done\n")

                if os.path.exists(new_images_path):
                    if verbose is True:
                        logf.write(">>> new image file '%s' is found.\n" % (new_images_path,))
                else:
                    if test is True:
                        logf.write(">>>[test] os.renames('%s','%s')\n" % (old_images_path,new_images_path,))
                    else:
                        if verbose is True:
                            logf.write(">>> os.renames('%s','%s')... " % (old_images_path,new_images_path,))
                        os.renames(old_images_path,new_images_path)
                        if verbose is True:
                            logf.write("done\n")

        """ 古いディレクトリはバックアップへ移動する """
        if os.path.exists(old_images_dir):
            if test is True:
                logf.write(">>[test] os.renames('%s','%s')\n" % (old_images_dir,backup_dir,))
            else:
                if not os.path.exists(backup_dir):
                    os.makedirs(backup_dir)
                if verbose is True:
                    logf.write(">> os.renames('%s','%s')... " % (old_images_dir,backup_dir,))
                os.renames(old_images_dir,backup_dir)
                if verbose is True:
                    logf.write("done\n")


    """ 2, extra disk image """
    if verbose is True:
        logf.write("\n")
        logf.write("> Check the extra disk image directory...\n")
    if os.path.exists(old_disk_dir):
        if verbose is True:
            logf.write(">> old_disk_dir '%s' is found.\n" % (old_disk_dir,))

        for domain_name in os.listdir(old_disk_dir):
            new_disk_dir = "%s/%s/disk" % (domain_data_dir,domain_name,)
            old_domain_disk_dir = "%s/%s" % (old_disk_dir,domain_name,)

            if not os.path.exists(new_disk_dir):
                if test is True:
                    logf.write(">>>[test] os.makedirs('%s')\n" % (new_disk_dir,))
                else:
                    if verbose is True:
                        logf.write(">>> os.makedirs('%s')... " % (new_disk_dir,))
                    os.makedirs(new_disk_dir)
                    if verbose is True:
                        logf.write("done\n")

            for file in os.listdir(old_domain_disk_dir):
                if file[-4:] == ".img":
                    new_disk_path = "%s/%s/%s" % (new_disk_dir,domain_name,file)
                    old_disk_path = "%s/%s" % (old_domain_disk_dir,file,)

                    if os.path.exists(new_disk_path):
                        if verbose is True:
                            logf.write(">>> new disk file '%s' is found.\n" % (new_disk_path,))
                    else:
                        if test is True:
                            logf.write(">>>[test] os.renames('%s','%s')\n" % (old_disk_path,new_disk_path,))
                        else:
                            if verbose is True:
                                logf.write(">>> os.renames('%s','%s')... " % (old_disk_path,new_disk_path,))
                            os.renames(old_disk_path,new_disk_path)
                            if verbose is True:
                                logf.write("done\n")

        """ 古いディレクトリはバックアップへ移動する """
        if os.path.exists(old_disk_dir):
            if test is True:
                logf.write(">>[test] os.renames('%s','%s')\n" % (old_disk_dir,backup_dir,))
            else:
                if not os.path.exists(backup_dir):
                    os.makedirs(backup_dir)
                if verbose is True:
                    logf.write(">> os.renames('%s','%s')... " % (old_disk_dir,backup_dir,))
                os.renames(old_disk_dir,backup_dir)
                if verbose is True:
                    logf.write("done\n")


    """ 3, snapshot image """
    if verbose is True:
        logf.write("\n")
        logf.write("> Check the snapshot disk image directory...\n")
    if os.path.exists(old_snapshot_dir):
        if verbose is True:
            logf.write(">> old_snapshot_dir '%s' is found.\n" % (old_snapshot_dir,))

        for domain_name in os.listdir(old_snapshot_dir):
            new_snapshot_dir = "%s/%s/snapshot" % (domain_data_dir,domain_name,)
            old_domain_snapshot_dir = "%s/%s" % (old_snapshot_dir,domain_name,)

            if not os.path.exists(new_snapshot_dir):
                if test is True:
                    logf.write(">>>[test] os.makedirs('%s')\n" % (new_snapshot_dir,))
                else:
                    if verbose is True:
                        logf.write(">>> os.makedirs('%s')... " % (new_snapshot_dir,))
                    os.makedirs(new_snapshot_dir)
                    if verbose is True:
                        logf.write("done\n")

            for file in os.listdir(old_domain_snapshot_dir):
                new_snapshot_path = "%s/%s/%s" % (new_snapshot_dir,domain_name,file)
                old_snapshot_path = "%s/%s" % (old_domain_snapshot_dir,file,)

                if os.path.exists(new_snapshot_path):
                    if verbose is True:
                        logf.write(">>> new snapshot file '%s' is found.\n" % (new_snapshot_path,))
                else:
                    if test is True:
                        logf.write(">>>[test] os.renames('%s','%s')\n" % (old_snapshot_path,new_snapshot_path,))
                    else:
                        if verbose is True:
                            logf.write(">>> os.renames('%s','%s')... " % (old_snapshot_path,new_snapshot_path,))
                        os.renames(old_snapshot_path,new_snapshot_path)
                        if verbose is True:
                            logf.write("done\n")

        """ 古いディレクトリはバックアップへ移動する """
        if os.path.exists(old_snapshot_dir):
            if test is True:
                logf.write(">>[test] os.renames('%s','%s')\n" % (old_snapshot_dir,backup_dir,))
            else:
                if not os.path.exists(backup_dir):
                    os.makedirs(backup_dir)
                if verbose is True:
                    logf.write(">> os.renames('%s','%s')... " % (old_snapshot_dir,backup_dir,))
                os.renames(old_snapshot_dir,backup_dir)
                if verbose is True:
                    logf.write("done\n")


    """ 4, boot image """
    if verbose is True:
        logf.write("\n")
        logf.write("> Check the boot image directory...\n")
    if os.path.exists(old_boot_dir) and os.path.exists(old_xml_config_dir):
        if verbose is True:
            logf.write(">> old_boot_dir '%s' is found.\n" % (old_boot_dir,))

        for file in os.listdir(old_xml_config_dir):
            if file[-4:] == ".xml":
                domain_name = file[0:-4]

                new_boot_dir = "%s/%s/boot" % (domain_data_dir,domain_name,)
                old_domain_xml_config_path = "%s/%s" % (old_xml_config_dir,file,)
                if not os.path.exists(new_boot_dir):
                    if test is True:
                        logf.write(">>>[test] os.makedirs('%s')\n" % (new_boot_dir,))
                    else:
                        if verbose is True:
                            logf.write(">>> os.makedirs('%s')... " % (new_boot_dir,))
                        os.makedirs(new_boot_dir)
                        if verbose is True:
                            logf.write("done\n")

                if os.path.exists(old_domain_xml_config_path):
                    if verbose is True:
                        logf.write(">>> old_domain_xml_config_path '%s' is found.\n" % (old_domain_xml_config_path,))

                    doc = get_xml_parse(old_domain_xml_config_path)

                    kernel = get_xml_xpath(doc,'/domain/os/kernel/text()')
                    if kernel is not None:
                        if os.path.exists(kernel):
                            if verbose is True:
                                logf.write(">>>> old kernel '%s' is found.\n" % (kernel,))

                            b_kernel = os.path.basename(kernel)
                            new_boot_kernel_path = "%s/%s" % (new_boot_dir,b_kernel,)
                            if os.path.exists(new_boot_kernel_path):
                                if verbose is True:
                                    logf.write(">>>> new_boot_kernel_path '%s' is found.\n" % (new_boot_kernel_path,))
                            else:
                                if test is True:
                                    logf.write(">>>>[test] os.renames('%s','%s')\n" % (kernel,new_boot_kernel_path,))
                                else:
                                    if verbose is True:
                                        logf.write(">>>> os.renames('%s','%s')... " % (kernel,new_boot_kernel_path,))
                                    os.renames(kernel,new_boot_kernel_path)
                                    if verbose is True:
                                        logf.write("done\n")

                    initrd = get_xml_xpath(doc,'/domain/os/initrd/text()')
                    if initrd is not None:
                        if os.path.exists(initrd):
                            if verbose is True:
                                logf.write(">>>> old initrd '%s' is found.\n" % (initrd,))

                            b_initrd = os.path.basename(initrd)
                            new_boot_initrd_path = "%s/%s" % (new_boot_dir,b_initrd,)
                            if os.path.exists(new_boot_initrd_path):
                                if verbose is True:
                                    logf.write(">>>> new_boot_initrd_path '%s' is found.\n" % (new_boot_initrd_path,))
                            else:
                                if test is True:
                                    logf.write(">>>>[test] os.renames('%s','%s')\n" % (initrd,new_boot_initrd_path,))
                                else:
                                    if verbose is True:
                                        logf.write(">>>> os.renames('%s','%s')... " % (initrd,new_boot_initrd_path,))
                                    os.renames(initrd,new_boot_initrd_path)
                                    if verbose is True:
                                        logf.write("done\n")

        """ 古いディレクトリはバックアップへ移動する """
        if os.path.exists(old_boot_dir):
            if test is True:
                logf.write(">>[test] os.renames('%s','%s')\n" % (old_boot_dir,backup_dir,))
            else:
                if not os.path.exists(backup_dir):
                    os.makedirs(backup_dir)
                if verbose is True:
                    logf.write(">> os.renames('%s','%s')... " % (old_boot_dir,backup_dir,))
                os.renames(old_boot_dir,backup_dir)
                if verbose is True:
                    logf.write("done\n")


    """ 5, xml config """
    if verbose is True:
        logf.write("\n")
        logf.write("> Check the xml config directory...\n")
    if os.path.exists(old_xml_config_dir):
        if verbose is True:
            logf.write(">> old_xml_config_dir '%s' is found.\n" % (old_xml_config_dir,))

        for file in os.listdir(old_xml_config_dir):
            if file[-4:] == ".xml":
                domain_name = file[0:-4]

                new_images_dir = "%s/%s/images" % (domain_data_dir,domain_name,)
                new_disk_dir   = "%s/%s/disk"   % (domain_data_dir,domain_name,)
                new_boot_dir   = "%s/%s/boot"   % (domain_data_dir,domain_name,)
                new_snapshot_dir = "%s/%s/snapshot" % (domain_data_dir,domain_name,)

                old_domain_xml_config_path = "%s/%s" % (old_xml_config_dir,file,)
                new_domain_xml_config_path = "%s/%s" % (new_xml_config_dir,file,)
                if os.path.exists(new_domain_xml_config_path):
                    if verbose is True:
                        logf.write(">>>> new_domain_xml_config_path '%s' is found.\n" % (new_domain_xml_config_path,))
                else:
                    doc = get_xml_parse(old_domain_xml_config_path)

                    old_patterns = []
                    new_patterns = []
                    kernel = get_xml_xpath(doc,'/domain/os/kernel/text()')
                    if kernel is not None:
                        b_kernel = os.path.basename(kernel)
                        new_boot_kernel_path = "%s/%s" % (new_boot_dir,b_kernel,)

                        old_line = "<kernel>%s</kernel>" % (kernel,)
                        new_line = "<kernel>%s</kernel>" % (new_boot_kernel_path,)
                        old_patterns.append(old_line)
                        new_patterns.append(new_line)

                    initrd = get_xml_xpath(doc,'/domain/os/initrd/text()')
                    if initrd is not None:
                        b_initrd = os.path.basename(initrd)
                        new_boot_initrd_path = "%s/%s" % (new_boot_dir,b_initrd,)

                        old_line = "<initrd>%s</initrd>" % (initrd,)
                        new_line = "<initrd>%s</initrd>" % (new_boot_initrd_path,)
                        old_patterns.append(old_line)
                        new_patterns.append(new_line)


                    old_line = "<source file='%s/(.*\.img)'/>" % (old_images_dir,)
                    new_line = "<source file='%s/\\1'/>" % (new_images_dir,)
                    old_patterns.append(old_line)
                    new_patterns.append(new_line)


                    old_line = "<source file='%s/%s/(.*\.img)'/>" % (old_disk_dir,domain_name,)
                    new_line = "<source file='%s/\\1'/>" % (new_disk_dir,)
                    old_patterns.append(old_line)
                    new_patterns.append(new_line)


                    old_line = "<currentSnapshot>%s/%s/(.*)</currentSnapshot>" % (old_snapshot_dir,domain_name,)
                    new_line = "<currentSnapshot>%s/\\1</currentSnapshot>" % (new_snapshot_dir,)
                    old_patterns.append(old_line)
                    new_patterns.append(new_line)

                    if verbose is True:
                        logf.write(">>> old_patterns:\n  "+'\n  '.join(old_patterns))
                        logf.write(">>> replacements:\n  "+'\n  '.join(new_patterns))

                    __TEST_MODE = True
                    if test is True:
                        try:
                            logf.write(">>>[test] xmlstr = ")
                            lines = []
                            fp = open(old_domain_xml_config_path,"r")
                            fcntl.lockf(fp.fileno(), fcntl.LOCK_SH)
                            for line in fp.readlines():
                                lines.append(line)
                            fcntl.lockf(fp.fileno(), fcntl.LOCK_UN)
                            fp.close()
                            lines = array_replace(lines, old_patterns, new_patterns)
                            for line in lines:
                                logf.write("%s",line)
                            __TEST_MODE = True
                        except:
                            pass

                    else:
                        if verbose is True:
                            logf.write(">>> file_contents_replace('%s','%s', ...)... " % (old_domain_xml_config_path, new_domain_xml_config_path,))

                        file_contents_replace(old_domain_xml_config_path, new_domain_xml_config_path, old_patterns, new_patterns)

                        if verbose is True:
                            logf.write("done\n")

                    if os.path.exists(new_domain_xml_config_path) or __TEST_MODE is True:
                        autostart_dir = "%s/autostart" % (new_xml_config_dir,)
                        autostart_file = "%s/%s.xml" % (autostart_dir,domain_name,)

                        if not os.path.exists(autostart_dir):
                            if test is True:
                                logf.write(">>>[test] os.makedirs('%s')\n" % (autostart_dir,))
                            else:
                                if verbose is True:
                                    logf.write(">>> os.makedirs('%s')... " % (autostart_dir,))
                                os.makedirs(autostart_dir)
                                if verbose is True:
                                    logf.write("done\n")

                        if os.path.lexists(autostart_file):
                            if test is True:
                                if verbose is True:
                                    logf.write(">>>>[test] os.unlink('%s')\n" % (autostart_file,))
                                    logf.write(">>>>[test] os.symlink('%s','%s')\n" % (new_domain_xml_config_path,autostart_file,))
                            else:
                                if verbose is True:
                                    logf.write(">>>> os.unlink('%s')... " % (autostart_file,))
                                os.unlink(autostart_file)
                                if verbose is True:
                                    logf.write("done\n")
                                    logf.write(">>>> os.symlink('%s','%s')... " % (new_domain_xml_config_path,autostart_file,))
                                os.symlink(new_domain_xml_config_path,autostart_file)
                                if verbose is True:
                                    logf.write("done\n")

                        command_args = [VENDOR_PREFIX+"/bin/virsh" ,"define",new_domain_xml_config_path]
                        if test is True:
                            if verbose is True:
                                logf.write(">>>>[test] execute_command('%s')\n" % (' '.join(command_args),))
                        else:
                            if verbose is True:
                                logf.write(">>>> execute_command('%s')... " % (' '.join(command_args),))
                            ret = execute_command(command_args)
                            if verbose is True:
                                logf.write("done\n")

    """ 6, karesansui config file """
    if verbose is True:
        logf.write("\n")
        logf.write("> Check Karesansui configuration file...\n")
    if os.path.exists(kss_config_file):
        if verbose is True:
            logf.write(">> kss_config_file '%s' is found.\n" % (kss_config_file,))

        """ new parameter """
        new_params = {
         "application.updater.yum.cachedir"    :"/var/opt/karesansui/cache/yum",
         "application.updater.yum.target.repos":"karesansui-base",
         "application.updater.yum.log.file"    :"/var/log/karesansui/yum.log",
        }
        new_lines = []
        for k,v in new_params.iteritems():
            try:
                sh_config_read(kss_config_file)[k]
            except:
                new_lines.append("%s=%s" % (k,v,))

        if len(new_lines) > 0:
            if test is True:
                if verbose is True:
                    logf.write(">>>>[test] append lines: %s\n" % (new_lines,))
            else:
                if verbose is True:
                    logf.write(">>>> append lines: %s ... " % (new_lines,))
                try:
                    fp = open(kss_config_file,"a")
                    fcntl.lockf(fp.fileno(), fcntl.LOCK_EX)
                    fp.write("%s\n" % ("\n".join(new_lines),))
                    fcntl.lockf(fp.fileno(), fcntl.LOCK_UN)
                    fp.close()
                    if verbose is True:
                        logf.write("done\n")
                except TypeError, e:
                    pass
                except IOError, e:
                    if verbose is True:
                        logf.write("failed. [%s]\n" % e)
                    pass

    """ 7, whitelist config file """
    if verbose is True:
        logf.write("\n")
        logf.write("> Check pysilhouette whitelist configuration file...\n")
    if os.path.exists(whitelist_file):
        if verbose is True:
            logf.write(">> whitelist_file '%s' is found.\n" % (whitelist_file,))

        """ new command """
        new_commands = [
         "/opt/karesansui/bin/update_software.py",   
        ]    
        new_lines = []
        try:
            fp = open(whitelist_file,"r")
            fcntl.lockf(fp.fileno(), fcntl.LOCK_SH)
            commands = []
            for line in fp.readlines():
                line = line.strip()
                commands.append(line)
            for line in new_commands:
                if not line in commands:
                    new_lines.append(line)
            fcntl.lockf(fp.fileno(), fcntl.LOCK_UN)
            fp.close()
        except TypeError, e:
            pass
        except IOError, e:
            pass

        if len(new_lines) > 0:
            if test is True:
                if verbose is True:
                    logf.write(">>>>[test] append lines: %s\n" % (new_lines,))
            else:
                if verbose is True:
                    logf.write(">>>> append lines: %s ... " % (new_lines,))
                try:
                    fp = open(whitelist_file,"a")
                    fcntl.lockf(fp.fileno(), fcntl.LOCK_EX)
                    fp.write("%s\n" % ("\n".join(new_lines),))
                    fcntl.lockf(fp.fileno(), fcntl.LOCK_UN)
                    fp.close()
                    if verbose is True:
                        logf.write("done\n")
                except TypeError, e:
                    pass
                except IOError, e:
                    if verbose is True:
                        logf.write("failed. [%s]\n" % e)
                    pass


    """ 新しいディレクトリ配下のパーミッションを変更する """
    if os.path.exists(domain_data_dir):
        if test is True:
            logf.write(">>[test] r_chgrp('%s','%s')\n" % (domain_data_dir,karesansui_group,))
            logf.write(">>[test] r_chmod('%s','g+rw')\n"  % (domain_data_dir,))
            logf.write(">>[test] r_chmod('%s','o-rwx')\n" % (domain_data_dir,))
        else:
            if verbose is True:
                logf.write(">> r_chgrp('%s','%s')... " % (domain_data_dir,karesansui_group,))
            r_chgrp(domain_data_dir,karesansui_group)
            if verbose is True:
                logf.write("done\n")

            if verbose is True:
                logf.write(">> r_chmod('%s','o-rwx')... " % (domain_data_dir,))
            r_chmod(domain_data_dir,"g+rw")
            r_chmod(domain_data_dir,"o-rwx")
            if verbose is True:
                logf.write("done\n")

    """ XML設定ディレクトリ配下のパーミッションを変更する """
    if os.path.exists(new_xml_config_dir):
        if test is True:
            logf.write(">>[test] r_chgrp('%s','%s')\n" % (new_xml_config_dir,karesansui_group,))
            logf.write(">>[test] r_chmod('%s','g+rw')\n"  % (new_xml_config_dir,))
            logf.write(">>[test] r_chmod('%s','o-rwx')\n" % (new_xml_config_dir,))
        else:
            if verbose is True:
                logf.write(">> r_chgrp('%s','%s')... " % (new_xml_config_dir,karesansui_group,))
            r_chgrp(new_xml_config_dir,karesansui_group)
            if verbose is True:
                logf.write("done\n")

            if verbose is True:
                logf.write(">> r_chmod('%s','o-rwx')... " % (new_xml_config_dir,))
            r_chmod(new_xml_config_dir,"g+rw")
            r_chmod(new_xml_config_dir,"o-rwx")
            if verbose is True:
                logf.write("done\n")


    logf.close()

    return retval

