%define commerce 0
%if %{?commerce:0}%{!?commerce:1}
%define commerce 1
%endif

%define __python $(which python)
%define __app karesansui
%define version 1.1.0
%define release 4
%define date %(echo `LANG=C date +%%Y%%m%%d%%H%%M%%S`)

%if %{commerce}
%define _vendor_name    hde
%define name %{_vendor_name}-karesansui
%define __prefix /opt/%{_vendor_name}
%define __sysconfdir %{_sysconfdir}/opt/%{_vendor_name}/%{__app}
%define python_home  %{__prefix}
%else
%define _vendor_name    %{nil}
%define __prefix /opt
%define name karesansui
%define __sysconfdir %{_sysconfdir}/opt/%{__app}
%define python_home  %{__prefix}/%{__app}
%endif

%define __bindir %{__prefix}/%{__app}/bin
%define __tmpdir %{__prefix}/%{__app}/tmp
%define _defaultdocdir %{__prefix}/%{__app}/share/doc
%define python_sitelib  %{python_home}/lib/python

%define __pysilhouette_prefix     %{__prefix}/pysilhouette
%define __pysilhouette_sysconfdir %{_sysconfdir}/opt/pysilhouette

%define __vendor_sysconfdir  %{_sysconfdir}/opt/hde

%define _user           kss
%define _group          kss
%define _user_doc       Karesansui Project
%define _uid_min        250
%define _uid_max        300
%define _group_member   wwwhde

Summary: Virtualization management tool(Web Application) 
Summary(ja): オープンソースの仮想ホスト管理アプリケーション
Name: %{name}
Version: %{version}
#Release: %{release}.%{date}
Release: %{release}
Source0: %{__app}-%{version}.tar.gz
License: LGPLv2+
Group: Applications/System
Url: http://karesansui-project.info/
Vendor: Karesansui Project
Packager: Taizo ITO <taizo@karesansui-project.info>
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
Prefix: %{_prefix}
BuildArch: noarch
Provides: %{__app}
Requires: hde-libvirt-python
Requires: pysilhouette
Requires: PyXML

%description
On the Web for virtualization management software to manage.
    The guest OS and the management of resources and dynamic changes can be done easily.
    RESTful Web applications in architecture.

%package data
Summary: UI data for Karesansui Core
Group: Applications/System
License: GPLv2
Requires: %{name} = %{version}

%description data
UI data for Karesansui Core

%package gadget
Summary: Basic gadget collection for Karesansui Core
Group: Applications/System
License: GPLv2
Requires: %{name} = %{version}

%description gadget
Basic gadget collection for Karesansui Core

%package bin
Summary: Basic command collection for Karesansui Core
Group: Applications/System
License: GPLv2
Requires: %{name} = %{version}

%description bin
Basic command collection for Karesansui Core

%package test
Summary: Unit test environment for Karesansui Core
Group: Applications/System
License: LGPLv2+
Requires: %{name} = %{version}
Requires: hde-python-paste

%description test
Unit test environment for Karesansui Core

%package plus
Summary: additional packages that extend functionality of existing packages
Group: Applications/System
License: See the source code
Requires: %{name} = %{version}
Requires: yum
Requires: rpm-python

%description plus
additional packages that extend functionality of existing packages

%prep
%setup -n %{__app}-%{version}

%build
python setup.py build

%install
python setup.py install --root=$RPM_BUILD_ROOT --record=INSTALLED_FILES --home=%{python_home}

install -d -m 0770 $RPM_BUILD_ROOT%{__sysconfdir}
%{__cp} -f doc/application.conf.example $RPM_BUILD_ROOT%{__sysconfdir}/application.conf.example
%{__cp} -f $RPM_BUILD_ROOT%{__sysconfdir}/application.conf{.example,}
%{__cp} -f doc/log.conf.example $RPM_BUILD_ROOT%{__sysconfdir}/log.conf.example
%{__cp} -f $RPM_BUILD_ROOT%{__sysconfdir}/log.conf{.example,}
%{__cp} -fr doc/lighttpd/ $RPM_BUILD_ROOT%{__sysconfdir}/lighttpd.example/
%{__cp} -f doc/whitelist.conf.example $RPM_BUILD_ROOT%{__sysconfdir}/

install -d -m 0770 $RPM_BUILD_ROOT/{etc,var}/opt/karesansui
install -d -m 0770 $RPM_BUILD_ROOT/var/log/karesansui
install -d -m 0770 $RPM_BUILD_ROOT%{__tmpdir}

find $RPM_BUILD_ROOT%{python_sitelib}/karesansui -type d -exec chmod g+rwx \{\} \; 2>/dev/null

install -d -m 0770 $RPM_BUILD_ROOT/{etc,var}/opt/karesansui/cache
install -d -m 0770 $RPM_BUILD_ROOT/{etc,var}/opt/karesansui/cache/yum

%clean
rm -rf $RPM_BUILD_ROOT

%pre
# Add group
getent group | %{__grep} "^%{_group}:" >/dev/null 2>&1
if [ $? -ne 0 ]; then
  __uid=%{_uid_min}
  while test ${__uid} -le %{_uid_max}
  do
    getent group | %{__grep} "^[^:]*:x:${__uid}:" >/dev/null 2>&1
    if [ $? -ne 0 ]; then
      _gid=${__uid}
      break
    fi
    __uid=`expr ${__uid} + 1`
  done
  /usr/sbin/groupadd -g ${_gid} -f %{_group}
fi

# Add user
getent passwd | %{__grep} "^%{_user}:" >/dev/null 2>&1
if [ $? -ne 0 ]; then
  __uid=%{_uid_min}
  while test ${__uid} -le %{_uid_max}
  do
    getent passwd | %{__grep} "^[^:]*:x:${__uid}:" >/dev/null 2>&1
    if [ $? -ne 0 ]; then
      _uid=${__uid}
      break
    fi
    __uid=`expr ${__uid} + 1`
  done
  /usr/sbin/useradd -c "%{_user_doc}" -u ${_uid} -g %{_group} -s /bin/false -r %{_user} 2> /dev/null || :
fi

# Add %{_group_member} user to %{_group} group member
%{__grep} ^%{_group_member}: /etc/passwd >/dev/null 2>&1
if [ $? -eq 0 ]; then
  gpasswd -a %{_group_member} %{_group} >/dev/null 2>&1
  gpasswd -a %{_group} %{_group_member} >/dev/null 2>&1
fi

%post
# Modify libvirt configuration file.
sysconfig_libvirt=%{_sysconfdir}/sysconfig/hde-libvirtd
if [ -f ${sysconfig_libvirt} ]; then
  %{__grep} "^PRIVSEP_GROUP=" ${sysconfig_libvirt} >/dev/null 2>&1
  if [ $? -ne 0 ]; then
    echo "PRIVSEP_GROUP=%{_group}" >>${sysconfig_libvirt}
  fi
fi
libvirtd_conf=%{__vendor_sysconfdir}/libvirt/libvirtd.conf
if [ -f ${libvirtd_conf} ]; then
  %{__grep} '^unix_sock_group = "root"' ${libvirtd_conf} >/dev/null 2>&1
  if [ $? -eq 0 ]; then
    %{__sed} -e "s#unix_sock_group = \"root\"#unix_sock_group = \"%{_group}\"#"       ${libvirtd_conf} >${libvirtd_conf}.$$
    %{__cp} -f ${libvirtd_conf}.$$ ${libvirtd_conf}
    %{__rm} -f ${libvirtd_conf}.$$
  fi
fi

# Make directory
if [ -d %{__vendor_sysconfdir} ]; then
  %{__mkdir_p} %{__vendor_sysconfdir}/xen/xml/
  %{__chgrp} -R %{_group} %{__vendor_sysconfdir}/xen/ >/dev/null 2>&1
  %{__chmod} -R g+rw %{__vendor_sysconfdir}/xen/ >/dev/null 2>&1
fi
libvirt_datadir=/var/opt/hde/libvirt
if [ -d ${libvirt_datadir} ]; then
  #for subdir in boot images snapshot disk
  for subdir in domains
  do
    %{__mkdir_p} ${libvirt_datadir}/${subdir}
    %{__chmod} g+rwx ${libvirt_datadir}/${subdir} >/dev/null 2>&1
    %{__chmod} o-rwx ${libvirt_datadir}/${subdir} >/dev/null 2>&1
  done
  %{__chgrp} -R %{_group} ${libvirt_datadir}/ >/dev/null 2>&1
  %{__chmod} g+rwx ${libvirt_datadir}/ >/dev/null 2>&1
fi

# Modify lighttpd configuration file.
for lighttpd_sysconfdir in %{__vendor_sysconfdir}/lighttpd /etc/lighttpd
do
  if [ -d ${lighttpd_sysconfdir} ]; then
    %{__mkdir_p} ${lighttpd_sysconfdir}/conf.d/karesansui/ >/dev/null 2>&1
    if [ ! -f ${lighttpd_sysconfdir}/conf.d/karesansui.conf ]; then
      %{__cp} -f %{__sysconfdir}/lighttpd.example/karesansui.conf ${lighttpd_sysconfdir}/conf.d/
      %{__cp} -f %{__sysconfdir}/lighttpd.example/{access,port,ssl}.conf ${lighttpd_sysconfdir}/conf.d/karesansui/
      %{__chgrp} -R %{_group} ${lighttpd_sysconfdir}/conf.d/karesansui*
      %{__chmod} -R 0660 ${lighttpd_sysconfdir}/conf.d/karesansui/*
    fi
  fi
done

# Register whitelist commands to pysilhouette service.
if [ -d %{__pysilhouette_sysconfdir} ]; then
  if [ ! -s %{__pysilhouette_sysconfdir}/whitelist.conf ]; then
    %{__cp} -f %{__sysconfdir}/whitelist.conf.example %{__pysilhouette_sysconfdir}/whitelist.conf
  fi
fi

%postun
if [ $1 = 0 ]; then
  /usr/sbin/userdel %{_user} 2> /dev/null || :
  /usr/sbin/groupdel %{_group} 2> /dev/null || :

  # Modify libvirt configuration file.
  sysconfig_libvirt=%{_sysconfdir}/sysconfig/hde-libvirtd
  if [ -f ${sysconfig_libvirt} ]; then
    %{__grep} -v "^PRIVSEP_GROUP=" ${sysconfig_libvirt} >${sysconfig_libvirt}.$$
    %{__cp} -f ${sysconfig_libvirt}.$$ ${sysconfig_libvirt}
    %{__rm} -f ${sysconfig_libvirt}.$$
  fi
  libvirtd_conf=%{__vendor_sysconfdir}/libvirt/libvirtd.conf
  if [ -f ${libvirtd_conf} ]; then
    %{__grep} '^unix_sock_group =' ${libvirtd_conf} >/dev/null 2>&1
    if [ $? -eq 0 ]; then
      %{__sed} -e "s#unix_sock_group = .*#unix_sock_group = \"root\"#"  ${libvirtd_conf} >${libvirtd_conf}.$$
      %{__cp} -f ${libvirtd_conf}.$$ ${libvirtd_conf}
      %{__rm} -f ${libvirtd_conf}.$$
    fi
  fi
fi

#%files -f INSTALLED_FILES
#%defattr(-,root,root)
#%doc doc tool

%files
%defattr(-,root,%{_group})
%doc doc tool AUTHORS COPYING COPYING.LIB INSTALL INSTALL.ja README README.ja
%dir %{python_sitelib}/
%dir %{python_sitelib}/karesansui/
%dir %{python_sitelib}/karesansui/db/
%dir %{python_sitelib}/karesansui/lib/
%dir %{python_sitelib}/karesansui/static/
%{python_sitelib}/karesansui/*.py*
%{python_sitelib}/karesansui/db/*.py*
%{python_sitelib}/karesansui/db/access/*.py*
%{python_sitelib}/karesansui/db/model/*.py*
%{python_sitelib}/karesansui/lib/*
%{python_sitelib}/karesansui/static/js/*
%{python_sitelib}/karesansui/static/lib/*
%{__sysconfdir}/*.example
%defattr(0770,root,%{_group})
%config(noreplace) %{__sysconfdir}/*.conf
%dir %{__sysconfdir}/
%dir /var/opt/karesansui/
%dir /var/log/karesansui/
%dir %{__tmpdir}/
%defattr(0770,root,%{_group})
%dir /var/opt/karesansui/cache
%defattr(0770,%{_group_member},%{_group})
%dir /var/opt/karesansui/cache/yum

%files data
%defattr(-,root,%{_group})
%dir %{python_sitelib}/karesansui/static/css/
%dir %{python_sitelib}/karesansui/static/icon/
%dir %{python_sitelib}/karesansui/static/images/
%dir %{python_sitelib}/karesansui/locale/
%{python_sitelib}/karesansui/static/css/*
%{python_sitelib}/karesansui/static/icon/*
%{python_sitelib}/karesansui/static/images/*
%{python_sitelib}/karesansui/locale/*/LC_MESSAGES/*.mo

%files gadget
%defattr(-,root,%{_group})
%dir %{python_sitelib}/karesansui/gadget/
%dir %{python_sitelib}/karesansui/templates/default/
%{python_sitelib}/karesansui/gadget/*
%{python_sitelib}/karesansui/templates/default/*

%files bin
%defattr(0770,root,%{_group})
%dir %{__bindir}/
%defattr(0550,root,%{_group})
%{__bindir}/*

%files test
%defattr(-,root,%{_group})
%dir %{python_sitelib}/karesansui/tests/
%{python_sitelib}/karesansui/tests/*

%files plus
%defattr(-,root,%{_group})
%dir %{python_sitelib}/karesansui/plus/
%{python_sitelib}/karesansui/plus/*

%changelog
* Wed Jan 06 2010 Kei Funagayama <kei@karesansui-project.info> - 1.1.0-4
- version 1.1.0 beta release.

* Fri Dec 25 2009 Taizo ITO <taizo@karesansui-project.info> - 1.1.0-3
- Fixed attach/detach device.

* Mon Dec 14 2009 Kei Funagayama <kei@karesansui-project.info> - 1.1.0-2
- Add "plus" package.
- Add Software Update feature.

* Thu Dec 10 2009 Taizo ITO <taizo@karesansui-project.info> - 1.1.0-1
- kvm support.
- Changed paths for domain's image data.

* Thu Oct 29 2009 Kei Funagayama <kei@karesansui-project.info> - 1.0.3-2
- CentOS(i386/x86_64) support.
- RHEL(i386/x86_64) support.

* Tue Sep 18 2009 Kei Funagayama <kei@karesansui-project.info> - 1.0.3-1
- Added checker for keymap selection.
- Fixed web server setting bugs.
- Fixed the following hungup bug.
    ** glibc detected *** /usr/bin/python: free(): invalid pointer:
- Changed the format of system uri path.
    fixed error "unexpected Xen URI path '/system', try xen:///" for libvirt-0.6.5.

* Thu Jun 18 2009 Kei Funagayama <kei@karesansui-project.info> - 1.0.2-1
- Sparce file support is now available at creating a guest environment.
- Keyboard maps selection is now available at creating a guest environment.
- Fixed rpm transaction closing order.
- Fixed checking of processor support.
- sqlite time to register with the system, had not added the time zone information.
- Network database is now available as pysilhouette database.
- Addresses an issue which karesansui does not work at multi-host environment.

* Tue Jun 9 2009 Kei Funagayama <kei@karesansui-project.info> - 1.0.1-1
- Karesansui now works on CentOS5.3 64bit(x86_64), RHEL5.3 64bit(x86_64) and RHEL5.3 32bit(x86).
- Added support for AMD Athlon64 or Opteron environment.
- Added favicons.
- Improves VNC console keyboard layout support.
- Prevents host environment's FQDN from being resolved.
- Highlights required items on input forms.
- Buttons turn disabled not to be clicked after clicking at dialog window.
- Karesansui now works when PostgreSQL is selected as database at the installation process.
- Addresses an issue which could not reach the management console after resetting F/W.
- Addresses an issue which could not move to other tabs while displaying guest console.
- Delete button is now turned disabled after destroying resources.
- Network configuration is now editable without errors.
- Addresses an issue which occurs when job search is performanced many times.
- Creating guest with empty value in "Memory Size" or "Disk Size" now works.
- Prevent input data from being posted to other resources when enter key is pressed on input forms.
- Improved a check logic about guest ID.
- Improved error handling on nonexistent NIC.

* Tue May 19 2009 Taizo ITO <taizo@karesansui-project.info> - 1.0.0-1
- Initial build.
