﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Twitter;
using Youryella.Windows.Forms;
using System.Xml;
using System.Net;
using System.IO;
using System.Windows.Media.Imaging;

namespace WindowsFormsApplication1
{

    public partial class Form1 : Form
    {

        public Form1()
        {
            InitializeComponent();
            this.FormBorderStyle = FormBorderStyle.Fixed3D;
            this.MaximizeBox = false;
            this.TopMost = !this.TopMost;
            var settings = Properties.Settings.Default;
            if (!string.IsNullOrEmpty((string)settings["AccessToken"]))
            {
                認証ToolStripMenuItem.Text = "認証取消(&A)";
                this.Opacity = settings.Opacity;
            }
            int ri = settings.ReplyInterval;
            timer1.Enabled = settings.ReplyPopup;
            timer1.Interval = ri;
            Form1.Form1Instance = this;
            this.notifyIcon1.Text = "かくれったー";

        }

        //Form1オブジェクトを保持するためのフィールド
        private static Form1 _form1Instance;

        //Form1オブジェクトを取得、設定するためのプロパティ
        public static Form1 Form1Instance
        {
            get
            {
                return _form1Instance;
            }
            set
            {
                _form1Instance = value;
            }
        }

        private void textBox3_KeyDown_1(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == System.Windows.Forms.Keys.Enter)
            {



                Auth auth;
                var settings = Properties.Settings.Default;

                if (settings.UserId == "")
                {
                    Form2 form2 = new Form2();
                    form2.Show();
                    return;
                }
                // 設定ファイルから読み込む
                auth = new Auth(settings.ConsumerKey, settings.ConsumerSecret,
                                settings.AccessToken, settings.AccessTokenSecret,
                                settings.UserId, settings.ScreenName);

                Dictionary<string, string> parameters = new Dictionary<string, string>();

                String text = textBox3.Text;
                textBox3.Text = "";
                if (textBox1.Text != "") text += " " + label1.Text + textBox1.Text;
                parameters.Add("status", auth.UrlEncode(text));
                auth.Post("http://api.twitter.com/1/statuses/update.xml", parameters);

            }
        }

        public static bool IsNumeric(string stTarget)
        {
            double dNullable;

            return double.TryParse(
                stTarget,
                System.Globalization.NumberStyles.Any,
                null,
                out dNullable
            );
        }

        public static bool IsNumeric(object oTarget)
        {
            return IsNumeric(oTarget.ToString());
        }

        private void button1_Click(object sender, EventArgs e)
        {
            String text = textBox3.Text;
            textBox3.Text = "";



            Auth auth;
            var settings = Properties.Settings.Default;


            // 設定ファイルから読み込む
            auth = new Auth(settings.ConsumerKey, settings.ConsumerSecret,
                            settings.AccessToken, settings.AccessTokenSecret,
                            settings.UserId, settings.ScreenName);

            Dictionary<string, string> parameters = new Dictionary<string, string>();

            if (textBox1.Text != "") text += " #" + textBox1.Text;
            parameters.Add("status", auth.UrlEncode(text));
            auth.Post("http://api.twitter.com/1/statuses/update.xml", parameters);

        }

        private void 認証ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            var settings = Properties.Settings.Default;
            if (!string.IsNullOrEmpty((string)settings["AccessToken"]))
            {
                settings.AccessToken = "";
                settings.AccessTokenSecret = "";
                settings.UserId = "";
                settings.ScreenName = "";
                settings.Save();
                認証ToolStripMenuItem.Text = "認証する(&A)";
            }
            else
            {
                Form2 form2 = new Form2();
                form2.Show();
            }
        }

        private void textBox3_TextChanged(object sender, EventArgs e)
        {
            int tl = 140 - this.textBox3.TextLength;
            this.label2.Text = tl.ToString();
        }

        private void 隠れるToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.WindowState = System.Windows.Forms.FormWindowState.Minimized;
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {

        }

        private void Form1_ClientSizeChanged(object sender, EventArgs e)
        {
            if (this.WindowState == System.Windows.Forms.FormWindowState.Minimized)
            {
                // フォームが最小化の状態であればフォームを非表示にする  
                this.Hide();

                // トレイリストのアイコンを表示する
                notifyIcon1.Icon = new Icon(this.Icon, 40, 40);
                notifyIcon1.Visible = true;
            }
        }

        private void notifyIcon1_Click(object sender, EventArgs e)
        {


        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (e.CloseReason != CloseReason.ApplicationExitCall)
            {
                e.Cancel = true;
                // フォームが最小化の状態であればフォームを非表示にする  
                this.Hide();

                // トレイリストのアイコンを表示する
                notifyIcon1.Icon = new Icon(this.Icon, 40, 40);
                notifyIcon1.Visible = true;
            }
        }

        private void notifyIcon1_DoubleClick(object sender, EventArgs e)
        {

        }

        private void 終了ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            notifyIcon1.Visible = false;
            Application.Exit();
        }

        private void 終了ToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            notifyIcon1.Visible = false;
            Application.Exit();
        }

        private void notifyIcon1_MouseClick(object sender, MouseEventArgs e)
        {
            if ((e.Button & MouseButtons.Left) == MouseButtons.Left)
            {
                // フォームを表示する  
                this.Visible = true;
                // 現在の状態が最小化の状態であれば通常の状態に戻す  
                if (this.WindowState == FormWindowState.Minimized)
                {
                    this.WindowState = FormWindowState.Normal;
                }
                // フォームをアクティブにする  
                this.Activate();
            }
        }

        private void 設定ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Form3 form3 = new Form3();
            form3.Show();
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            using (Youryella.Windows.Forms.AlertWindow aw = new Youryella.Windows.Forms.AlertWindow())
            {
                string url = "http://www.wgag.net/";  // URL

                LinkLabel linkLabel;
                linkLabel = new LinkLabel()
                {
                    Location = new Point(20, 20),
                    Text = url,
                    AutoSize = true,
                };

                //linkLabel.Links.Add(0, url.Length, url);  // リンクを追加
                //aw.MessageLiks.Add(0,0,linkLabel);
                //aw.LinkClicked += new LinkLabelLinkClickedEventHandler(linkLabel_LinkClicked);

                Auth auth;
                var settings = Properties.Settings.Default;

                // 設定ファイルから読み込む
                auth = new Auth(settings.ConsumerKey, settings.ConsumerSecret,
                                settings.AccessToken, settings.AccessTokenSecret,
                                settings.UserId, settings.ScreenName);

                Dictionary<string, string> parameters = new Dictionary<string, string>();


                //parameters.Add("count", "30");
                string a = auth.Get("http://api.twitter.com/1/statuses/mentions.xml", parameters);

                XmlDocument xd = new XmlDocument();

                xd.LoadXml(a);
                XmlElement xe = xd.DocumentElement;
                XmlNodeList xnl = xe.GetElementsByTagName("name");
                XmlNodeList xnl2 = xe.GetElementsByTagName("text");
                XmlNodeList xnl3 = xe.GetElementsByTagName("profile_image_url");
                XmlNodeList xnl4 = xe.GetElementsByTagName("created_at");

                for (int i = 0; i < xnl.Count; i++)
                {
                    aw.CustomIcon = loadImageFromURL(xnl3.Item(i).InnerText);
                    aw.Icon = AlertIcons.Custom;
                    aw.BlinkCount = 0;
                    aw.Title = xnl.Item(i).InnerText;
                    DateTime dt = datetimeParceTwitter(xnl4.Item(i).InnerText);
                    dt = dt.AddMilliseconds(timer1.Interval);
                    DateTime now = DateTime.Now;
                    if (now < dt)
                    {
                        aw.Show(xnl2.Item(i).InnerText);
                    }
                    else
                    {
                        break;
                    }

                }

                    
            }
        }

        private DateTime datetimeParceTwitter(string created_at)
        {
            string convertStr = "ddd MMM dd HH':'mm':'ss zz'00' yyyy";
            DateTime dt = DateTime.ParseExact(created_at, convertStr,
                System.Globalization.DateTimeFormatInfo.InvariantInfo,
                System.Globalization.DateTimeStyles.None);
            return dt;
        }

        // リンクラベルがクリックされたときのイベントハンドラ
//        private void linkLabel_LinkClicked(
//            object sender, LinkLabelLinkClickedEventArgs e)
//        {
//            this.button1.Text = "aaaa";
//        }

        public static System.Drawing.Image loadImageFromURL(string url)
        {
            int buffSize = 65536; // 一度に読み込むサイズ
            MemoryStream imgStream = new MemoryStream();

            //------------------------
            // パラメータチェック
            //------------------------
            if (url == null || url.Trim().Length <= 0)
            {
                return null;
            }

            //----------------------------
            // Webサーバに要求を投げる
            //----------------------------
            WebRequest req = WebRequest.Create(url);
            BinaryReader reader = new BinaryReader(req.GetResponse().GetResponseStream());

            //--------------------------------------------------------
            // Webサーバからの応答データを取得し、imgStreamに保存する
            //--------------------------------------------------------
            while (true)
            {
                byte[] buff = new byte[buffSize];

                // 応答データの取得
                int readBytes = reader.Read(buff, 0, buffSize);
                if (readBytes <= 0)
                {
                    // 最後まで取得した->ループを抜ける
                    break;
                }

                // バッファに追加
                imgStream.Write(buff, 0, readBytes);
            }

            return new Bitmap(imgStream);
        }

        private void label1_Click(object sender, EventArgs e)
        {
            if (label1.Text == "#")
            {
                label1.Text = "@";
            }
            else
            {
                label1.Text = "#";
            }
            
        }

    }
}
