﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Twitter;
using Youryella.Windows.Forms;
using System.Xml;
using System.Net;
using System.IO;
using System.Windows.Media.Imaging;
using System.Threading;
using System.Timers;

namespace Kakuretter
{

    public partial class Form1 : Form
    {

        public HotKey hotKey;

        void hotKey_HotKeyPush(object sender, EventArgs e)
        {

            if (this.Visible)
            {
                this.Hide();
                this.Close();

                // トレイリストのアイコンを表示する
                notifyIcon1.Icon = new Icon(this.Icon, 40, 40);
                notifyIcon1.Visible = true;
            }
            else
            {
                // フォームを表示する
                this.Visible = true;
                this.WindowState = FormWindowState.Normal;
                this.Activate();
            }

            
        }

        public Form1()
        {
            InitializeComponent();

            var settings = Properties.Settings.Default;

            if ((bool)settings["HotKeyHidden"] == true)
            {
                this.HotKeyHiddenActivate();
            }

            if (!string.IsNullOrEmpty((string)settings["AccessToken"]))
            {
                authToolStripMenuItem.Text = "認証解除(&A)";

                int ri = settings.ReplyInterval;
                timer1.Interval = ri;
                timer1.Enabled = settings.ReplyPopup;
            
            }

            this.Location = settings.MyLocation;
            this.Opacity = settings.Opacity;
            Form1.Form1Instance = this;
        }

        public void HotKeyHiddenActivate(){
            hotKey = new HotKey(MOD_KEY.ALT, Keys.H);
            hotKey.HotKeyPush += new EventHandler(hotKey_HotKeyPush);
        }

        //Form1オブジェクトを保持するためのフィールド
        private static Form1 _form1Instance;

        //Form1オブジェクトを取得、設定するためのプロパティ
        public static Form1 Form1Instance
        {
            get
            {
                return _form1Instance;
            }
            set
            {
                _form1Instance = value;
            }
        }

        private void textBox3_KeyDown_1(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == System.Windows.Forms.Keys.Enter)
            {

                // 設定ファイルから読み込む
                var settings = Properties.Settings.Default;
                if (settings.UserId == "")
                {
                    Form2 form2 = new Form2();
                    form2.Show();
                    return;
                }
                this.tweet();

            }
        }

        private void button1_Click(object sender, EventArgs e)
        {

            // 設定ファイルから読み込む
            var settings = Properties.Settings.Default;
            if (settings.UserId == "")
            {
                Form2 form2 = new Form2();
                form2.Show();
                return;
            }
            this.tweet();

        }

        private void tweet()
        {
            String text = textBox3.Text;
            if (text == "") return;
            textBox3.Text = "";

            Dictionary<string, string> parameters = new Dictionary<string, string>();

            if (textBox1.Text != "") text += " " + label1.Text + textBox1.Text;
            // 設定ファイルから読み込む
            var settings = Properties.Settings.Default;
            Auth auth = new Auth(settings.ConsumerKey, settings.ConsumerSecret,
                            settings.AccessToken, settings.AccessTokenSecret,
                            settings.UserId, settings.ScreenName);
            parameters.Add("status", auth.UrlEncode(text));
            auth.Post("http://api.twitter.com/1/statuses/update.xml", parameters);
        }

        private void 認証ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            var settings = Properties.Settings.Default;
            if (!string.IsNullOrEmpty((string)settings["AccessToken"]))
            {
                //認証解除ボタンが押されたときに本当に解除するかの確認を行う。
                DialogResult result = MessageBox.Show("本当に認証を解除しますか？",
                    "確認",
                    MessageBoxButtons.YesNoCancel,
                    MessageBoxIcon.Exclamation,
                    MessageBoxDefaultButton.Button2);

                if (result == DialogResult.Yes)
                {
                    settings.AccessToken = "";
                    settings.AccessTokenSecret = "";
                    settings.UserId = "";
                    settings.ScreenName = "";
                    settings.Save();
                    authToolStripMenuItem.Text = "認証する(&A)...";
                }
            }
            else
            {
                Form2 form2 = new Form2();
                form2.Show();
            }
        }

        private void textBox3_TextChanged(object sender, EventArgs e)
        {
            int tl = 140 - this.textBox3.TextLength;
            this.label2.Text = tl.ToString();
        }

        private void 隠れるToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {

        }

        private void notifyIcon1_Click(object sender, EventArgs e)
        {


        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (e.CloseReason != CloseReason.ApplicationExitCall)
            {
                e.Cancel = true;
                // フォームが最小化の状態であればフォームを非表示にする  
                this.Hide();
                // トレイリストのアイコンを表示する
                notifyIcon1.Icon = new Icon(this.Icon, 40, 40);
                notifyIcon1.Visible = true;
            }
        }

        private void notifyIcon1_DoubleClick(object sender, EventArgs e)
        {

        }

        private void 終了ToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            notifyIcon1.Visible = false;

            var settings = Properties.Settings.Default;
            settings.MyLocation = this.Location;
            settings.Save();
            if (settings.HotKeyHidden == true)
            {
                hotKey.Dispose();
            }
            Application.Exit();
        }

        private void notifyIcon1_MouseClick(object sender, MouseEventArgs e)
        {
            if ((e.Button & MouseButtons.Left) == MouseButtons.Left)
            {
                // フォームを表示する  
                this.Visible = true;
                // フォームをアクティブにする  
                this.Activate();
            }
        }

        private void 設定ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Form3 form3 = new Form3();
            form3.Show();
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }

        void CloseClick(object obj, EventArgs ea)
        {
            //MessageBox.Show("Closed was Clicked");
        }

        void TitleClick(object obj, EventArgs ea)
        {
            MessageBox.Show("Title was Clicked");
        }

        void ContentClick(object obj, EventArgs ea)
        {
            MessageBox.Show("Content was Clicked");
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            // 設定ファイルから読み込む
            var settings = Properties.Settings.Default;
            if (string.IsNullOrEmpty((string)settings["AccessToken"])) return;

            Dictionary<string, string> parameters = new Dictionary<string, string>();
            parameters.Add("count", "30");

            Auth auth = new Auth(settings.ConsumerKey, settings.ConsumerSecret,
                            settings.AccessToken, settings.AccessTokenSecret,
                            settings.UserId, settings.ScreenName);
            string a = auth.Get("http://api.twitter.com/1/statuses/mentions.xml", parameters);
            XmlDocument xd = new XmlDocument();
            xd.LoadXml(a);
            XmlElement xe = xd.DocumentElement;

            String replyText = "";
            XmlNodeList xnl = xe.ChildNodes;

            for (int i = 0; i < xnl.Count; i++)
            {
                DateTime dt = datetimeParceTwitter(xnl[i].ChildNodes[0].InnerText);
                dt = dt.AddMilliseconds(timer1.Interval);
                DateTime now = DateTime.Now;
                if (now < dt)
                {
                    replyText += xnl[i].ChildNodes[8].ChildNodes[1].InnerText + "さん\n" + xnl[i].ChildNodes[2].InnerText;
                    if (i != (xnl.Count - 1))
                    {
                        replyText += "\n\n";
                    }
                }

            }

            if (replyText != "")
            {
                //バルーンヒントのタイトル
                notifyIcon1.BalloonTipTitle = "返信がありました";
                //バルーンヒントに表示するメッセージ
                notifyIcon1.BalloonTipText = replyText;
                //バルーンヒントに表示するアイコン
                notifyIcon1.BalloonTipIcon = ToolTipIcon.Info;
                //バルーンヒントを表示する
                //表示する時間をミリ秒で指定する
                notifyIcon1.ShowBalloonTip(1000);
            }
        }

        private DateTime datetimeParceTwitter(string created_at)
        {
            string convertStr = "ddd MMM dd HH':'mm':'ss zz'00' yyyy";
            DateTime dt = DateTime.ParseExact(created_at, convertStr,
                System.Globalization.DateTimeFormatInfo.InvariantInfo,
                System.Globalization.DateTimeStyles.None);
            return dt;
        }

        private void label1_Click(object sender, EventArgs e)
        {
            if (label1.Text == "#")
            {
                label1.Text = "@";
            }
            else
            {
                label1.Text = "#";
            }

        }

        private void 設定OToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Form3 form3 = new Form3();
            form3.Show();
        }

    }
}
