﻿using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;

namespace カブラウザもどき
{
    /// <summary>
    /// WEBブラウザ拡張イベント定義
    /// </summary>
    public class BrowserExtendedNavigatingEventArgs : CancelEventArgs
    {
        private Uri _Url;
        /// <summary>
        /// The URL to navigate to
        /// </summary>
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode")]
        public Uri Url
        {
            get { return _Url; }
        }

        private string _Frame;
        /// <summary>
        /// The name of the frame to navigate to
        /// </summary>
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode")]
        public string Frame
        {
            get { return _Frame; }
        }

        private UrlContext navigationContext;
        /// <summary>
        /// The flags when opening a new window
        /// </summary>
        public UrlContext NavigationContext
        {
            get { return this.navigationContext; }
        }

        private object _pDisp;
        /// <summary>
        /// The pointer to ppDisp
        /// </summary>
        public object AutomationObject
        {
            get { return this._pDisp; }
            set { this._pDisp = value; }
        }

        /// <summary>
        /// Creates a new instance of WebBrowserExtendedNavigatingEventArgs
        /// </summary>
        /// <param name="automation">Pointer to the automation object of the browser</param>
        /// <param name="url">The URL to go to</param>
        /// <param name="frame">The name of the frame</param>
        /// <param name="navigationContext">The new window flags</param>
        public BrowserExtendedNavigatingEventArgs(object automation, Uri url, string frame, UrlContext navigationContext)
            : base()
        {
            _Url = url;
            _Frame = frame;
            this.navigationContext = navigationContext;
            this._pDisp = automation;
        }
    }

    /// <summary>
    /// Flags used by INewWindowManager::EvaluateNewWindow. 
    /// These values are taken into account in the decision of whether to display a pop-up window.
    /// </summary>
    [Flags]
    public enum UrlContext
    {
        /// <summary>
        /// No information Present
        /// </summary>
        None = 0x0,
        /// <summary>
        /// The page is unloading. This flag is set in response to the onbeforeunload and onunload events. 
        /// Some pages load pop-up windows when you leave them rather than when you enter. This flag is used to identify those situations.
        /// </summary>
        Unloading = 0x1,
        /// <summary>
        /// The call to INewWindowManager::EvaluateNewWindow is the result of a user-initiated action 
        /// (a mouse click or key press). Use this flag in conjunction with the NWMF_FIRST_USERINITED flag 
        /// to determine whether the call is a direct or indirect result of the user-initiated action.
        /// </summary>
        UserInited = 0x2,
        /// <summary>
        /// When NWMF_USERINITED is present, this flag indicates that the call to 
        /// INewWindowManager::EvaluateNewWindow is the first query that results from this user-initiated action. 
        /// Always use this flag in conjunction with NWMF_USERINITED.
        /// </summary>
        UserFirstInited = 0x4,
        /// <summary>
        /// The override key (ALT) was pressed. The override key is used to bypass the pop-up manager預llowing 
        /// all pop-up windows to display預nd must be held down at the time that INewWindowManager::EvaluateNewWindow is called. 
        /// </summary>
        OverrideKey = 0x8,
        /// <summary>
        /// The new window attempting to load is the result of a call to the showHelp method. Help is sometimes displayed in a separate window, 
        /// and this flag is valuable in those cases.
        /// </summary>
        ShowHelp = 0x10,
        /// <summary>
        /// The new window is a dialog box that displays HTML content.
        /// </summary>
        HtmlDialog = 0x20,
        /// <summary>
        /// Indicates that the EvaluateNewWindow method is being called through a marshalled Component Object Model (COM) proxy 
        /// from another thread. In this situation, the method should make a decision and return immediately without performing 
        /// blocking operations such as showing modal user interface (UI). Lengthy operations will cause the calling thread to 
        /// appear unresponsive.
        /// </summary>
        FromProxy = 0x40
    }
}
