﻿using System;
using System.ComponentModel;
 using System.Windows.Forms;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

namespace カブラウザもどき
{
    /// <summary>
    /// タイムアウトつき非表示ブラウザ
    /// </summary>
    class NonDispBrowser : WebBrowser
    {
        bool done;

        // タイムアウト 
        TimeSpan timeout = new TimeSpan(0, 0, 10);

        protected override void OnDocumentCompleted(WebBrowserDocumentCompletedEventArgs e)
        {
            base.OnDocumentCompleted(e);
            // このメソッドが実行されるため実際のURLを確認する
            if (e.Url == this.Url)
            {
                done = true;
            }
        }

        protected override void OnNewWindow(CancelEventArgs e)
        {
            e.Cancel = true;
            base.OnNewWindow(e);
        }

        public NonDispBrowser()
        {
            this.ScriptErrorsSuppressed = true;
        }

        public bool NavigateAndWait(string url)
        {
            this.Refresh(WebBrowserRefreshOption.Completely);
            base.Navigate(new Uri(url)); // ページの移動

            done = false;
            DateTime start = DateTime.Now;

            while (done == false)
            {
                if (DateTime.Now - start > timeout)
                {
                    // タイムアウト
                    return false;
                }
                Application.DoEvents();
            }
            return true;
        }

        private void InitializeComponent()
        {
            this.SuspendLayout();
            // 
            // NonDispBrowser
            // 
            this.Visible = false;
            this.ResumeLayout(false);
        }
    }

    /// <summary>
    /// タイムアウト付きブラウザ
    /// </summary>
    class DispBrowser : WebBrowser
    {
        bool done;

        // タイムアウト 
        TimeSpan timeout = new TimeSpan(0, 0, 10);

        protected override void OnDocumentCompleted(WebBrowserDocumentCompletedEventArgs e)
        {
            base.OnDocumentCompleted(e);
            // このメソッドが実行されるため実際のURLを確認する
            if (e.Url == this.Url)
            {
                done = true;
            }
        }


        //protected override void OnNewWindow(CancelEventArgs e)
        //{
        //    e.Cancel = true;
        //    base.OnNewWindow(e);
        //}

        public DispBrowser()
        {
            this.ScriptErrorsSuppressed = true;
        }

        public bool NavigateAndWait(string url)
        {
            this.Refresh(WebBrowserRefreshOption.Completely);
            base.Navigate(new Uri(url)); // ページの移動

            done = false;
            DateTime start = DateTime.Now;

            while (done == false)
            {
                if (DateTime.Now - start > timeout)
                {
                    // タイムアウト
                    return false;
                }
                Application.DoEvents();
            }
            return true;
        }

        private void InitializeComponent()
        {
            this.SuspendLayout();
            this.Visible = true;
            this.ResumeLayout(false);
        }
    }
}
