﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Web;
using System.Threading;
using System.Xml;
using System.Collections;
using System.Diagnostics;

// for Datagridview

namespace カブラウザもどき
{
    /// <summary>
    /// このアプリケーションの実行には.NET Framework 3.5が必要です。
    /// http://www.microsoft.com/downloads/ja-jp/details.aspx?displaylang=ja&FamilyID=0a391abd-25c1-4fc0-919f-b21f31ab88b7
    /// </summary>
    public partial class Form1 : Form
    {
        /// <summary>
        /// このアプリ内の改行文字
        /// </summary>
        public const string csCrLf = "\r\n";
        /// <summary>
        /// タイトル一覧（xxxx.dat）ファイルの格納場所
        /// </summary>
        public const string csDatDir = @".\Logs\kabu\";  // datファイル格納
        /// <summary>
        /// 無視リスト一覧
        /// </summary>
        public const string csNGFile = @".\NGName.txt";  // 無視リスト
        /// <summary>
        /// カブラウザのコード一覧（code.lst）の場所
        /// </summary>
        public const string csCDFile = @".\code.lst";
        /// <summary>
        /// カブラウザのコード一覧（edinet.lst）の場所
        /// </summary>
        public const string csEDIFile = @".\edinet.lst";
        /// <summary>
        /// 初期設定ファイル（殆ど空）
        /// </summary>
        public const string csIniFile = @".\kabu.ini";

        private uint maxRow;
        private static CurrentContext context = null;     // 表示中の銘柄を管理する構造体(このアプリの肝)
        private Hashtable edinetlist = new Hashtable();   // EDINETコードリスト
        private Hashtable ignorelist = new Hashtable();   // 無視リスト
        private Hashtable emphasislist = new Hashtable(); // ignorelistと同じ（灰色表示に使う）
        private char delimiter = char.Parse(Char.ConvertFromUtf32(128));  // xxxx.datファイルの区切り文字(絶対に使用されていない文字)
        private char tvdelimiter = '　';                  // TreeViewに表示した銘柄のコードと銘柄名称の区切り文字
        private static NonDispBrowser ndb = new NonDispBrowser();  // 裏で動く非表示のブラウザ
        private string displayType = "ListView";

        private enum ImageList  // アイコンリスト
        {
            CloseFolder = 0, OpenFolder = 1, File = 2, Search = 3, Note = 4, Reply = 5, AllGet = 6,
            DailyRank = 7, WeeklyRank = 8, MonthlyRank = 9, TextSearch = 10, NGOn = 11, NGOff = 12
        };

        private enum ImageListSub  // アイコンリスト
        {
            Short = 0, Think = 1, Timely = 2, News = 3, Edinet= 4
        };


        /// <summary>
        /// コンストラクタ
        /// </summary>
        public Form1()
        {
            InitializeComponent();
        }


        /**
         * 
         * Formを初期化する
         * 
         */
        private void Form1_Load(object sender, EventArgs e)
        {
            this.Text = "カブラウザもどき";

            // メニューの初期化
            MenuInit();

            // ツールストリップ初期化
            ToolStripInit();

            // kabu.iniファイル読込み
            //if (!LoadIniFile()) return ;
            LoadIniFile();

            // リストビュー初期化
            ListViewInit();

            // **************   ここからcode.lstの読み込み, TreeViewの設定
            this.treeView1.Nodes.Clear();
            this.treeView1.ImageList = imageList1;
            LoadCodeList();
            this.treeView1.AllowDrop = true;
            this.treeView1.LabelEdit = true;
            // ダミーを最低1つはぶら下げる
            if (this.treeView1.Nodes.Count == 0)
            {
                TreeNode tn = new TreeNode("フォルダ１");
                tn.Name = "フォルダ１";
                tn.ImageIndex = (int)ImageList.CloseFolder;
                this.treeView1.Nodes.Add(tn);
            }
            // **************   ここまでcode.lstの読み込み, TreeViewの設定  

            // EDINETコード読込み
            LoadEDIList();

            // *************  ここからTextBox関連
            this.textBox3.Enabled = false;
            this.textBox4.Enabled = false;
            // *************  ここまでTextBox関連
            
        }

        /// <summary>
        /// StripMenuを初期化する
        /// </summary>
        private void MenuInit()
        {
            //  ListViewに表示するメニュー
            ContextMenuStrip menu_listview = new ContextMenuStrip();
            ToolStripMenuItem menu_listview_1 = new ToolStripMenuItem();
            ToolStripMenuItem menu_listview_2 = new ToolStripMenuItem();
            ToolStripMenuItem menu_listview_3 = new ToolStripMenuItem();
            ToolStripMenuItem menu_listview_4 = new ToolStripMenuItem();
            ToolStripMenuItem menu_listview_5 = new ToolStripMenuItem();
            ToolStripMenuItem menu_listview_6 = new ToolStripMenuItem();
            ToolStripMenuItem menu_listview_7 = new ToolStripMenuItem();
            menu_listview_1.Text = "返信";
            menu_listview_1.Click += delegate
            {
                if (listView1.SelectedItems != null && listView1.SelectedItems.Count > 0)
                {
                    string mid = listView1.SelectedItems[0].Text;
                    webBrowser1.Navigate(new Uri("http://post.messages.yahoo.co.jp/bbs?mm=FN&action=r&board=1" + context.GetPad() + context.GetCode() + "&tid=" + context.tid + "&sid=1" + context.GetPad() + context.GetCode() + "&mid=" + mid));
                }
            };

            menu_listview_2.Text = "スレッドを表示";
            menu_listview_2.Click += delegate
            {
                if (listView1.SelectedItems != null && listView1.SelectedItems.Count > 0)
                {
                    string mid = listView1.SelectedItems[0].SubItems[0].Text;
                    webBrowser1.Navigate(new Uri("http://post.messages.yahoo.co.jp/bbs?mm=FN&action=m&board=1" + context.GetPad() + context.GetCode() + "&tid=" + context.tid + "&sid=1" + context.GetPad() + context.GetCode() + "&mid=" + mid + "&thr=" + mid + "&cur=" + mid));
                }
            };

            menu_listview_3.Text = "前の40件を表示";
            menu_listview_3.Click += delegate
            {
                GetTitleListsFromHtml(context.GetCode(), -1);
                RedisplayListView();
            };

            menu_listview_4.Text = "次の40件を表示";
            menu_listview_4.Click += delegate
            {
                GetTitleListsFromHtml(context.GetCode(), 1);
                RedisplayListView();
            };

            menu_listview_5.Text = "無視リストに入れる";
            menu_listview_5.Click += delegate
            {
                if (listView1.SelectedItems != null && listView1.SelectedItems.Count > 0)
                {
                    string tmpSender = listView1.SelectedItems[0].SubItems[2].Text;
                    InsertNGName(tmpSender);
                    LoadNGName();
                    this.toolStrip1.Items[0].ImageIndex = (int)ImageList.NGOn;
                    RedisplayListView();
                }
            };

            menu_listview_6.Text = "無視リストから消去する";
            menu_listview_6.Click += delegate
            {
                if (listView1.SelectedItems != null && listView1.SelectedItems.Count > 0)
                {
                    string tmpSender = listView1.SelectedItems[0].SubItems[2].Text;
                    RemoveNGName(tmpSender);
                    RedisplayListView();
                }
            };

            menu_listview_7.Text = "ブラウザで表示する";
            menu_listview_7.Click += delegate
            {
                if (listView1.SelectedItems != null && listView1.SelectedItems.Count > 0)
                {
                    string mid = listView1.SelectedItems[0].SubItems[0].Text;
                    string url = "http://messages.yahoo.co.jp/bbs?.mm=FN&action=m&board=1" + context.GetPad() + context.GetCode() + "&tid=" + context.tid + "&sid=1" + context.GetPad() + context.GetCode() + "&mid=" + mid;
                    Process.Start("IExplore.exe", url);
                }
            };
            
            menu_listview.Items.Add(menu_listview_1);
            menu_listview.Items.Add(menu_listview_2);
            menu_listview.Items.Add(menu_listview_3);
            menu_listview.Items.Add(menu_listview_4);
            menu_listview.Items.Add("-");
            menu_listview.Items.Add(menu_listview_5);
            menu_listview.Items.Add(menu_listview_6);
            menu_listview.Items.Add("-");
            menu_listview.Items.Add(menu_listview_7);

            //  TreeViewに表示するメニュー
            ContextMenuStrip menu_on_company = new ContextMenuStrip();
            ContextMenuStrip menu_on_folder = new ContextMenuStrip();
            ToolStripMenuItem menuCP1 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP2 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP3 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP4 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP5 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP6 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP7 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP8 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP9 = new ToolStripMenuItem();


            ToolStripMenuItem menuCP10 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP11 = new ToolStripMenuItem();

            menuCP1.Text = "銘柄コード作成";
            menuCP2.Text = "削除";
            menuCP2.Click += delegate
            {

                if (MessageBox.Show("削除しますがよろしいですか？",
                    "確認",
                    MessageBoxButtons.YesNo,
                    MessageBoxIcon.Question,
                    MessageBoxDefaultButton.Button2) == DialogResult.Yes)
                {
                    TreeNode tn = treeView1.SelectedNode;
                    tn.Remove();
                }
            };
            menuCP3.Text = "フォルダ作成";
            menuCP3.Click += delegate
            {
                TreeNode tn = new TreeNode();
                treeView1.Nodes.Add(tn);
                treeView1.SelectedNode = tn;
                treeView1.Focus();
                if (treeView1.SelectedNode != null)
                {
                    treeView1.LabelEdit = true;
                    treeView1.SelectedNode.BeginEdit();
                }
            };
            menuCP4.Text = "チャート表示";
            menuCP4.Click += delegate
            {
                if (treeView1.SelectedNode != null && treeView1.SelectedNode.ImageIndex == (int)ImageList.File && treeView1.SelectedNode.Name.Length >= 4)
                {
                    string code = treeView1.SelectedNode.Name;
                    webBrowser1.Navigate(new Uri("http://stocks.finance.yahoo.co.jp/stocks/chart/?code=" + code + "&ct=z&t=6m&q=c&l=off&z=m&p=m65,m130,s&a=v"));
                }
            };
            menuCP5.Text = "ニュース表示";
            menuCP5.Click += delegate
            {
                if (treeView1.SelectedNode != null && treeView1.SelectedNode.ImageIndex == (int)ImageList.File && treeView1.SelectedNode.Name.Length >= 4)
                {
                    string code = treeView1.SelectedNode.Name;
                    webBrowser1.Navigate(new Uri("http://stocks.finance.yahoo.co.jp/stocks/news/?code=" + code));
                }
            };
            menuCP6.Text = "企業情報を表示";
            menuCP6.Click += delegate
            {
                if (treeView1.SelectedNode != null && treeView1.SelectedNode.ImageIndex == (int)ImageList.File && treeView1.SelectedNode.Name.Length >= 4)
                {
                    string code = treeView1.SelectedNode.Name;
                    webBrowser1.Navigate(new Uri("http://stocks.finance.yahoo.co.jp/stocks/profile/?code=" + code));
                }
            };

            menuCP7.Text = "保存する";
            menuCP7.Click += delegate
            {
                SaveCodeList();
                MessageBox.Show("code.lstに保存しました。");
            };

            menuCP8.Text = "ブラウザで表示する";
            menuCP8.Click += delegate
            {
                if (treeView1.SelectedNode != null && treeView1.SelectedNode.ImageIndex == (int)ImageList.File && treeView1.SelectedNode.Name.Length >= 4)
                {
                    string code = this.treeView1.SelectedNode.Name;
                    string url = "http://messages.yahoo.co.jp/bbs?action=topics&board=1" + context.GetPad() + code + "&sid=1" + context.GetPad() + code + "";
                    Process.Start("IExplore.exe", url);
                }
            };

            menuCP9.Text = "編集";
            menuCP9.Click += delegate
            {
                TreeNode tn = treeView1.SelectedNode;
                treeView1.LabelEdit = true;
                if (tn != null && treeView1.LabelEdit )
                {
                    tn.BeginEdit();
                }
            };

            menuCP10.Text = "全て展開する";
            menuCP10.Click += delegate
            {
                foreach (TreeNode tn in treeView1.Nodes)
                {
                    if (tn.Parent == null) tn.Expand();
                }
            };

            menuCP11.Text = "全て閉じる";
            menuCP11.Click += delegate
            {
                foreach (TreeNode tn in treeView1.Nodes)
                {
                    if (tn.Parent == null) tn.Collapse();
                }
            };

            menu_on_folder.Items.Add(menuCP1);
            menu_on_folder.Items.Add(menuCP2);

            menu_on_company.Items.Add(menuCP4);
            menu_on_company.Items.Add(menuCP5);
            menu_on_company.Items.Add(menuCP6);
            menu_on_company.Items.Add(menuCP8);

            menu_on_company.Items.Add("-");
            menu_on_company.Items.Add(menuCP3);
            menu_on_company.Items.Add(menuCP2);
            menu_on_company.Items.Add(menuCP9);

            menu_on_company.Items.Add("-");
            menu_on_company.Items.Add(menuCP10);
            menu_on_company.Items.Add(menuCP11);
            menu_on_company.Items.Add(menuCP7);


            ContextMenuStrip menu_on_status = new ContextMenuStrip();
            ToolStripMenuItem menuST1 = new ToolStripMenuItem();
            menuST1.Text = "URLをコピーする";
            menuST1.Click += delegate
            {
                Clipboard.SetText(this.toolStripStatusLabel1.Text);
            };
            menu_on_status.Items.Add(menuST1);

            this.contextMenuStrip1 = menu_on_company;
            this.contextMenuStrip2 = menu_listview;
            this.contextMenuStrip3 = menu_on_folder;
            this.contextMenuStrip4 = menu_on_status;
            this.treeView1.ContextMenuStrip = menu_on_company;
            this.listView1.ContextMenuStrip = menu_listview;
            this.statusStrip1.ContextMenuStrip = menu_on_status;
            
            return;
        }

        /// <summary>
        /// ToolStripを初期化する
        /// </summary>
        private void ToolStripInit()
        {
            this.toolStrip1.ImageList = imageList1;
            // 
            // toolStripButton1
            //
            ToolStripButton toolStripButton1 = new System.Windows.Forms.ToolStripButton();
            toolStripButton1.Alignment = ToolStripItemAlignment.Left;
            toolStripButton1.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton1.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            toolStripButton1.ImageIndex = (int)ImageList.Search;
            toolStripButton1.Name = "toolStripButton1";
            toolStripButton1.Text = "検索";
            toolStripButton1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            toolStripButton1.Click += new System.EventHandler(this.toolStripButton1_Click);
            // 
            // toolStripButton2
            // 
            ToolStripButton toolStripButton2 = new System.Windows.Forms.ToolStripButton();
            toolStripButton2.Alignment = ToolStripItemAlignment.Right;
            toolStripButton2.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton2.ImageIndex = (int)ImageList.Note;
            toolStripButton2.Name = "toolStripButton2";
            toolStripButton2.Text = "書込";
            toolStripButton2.Click += new System.EventHandler(this.toolStripButton2_Click);
            // 
            // toolStripButton3
            // 
            ToolStripButton toolStripButton3 = new System.Windows.Forms.ToolStripButton();
            toolStripButton3.Alignment = ToolStripItemAlignment.Right;
            toolStripButton3.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton3.ImageIndex = (int)ImageList.Reply;
            toolStripButton3.Name = "toolStripButton3";
            toolStripButton3.Text = "返信";
            toolStripButton3.Click += new System.EventHandler(this.toolStripButton3_Click);
            // 
            // toolStripButton4
            // 
            ToolStripButton toolStripButton4 = new System.Windows.Forms.ToolStripButton();
            toolStripButton4.Alignment = ToolStripItemAlignment.Right;
            toolStripButton4.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton4.ImageIndex = (int)ImageList.TextSearch;
            toolStripButton4.Name = "toolStripButton4";
            toolStripButton4.Text = "全文検索";
            toolStripButton4.Click += new System.EventHandler(this.toolStripButton4_Click);

            // 
            // toolStripButton5
            // 
            ToolStripButton toolStripButton5 = new System.Windows.Forms.ToolStripButton();
            toolStripButton5.Alignment = ToolStripItemAlignment.Right;
            toolStripButton5.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton5.ImageIndex = (int)ImageList.AllGet;
            toolStripButton5.Name = "toolStripButton5";
            toolStripButton5.Text = "全タイトル取得";
            toolStripButton5.Click += new System.EventHandler(this.toolStripButton5_Click);

            // 
            // toolStripButton6
            // 
            ToolStripButton toolStripButton6 = new System.Windows.Forms.ToolStripButton();
            toolStripButton6.Alignment = ToolStripItemAlignment.Right;
            toolStripButton6.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton6.ImageIndex = (int)ImageList.DailyRank;
            toolStripButton6.Name = "toolStripButton6";
            toolStripButton6.Text = "日次ランキング";
            toolStripButton6.Click += new System.EventHandler(this.toolStripButton6_Click);
            // 
            // toolStripButton7
            // 
            ToolStripButton toolStripButton7 = new System.Windows.Forms.ToolStripButton();
            toolStripButton7.Alignment = ToolStripItemAlignment.Right;
            toolStripButton7.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton7.ImageIndex = (int)ImageList.WeeklyRank;
            toolStripButton7.Name = "toolStripButton7";
            toolStripButton7.Text = "週次ランキング";
            toolStripButton7.Click += new System.EventHandler(this.toolStripButton7_Click);
            // 
            // toolStripButton8
            // 
            ToolStripButton toolStripButton8 = new System.Windows.Forms.ToolStripButton();
            toolStripButton8.Alignment = ToolStripItemAlignment.Right;
            toolStripButton8.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton8.ImageIndex = (int)ImageList.MonthlyRank;
            toolStripButton8.Name = "toolStripButton8";
            toolStripButton8.Text = "月次ランキング";
            toolStripButton8.Click += new System.EventHandler(this.toolStripButton8_Click);

            // 
            // toolStripButton9
            // 
            ToolStripButton toolStripButton9 = new System.Windows.Forms.ToolStripButton();
            toolStripButton9.Alignment = ToolStripItemAlignment.Right;
            toolStripButton9.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton9.ImageIndex = (int)ImageList.NGOn;
            toolStripButton9.Name = "toolStripButton9";
            toolStripButton9.Text = "無視リストの表示を切替";
            toolStripButton9.Click += new System.EventHandler(this.toolStripButton9_Click);

            toolStrip1.Items.Add(toolStripButton9);
            toolStrip1.Items.Add(toolStripButton8);
            toolStrip1.Items.Add(toolStripButton7);
            toolStrip1.Items.Add(toolStripButton6);
            toolStrip1.Items.Add(toolStripButton5);
            toolStrip1.Items.Add(toolStripButton4);
            toolStrip1.Items.Add(toolStripButton3);
            toolStrip1.Items.Add(toolStripButton2);
            toolStrip1.Items.Add(toolStripButton1);

            // 
            // toolStripButton10
            // 
            ToolStripButton toolStripButton10 = new System.Windows.Forms.ToolStripButton();
            toolStripButton10.Alignment = ToolStripItemAlignment.Right;
            toolStripButton10.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton10.ImageIndex = (int)ImageListSub.Short;
            toolStripButton10.Name = "toolStripButton10";
            toolStripButton10.Text = "空売り残高を表示";
            toolStripButton10.Click += new System.EventHandler(this.toolStripButton10_Click);

            // 
            // toolStripButton11
            // 
            ToolStripButton toolStripButton11 = new System.Windows.Forms.ToolStripButton();
            toolStripButton1.Alignment = ToolStripItemAlignment.Right;
            toolStripButton11.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton11.ImageIndex = (int)ImageListSub.Think;
            toolStripButton11.Name = "toolStripButton11";
            toolStripButton11.Text = "考える株式投資";
            toolStripButton11.Click += new System.EventHandler(this.toolStripButton11_Click);

            // 
            // toolStripButton12
            // 
            ToolStripButton toolStripButton12 = new System.Windows.Forms.ToolStripButton();
            toolStripButton1.Alignment = ToolStripItemAlignment.Right;
            toolStripButton12.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton12.ImageIndex = (int)ImageListSub.Timely;
            toolStripButton12.Name = "toolStripButton12";
            toolStripButton12.Text = "東証適時開示システム";
            toolStripButton12.Click += new System.EventHandler(this.toolStripButton12_Click);

            // 
            // toolStripButton13
            // 
            ToolStripButton toolStripButton13 = new System.Windows.Forms.ToolStripButton();
            toolStripButton13.Alignment = ToolStripItemAlignment.Right;
            toolStripButton13.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton13.ImageIndex = (int)ImageListSub.News;
            toolStripButton13.Name = "toolStripButton13";
            toolStripButton13.Text = "Yahooニュース検索";
            toolStripButton13.Click += new System.EventHandler(this.toolStripButton13_Click);

            // 
            // toolStripButton14
            // 
            ToolStripButton toolStripButton14 = new System.Windows.Forms.ToolStripButton();
            toolStripButton14.Alignment = ToolStripItemAlignment.Right;
            toolStripButton14.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton14.ImageIndex = (int)ImageListSub.Edinet;
            toolStripButton14.Name = "toolStripButton14";
            toolStripButton14.Text = "EDINET";
            toolStripButton14.Click += new System.EventHandler(this.toolStripButton14_Click);

            
            this.toolStrip2.ImageList = imageList2;
            this.toolStrip2.Items.Add(toolStripButton14);
            //this.toolStrip2.Items.Add(toolStripButton13);
            this.toolStrip2.Items.Add(toolStripButton12);
            this.toolStrip2.Items.Add(toolStripButton10);
            this.toolStrip2.Items.Add(toolStripButton11);
        }


        /// <summary>
        /// ListViewを初期化する
        /// </summary>
        private void ListViewInit()
        {
            // **************   ここからListviewの設定
            //一覧表示
            this.listView1.View = View.Details;
            this.listView1.GridLines = true;

            // ヘッダ追加
            this.listView1.Columns.Add("No.", 70, HorizontalAlignment.Left);
            this.listView1.Columns.Add("メッセージ", 300, HorizontalAlignment.Left);
            this.listView1.Columns.Add("投稿者", 150, HorizontalAlignment.Left);
            this.listView1.Columns.Add("投稿時の気持ち", 150, HorizontalAlignment.Left);
            this.listView1.Columns.Add("投稿時間", 150, HorizontalAlignment.Left);
            this.listView1.Columns.Add("", 300, HorizontalAlignment.Left);  // 右端ダミー
            this.listView1.FullRowSelect = true;
            //this.listView1.HotTracking = true;
            // **************   ここまでListviewの設定

            // 無視リスト読込み
            LoadNGName();

            // 初期カラーで塗りつぶす
            //            InitBackgrounColor();
        }

        /// <summary>
        /// DataGripViewを初期化する
        /// </summary>
        private void GridViewInit()
        {
            this.dataGridView1.MultiSelect = false;
            DataGridViewCellStyle style = dataGridView1.ColumnHeadersDefaultCellStyle;
            style.BackColor = Color.White;
            style.ForeColor = Color.Black;
        }

        /// <summary>
        /// iniファイルを読み込む
        /// </summary>
        private bool LoadIniFile()
        {
            // 整数値を読み出す
            maxRow = IniFileHandler.GetPrivateProfileInt("TitleList", "PrefetchRow", 0, csIniFile);
            context = new CurrentContext(maxRow);

            // タイトル一覧の表示方法(Listview/DataGridView)
            StringBuilder sb = new StringBuilder(1024);
            IniFileHandler.GetPrivateProfileString( "TitleList", "DisplayType", "ListView", sb, (uint)sb.Capacity,  csIniFile);
            displayType = sb.ToString();
            
            // NGName.txt, code.lstファイルチェック
            if (!File.Exists( csNGFile ) && !File.Exists(csCDFile)) {

                if (MessageBox.Show("カレントフォルダにNGName.txtとcode.lstが存在しません。\n\nカブラウザをお使いだった場合は、この２ファイルをコピーして\n再立ち上げして下さい。お使いでない場合は、\n２ファイルを新規に作成します。\n\n作成しますか？",
                    "確認",
                    MessageBoxButtons.YesNo,
                    MessageBoxIcon.Question,
                    MessageBoxDefaultButton.Button2) == DialogResult.Yes)
                {

                    File.Create(csNGFile).Close();
                    File.Create(csCDFile).Close();
                }
                else
                {
                    return false;
                }
            }
            return true;
        }


        /**
         * カブラウザの設定ファイルであるcode.lstを読み込んでTreeViewを作成する 
         */
        public void LoadCodeList()
        {
            string path = csCDFile;
            List<int> expandes = new List<int>(); 

            if (!File.Exists(path)) return;

            this.textBox2.AppendText("( ･∀･)ﾉ > code.lstよみ込み" + csCrLf);
            using (StreamReader sr = new StreamReader(path, Encoding.GetEncoding("Shift_JIS")))
            {
                string contents;
                string line;
                string folder = "";
                string[] column;
                int tnFolderIndex = 0;

                contents = sr.ReadToEnd();
                sr.Close();

                StringReader sr2 = new StringReader(contents);
                while ((line = sr2.ReadLine()) != null)
                {
                    column = line.Split('\t');
                    if (column.Length > 1 && column[0] != "" && column[1] != "")
                    {
                        //フォルダ
                        if (column[0] == "1" || column[0] == "0")
                        {
                            tnFolderIndex = AddCompanyCodeList(column[1], "", "", false);
                            if ( column[0] == "1") {
                                expandes.Add(tnFolderIndex);
                            }
                            folder = column[1];
                        }
                        else
                        {
                            AddCompanyCodeList(folder, column[0] + tvdelimiter + column[1], column[0], false);
                        }
                    }
                }
                foreach (int exp in expandes)
                {
                    treeView1.Nodes[exp].Expand();
                }
                expandes = null;
            }
        }

        /**
         * 銘柄コードとＥＤＩＮＥＴコードを紐付けるedinet.lstを読み込む 
         */
        public void LoadEDIList()
        {
            string path = csEDIFile;
            List<int> expandes = new List<int>();

            if (!File.Exists(path)) return;

            this.textBox2.AppendText("( ･∀･)ﾉ > edinet.lstよみ込み" + csCrLf);
            using (StreamReader sr = new StreamReader(path))
            {
                string contents;
                string line;
                string[] column;

                contents = sr.ReadToEnd();
                sr.Close();

                StringReader sr2 = new StringReader(contents);
                while ((line = sr2.ReadLine()) != null)
                {
                    column = line.Split('\t');
                    if (column.Length > 1 && column[0] != "" && column[1] != "")
                    {
                        edinetlist[column[0]] = column[1];
                    }
                }
            }
        }
        
        /**
         * カブラウザの設定ファイルであるcode.lstを保存する 
         */
        public void SaveCodeList()
        {
            string path = csCDFile;
            this.textBox2.AppendText("( ･∀･)ﾉ > code.lst書き込み" + csCrLf);

            using (StreamWriter sw = new StreamWriter(path, false, System.Text.Encoding.GetEncoding("Shift_JIS")))
            {
                string code = "";
                string name = "";
                foreach (TreeNode tn in treeView1.Nodes)
                {
                    // フォルダの場合は配下の銘柄コードを全て保存
                    if (tn.ImageIndex == (int)ImageList.OpenFolder || tn.ImageIndex == (int)ImageList.CloseFolder)
                    {
                        code = (tn.IsExpanded) ? "1": "0"; 
                        name = tn.Text;
                        sw.WriteLine(code + "\t" + name);

                        // コード＋銘柄名称
                        foreach (TreeNode child in tn.Nodes)
                        {
                            code = child.Name;
                            name = child.Text.Replace(child.Name, "");
                            name = name.Trim();
                            sw.WriteLine(code + "\t" + name);
                        }
                    }
                    else
                    {
                        // 銘柄コードがRootにダイレクトに配置されている
                        string result ;
                        if (IsRegularCode(tn.Name, out result))
                        {
                            code = tn.Name;
                            name = tn.Text.Replace(tn.Name, "");
                            name = name.Trim();
                            sw.WriteLine(code + "\t" + name);
                        }
                    }
                }
                sw.Close();
            }
        }

        /// <summary>
        /// senderを無視リストに入れる
        /// </summary>
        /// <param name="sender"></param>
        private void InsertNGName(string sender)
        {
            if (!File.Exists(csNGFile))
            {
                MessageBox.Show("NGName.txtが存在しません。再度アプリケーションを立ち上げなおして、\nNGName.txtを作成してください。");
                return;
            }

            using (StreamWriter sw = new StreamWriter( csNGFile, true, Encoding.GetEncoding("Shift_JIS")))
            {  
                sw.WriteLine(sender);
                sw.Close();
            }
        }

        /// <summary>
        /// 無視リストを読み直す
        /// </summary>
        private void LoadNGName()
        {
            string ignore = "";

            if (!File.Exists(csNGFile))
            {
                // MessageBox.Show("NGName.txtが存在しません。再度アプリケーションを立ち上げなおして、\nNGName.txtを作成してください。");
                return;
            }
            
            using (StreamReader sr = new StreamReader(csNGFile, Encoding.GetEncoding("Shift_JIS")))
            {
                string igname = "";
                while ((igname = sr.ReadLine()) != null )
                {
                    ignorelist[igname] = igname;
                    emphasislist[igname] = igname;
                }
            }
        }

        /// <summary>
        /// senderを無視リストから外す
        /// </summary>
        /// <param name="sender"></param>
        private void RemoveNGName(string sender)
        {
            StringReader ignores;

            if (!File.Exists(csNGFile))  {
                MessageBox.Show("NGName.txtが存在しません。再度アプリケーションを立ち上げなおして、\nNGName.txtを作成してください。");
                return;
            }

            using (StreamReader sr = new StreamReader(csNGFile, Encoding.GetEncoding("Shift_JIS")))
            {
                ignores = new StringReader(sr.ReadToEnd());
                sr.Close();
            }
            using (StreamWriter sw = new StreamWriter(csNGFile, false, Encoding.GetEncoding("Shift_JIS")))
            {

                string line;
                while ((line = ignores.ReadLine()) != null)
                {
                    if (line != sender)
                    {
                        sw.WriteLine(line);
                    }
                }
                sw.Close();
            }
            emphasislist.Remove(sender);
        }

        /// <summary>
        /// DataGridViewを再描画する
        /// </summary>
        private void RedisplayGridView()
        {
            string[] row = null;
            dataGridView1.Rows.Clear();
            //次の40件
            if (context.nextPage != "")
            {
                row = new string[] { "次の40件", "", "", "", "" ,"" };
                dataGridView1.Rows.Add(row);
            }

            for (int i = 0; i < maxRow; i++)
            {


                if (context.t[i] != null && context.t[i].title != "" && ignorelist[context.t[i].sender] == null)
                {

                    DataGridViewLinkColumn ln = new DataGridViewLinkColumn();
                    ln.UseColumnTextForLinkValue = false;
                    ln.Text = context.t[i].title;
                    ln.HeaderText = "http://messages.yahoo.co.jp/bbs?.mm=FN&action=m&board=1" + context.GetPad() + context.GetCode() + "&tid=" + context.tid + "&sid=1" + context.GetPad() + context.GetCode() + "&mid=" + context.t[i].titleNo;
                    
                    row = new string[] { 
                        context.t[i].titleNo,
                        context.t[i].title,
                        context.t[i].sender,
                        context.t[i].emotion,
                        context.t[i].sendTime,
                    "" };
                    dataGridView1.Rows.Add(row);
//                    dataGridView1.Columns.add = ln;
                }
            }

            //前の40件
            if (context.prevPage != "")
            {
                row = new string[] { "前の40件", "", "", "", "", "" };
                dataGridView1.Rows.Add(row);
            }
            this.dataGridView1.AlternatingRowsDefaultCellStyle.BackColor = Color.AliceBlue;

        }

        /// <summary>
        /// TitleListペインを再描画する
        /// </summary>
        private void RedisplayListView()
        {
            listView1.Items.Clear();

            //次の40件
            if (context.nextPage != "")
            {
                ListViewItem item = new ListViewItem();
                item.Text = "次の40件";
                item.SubItems.Add("");
                item.SubItems.Add("");
                item.SubItems.Add("");
                item.SubItems.Add("");
                item.SubItems.Add("");
                
                listView1.Items.Add(item);
            }

            for (int i = 0; i < maxRow; i++)
            {
                if (context.t[i] != null && context.t[i].title != "" && ignorelist[ context.t[i].sender] == null )
                {
                    ListViewItem item = new ListViewItem();
                    item.Text = context.t[i].titleNo;
                    item.SubItems.Add(context.t[i].title);
                    item.SubItems.Add(context.t[i].sender);
                    item.SubItems.Add(context.t[i].emotion);
                    item.SubItems.Add(context.t[i].sendTime);
                    item.SubItems.Add("");
                    
                    if (context.t[i].status == "0" )  // 未読
                    {
                        item.Font = new Font(item.Font, FontStyle.Bold); 
                    }
                    if (emphasislist[context.t[i].sender] != null)
                    {
                        item.ForeColor = Color.SlateGray;
                    }
                    
                    listView1.Items.Add(item);
                }
            }
            //前の40件
            if (context.prevPage != "")
            {
                ListViewItem item = new ListViewItem();
                item.Text = "前の40件";
                item.SubItems.Add("");
                item.SubItems.Add("");
                item.SubItems.Add("");
                item.SubItems.Add("");
                item.SubItems.Add("");
                listView1.Items.Add(item);
            }
            PaintBackgrounColorListView();
            this.Text = "カブラウザもどき - " + context.title;
        }

        /// <summary>
        /// ListView1のバックグラウンドを偶数行=空色
        /// 奇数行=白に塗る
        /// </summary>
        private void PaintBackgrounColorListView() {
            for ( int i = 0; i < listView1.Items.Count; i++  ) 
            {
                if (i % 2 == 0)
                {
                    listView1.Items[i].BackColor = Color.AliceBlue;
                }
                else
                {
                    listView1.Items[i].BackColor = Color.White;
                }
            }
            return;
        }

        /// <summary>
        /// DataGridViewのバックグラウンドを偶数行=空色
        /// 奇数行=白に塗る
        /// </summary>
        private void PaintBackgrounColorGridView()
        {
            for (int i = 0; i < dataGridView1.RowCount; i++)
            {
                if (i % 2 == 0)
                {
                    //dataGridView1.Rows[i].sty .BackColor = Color.AliceBlue;
                }
                else
                {
                    //listView1.Items[i].BackColor = Color.White;
                }
            }
            return;
        }

        /// <summary>
        /// ListView1のバックグラウンドを白色に塗る
        /// </summary>
        private void InitBackgrounColor()
        {
            for (int i = 0; i < listView1.Items.Count; i++)
            {
                listView1.Items[i].BackColor = Color.White;
            }
            return;
        }

        /// <summary>
        ///  TreeView等に表示された、長いコード(long_code) 
        ///  例）　"1605 国際石油開発帝石", "998407 日経平均株価", "AUDJPY オーストラリアドル"
        ///  (4桁に限定されない)の銘柄コード部分を返す
        /// </summary>
        /// <param name="long_code"></param>
        /// <returns></returns>
        private string GetRegularCode(string long_code)
        {
            // 正規化された銘柄コード
            string short_code = "";
            char[] delim = { ' ', '\t', tvdelimiter };
            if (long_code.Split(delim).Length > 0)
            {
                short_code = long_code.Split(delim)[0];
            }
            else
            {
                if (short_code.Length >= 6 )
                {
                    short_code = short_code.Substring(0, 6);
                }
                else if (short_code.Length >= 4)
                {
                    short_code = short_code.Substring(0, 4);
                }
                else
                {
                    short_code = long_code;
                }
            }
            return short_code;
        }


        /// <summary>
        /// CompanyCodeListペインにフォルダ、または銘柄コードを加える
        /// folder, short_code, long_code には空でも必ず""(空文字)を渡すこと.
        /// </summary>
        /// <param name="folder"></param>
        /// <param name="long_code">銘柄コード＋銘柄名称( 5214　日本電気硝子 )</param>
        /// <param name="short_code">銘柄コードのみ(例 5214)</param>
        /// <param name="bChkNecessary"></param>
        /// <returns>登録したTreeNodeのIndex。失敗した場合は-1</returns>
        private int AddCompanyCodeList(string folder, string long_code, string short_code, bool bChkNecessary)
        {
            int ret = -1;

            //想定外
            if (folder == null || short_code == null || long_code == null 
                || (folder == "" && short_code == "" && long_code == "")) { return ret; }
            if (short_code == "" )
            {
                short_code = GetRegularCode(long_code);
            }
            
            // 銘柄コードがヤフー掲示板に存在するかチェックする
            if ( bChkNecessary )
            {
                string chkUrl = "http://m.finance.yahoo.co.jp/stock/bbs?code=" + short_code;
                ndb.NavigateAndWait(chkUrl);
                HtmlDocument doc = ndb.Document;

                if (doc.Title.ToString() == "エラー - Y!ファイナンス")
                {
                    this.textBox2.AppendText("( ・益・)ﾉ > そんなもんねぇよ。　 " + short_code + csCrLf);
                    return ret;
                }
                else
                {
                    context.comapnyName = doc.Title.ToString().Split('【')[0];
                    if (long_code == "" || long_code == null)
                    {
                        long_code = short_code + tvdelimiter + context.comapnyName;
                    }
                }
            }
            // folderを追加する
            if (folder != "" && short_code == "")
            {
                TreeNode tnFolder = new TreeNode(folder, (int)ImageList.CloseFolder, (int)ImageList.OpenFolder);
                tnFolder.Name = folder;
                ret = treeView1.Nodes.Add(tnFolder);
            }
            // root直下にコードを追加する
            else if (folder == "" && short_code != "")
            {
                try
                {
                    TreeNodeCollection tnc = treeView1.Nodes;
                    if (tnc == null) return -1;
                    bool isNew = true;
                    foreach (TreeNode n in tnc)
                    {
                        // 自ノード調査
                        if (n.Name != null && n.Name == short_code)
                        {
                            //すでに登録済み
                            treeView1.SelectedNode = n;
                            treeView1.Focus();
                            isNew = false;
                            break;
                        }
                        // 子ノード調査
                        foreach (TreeNode child in n.Nodes)
                        {
                            if (child.Name != null && child.Name == short_code)
                            {
                                // すでに追加済み
                                treeView1.SelectedNode = child;
                                treeView1.Focus();
                                isNew = false;
                                break;
                            }
                        }
                        if (!isNew) break;
                    }
                    if (isNew)
                    {
                        // 親ノードを選択させて、ぶら下げる
                        TreeNode tn = new TreeNode(long_code.Trim(), (int)ImageList.File, (int)ImageList.File);
                        tn.Name = short_code;
                        ret = treeView1.Nodes.Add(tn);

                        // ダイアログ
                        /* 銘柄コードを入れる度に一々聞いてくるのはウザったいのでやめる。
                         * 親のいない銘柄コードを警告するのはアプリ終了時で十分。
                        ParentNodeList nodelist =  new ParentNodeList();
                        Hashtable param = new Hashtable();
                        for (int i = 0; i < this.treeView1.Nodes.Count; i++)
                        {
                            if (this.treeView1.Nodes[i].Parent == null && this.treeView1.Nodes[i].ImageIndex != (int)ImageList.File)
                            {
                                param[this.treeView1.Nodes[i].Index] = this.treeView1.Nodes[i].Text;
                            }
                        }
                        nodelist.Show(this.Owner, param);
                        TreeNode target = this.treeView1.Nodes[nodelist.resTnIndex];
                        TreeNode tnclone = (TreeNode)tn.Clone();
                        target.Nodes.Add(tnclone);
                        tn.Remove();
                        this.treeView1.SelectedNode = tnclone;
                        nodelist.Dispose();
                        */
                    }
                    else { ret = 0; }
                    
                }
                catch (NullReferenceException e)
                {
                    this.textBox2.AppendText(folder + "," + long_code + "," + bChkNecessary);
                    this.textBox2.AppendText(e.ToString() + csCrLf);
                }

            }
            // フォルダを指定してコード登録
            else if (folder != "" && short_code != "")
            {
                TreeNodeCollection tnc = treeView1.Nodes;
                TreeNode parent = null;
                foreach (TreeNode n in tnc)
                {
                    if (n.Text == folder)
                    {
                        parent = n;
                        break;
                    }
                }
                TreeNode tnCode = new TreeNode(long_code.Trim(), (int)ImageList.File, (int)ImageList.File);
                tnCode.Name = short_code;
                // 親ノードに追加
                if (parent != null)
                {
                    parent.Nodes.Add(tnCode);
                }
                // 親ノードと一緒に作成
                else
                {
                    TreeNode[] tnCodes = { tnCode } ;
                    TreeNode tnFolder = new TreeNode(folder, tnCodes);
                    ret = treeView1.Nodes.Add(tnFolder);
                }
            }
            return ret;
        }

        /// <summary>
        /// 銘柄コードを選択されたタイミングでその銘柄に対するキャッシュデータを
        ///  読み込んでハッシュマップに格納する
        ///  戻り値：-1 ファイル無し
        /// </summary>
        /// <param name="code"></param>
        /// <returns></returns>
        private int ReadCache(string code)
        {
            string path = csDatDir + code + ".dat";
            if (!File.Exists(path)) return -1;

            // キャッシュデータフォーマット
            // [titleNo],[Title],[Sender],[upDate],[Emotion],[Status]
            this.textBox2.AppendText("( ･∀･)ﾉ > キャッシュよみ込み" + csCrLf);
            string[] aLine;
            using (StreamReader sr = new StreamReader(path))
            {
                string line;
                while ((line = sr.ReadLine()) != null)
                {
                    aLine = line.Split(this.delimiter);
                }
            }
            return 0;
        }

        /// <summary>
        /// 該当銘柄コードのTitle一覧の取得を行う
        /// 投稿タイトル一覧を取得して配列に格納する
        /// </summary>
        /// <param name="pageNo">ぺジー番号 0:最新 -1:前の40件 1:次の40件</param>
        public int GetTitleListsFromHtml(string longCode, int pageNo)
        {
            if (longCode == "") { return -1; }
            string url = "";
            int ret = 0;

            switch (pageNo)
            {
                case 1:
                    url = context.nextPage;
                    context.ClearTitleList();
                    break;
                case -1:
                    context.ClearTitleList();
                    url = context.prevPage;
                    break;
                case 0:
                default:
                    if (!context.Lock()) { MessageBox.Show("銘柄コードは現在ロックされています\nしばらくお待ちください"); return -1; }
                    try
                    {
                        context.Clear();
                        context.SetCode(GetRegularCode(longCode));
                        url = "http://messages.yahoo.co.jp/bbs?action=topics&board=1" + context.GetPad() + context.GetCode() + "&sid=1" + context.GetPad() + context.GetCode();
                        ret = GetTopicId(context.GetCode(), true);
                    }
                    finally
                    {
                        context.UnLock();
                    }
                    break;
            }


            if (ret == 0)
            {
                if (!context.Lock()) { MessageBox.Show("銘柄コードは現在ロックされています\nしばらくお待ちください"); return -1; }
                try
                {
                    // URLパターン
                    // Page1: http://messages.yahoo.co.jp/bbs?.mm=FN&action=l&board=1006758&sid=1006758&tid=a5bda5ka1bc&start=281236
                    // Page2: http://messages.yahoo.co.jp/bbs?.mm=FN&action=l&board=1006758&sid=1006758&tid=a5bda5ka1bc&start=281196
                    //  ※tidあり、tidを入れたら、startは必須？
                    //または、
                    // Page(最新): http://messages.yahoo.co.jp/bbs?.mm=FN&action=topic&board=1006758&sid=1006758
                    if (!ndb.NavigateAndWait(url))
                    {
                        this.textBox2.AppendText("（｡・-・）失敗ｼﾀﾖｳﾀﾞ...もう一回やって！" + csCrLf);
                    }
                    // これは止める  ndb.NavigateAndWait("http://m.finance.yahoo.co.jp/stock/bbs?code=" + code.Substring(0, 4));
                    this.textBox2.AppendText("( ･∀･)ﾉ > げっと！　 " + context.GetCode() + csCrLf);
                    HtmlDocument doc = ndb.Document;
                    context.title = doc.Title;

                    // テーブル内の文字列を構造体に格納する
                    // タイトル一覧はHTMLの四重にネストされたテーブル配下にある.
                    int tblCnt = 0;
                    int rowCnt = 0;
                    foreach (HtmlElement e in doc.GetElementsByTagName("TABLE"))
                    {
                        if (e.InnerText != null && e.InnerText.IndexOf("投稿時間") != -1)
                        {
                            tblCnt++;
                            if (tblCnt == 4)
                            {
                                HtmlElementCollection rows = e.GetElementsByTagName("TR");
                                foreach (HtmlElement row in rows)
                                {
                                    HtmlElementCollection cols = row.GetElementsByTagName("TD");
                                    int chkelm = 0;
                                    bool bChk = int.TryParse(cols[0].InnerText, out chkelm);
                                    if (cols.Count == 9 && bChk && chkelm > 1 && chkelm <= context.GetMaxTitleNo())
                                    {
                                        context.t[rowCnt].titleNo = chkelm.ToString();
                                        context.t[rowCnt].title = cols[1].InnerText;
                                        context.t[rowCnt].sender = cols[4].InnerText;
                                        context.t[rowCnt].emotion = cols[5].InnerText;
                                        context.t[rowCnt].sendTime = cols[8].InnerText;
                                        rowCnt++;
                                    }
                                }
                            }
                        }
                    }

                    foreach (HtmlElement e in doc.GetElementsByTagName("A"))
                    {
                        string href = e.GetAttribute("href"); // HREF属性の値
                        string text = e.InnerText; // リンク文字列

                        if (e.InnerText == "前の40件") context.prevPage = e.GetAttribute("href");
                        if (e.InnerText == "次の40件") context.nextPage = e.GetAttribute("href");

                        /* url からmidを切り出して表示する方法 - 遅いのでやめる
                        uint i = 0;
                        string[] aUrl;
                        if (!string.IsNullOrEmpty(href) && e.InnerText != "前の40件" && e.InnerText != "次の40件" && e.InnerText != "最初から読む")
                        {
                            if (href.Length > 40)
                            {
    //                            Console.WriteLine(text + ":" + href);
                                if (href.Substring(0, 39) == "http://messages.yahoo.co.jp/bbs?.mm=FN&" && !string.IsNullOrEmpty(text))
                                {
                                    aUrl = href.Split('=');
    //                                context.t[i] = new TitleLists(aUrl[aUrl.Length - 1], href, text.Replace("\r\n", ""), "", "", "");
                                    context.t[i] = new TitleLists(aUrl[aUrl.Length - 1], "", text.Replace("\r\n", ""), "", "", "");
                                    i++;
                                    if (i == maxRow) { break; }
                                }
                                if (href.Substring(0, 32) == "http://post.messages.yahoo.co.jp")
                                {
                                    context.postUrl = href.ToString();
                                }
                            }
                        }
                        */
                    }

                }
                finally
                {
                    context.UnLock();
                }
            } else // GetTopicId() の戻り値 not 0 
            {
                this.textBox2.AppendText("( ・益・)　ﾉ > ﾖｲﾖｲわかんねぇよ。" + csCrLf);
            }
            return 0;
        }

        /// <summary>
        /// 投稿タイトル一覧をRSSから取得して配列に格納する
        /// 取得は高速だが、最新しか取得できない。前の頁以前は取得不可。
        /// GetTitleListsFromHtmlを使用する事。
        /// </summary>
        /// <param name="longCode"></param>
        /// <param name="t"></param>
        /// <returns></returns>
        public int GetTitleListsFromRSS(string longCode, ref TitleLists[] t)
        {
            if (longCode == "") { return -1; }
            //string code = longCode.Substring(0, 4);
            string code = GetRegularCode(longCode);
            context.SetCode(code);
            GetTopicId(code, true);

            // RSSフィードURLを取得する
            string chkUrl = "http://messages.yahoo.co.jp/bbs?action=topics&board=1" + context.GetPad() + code + "&sid=1" + context.GetPad() + code + "";
            string rssUrl = "http://messages.yahoo.co.jp/bbs?action=4&board=1" + context.GetPad() + code + "&sid=1" + context.GetPad() + code + "&tid=" + code;
            ndb.NavigateAndWait(chkUrl);
            HtmlDocument doc = ndb.Document;
            context.title = doc.Title;

            bool breakFlag = false;
            //
            // TopicIdを取得する
            foreach (HtmlElement e in doc.GetElementsByTagName("LINK"))
            {
                string text = e.OuterHtml.Replace("&amp;", "&"); // リンク文字列
                string[] aTmp;
                if (text.IndexOf("rel=alternate") != -1)
                {
                    aTmp = text.Split('&');
                    foreach (string s in aTmp)
                    {
                        if (s.Length > 3 && s.Substring(0, 3) == "tid")
                        {
                            string regularTid = s.Split('=')[1];
                            regularTid = regularTid.Split('"')[0];
                            context.tid = regularTid;
                            rssUrl = "http://messages.yahoo.co.jp/bbs?action=4&board=1" + context.GetPad() + code + "&sid=1" + context.GetPad() + code + "&tid=" + context.tid;
                            breakFlag = true;
                        }
                        if (breakFlag) break;
                    }

                }
                if (breakFlag) break;
            }
            // ndb = null;
            this.textBox2.AppendText("( ･∀･)ﾉ > げっと！　 " + code + csCrLf);

            // タイトル一覧取得
            XmlDocument xmlDoc = new XmlDocument();
            try
            {
                xmlDoc.Load(rssUrl);
            }
            catch (XmlException e)
            {
                this.textBox2.AppendText("　( ・益・)　ﾉ > そんなもん、ねぇよ　 " + csCrLf);
                return -1;
            }
            context.ClearTitleList();
            XmlNodeList nodes = xmlDoc.GetElementsByTagName("item");

            string[] aUrl;
            for (int i = 0; i < nodes.Count; i++)
            {
                XmlNodeList titleNodes = nodes[i].SelectNodes("title");
                XmlNodeList dateNodes = nodes[i].SelectNodes("pubDate");
                XmlNodeList linkNodes = nodes[i].SelectNodes("link");
                XmlNodeList descNodes = nodes[i].SelectNodes("description");

                context.t[i].title = titleNodes[0].InnerText;
                context.t[i].sendTime = dateNodes[0].InnerText;
                context.t[i].url = linkNodes[0].InnerText;

                aUrl = descNodes[0].InnerText.Split(',');
                for (int j = 0; j < aUrl.Length; j++)
                {
                    if (aUrl[j].Length > 4 && aUrl[j].Substring(0, 4) == "投稿者:") context.t[i].sender = aUrl[j].Replace("投稿者:", "");
                    if (aUrl[j].Length > 5 && aUrl[j].Substring(0, 5) == "投稿番号:") context.t[i].titleNo = aUrl[j].Replace("投稿番号:", "");
                    if (aUrl[j].Length > 5 && aUrl[j].Substring(0, 5) == "投稿日時:") context.t[i].sendTime = aUrl[j].Replace("投稿日時:", "");
                }

                if (aUrl.Length == 5)
                {
                    context.t[i].emotion = aUrl[4];
                }

                //                context.ht[context.t[i].titleNo] = context.t[i];
            }
            context.SetCode(code);
            context.maxTilteNo = context.t[0].titleNo;
            // context.Save();
            return 0;
        }

        /// <summary>
        /// 投稿タイトル一覧をローカルファイルから取得して配列に格納する
        /// 未キャッシュ部分はGetTitleListsFromHtmlを使用する。
        /// </summary>
        /// <param name="longCode"></param>
        /// <param name="mid">中心となるMessageIdを指定する（前後20件を表示）</param>
        /// <returns></returns>
        public int GetTitleListsFromLocal(string longCode, string mid )
        {
            if (longCode == "") { return -1; }
            //string code = longCode.Substring(0, 4);
            string code = GetRegularCode(longCode);
            string[] lines = null;
            string line = "";
            int iMid = int.Parse(mid);

            if (context.tid == null || context.tid == "")
            {
                GetTopicId(code, true);
            }

            listView1.Items.Clear();
            if (!File.Exists(csDatDir  + context.GetCode() + ".dat")) return -1;

            ListViewItem item = new ListViewItem();
            item.Text = "次のページ";  // ローカルから取得する場合は"前のページ"と表示する 
            item.SubItems.Add("");  // title
            item.SubItems.Add("");  // sender
            item.SubItems.Add("");  // pubdate
            item.SubItems.Add("");  // emotion
            listView1.Items.Add(item);

            using (context.topicSr = new StreamReader(csDatDir + context.GetCode() + ".dat"))
            {

                while ((line = context.topicSr.ReadLine()) != null)
                {
                    lines = line.Split(this.delimiter);
                    if (iMid > 20 && int.Parse(lines[0]) > (iMid - 20) && int.Parse(lines[0]) < (iMid + 20))
                    {
                        item = new ListViewItem();
                        item.Text = lines[0];  // title id 
                        item.SubItems.Add(lines[1]);  // title
                        item.SubItems.Add(lines[2]);  // sender
                        item.SubItems.Add(lines[3]);  // pubdate
                        item.SubItems.Add(lines[4]);  // emotion
                        listView1.Items.Add(item);
                        
                        if (lines[5] == "0" || lines[5] == "")  // status 未読
                        {
                            item.Font = new Font(item.Font, FontStyle.Bold);
                        }
                        
                        if (int.Parse(lines[0]) < (iMid - 20)) break;
                    }
                }
                lines = null;
            }

            item = new ListViewItem();
            item.Text = "前のページ";  // ローカルから取得する場合は"前のページ"と表示する 
            item.SubItems.Add("");  // title
            item.SubItems.Add("");  // sender
            item.SubItems.Add("");  // pubdate
            item.SubItems.Add("");  // emotion
            listView1.Items.Add(item);

            PaintBackgrounColorListView();
            return 0;
        }

        ///<summary>
        /// HTMLから投稿タイトル一覧を全部取得してファイルに保存する
        /// 最新titleIDからmaxRow分はTitleListsクラスに格納する
        ///</summary>
        public int SaveAllTitleList(string longCode, ref TitleLists[] t)
        {
            int maxTitleNo = 0;  // 取得済みのtitle
            string code = GetRegularCode(longCode);
            bool bReadExitFlag = false; // キャッシュされた最新まで達したので読込み終了する

            if (longCode == "") { return -1; }
            if ((MessageBox.Show("この処理を行うとタイトルによる「全文検索」が可能となりますが、\n処理は５分から１０分程度の時間がかかります。続行しますか？","ダウンロード確認",
                    MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.No)) { return -1; }

            if (File.Exists(csDatDir + code + ".dat"))
            {
                string line="";
                using (StreamReader sr = new StreamReader(csDatDir + code + ".dat"))
                {
                    line = sr.ReadLine();
                    if (line != null && line.Split(delimiter).Length > 1)
                    {
                        maxTitleNo = int.Parse(line.Split(delimiter)[0]);
                        MessageBox.Show(maxTitleNo + "以降を取得して保存します。");
                    }
                }
            }

            if (!context.Lock()) { MessageBox.Show("銘柄コードは現在ロックされています\nしばらくお待ちください"); return -1; }
            try
            {
                //string code = longCode.Substring(0, 4);
                
                int chk = GetTopicId(code, false);

                if (chk == 0)
                {

                    TitleLists data = new TitleLists();

                    // 最新の一覧
                    ndb.NavigateAndWait("http://messages.yahoo.co.jp/bbs?action=topics&board=1" + context.GetPad() + code + "&sid=1" + context.GetPad() + code + "&tid=" + context.tid);
                    string path = csDatDir + code + ".dat";

                    //if (File.Exists(path))
                    //{
                    //    SortUniqTitleList(path);
                    //}

                    StreamWriter sw = new StreamWriter(path, true);
                    sw.WriteLine("0" + this.delimiter + context.tid);

                    for (int i = 0; i <= (context.GetMaxTitleNo() / 40); i++)
                    {
                        //                    Console.WriteLine(ndb.Url.ToString());
                        this.toolStripStatusLabel1.Text = ndb.Url.ToString();
                        HtmlDocument doc = ndb.Document;

                        foreach (HtmlElement e in doc.GetElementsByTagName("A"))
                        {
                            if (e.InnerText == "前の40件") context.prevPage = e.GetAttribute("href");
                            if (e.InnerText == "次の40件") context.nextPage = e.GetAttribute("href");
                        }

                        // 前の40件リンクを辿ってyahoo掲示板をクロール
                        // タイトル一覧はHTMLの四重にネストされたテーブル配下にある.
                        int tblCnt = 0;
                        foreach (HtmlElement e in doc.GetElementsByTagName("TABLE"))
                        {
                            if (e.InnerText != null && e.InnerText.IndexOf("投稿時間") != -1)
                            {
                                tblCnt++;
                                if (tblCnt == 4)
                                {
                                    HtmlElementCollection rows = e.GetElementsByTagName("TR");
                                    foreach (HtmlElement row in rows)
                                    {
                                        HtmlElementCollection cols = row.GetElementsByTagName("TD");
                                        int chkelm = 0;
                                        bool bChk = int.TryParse(cols[0].InnerText, out chkelm);
                                        if (cols.Count == 9 && bChk && chkelm > 1 && chkelm <= context.GetMaxTitleNo())
                                        {
                                            data.titleNo = chkelm.ToString();
                                            data.title = cols[1].InnerText;
                                            data.sender = cols[4].InnerText;
                                            data.emotion = cols[5].InnerText;
                                            data.sendTime = cols[8].InnerText;
                                            data.WriteLine(sw);
                                            if (chkelm <= maxTitleNo)
                                            {
                                                bReadExitFlag = true;
                                                break;
                                            }
                                        }
                                    }
                                }
                            }
                            if (bReadExitFlag) break;
                        }
                        if (bReadExitFlag) break;
                        ndb.NavigateAndWait(context.prevPage);
                    } // 読込みループ終了
                    sw.Close();
                    sw = null;
                    SortUniqTitleList(path);
                    this.textBox3.Enabled = true;
                    this.textBox4.Enabled = true;
                    this.toolStripStatusLabel1.Text = "";
                }

            }
            finally
            {
                context.UnLock();
            }
            MessageBox.Show("ダウンロード完了！");
            return 0;
        }

        /// <summary>
        /// xxxx.datファイルを重複を除いて、降順にソートする
        /// </summary>
        /// <param name="path"></param>
        private void SortUniqTitleList(string path)
        {

            KeyValuePair<int, string> kvp = new KeyValuePair<int, string>();
            IDictionary dic = new Dictionary<int, string>();
            List<KeyValuePair<int, string>> list;
            // 保存したメッセージ一覧をsort & uniqする
            using (StreamReader sr = new StreamReader(path))
            {
                StringReader tmp = new StringReader(sr.ReadToEnd());

                string[] splittedline;
                sr.Close();
                string line;
                while (( line = tmp.ReadLine()) != null) {
                    splittedline = line.Split(delimiter);
                    dic[int.Parse(splittedline[0])] = line;
                }

                list = SortByKey((Dictionary<int,string>)dic);

                StreamWriter sw = new StreamWriter(path);
                sw.Write("");
                foreach (KeyValuePair<int, string> tmpLine in list ) 
                {
                    sw.WriteLine(tmpLine.Value);
                }
                sw.Close();
                return;
            }
        }

        /// <summary>
        /// 連想配列のリストをキーでソートする
        /// </summary>
        /// <param name="dic"></param>
        /// <returns></returns>
        private List<KeyValuePair<int, string>> SortByKey(Dictionary<int, string> dic){
            List<KeyValuePair<int, string>> list = new List<KeyValuePair<int, string>>(dic);
            list.Sort(
              delegate(KeyValuePair<int, string> kvp1, KeyValuePair<int, string> kvp2)
              {
                  return kvp2.Key - kvp1.Key;
              });
            return list;
        }


        /// <summary>
        ///  Yahoo掲示板のTopic ID (tid=部分)、最大TitleNo を取得する.取得値は状態変数に格納する
        /// </summary>
        /// <returns></returns>
        public int GetTopicId(string code, bool isCheckLock)
        {
            int ret = 0;         // 戻り値
            int iMaxTitleNo = 0; // 最大タイトルNo
            string sComp = "";   // タイトルNo比較用
            bool breakFlag = false;
            bool titleFlag = false;

            context.SetCode(code);
            string chkUrl = "http://messages.yahoo.co.jp/bbs?action=topics&board=1" + context.GetPad() + context.GetCode() + "&sid=1" + context.GetPad() + context.GetCode() + "";

            if (!ndb.NavigateAndWait(chkUrl))
            {
                this.textBox2.AppendText("（｡・-・）失敗ｼﾀﾖｳﾀﾞ...もう一回やって！");
            }

            HtmlDocument doc = ndb.Document;

            // object lcok
            if (isCheckLock)
            {
                if (!context.Lock()) { MessageBox.Show("銘柄コードは現在ロックされています\nしばらくお待ちください"); return -1; }
            }
            // object lock

            try
            {
                // Topic id取得
                foreach (HtmlElement e in doc.GetElementsByTagName("LINK"))
                {
                    string text = e.OuterHtml.Replace("&amp;", "&"); // リンク文字列
                    string[] aTmp;
                    if (text.IndexOf("rel=alternate") != -1)
                    {
                        aTmp = text.Split('&');
                        foreach (string s in aTmp)
                        {
                            if (s.Length > 3 && s.Substring(0, 3) == "tid")
                            {
                                string regularTid = s.Split('=')[1];
                                regularTid = regularTid.Split('"')[0];
                                context.tid = regularTid;
                                breakFlag = true;
                            }
                            if (breakFlag) break;
                        }

                    }
                    if (breakFlag) break;
                }

                // 最大TitleNo取得
                foreach (HtmlElement e in doc.GetElementsByTagName("A"))
                {
                    string sLink = e.GetAttribute("href");

                    if (sLink.Length > 33 && sLink.Substring(0, 33) == "http://post.messages.yahoo.co.jp/") context.postUrl = sLink.ToString();

                    if (sLink.Length > 50 && sLink.Substring(0, 47) == "http://messages.yahoo.co.jp/bbs?.mm=FN&action=m")
                    {
                        string[] de = { "mid=", "\">" };
                        string[] tmp = e.OuterHtml.Split(de, StringSplitOptions.None);
                        if (tmp.Length > 1)
                        {
                            sComp = tmp[1];
                            int test = 0;
                            if (int.TryParse(sComp, out test))
                            {
                                if (iMaxTitleNo < test)
                                {
                                    iMaxTitleNo = test;
                                }
                            }
                        }
                    }
                }
                // IMG用の市場コードを含んだ銘柄コード
                foreach (HtmlElement e in doc.GetElementsByTagName("IMG"))
                {
                    string sLink = e.GetAttribute("src");
                    try
                    {
                        if (sLink.Length >= 36 && ( sLink.Substring(0, 30) == "http://gchart.yahoo.co.jp/t?s=" || sLink.Substring(0, 30) == "http://rchart.yahoo.co.jp/t?s=" ))
                        {
                            string tmp = sLink.ToString().Substring(30, sLink.Length-30);
                            context.codeAndExchange = tmp.Split('&')[0];
                        }
                    }
                    catch (NullReferenceException exp)
                    {
                        context.codeAndExchange = "";
                    }
                }

                context.maxTilteNo = iMaxTitleNo.ToString();
                if (context.maxTilteNo == "") titleFlag = false; else titleFlag = true;
            }
            catch (IndexOutOfRangeException e)
            {
                this.textBox2.AppendText(e.ToString() + csCrLf);
                context.maxTilteNo = "";
                ret = -1;
            }
            catch (NullReferenceException e)
            {
                this.textBox2.AppendText(e.ToString() + csCrLf);
                context.maxTilteNo = "";
                ret = -1;
            }
            finally
            {
                if (isCheckLock)
                {
                    context.UnLock();
                }
                ret = (titleFlag && breakFlag) ? 0 : -1;
            }
            /*
            foreach (HtmlElement e in doc.GetElementsByTagName("TABLE"))
            {
                HtmlElementCollection child = e.Children ;
                foreach ( HtmlElement ce in child ) {
                    Console.WriteLine(ce.OuterHtml);
                }

                /*
                string[] de = {"mid="};
                string[] tmp = e.OuterHtml.Split(de, StringSplitOptions.None);
                if ( tmp.Length > 1 ) 
                {
                    string comp = tmp[1].Replace("\">","");
                    if ( maxTitleNo < int.Parse(comp))
                    {
                        context.maxTilteNo = e.InnerHtml.Split(de, StringSplitOptions.None)[1];
                    }
                }
               
            }*/

            //context.maxTilteNo = maxTitleNo.ToString();
            return ret;
        }

        /*
         * RSSから投稿タイトル一覧を全部取得してファイルに保存する
         * 最新titleIDからmaxRow分はTitleListsクラスに格納する
         * 
         */
        /*** RSSフィードから過去分の記事を取得する方法が未定。本関数は暫くコメントアウトする
        public void SaveAllTitleListFromRSS(string longCode, ref TitleLists[] t)
        {
            if (longCode == "") { return ; }
            string code = longCode.Substring(0, 4);

            // RSSフィードURLを取得する
            string chkUrl = "http://messages.yahoo.co.jp/bbs?action=topics&board=100" + code + "&sid=100" + code + "";
            string rssUrl = "http://messages.yahoo.co.jp/bbs?action=4&board=100" + code + "&sid=100" + code + "&tid=" + code;
            ndb.NavigateAndWait(chkUrl);
            HtmlDocument doc = ndb.Document;
            bool breakFlag = false;
            foreach (HtmlElement e in doc.GetElementsByTagName("LINK"))
            {
                string text = e.OuterHtml.Replace("&amp;", "&"); // リンク文字列
                string[] aTmp;
                if (text.IndexOf("rel=alternate") != -1)
                {
                    aTmp = text.Split('&');
                    foreach (string s in aTmp)
                    {
                        if (s.Length > 3 && s.Substring(0, 3) == "tid")
                        {
                            string regularTid = s.Split('=')[1];
                            regularTid = regularTid.Split('"')[0];
                            context.tid = regularTid;
                            rssUrl = "http://messages.yahoo.co.jp/bbs?action=4&board=100" + code + "&sid=100" + code + "&tid=" + context.tid;
                            breakFlag = true;
                        }
                        if (breakFlag) break;
                    }

                }
                if (breakFlag) break;
            }
            ndb = null;
            this.textBox2.AppendText("( ･∀･)ﾉ > ぶっこ抜き！　 " + rssUrl + csCrLf);

            //-----------------------------------------------------------------------------------------
            // URLパターン：
            // Page1: http://messages.yahoo.co.jp/bbs?.mm=FN&action=4&board=1006758&sid=1006758&tid=a5bda5ka1bc&start=281236
            // Page2: http://messages.yahoo.co.jp/bbs?.mm=FN&action=4&board=1006758&sid=1006758&tid=a5bda5ka1bc&start=281196
            // 最新のNo.を記憶して、50ずつ減少しながら構造体に格納する
            //-----------------------------------------------------------------------------------------

            // maxTitleNoを取得
        }
         */

        /// <summary>
        /// 引数のURLのメッセージコンテンツを取得する 
        /// URL例) http://messages.yahoo.co.jp/bbs?.mm=FN&action=m&board=1005214&tid=ffckdcee5a4bekbbr&sid=1005214&mid=10331
        /// </summary>
        /// <param name="mid"></param>
        /// <returns></returns>
        private string GetContentsFromPCSite(string mid)
        {
            try
            {
                // メッセージ内容はhtmlの中から"class=s130"をキーとして取得する
                string pad = "";
                string url = "http://messages.yahoo.co.jp/bbs?.mm=FN&action=m&board=1" + context.GetPad() + context.GetCode() + "&tid=" + context.tid + "&sid=1" + context.GetPad() + context.GetCode() + "&mid=" + mid;
                toolStripStatusLabel1.Text = url;
                if (!ndb.NavigateAndWait(url))
                {
                    this.textBox2.AppendText("（｡・-・）失敗ｼﾀﾖｳﾀﾞ...もう一回やって！");
                }
                HtmlDocument doc = ndb.Document;
                if (doc.Title == "Yahoo!掲示板 - エラー") return doc.Title;
                context.title = doc.Title;

                // コンテンツの取得方法１ 遅い
                /*
                HtmlElementCollection all = doc.All;
                HtmlElement he1 = doc.GetElementById("s130");
                HtmlElementCollection he2 = all.GetElementsByName("s130");
                he1.GetAttribute("className");
                HtmlElementCollection ec = doc.GetElementsByTagName("TD");
                foreach ( HtmlElement e in ec ) 
                {
                    Console.WriteLine(e.GetAttribute("className").ToString());
                    if (e.GetAttribute("className") == "s130")
                    {
                        return e.OuterHtml;
                    }
                }
                **/
                // コンテンツの取得方法２　早いが失敗する可能性あり
                try
                {
                    string retHtml = "";
                    if (doc.GetElementsByTagName("TABLE").Count >= 25)
                    {
                        HtmlElement eRet = doc.GetElementsByTagName("TABLE")[25];

                        //HtmlElement eRet1= doc.GetElementsByTagName("TABLE")[26];
                        //HtmlElement eRet2= doc.GetElementsByTagName("TABLE")[27];
                        //HtmlElement eRet3 = doc.GetElementsByTagName("TABLE")[24];

                        retHtml = eRet.OuterHtml;
                        eRet = null;
                        doc = null;
                    }
                    else retHtml = "contents get error!";
                    //ndb = null;
                    return retHtml;
                }
                catch (NullReferenceException e)
                {
                    Console.WriteLine(e.ToString());
                    return "contents get error!";
                }
                /**
                // コンテンツの取得方法３
                // 遅い
                HtmlElementCollection ec2 = doc.GetElementsByTagName("TABLE");
                int i = 0;
                foreach (HtmlElement e in ec2)
                {
                    if (e.OuterHtml.IndexOf("class=s130") != -1)
                    {
                        i++;
                        if (i == 3)
                        {
                            string retHtml = e.OuterHtml;
                            e = null;
                            ec2 = null;
                            ndb = null;
                            return retHtml;
                        }
                    }
                }
                **/
            }
            catch (NullReferenceException e)
            {
                this.textBox2.AppendText(e.ToString() + csCrLf);
            }

            return "contents get error!";
        }

        /// <summary>
        /// 引数のURLのメッセージコンテンツをYahooモバイルから取得する 
        /// 例) http://m.finance.yahoo.co.jp/stock/bbs?code=6255
        /// </summary>
        /// <param name="mid"></param>
        /// <returns></returns>
        private string GetContentsFromMobileSite(string mid)
        {
            try
            {
                // メッセージ内容はhtmlの中から"class=s130"をキーとして取得する
                string url = "http://m.finance.yahoo.co.jp/stock/bbs?code=" + context.GetCode();
                toolStripStatusLabel1.Text = url;
                ndb.NavigateAndWait(url);

                HtmlElement title = null;
                HtmlElement sender = null;
                HtmlElement replyUrl = null;
                HtmlElement message = null;
                bool bThisMessage = false;


                HtmlDocument doc = ndb.Document;
                HtmlElementCollection all = doc.All;
                HtmlElementCollection articles = doc.GetElementsByTagName("article");
                HtmlElementCollection titles = doc.GetElementsByTagName("h3");
                HtmlElementCollection texts = doc.GetElementsByTagName("p");

                Console.WriteLine("message id: " + mid);

                for (int i = 0; i < all.Count; i++)
                {
                    if (all[i].GetAttribute("classname") == "title" && (all[i].InnerText.IndexOf(mid) != -1))
                    {
                        for (int j = 0; j < 10; j++)
                        {
                            Console.WriteLine(all[i + j].InnerText);
                            if (all[i + j].GetAttribute("classname") == "text")
                            {
                                return all[i + j].InnerText;
                            }
                        }
                    }
                }

                for (int i = 0; i < titles.Count; i++)
                {
                    if (titles[i].InnerText.IndexOf(mid) != -1)
                    {
                        return articles[i].InnerHtml;
                    }
                }

                // 引数のmidのメッセージを探し出して戻す
                foreach (HtmlElement article in articles)
                {
                    //                foreach (HtmlElement e in article)
                    //                {
                    HtmlElement e = article;
                    if (e.GetAttribute("className") == "title")
                    {
                        if (e.InnerText.IndexOf(mid) != -1)
                        {
                            bThisMessage = true;
                        };
                    }
                    if (e.GetAttribute("className") == "text" && bThisMessage == true)
                    {
                        if (e.InnerText.IndexOf(mid) != -1)
                        {
                            return e.InnerHtml;
                        };
                    }
                    //                }
                }
            }
            finally
            {
            }
            return "contents get error!";
        }

        /// <summary>
        /// 空売り残高の検索
        /// 検索結果を取得する
        /// </summary>
        /// <returns></returns>
        /*  javascript が無いのでソート関連がまともに動かないのでやめる
        private void GetShortInterest()
        {
            string html = "";
            string url = "http://www.your-alert-service.com/shortselling/" + context.GetCode() + ".html";
            toolStripStatusLabel1.Text = url;
            ndb.NavigateAndWait(url);
            HtmlDocument doc = ndb.Document;
            if (doc.Title != "HTTP 404 未検出")
            {
                html = doc.GetElementById("search_result").InnerHtml;

                webBrowser1.DocumentText = "<html><head><title>" + context.title + "</title>" + csCrLf
                    + "</head><body>" + csCrLf
                    + "<link rel=\"stylesheet\" type=\"text/css\" href=\"http://www.your-alert-service.com/static/css/shortpos.css\"/>" + csCrLf
                    + html + csCrLf
                    + "</body></html>" + csCrLf;
            }
        }
        */

        /// <summary>
        /// 指定したメッセージIDのタイトルインスタンスを返す
        /// ※未使用
        /// </summary>
        /// <param name="mid"></param>
        /// <returns></returns>
        private TitleLists GetTitleListEntity(string mid)
        {
            TitleLists ret = null;
            for (int i = 0; i < context.t.Length; i++)
            {
                if (context.t[i].titleNo == mid)
                {
                    ret = context.t[i];
                    break;
                }
            }
            return ret;
        }

        /// <summary>
        /// 銘柄コードのロック状態を確認して、タイトル一覧を表示する
        /// 銘柄コードが登録済みでなければ、TreeViewに登録する
        /// 呼び出し側は使わないcodeをnullでは無く、空文字("")で渡すこと
        /// </summary>
        /// <param name="long_code">銘柄コードのみ(例 5214)</param>
        /// <param name="short_code">銘柄コード＋銘柄名称(例 5214　日本電気硝子)</param>
        private void AddCodeToList(string long_code, string short_code)
        {
            if (short_code == null || long_code == null) return;
            if (short_code == "" && long_code != "")
            {
                short_code = long_code.Split(tvdelimiter)[0];
            }

            this.textBox2.AppendText("( ･∀･)ﾉ > けんさく！　 " + short_code + csCrLf);
            string chkedcode = null;
            if (!context.Lock()) { MessageBox.Show("銘柄コードは現在ロックされています\nしばらくお待ちください"); return; }
            try
            {
                context.Clear();
                int ret = AddCompanyCodeList("", long_code, short_code, true);
                if (ret != -1 && IsRegularCode(short_code, out chkedcode))
                {
                    // TitleListペインを再表示
                    listView1.Items.Clear();
                    // ret = GetTitleListsFromRSS(code, ref context.t);
                    ret = GetTitleListsFromHtml(chkedcode, 0);
                    if (ret != -1)
                    {
                        RedisplayListView();
                        //RedisplayGridView();
                    }
                }
            } finally {
                context.UnLock();
            }
        }

        /// <summary>
        /// 引数のコードがYahoo掲示板のコードとして正しいか評価する
        /// 
        /// </summary>
        /// <param name="code"></param>
        /// <returns></returns>
        private bool IsRegularCode(string code, out string result) {
            bool ret = false;
            string[] tmp ;

            if (code.IndexOf(tvdelimiter) > 0)
            {
                tmp = code.Split(tvdelimiter);
                result = tmp[0];
            }
            else
            {
                result = code;
            }

            if (result.Length < 4 || result.Length > 6)
            {
                result = null;
                ret = false;
            }
            else
            {
                if (result.Length == 4)
                {
                    int test;
                    ret = int.TryParse(result, out test);
                    if (!ret)
                    {
                        result = null;
                    }
                }
                else
                {
                    ret = true;
                }
            }
            return ret;
        }

        /// <summary>
        /// 指定語句による全文検索 
        /// </summary>
        private void DoSearchAllTitles()
        {

            if (context.GetCode() == "") return;
            string contents = "";
            string line = "";
            int iCnt = 0;
            if (!File.Exists(csDatDir + context.GetCode() + ".dat")) { textBox2.AppendText("（`皿）> ファイルがねぇ"); return; }

            using (StreamReader sr = new StreamReader(csDatDir + context.GetCode() + ".dat"))
            {

                contents = sr.ReadToEnd();
                sr.Close();
                line = "";
                StringReader sr2 = new StringReader(contents);
                while ((line = sr2.ReadLine()) != null)
                {
                    string[] splittedline;
                    if (line.IndexOf(textBox3.Text) != -1)
                    {
                        if (iCnt == 0) listView1.Items.Clear();
                        splittedline = line.Split(this.delimiter);
                        ListViewItem item = new ListViewItem();
                        item.Text = splittedline[0];  // no
                        item.SubItems.Add(splittedline[1]);  // title
                        item.SubItems.Add(splittedline[2]);  // sender
                        item.SubItems.Add(splittedline[3]);  // pubdate
                        item.SubItems.Add(splittedline[4]);  // emotion
                        
                        if ( splittedline[5] == "0" || splittedline[5] == "") {      // status
                            item.Font = new Font(item.Font, FontStyle.Bold);
                        }
                        listView1.Items.Add(item);
                        iCnt++;
                    }
                }
                sr2 = null;
            }
            PaintBackgrounColorListView();
            if (iCnt == 0) MessageBox.Show("検索結果が０件でした。");
        }

        /// <summary>
        /// 検索ボタン
        /// テキストボックスに入力されたコードをCompanyCodeListペインに追加する
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            string code = this.textBox1.Text;
            AddCodeToList("", code);
        }        

        /// <summary>
        /// 掲示板に新規書き込み
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton2_Click(object sender, EventArgs e)
        {
            this.textBox2.AppendText("( ･∀･)ﾉ > 書き込み！　 " + csCrLf);
            // write api url ilke this...
            //http://post.messages.yahoo.co.jp/bbs?.mm=FN&action=r&board=1006255&tid=6255&sid=1006255&mid=0
            string url = "";
            url = context.postUrl;
            toolStripStatusLabel1.Text = url;
            webBrowser1.NavigateAndWait(url);
        }

        /// <summary>
        /// 返信 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton3_Click(object sender, EventArgs e)
        {
            if (listView1.SelectedItems.Count > 0)
            {
                string mid = listView1.SelectedItems[0].Text;
                webBrowser1.Navigate(new Uri("http://post.messages.yahoo.co.jp/bbs?mm=FN&action=r&board=1" + context.GetPad() + context.GetCode() + "&tid=" + context.tid + "&sid=1" + context.GetPad() + context.GetCode() + "&mid=" + mid));
            }
        }

        /// <summary>
        /// 全文検索 ボタン押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton4_Click(object sender, EventArgs e)
        {
            if (textBox3.Text.Length == 0)
            {
                MessageBox.Show("検索ワードを入力してください。");
                return;
            }
            DoSearchAllTitles();
        }

        /// <summary>
        /// 全タイトルを取得 ボタン押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton5_Click(object sender, EventArgs e)
        {
            if (this.textBox1.Text == "" || this.textBox1.Text.Length != 4)
            {
                MessageBox.Show("テキストボックスに銘柄コードを入力してください");
                return;
            }
            int ret = SaveAllTitleList(this.textBox1.Text, ref context.t);
        }

        /// <summary>
        ///  ランキング表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton6_Click(object sender, EventArgs e)
        {
            webBrowser1.Navigate(new Uri("http://messages.yahoo.co.jp/ranking/stocks/postranking_daily.html"));
            this.Text = "カブラウザもどき - Yahoo!掲示板 - 銘柄別投稿数ランキング - デイリー";
        }

        /// <summary>
        /// ランキング表示（週次）
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton7_Click(object sender, EventArgs e)
        {
            webBrowser1.Navigate(new Uri("http://messages.yahoo.co.jp/ranking/stocks/postranking_weekly.html"));
            this.Text = "カブラウザもどき - Yahoo!掲示板 - 銘柄別投稿数ランキング - ウィークリー";
        }

        /// <summary>
        /// ランキング表示（月次）
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton8_Click(object sender, EventArgs e)
        {
            webBrowser1.Navigate(new Uri("http://messages.yahoo.co.jp/ranking/stocks/postranking_monthly.html"));
            this.Text = "カブラウザもどき - Yahoo!掲示板 - 銘柄別投稿数ランキング - マンスリー";
        }

        /// <summary>
        /// 無視リストを切替
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton9_Click(object sender, EventArgs e)
        {
            if (ignorelist.Count != 0) { 
                ignorelist = new Hashtable();
                this.toolStrip1.Items[0].ImageIndex = (int)ImageList.NGOff;
            } else { 
                LoadNGName();
                this.toolStrip1.Items[0].ImageIndex = (int)ImageList.NGOn;
            }
            RedisplayListView();
        }

        /// <summary>
        /// 空売り残高を表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton10_Click(object sender, EventArgs e)
        {
            if (context.GetCode() == "")
            {
                MessageBox.Show("銘柄コードを入力してください。");
            }
            else
            {
                webBrowser1.Navigate(new Uri("http://www.your-alert-service.com/shortselling/" + context.GetCode() + ".html"));
                //GetShortInterest();
            }
        }


        /// <summary>
        /// 考える株式投資を表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton11_Click(object sender, EventArgs e)
        {
            if (context.GetCode() == "")
            {
                MessageBox.Show("銘柄コードを入力してください。");
            }
            else
            {
                webBrowser1.Navigate(new Uri("http://g2s.biz/tool/edinet/" + context.GetCode()));
            }
        }

        /// <summary>
        /// 東証適時開示システムを表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton12_Click(object sender, EventArgs e)
        {
            if (context.GetCode() == "")
            {
                MessageBox.Show("銘柄コードを入力してください。");
                return;
            }
            //webBrowser1.Navigate("https://www.release.tdnet.info/inbs/140120120614056040.pdf");
                
            webBrowser1.NavigateAndWait("https://www.release.tdnet.info/index.html");
            

            HtmlDocument doc = webBrowser1.Document.Window.Frames[0].Document;
            HtmlElementCollection sels = doc.GetElementsByTagName("SELECT");
            if (sels.Count > 0)
            {
                HtmlElement el1 = (HtmlElement)sels[0];
                HtmlElement el2 = (HtmlElement)sels[1];
                string today = DateTime.Now.ToString("yyyyMMdd");
                string before1m = DateTime.Now.AddMonths(-1).AddDays(1).ToString("yyyyMMdd");
                el1.SetAttribute("value", before1m);
                el2.SetAttribute("value", today);
                doc.GetElementById("q").SetAttribute("value", context.GetCode());
                doc.Forms[0].InvokeMember("submit");
                toolStripStatusLabel1.Text = "https://www.release.tdnet.info/index.html";
            }

            //      doc.DomDocument.frams[0].Document.form1.t0.Value = "20120531"; 

        }

        /// <summary>
        /// Yahooニュースを表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton13_Click(object sender, EventArgs e)
        {
            if (context.GetCode() == "")
            {
                MessageBox.Show("銘柄コードを入力してください。");
                return;
            }
            webBrowser1.NavigateAndWait("http://news.finance.yahoo.co.jp/search/?q=" + context.GetCode() + "&p=1");
            HtmlDocument doc = webBrowser1.Document;
            HtmlElementCollection elms = doc.GetElementsByTagName("LI");
            listView1.Items.Clear();

            string t_tilte = "";
            string t_sender = "";
            string t_pubDate = "";
            bool b_title = false;
            bool b_sender = false;

            foreach (HtmlElement el in elms)
            {   

                if (el.GetAttribute("className") == "yjMt ymuiArrow1L")
                {
                    t_tilte = el.InnerText;
                    b_title = true;
                    
                } else if ( el.GetAttribute("className") == "yjSt marB2 ymuiDate padL10") 
                {


                    t_pubDate = el.InnerText;
                    if ( el.GetElementsByTagName("A").Count > 0 ) {
                        t_sender = el.GetElementsByTagName("A")[0].InnerText;
                    }
                    b_sender = true;
                }
                
                if ( b_title && b_sender ) {
                    ListViewItem item = new ListViewItem();
                    item.Text = "　　　・";
                    item.SubItems.Add(t_tilte);
                    item.SubItems.Add(t_sender);
                    item.SubItems.Add("");
                    item.SubItems.Add(t_pubDate);
                    item.SubItems.Add("");
                    listView1.Items.Add(item);
                    b_title = false;
                    b_sender = false;
                }
            }
            PaintBackgrounColorListView();
            return;
        }

        /// <summary>
        /// EDINETを表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton14_Click(object sender, EventArgs e)
        {
            HtmlDocument doc;
            if (context.GetCode() == "")
            {
                MessageBox.Show("銘柄コードを入力してください。");
            }
            else if (edinetlist[this.textBox1.Text] != null)
            {
                string edi = edinetlist[this.textBox1.Text].ToString();
                this.webBrowser1.NavigateAndWait("https://info.edinet-fsa.go.jp/E01EW/BLMainController.jsp?uji.verb=W1E62010YuKaBtn&uji.bean=ee.bean.EEW1E62030IBean&PID=currentPage&TID=W1E62030");
                doc = webBrowser1.Document;
                doc.GetElementById("edinetCode").SetAttribute("value", edi);
                HtmlElementCollection elms =  doc.All.GetElementsByName("documentsKind");
                for (int i = 0; i < elms[0].All.Count; i++)
                {
                    elms[0].All[i].SetAttribute("selected", "true");
                }
                doc.GetElementById("show3").SetAttribute("checked", "true");
                //doc.Forms[1].InvokeMember("submit");
                this.textBox5.Text = edi;
                this.toolStripStatusLabel1.Text = "https://info.edinet-fsa.go.jp/E01EW/BLMainController.jsp?uji.verb=W1E62010YuKaBtn&uji.bean=ee.bean.EEW1E62030IBean&PID=currentPage&TID=W1E62030";

            }
            else
            {
                MessageBox.Show("EDINETコードが不明でした");
            }
            return ;
        }
        /// <summary>
        /// ListViewダブルクリック イベント制御
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void listView1_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            DisplaySelectedContents();
        }

        private void listView1_KeyPress(object sender, KeyPressEventArgs e)
        {
            switch (e.KeyChar)
            {
                case (char)Keys.Enter: // enterキー押下
                    DisplaySelectedContents();
                    break;
                default:
                    break;
            }
        }

        /// <summary>
        /// GridViewで選択されたメッセージを制御する
        /// </summary>
        private void DisplaySelectedGridContents()
        {
            if ( dataGridView1.SelectedRows.Count == 0) { return; }
            string mid = dataGridView1.SelectedRows[0].Cells[0].ToString();
            switch (mid)
            {
                case "次のページ":
                    
                    GetTitleListsFromLocal(context.GetCode(), mid);
                    break;

                case "前のページ":
                    mid = listView1.Items[listView1.Items.Count - 2].Text;
                    GetTitleListsFromLocal(context.GetCode(), mid);
                    break;

                case "次の40件":
                    GetTitleListsFromHtml(mid, 1);
                    RedisplayListView();
                    break;

                case "前の40件":
                    GetTitleListsFromHtml(mid, -1);
                    RedisplayListView();
                    break;

                default:
                    dataGridView1.SelectedRows[0].InheritedStyle.Font = new Font(listView1.SelectedItems[0].Font, FontStyle.Regular);
                    DisplayContents(mid);
                    break;
            }
            return;
        }

        /// <summary>
        /// ListViewで選択されたメッセージを表示する
        /// </summary>
        private void DisplaySelectedContents()
        {
            if (listView1.SelectedItems.Count == 0) { return; }
            string mid = listView1.SelectedItems[0].Text;
            switch (mid)
            {
                case "次のページ":
                    mid = listView1.Items[1].Text;
                    GetTitleListsFromLocal(context.GetCode(), mid);
                    break;

                case "前のページ":
                    mid = listView1.Items[listView1.Items.Count-2].Text;
                    GetTitleListsFromLocal(context.GetCode(), mid);
                    break;

                case "次の40件":
                    GetTitleListsFromHtml(mid, 1);
                    RedisplayListView();
                    break;

                case "前の40件":
                    GetTitleListsFromHtml(mid, -1);
                    RedisplayListView();
                    break;

                default:
                    if (listView1.SelectedItems.Count > 0)
                    {
                        listView1.SelectedItems[0].Font = new Font(listView1.SelectedItems[0].Font, FontStyle.Regular);
                        DisplayContents(mid);
                    }
                    break;
            }
            return;
        }

        /// <summary>
        /// GridViewで選択されたメッセージを表示する
        /// </summary>
        private void DisplaySelectedGrid()
        {
            if ( this.dataGridView1.SelectedRows.Count == 0) { return; }
            string mid = this.dataGridView1.SelectedRows[0].Cells[0].Value.ToString();
            switch (mid)
            {
                case "次のページ":
                    mid = listView1.Items[1].Text;
                    GetTitleListsFromLocal(context.GetCode(), mid);
                    break;

                case "前のページ":
                    mid = listView1.Items[listView1.Items.Count - 2].Text;
                    GetTitleListsFromLocal(context.GetCode(), mid);
                    break;

                case "次の40件":
                    GetTitleListsFromHtml(mid, 1);
                    RedisplayListView();
                    break;

                case "前の40件":
                    GetTitleListsFromHtml(mid, -1);
                    RedisplayListView();
                    break;

                default:
                    if (dataGridView1.SelectedRows.Count > 0)
                    {
                        dataGridView1.SelectedRows[0].InheritedStyle.Font
                            = new Font(dataGridView1.SelectedRows[0].InheritedStyle.Font, FontStyle.Regular);
                        DisplayContents(mid);
                    }
                    break;
            }
            return;
        }

        /// <summary>
        /// 指定されたMessageIdをブラウズする
        /// </summary>
        /// <param name="mid"></param>
        private void DisplayContents(string mid)
        {

            // 投稿を表示
            // URL例) http://messages.yahoo.co.jp/bbs?.mm=FN&action=m&board=1006255&tid=6255&sid=1006255&mid=18488
            //if (listView1.SelectedItems.Count != 1) { return; }
            string s = "";

            // 表示するチャート描画
            string chartHtml = "";
            chartHtml = GetChartHtml();

            //webBrowser1.Navigate(new Uri(t[listView1.SelectedItems[0].Index].url));
            //string mid = listView1.SelectedItems[0].Text;
            s = GetContentsFromPCSite(mid);
            //s = GetContentsFromMobileSite(mid);
            //                    WebClient wc = new WebClient();
            //YAHOO objectエラーを防ぐために最小限度のjsを使用する

            if (webBrowser1.Version.Major > 6)
            {

                webBrowser1.DocumentText = "<html><head><title>" + context.title + "</title>" + csCrLf
                    + "<script language=\"javascript\" src=\"http://avtimg.yahoo.co.jp/js/avatar_multi_nonlink.js\"></script>" + csCrLf
                    + "<script language=\"javascript\" src=\"http://i.yimg.jp/images/commerce/js/libs/jquery/core/1.7.1/jquery.min.js\"></script>" + csCrLf
                    + "<script language=\"javascript\" src=\"http://i.yimg.jp/images/socialproducts/common/usercard/v5.0/js/usercard.js\"></script>" + csCrLf
                    + "<script language=\"javascript\" src=\"http://i.yimg.jp/images/help/env/1.2.0/env-min.js\"></script>" + csCrLf
                    + "<link rel=\"stylesheet\" type=\"text/css\" href=\"http://i.yimg.jp/images/socialproducts/common/usercard/v5.0/css/s150m.css\"/>" + csCrLf
                    + "</head><body>" + csCrLf
                    + s + csCrLf
                    + chartHtml + csCrLf
                    + "</body></html>" + csCrLf;
            }
            else
            {
                webBrowser1.DocumentText = "<html><head><title>" + context.title + "</title>" + csCrLf
                    + "<script language=\"javascript\" src=\"http://i.yimg.jp/images/socialproducts/common/usercard/v5.0/js/usercard.js\"></script>" + csCrLf
                    + "<script language=\"javascript\" src=\"http://i.yimg.jp/images/help/env/1.2.0/env-min.js\"></script>" + csCrLf
                    + "<link rel=\"stylesheet\" type=\"text/css\" href=\"http://i.yimg.jp/images/socialproducts/common/usercard/v5.0/css/s150m.css\"/>" + csCrLf
                    + "</head><body>" + csCrLf
                    + s + csCrLf
                    + chartHtml + csCrLf
                    + "</body></html>" + csCrLf;

            }
            /* ブラウズするだけ（広告表示）
            string url = "http://messages.yahoo.co.jp/bbs?.mm=FN&action=m&board=100" + context.code + "&tid=" + context.tid + "&sid=100" + context.code + "&mid=" + mid;
            webBrowser1.NavigateAndWait(url);
            */
        }

        private string GetChartHtml()
        {
            string ret = "";

            if (webBrowser1.Version.Major > 6)
            {
                ret = "<style type='text/css'>TD.y_chart { font-size: 12px; background: #EEEEDD; border: 1px; }</style>";
                ret += "<br><table border='1' cellspacing='0'><tr>";
                ret += "<td class='y_chart'>日足</td><td class='y_chart'>1週間</td></tr><tr>";
                ret += "<td rowspan='3'><img src='http://rchart.yahoo.co.jp/z?s=" + context.codeAndExchange + "&t=6m&l=off&z=m&q=c&a=v&c=' width='400'></img>";
                ret += "</td><td rowspan='1'>";
                ret += "<img src='http://rchart.yahoo.co.jp/g?s=" + context.codeAndExchange + "&t=6m&l=off&z=m&q=c&a=v&c=' width='200'></img>";
                ret += "</tr><tr><td class='y_chart'>日中足</td></tr><tr><td rowspan='1'>";
                ret += "<img src='http://rchart.yahoo.co.jp/f?s=" + context.codeAndExchange + "&t=6m&l=off&z=m&q=c&a=v&c=' width='200'></img>";
                ret += "</td></tr></table>";
            }
            else  // IE6以下はアンチエイリアスが効かなくて汚い
            {
                ret = "<style type='text/css'>TD.y_chart { font-size: 12px; background: #EEEEDD; border: 1px; }</style>";
                ret += "<br><table border='1' cellspacing='0'><tr>";
                ret += "<td class='y_chart'>日足</td><td class='y_chart'>1週間</td></tr><tr>";
                ret += "<td rowspan='3'><img src='http://rchart.yahoo.co.jp/z?s=" + context.codeAndExchange + "&t=6m&l=off&z=m&q=c&a=v&c='></img>";
                ret += "</td><td rowspan='1'>";
                ret += "<img src='http://rchart.yahoo.co.jp/g?s=" + context.codeAndExchange + "&t=6m&l=off&z=m&q=c&a=v&c=' ></img>";
                ret += "</tr><tr><td class='y_chart'>日中足</td></tr><tr><td rowspan='1'>";
                ret += "<img src='http://rchart.yahoo.co.jp/f?s=" + context.codeAndExchange + "&t=6m&l=off&z=m&q=c&a=v&c=' ></img>";
                ret += "</td></tr></table>";
            }
            return ret;
        }


        /// <summary>
        /// 銘柄コードでキー押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void textBox1_KeyPress(object sender, KeyPressEventArgs e)
        {
            switch (e.KeyChar)
            {
                case (char)Keys.Enter:
                    AddCodeToList("", this.textBox1.Text);
                    TextboxConditionChange(this.textBox1.Text);

                    break;
                default:
                    break;
            }
        }

        /// <summary>
        /// メッセージID でキー押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void textBox4_KeyPress(object sender, KeyPressEventArgs e)
        {
            switch (e.KeyChar)
            {
                case (char)Keys.Enter:
                    if (textBox4.Text != "" && textBox1.Text != "")
                    {
                        GetTitleListsFromLocal(textBox1.Text, textBox4.Text);
                        if (listView1.Items.Count > 19)
                        {
                            listView1.Items[19].Selected = true;
                            listView1.EnsureVisible(listView1.SelectedIndices[0]);
                            listView1.FocusedItem = listView1.SelectedItems[0];
                            listView1.Focus();
                        }
                    }
                    break;
                default:
                    break;
            }
        }

        /// <summary>
        ///  TreeViewでドラッグ＆ドロップ　制御
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void treeView1_ItemDrag(object sender, ItemDragEventArgs e)
        {
            TreeView tv = (TreeView)sender;
            tv.SelectedNode = (TreeNode)e.Item;
            tv.Focus();
            //ノードのドラッグを開始する
            DragDropEffects dde =
                tv.DoDragDrop(e.Item, DragDropEffects.All);
            //移動した時は、ドラッグしたノードを削除する
            if ((dde & DragDropEffects.Move) == DragDropEffects.Move)
                tv.Nodes.Remove((TreeNode)e.Item);
        }

        /// <summary>
        ///  TreeViewでドラッグ＆ドロップ　制御
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void treeView1_DragDrop(object sender, DragEventArgs e)
        {
            //ドロップされたデータがTreeNodeか調べる
            if (e.Data.GetDataPresent(typeof(TreeNode)))
            {
                TreeView tv = (TreeView)sender;
                //ドロップされたデータ(TreeNode)を取得
                TreeNode source =
                    (TreeNode)e.Data.GetData(typeof(TreeNode));
                //ドロップ先のTreeNodeを取得する
                TreeNode target =
                    tv.GetNodeAt(tv.PointToClient(new Point(e.X, e.Y)));
                //マウス下のNodeがドロップ先として適切か調べる
                if (target != null && target != source &&
                    IsDruggable(source, target))
                {
                    //ドロップされたNodeのコピーを作成
                    TreeNode cln = (TreeNode)source.Clone();
                    //Nodeを追加
                    if (target.Parent != null && source.ImageIndex == (int)ImageList.File)
                    {   
                        target.Parent.Nodes.Insert(target.Index , cln);
                    }
                    else if (target.Parent == null && source.ImageIndex == (int)ImageList.File)
                    {
                        target.Nodes.Insert(target.Index, cln);
                    }
                    else if (target.Parent == null)
                    {
                        this.treeView1.Nodes.Insert(target.Index, cln);
                    }
                    else
                    {
                        target.Nodes.Add(cln);
                    }
                    //ドロップ先のNodeを展開
                    target.Expand();
                    //追加されたNodeを選択
                    tv.SelectedNode = cln;
                }
                else
                    e.Effect = DragDropEffects.None;
            }
            else
                e.Effect = DragDropEffects.None;
        }

        /// <summary>
        /// あるTreeNodeがDrop先として適切か調べる
        /// </summary>
        /// <param name="source">移動元</param>
        /// <param name="target">移動先</param>
        /// <returns>Drop可能ならTrue</returns>
        private static bool IsDruggable(TreeNode source, TreeNode target)
        {
            if (target.Parent != null && (source.ImageIndex == (int)ImageList.CloseFolder 
                || source.ImageIndex == (int)ImageList.OpenFolder)) return false;  // フォルダを子ノードには追加できない
            if (source.Parent == source) return false; // 自ノードには追加できない
            return true;
        }

        /// <summary>
        /// TreeViewでドラッグ＆ドロップ　制御
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void treeView1_DragOver(object sender, DragEventArgs e)
        {
            //ドラッグされているデータがTreeNodeか調べる
            if (e.Data.GetDataPresent(typeof(TreeNode)))
            {
                if ((e.KeyState & 8) == 8 &&
                    (e.AllowedEffect & DragDropEffects.Copy) ==
                    DragDropEffects.Copy)
                    //Ctrlキーが押されていればCopy
                    //"8"はCtrlキーを表す
                    e.Effect = DragDropEffects.Copy;
                else if ((e.AllowedEffect & DragDropEffects.Move) ==
                    DragDropEffects.Move)
                    //何も押されていなければMove
                    e.Effect = DragDropEffects.Move;
                else
                    e.Effect = DragDropEffects.None;
            }
            else
                //TreeNodeでなければ受け入れない
                e.Effect = DragDropEffects.None;

            //マウス下のNodeを選択する
            if (e.Effect != DragDropEffects.None)
            {
                TreeView tv = (TreeView)sender;
                //マウスのあるNodeを取得する
                TreeNode target =
                    tv.GetNodeAt(tv.PointToClient(new Point(e.X, e.Y)));
                //ドラッグされているNodeを取得する
                TreeNode source =
                    (TreeNode)e.Data.GetData(typeof(TreeNode));
                //マウス下のNodeがドロップ先として適切か調べる
//                if (target != null && target != source &&
//                        IsDruggable(source, target))
                if (target != null && target != source)
                {
                    //Nodeを選択する
                    if (target.IsSelected == false)
                        tv.SelectedNode = target;
                }
                else
                    e.Effect = DragDropEffects.None;
            }
        }

        /// <summary>
        /// 引数の銘柄コードのタイトル一覧を表示する
        /// </summary>
        /// <param name="e">4ケタの銘柄コード</param>
        private void DisplayTitleList(string code )
        {
            if (code == null || code == "" || code.Length < 4) { return; }
            this.textBox2.AppendText("( ･∀･)ﾉ > 表示するよ！　 " + code + csCrLf);
            // TitleListペインを再表示
            listView1.Items.Clear();
            int ret = GetTitleListsFromHtml(code, 0);
            //int ret = GetTitleListsFromRSS(code, ref context.t);
            if (ret != -1)
            {
                this.textBox1.Text = code;
                RedisplayListView();
                //RedisplayGridView();

                foreach (TreeNode tn in treeView1.Nodes)
                {
                    if ( tn.Name == code )
                    {
                        treeView1.SelectedNode = tn;
                    }
                }
                TextboxConditionChange(code);
            }
        }

        /// <summary>
        /// 銘柄コードを変えた場合の制御
        /// </summary>
        /// <param name="code"></param>
        private void TextboxConditionChange(string code)
        {

            if (File.Exists(csDatDir + code + ".dat"))
            {
                this.textBox3.Enabled = true;
                this.textBox4.Enabled = true;
            }
            else
            {
                this.textBox3.Text = "";
                this.textBox4.Text = "";
                this.textBox3.Enabled = false;
                this.textBox4.Enabled = false;
            }
            return;
        }

        /// <summary>
        /// TreeViewでキーを押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void treeView1_KeyUp(object sender, KeyEventArgs e)
        {
            switch (e.KeyCode)
            {
                case Keys.Enter:
                    string short_code = "";
                    if (e == null) { return; }
                    if (!string.IsNullOrEmpty(treeView1.SelectedNode.Name) && treeView1.SelectedNode.Parent != null)
                    {
                        short_code = GetRegularCode(treeView1.SelectedNode.Name);
                        DisplayTitleList(short_code);
                    }
                    break;
                case Keys.F2:
                    TreeNode tn = treeView1.SelectedNode;
                    treeView1.LabelEdit = true;
                    if (tn != null && treeView1.LabelEdit && tn.IsEditing)
                    {
                        tn.BeginEdit();
                    }
                    break;
                case Keys.Delete:
                    TreeNode tntmp = treeView1.SelectedNode;
                    tntmp.Remove();
                    break;
                default:
                    break;
            }
        }

        /// <summary>
        /// TreeViewで選択されたオブジェクトがフォルダか確認する
        /// </summary>
        /// <param name="tn"></param>
        /// <returns></returns>
        private bool IsFolder(TreeNode tn)
        {
            bool ret = false;
            if (tn.Parent == null && (tn.ImageIndex == (int)ImageList.CloseFolder || tn.ImageIndex == (int)ImageList.OpenFolder))
            {
                ret = true;
            }
            return ret;
        }

        /// <summary>
        /// TreeViewでダブルクリック
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void treeView1_MouseDoubleClick_1(object sender, MouseEventArgs e)
        {
            string short_code = "";
            if (e == null) { return; }
            TreeNode select = treeView1.SelectedNode ;
            // ファイルの場合はタイトル一覧を表示
            if (!string.IsNullOrEmpty(select.Name) && !IsFolder(select) && select.Name.Length >= 4)
            {
                short_code = treeView1.SelectedNode.Name;
                DisplayTitleList(short_code);
            }
            // フォルダの場合はリネーム
            else if (!string.IsNullOrEmpty(select.Name) && IsFolder(select))
            {
                TreeNode tn = treeView1.SelectedNode;
                treeView1.LabelEdit = true;
                if (tn != null && treeView1.LabelEdit && tn.IsEditing)
                {
                    tn.BeginEdit();
                }
            }
        }

        /// <summary>
        /// このアプリを閉じる前の処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if ((MessageBox.Show("アプリケーションを終了する前にcode.lstファイルを保存しますか？", "確認",
                    MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.Yes)) {
                        SaveCodeList();
            }
        }

        /// <summary>
        /// 全文検索テキストボックスでキー押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void textBox3_KeyPress(object sender, KeyPressEventArgs e)
        {
            switch( e.KeyChar ) {
            case (char)Keys.Enter:
                if (textBox3.Text.Length == 0)
                {
                    MessageBox.Show("検索ワードを入力してください。");
                    return;
                }
                DoSearchAllTitles();
                break;
            default:
                break;
            }
        }

        /// <summary>
        /// TreeViewで名称変更後の処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void treeView1_AfterLabelEdit(object sender, NodeLabelEditEventArgs e)
        {
            try
            {
                bool editOk = true;
                if (e.Node.Parent == null)
                { // フォルダ
                    treeView1.SelectedNode.Text = e.Node.Text;
                    treeView1.SelectedNode.Name = e.Node.Text;
                    treeView1.SelectedNode.ImageIndex = (int)ImageList.CloseFolder;
                    e.Node.EndEdit(false);
                }
                else
                {
                    string outCode = "";
                    if (e.Label.Length > 0)
                    {
                        if (e.Label.IndexOf(tvdelimiter) == -1) editOk = false;
                        if (!IsRegularCode(e.Label, out outCode)) editOk = false;
                        if (!editOk)
                        {
                            MessageBox.Show("銘柄名称を変更する場合は、コードと名称の間を全角スペースで空けて下さい.");
                            e.CancelEdit = true;
                            e.Node.EndEdit(true);
                        }
                        else
                        {
                            treeView1.SelectedNode.Text = e.Label;
                            e.Node.EndEdit(false);
                        }
                    }
                }
                this.treeView1.LabelEdit = false;
            }
            catch (NullReferenceException exp)
            {
                e.CancelEdit = true;
                e.Node.EndEdit(true);
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void dataGridView1_CellContentDoubleClick(object sender, DataGridViewCellEventArgs e)
        {
            DisplaySelectedGrid();
        }

    }

    /// <summary>
    /// 比較クラス
    /// </summary>
    class ListViewItemComparer : IComparer
    {
        private int col;
        private int sortOrder;

        // コンストラクタ
        public ListViewItemComparer(int col, int sortOrder)
        {
            this.col = col;
            this.sortOrder = sortOrder;
        }
        // 比較メソッド
        public int Compare(object x, object y)
        {
            int ret = 0;
            switch (col)
            {
                case 0:    // 文字列でソート
                    ret = String.Compare(((ListViewItem)x).SubItems[col].Text,
                        ((ListViewItem)y).SubItems[col].Text);
                    break;
                case 1:    // 数値でソート
                    ret = int.Parse(((ListViewItem)x).SubItems[col].Text) <
                       int.Parse(((ListViewItem)y).SubItems[col].Text) ? -1 : 1;
                    break;
            }
            return ret * sortOrder;
        }
    }


    /// <summary>
    ///投稿タイトルリスト クラス
    /// </summary>
    public class TitleLists
    {
        public string titleNo;
        public string url;
        public string title;
        public string sender;
        public string emotion;
        public string sendTime;
        public string status;  // 0:未読, 1:既読, null:未読
        private string delimiter = Char.ConvertFromUtf32(128);

        public TitleLists() { this.titleNo = ""; this.title = ""; this.url = ""; this.sendTime = ""; this.sender = ""; this.emotion = ""; status = "0"; }
        public TitleLists(string[] p)
        {
            if (p.Length < 6) { return;  }
            titleNo = p[0];
            url = p[1];
            title = p[2];
            sender = p[3];
            emotion = p[4];
            sendTime = p[5];
            status = "0";
        }
        public void Clear()
        {
            titleNo = "";
            url = "";
            title = "";
            sender = "";
            emotion = "";
            sendTime = "";
            status = "0";
        }

        public TitleLists(string p1, string p2, string p3, string p4, string p5, string p6, string p7)
        {
            titleNo = p1;
            url = p2;
            title = p3;
            sender = p4;
            emotion = p5;
            sendTime = p6;
            status = p7;
        }
        public override string ToString()
        {
            return titleNo + delimiter + title + delimiter + sender + delimiter + sendTime + delimiter + emotion + delimiter + status;
        }
        //パスを指定して内容を書き込み
        public int WriteLine(string path)
        {
            using (StreamWriter sw = new StreamWriter(path))
            {
                sw.WriteLine(this.ToString());
            }
            return 0;
        }
        //StreamWriteを指定して書き込み
        public int WriteLine(StreamWriter sw)
        {
            sw.WriteLine(this.ToString());
            return 0;
        }
        /// <summary>
        /// TitleNoをint型で返す
        /// </summary>
        /// <returns></returns>
        public int GetTitleNo(){
            return int.Parse(titleNo);
        }
    }

    /// <summary>
    /// 状態変数 - このアプリの核
    /// </summary>
    public class CurrentContext
    {
        public string nextPage = "";
        public string prevPage = "";
        public string codeAndExchange = ""; // 市場コードつき銘柄コード ( 5202,t )
        private string code = "";     // 銘柄コード  ( 5202 ) ※padと対になる為、直接アクセスは許さない
        private string pad;           // パディング用のコード 
        public string comapnyName = "";
        public string title;
        public string tid;      // 掲示板のTopic ID
        public string postUrl;  // 新規投稿するためのURL
        public string maxTilteNo;  // 最新のタイトルNo
        public uint maxRow;

        public int close;
        public int change;

        public StreamReader topicSr;
        public StreamWriter topicSw;
        public TitleLists[] t;
        private bool lockflag = false; // ロック中
        /// <summary>
        /// コンストラクタ - 画面に表示する最大件数を渡してオブジェクト生成
        /// </summary>
        /// <param name="maxRow"></param>
        public CurrentContext(uint maxRow) {
            this.maxRow = maxRow;
            this.lockflag = false;
            TitleLists[] instance = new TitleLists[maxRow];
            for (int i = 0; i < maxRow; i++)
            {
                instance[i] = new TitleLists();
            }
            this.t = instance;
        }
        /// <summary>
        /// 表示中のタイトルリストをファイルに保存する
        /// </summary>
        /// <returns></returns>
        public int Save()
        {
            string path = Form1.csDatDir + code + ".dat";
            topicSw = new StreamWriter(path);
            foreach (TitleLists tmp in t)
            {
                tmp.WriteLine(topicSw);
            }
            topicSw.Close();
            topicSw = null;
            return 0;
        }
        /// <summary>
        /// パディング文字列を返す
        /// </summary>
        /// <returns></returns>
        public string GetPad()
        {
            return this.pad;
        }
        /// <summary>
        /// 銘柄コードを返す
        /// </summary>
        /// <returns></returns>
        public string GetCode()
        {
            return this.code;
        }
        /// <summary>
        /// 銘柄コードをセットする、と同時にゼロ埋め用の
        /// pad変数をセットする。
        /// </summary>
        /// <param name="code"></param>
        public void SetCode(string code)
        {
            this.code = code;
            if (code.Length == 6) pad = "";
            if (code.Length == 4) pad = "00";
        }

        /// <summary>
        /// TitleNoの最大値をint型で返す
        /// </summary>
        /// <returns></returns>
        public int GetMaxTitleNo()
        {
            return int.Parse(maxTilteNo);
        }
        /// <summary>
        /// オブジェクトの保有するTitle List一覧をクリアする。
        /// 次のページを表示する場合呼び出す。
        /// </summary>
        public void ClearTitleList()  {
            for (int i = 0; i < maxRow; i++)
            {
                t[i].Clear();
            }
        }
        /// <summary>
        /// このオブジェクトの内容をクリアする
        /// 別の銘柄コードを選択時に呼び出す事。
        /// </summary>
        public void Clear()
        {
            this.tid = "";
            this.pad = "";
            this.code = "";
            this.comapnyName = "";
            this.postUrl = "";
            this.prevPage = "";
            this.nextPage = "";
            this.maxTilteNo = "";
            this.ClearTitleList();
            this.topicSr = null;
            this.topicSw = null;
            this.lockflag = false;
        }
        
        /// <summary>
        /// このオブジェクトのロックを取得する
        /// </summary>
        /// <returns></returns>
        public bool Lock() {
            bool ret ;
            if (lockflag) {
                ret = false;
            } else {
                lockflag = true;
                ret = true;
            }
            return ret ;
        }
        /// <summary>
        /// このオブジェクトのロックを解放する
        /// </summary>
        /// <returns></returns>
        public void UnLock()
        {
            lockflag = false;
        }
    }
}