﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Xml;
using System.Collections;
using System.Diagnostics;

namespace カブラウザもどき
{
    public class GetYahooTextream : GetYahoo
    {
        /*
        private CurrentContext context = null;
        private TextBox console = null;
        private ToolStripStatusLabel console2 = null;
        private Hashtable edinetlist;
        private WebBrowserController ndbControl = null;
         * */

        public GetYahooTextream(カブラウザもどき.CurrentContext context, TextBox console, ToolStripStatusLabel console2, WebBrowserController ndbControl, Hashtable edinetlist)
        {
            this.context = context;
            this.console = console;
            this.console2 = console2;
            this.ndbControl = ndbControl;
            this.edinetlist = edinetlist;
            this.context.SetYahooInstance(this);
        }
        
        public override string GetReplyUrl(string mid)
        {
            if (context.GetCode() == "") return "";
            return "http://textream.yahoo.co.jp/message/"+context.board+"/"+context.tid+"?comment="+mid;
        }
        public override string GetThreadUrl(string mid)
        {
            //textreamではスレッド表示は廃止されたため、空文字を返す
            return "";
        }
        public override string GetBaseUrl()
        {
            if (context.GetCode() == "") return "";
            return "http://textream.yahoo.co.jp/message/" + context.board + "/" + context.tid;
        }
        public override string GetMassageUrl(string mid)
        {
            if (context.GetCode() == "") return "";
            return "http://textream.yahoo.co.jp/message/" + context.board + "/" + context.tid + "?comment=" + mid;
        }
        public string GetPostedSelf()
        {
            return "http://textream.yahoo.co.jp/personal/history/comment";
        }
        public override string GetMessageListFromUserId(string sender)
        {
            if (sender == "") return "";
            foreach (TitleLists t in context.t) {
                if (t.sender == sender) {
                    return "http://textream.yahoo.co.jp/personal/history/comment?user=" + t.user;
                }
            }
            return "";
        }
        /// <summary>
        ///　無条件にtrueを返す
        /// </summary>
        /// <param name="code"></param>
        /// <returns></returns>
        public override bool IsValidYahooCode(string code)
        {
            return true;
        }

        /// <summary>
        /// 引数のURLのメッセージコンテンツを取得する 
        /// コンテンツの内容はあらかじめ取得している事
        /// </summary>
        /// <param name="mid"></param>
        /// <returns></returns>
        public override string GetContents(string mid)
        {
            YahooSkin skin = context.GetSkin();
            skin.ContextToSkin(context);
            TitleLists thisTitle = null;
            string s = "";

            foreach (TitleLists t in context.t) {
                if (t.titleNo == mid) {
                    thisTitle = t;
                    break;
                }
            }

            if (thisTitle != null) {
                skin.set("&MESSAGE", thisTitle.content);
                skin.set("&RESURL", GetReplyUrl(mid));
                skin.set("&NUMBER", thisTitle.titleNo);
                skin.set("&TITLE", thisTitle.title);
                skin.set("&NAME", thisTitle.sender);
                skin.set("&FEELINGS", thisTitle.emotion);
                skin.set("&DATE", thisTitle.sendTime);
                skin.set("&M_FINDMSG", GetMessageListFromUserId(thisTitle.sender));
                skin.set("&M_COMMENT_THM", thisTitle.userIcon);
                
            }
            //ニックネームはひとまず置いておく
            //                            skin.set("&M_NICKNAME", e.GetAttribute("HREF").Replace("http://search.messages.yahoo.co.jp/search/?p=", ""));
            return "";
        }


        ///<summary>
        /// HTMLから投稿タイトル一覧を全部取得してファイルに保存する
        /// 最新titleIDからmaxRow分はTitleListsクラスに格納する
        ///</summary>
        public override int SaveAllTitleList(string code, ref TitleLists[] t)
        {
            int maxTitleNo = 0;  // 取得済みのtitle
            string className = "";
            NonDispBrowser ndb = (NonDispBrowser)ndbControl.GetBrowser();

            if (code == "") { return -1; }

            bool bReadExitFlag = false; // キャッシュされた最新まで達したので読込み終了する

            if ((MessageBox.Show("この処理を行うとタイトルによる「全文検索」が可能となりますが、\n処理は５分から１０分程度の時間がかかります。続行しますか？", "ダウンロード確認",
                    MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.No)) { return -1; }

            if (File.Exists(Form1.csDatDir + code + ".dat")) {
                string line = "";
                using (StreamReader sr = new StreamReader(Form1.csDatDir + code + ".dat")) {
                    line = sr.ReadLine();
                    if (line != null && line.Split(Form1.delimiter).Length > 1) {
                        maxTitleNo = int.Parse(line.Split(Form1.delimiter)[0]);
                        MessageBox.Show(maxTitleNo + "以降を取得して保存します。");
                    }
                }
            }

            int itemCnt = 0;

            if (!context.Lock()) { MessageBox.Show("銘柄コードは現在ロックされています\nしばらくお待ちください"); return -1; }
            try {

                int chk = GetTopicId(code, false);
                TitleLists data = new TitleLists();
                // 最新の一覧
                ndb.NavigateAndWait(this.GetBaseUrl());
                string path = Form1.csDatDir + code + ".dat";

                StreamWriter sw = new StreamWriter(path, true);
                sw.WriteLine("0" + Form1.delimiter + context.tid + Form1.delimiter + context.GetCodeAndExchange() + Form1.delimiter + context.comapnyName);

                int tblCnt = 0;
                HtmlElement elm = null;
                HtmlElement elm2 = null;
                HtmlElement ttl = null;
                HtmlElement commentTxt = null;
                HtmlElement commentThm = null;
                HtmlElementCollection tmp = null;
                HtmlElementCollection elms = null;
                HtmlElementCollection elms2 = null;
                for (int i = 0; i <= (context.GetMaxTitleNo() / 40); i++) {

                    console2.Text = ndb.Url.ToString();
                    HtmlDocument doc = ndb.Document;
                    itemCnt = 0;
                    foreach (HtmlElement e in doc.GetElementsByTagName("A")) {
                        if (e.InnerText == "次のページ") {
                            context.prevPage = e.GetAttribute("href");
                            itemCnt = 1;
                            break;
                        }
                    }
                    // title no :  .commentBox > .commentTxt cf > input type=hidden name=commentInfo
                    // title no :  .commentBox > .commentTxt cf > .textArea cf > .ttl > dtタグ > spanタグ
                    // title :  .commentBox > .commentTxt cf > .textArea cf > .ttl > .commentTitle
                    // sender : .commentBox > .commentTxt cf > .textArea cf > .ttl > .name cf
                    // user   : .commentBox > .commentTxt cf > .textArea cf > .ttl > .name cf > 
                    // emotion :  .commentBox > .commentTxt cf > .textArea cf > .ttl > .name cf > .labelEmotion
                    // sendTime :  .commentBox > .commentTxt cf > .textArea cf > .ttl > .date
                    // content :  .commentBox > .commentTxt cf > .hideDetail > detail
                    foreach (HtmlElement e in doc.GetElementsByTagName("a")) {

                        className = e.GetAttribute("className");
                        System.Console.WriteLine(className);
                        if (className == "commentTitle") {

                            ttl = e.Parent.Parent;
                            if (ttl.GetElementsByTagName("dt").Count > 0) {
                                if (ttl.GetElementsByTagName("dt")[0].GetElementsByTagName("span").Count > 0) {
                                    data.titleNo = ttl.GetElementsByTagName("dt")[0].GetElementsByTagName("span")[0].InnerText.Replace("No.", "");
                                    if (maxTitleNo == 0) {
                                        maxTitleNo = int.Parse(data.titleNo);
                                    }
                                }
                            }

                            elm = Utils.GetElementByClassName(ttl, "commentTitle");
                            if (elm != null) data.title = elm.InnerHtml;

                            elm = Utils.GetElementByClassName(ttl, "labelEmotion", "p");
                            if (elm != null) data.emotion = elm.InnerText;

                            elm = Utils.GetElementByClassName(ttl, "name cf");
                            if (elm != null) {
                                tmp = elm.GetElementsByTagName("a");
                                if (tmp.Count > 0) {
                                    data.sender = tmp[0].InnerText;
                                } else {
                                    // A tagに存在しない場合は p タグの場合もある
                                    tmp = elm.GetElementsByTagName("p");
                                    if (tmp.Count > 0) {
                                        data.sender = tmp[0].InnerText;
                                    }
                                }
                            }

                            elm = Utils.GetElementByClassName(ttl, "date");
                            if (elm != null) data.sendTime = elm.InnerHtml;

                            commentTxt = ttl.Parent.Parent;

                            // userIcon, user
                            commentThm = commentTxt.Parent;
                            elm = Utils.GetElementByClassName(commentThm, "commentThm", "p");
                            if (elm != null) {
                                elms2 = elm.GetElementsByTagName("img");
                                if (elms2.Count > 0) {
                                    elm2 = elms2[0];
                                    if (elm2 != null) data.userIcon = elm2.GetAttribute("src");
                                }
                                elms2 = elm.GetElementsByTagName("a");
                                if (elms2.Count > 0) {
                                    elm2 = elms2[0];
                                    if (elm2 != null) data.user =
                                        elm2.GetAttribute("href").Replace("http://textream.yahoo.co.jp/personal/history/comment?user=", "");
                                }

                            } else {
                                data.userIcon = "http://i.yimg.jp/images/mb/textream/pc/thumb02.png";
                                data.user = "";
                            }
                            data.WriteLine(sw, true);

                            if (int.Parse(data.titleNo) > maxTitleNo) {
                                bReadExitFlag = true;
                                break;
                            }

                        }
                        if (bReadExitFlag) break;
                    }
                    if (bReadExitFlag) break;
                    if (itemCnt == 1) {
                        ndb.NavigateAndWait(context.prevPage);
                    } else {
                        //次のページが存在しない
                        bReadExitFlag = true;
                        break;
                    }
                } // 読込みループ終了
                sw.Close();
                sw = null;
                Utils.SortUniqTitleList(path);
            }
            finally {
                context.UnLock();
            }

            MessageBox.Show("ダウンロード完了！");
            return 0;
        }

        /// <summary>
        ///  Yahoo掲示板のTopic ID (tid=部分)、最大TitleNo を取得する.取得値は状態変数に格納する
        ///  この値は変則で、単に銘柄コード(ex.2432)もあれば、ランダム？(8136 -> a55a5sa5jaaa) 
        ///  パターンもある。
        ///  ・textreamの場合はどこからTIDを取ってくればいいのかわからない
        ///  　とりあえず、固定値を使用する。
        ///  　存在しない場合は銘柄コードで推定する。
        /// </summary>
        /// <param name="isCheckLock">使用しない</param>
        /// <returns>0:正常 -1:異常</returns>
        public override int GetTopicId(string code, bool isCheckLock)
        {
            int ret = -1;
            if (edinetlist.ContainsKey(code)) {
                context.tid = ((string)edinetlist[code]).Split(',')[3];
            }
            if (context.tid != "") {
                ret = 0;
            } else {
                context.tid = code;
            }
            context.postUrl = GetBaseUrl() + "#commentEntryForm";
            return ret;
        }

        /// <summary>
        ///  Yahoo掲示板のその他の情報を取得する
        ///  HtmlDocument docには正常なDocumentオブジェクトを渡すこと.
        ///  此処ではチェックしない
        ///  セットする値(context):  codeAndExchange, comapnyName
        ///  セットする値(yahoo):  &DATE, &CLOSE, &CHANGE 
        /// </summary>
        /// <returns>0:正常 -1:異常</returns>
        public override void GetOtherInfo(string code, HtmlDocument doc)
        {

            try {
                // IMG用の市場コードを含んだ銘柄コード
                foreach (HtmlElement e in doc.GetElementsByTagName("IMG")) {
                    string sLink = e.GetAttribute("src");
                    try {
                        if (sLink.Length >= 36 && (sLink.Substring(0, 30) == "http://rchart.yahoo.co.jp/t?s=" ||
                                                   sLink.Substring(0, 30) == "http://gchart.yahoo.co.jp/t?s=")) {
                            string tmp = sLink.ToString().Substring(30, sLink.Length - 30);
                            context.SetCodeAndExchange(tmp.Split('&')[0]);
                            break;
                        }
                    }
                    catch (NullReferenceException exp) {
                        context.SetCodeAndExchange("");
                    }
                }

                //終値と前日比
                int itemCnt = 0;
                foreach (HtmlElement e in doc.GetElementsByTagName("meta")) {
                    
                    if (itemCnt == 1) break;

                    switch (e.GetAttribute("property")) {
                        case "og:title":
                            context.title = e.GetAttribute("content").ToString();
                            context.comapnyName = context.title.Split('-')[1].TrimStart().TrimEnd();
                            itemCnt++;
                            break;
                        default:
                            break;
                    }
                }
            }
            catch (IndexOutOfRangeException e) {
                console.AppendText(e.ToString() + Form1.csCrLf);
            }
            catch (NullReferenceException e) {
                console.AppendText(e.ToString() + Form1.csCrLf);
            }
            return ;
        }
        public override int GetSid(string code)
        {
            int ret = -1;
            if (edinetlist.ContainsKey(code)) {
                context.sid = ((string)edinetlist[code]).Split(',')[2];
            }

            if (context.sid != "") {
                ret = 0;
            } else {
                context.sid = "100" + code;
            }
            return ret;
        }
        public override int GetBorad(string code)
        {
            int ret = -1;
            if (edinetlist.ContainsKey(code)) {
                context.board = ((string)edinetlist[code]).Split(',')[1];
            }
            if (context.board != "") {
                ret = 0;
            } else {
                context.board = "100" + code;
            }
            return ret;
        }


        /// <summary>
        /// YahooTextreamから該当銘柄コードのTitle一覧の取得を行う
        /// 投稿タイトル一覧を取得して配列に格納する
        /// 履歴：
        /// </summary>
        /// <param name="pageNo">ぺジー番号 0:最新 -1:前の40件 1:次の40件</param>
        public override int GetTitleLists(string longCode, int pageNo)
        {
            string url = "";
            int ret = 0;
            int itemCnt = 0;
            //Stopwatch sw = new Stopwatch();
            NonDispBrowser ndb = (NonDispBrowser)ndbControl.GetBrowser();

            switch (pageNo) {
                case 1:
                    if (context.nextPage == null || context.nextPage == "") {
                        ret = -1;
                    } else {
                        url = context.nextPage;
                        context.ClearTitleList();
                    }
                    break;
                case -1:
                    if (context.prevPage == null || context.prevPage == "") {
                        ret = -1;
                    } else {
                        context.ClearTitleList();
                        url = context.prevPage;
                    }
                    break;
                case 0:
                default:
                    url = GetBaseUrl();
                    ret = GetTopicId(context.GetCode(), false);
                    //yahoo.GetOtherInfo(context.GetCode(), false);
                    break;
            }

            ComConstants now = ndbControl.DlControl;
            console.AppendText("( ･∀･)ﾉ > げっと！　 " + context.GetCode() + Form1.csCrLf);

            if (ret == 0) {
                if (!context.Lock()) { MessageBox.Show("銘柄コードは現在ロックされています\nしばらくお待ちください"); return -1; }
                try {
                    ComConstants filter = ComConstants.DLCTL_NO_JAVA
                                        | ComConstants.DLCTL_NO_SCRIPTS
                                        | ComConstants.DLCTL_NO_DLACTIVEXCTLS
                                        | ComConstants.DLCTL_NO_RUNACTIVEXCTLS
                                        | ComConstants.DLCTL_DLIMAGES;
                    ndbControl.DlControl = filter;

                    // URLパターン
                    // Page1: http://textream.yahoo.co.jp/message/1002432/2432?page=2&sort=d&feel=99
                    // Page2: http://textream.yahoo.co.jp/message/1008136/a55a5sa5ja5aa?page=2&sort=d&feel=99
                    //または、
                    // Page(最新): http://textream.yahoo.co.jp/message/1002432/2432

                    //sw.Start();
                    if (!ndb.NavigateAndWait(url)) {
                        console.AppendText("（｡・-・）失敗ｼﾀﾖｳﾀﾞ...もう一回やって！" + Form1.csCrLf);
                        return -1;
                    }
                    //sw.Stop();
                    //this.textBox2.AppendText("DL時間2：" + sw.ElapsedMilliseconds + csCrLf);
                    HtmlDocument doc = ndb.Document;

                    console.AppendText("（ *´∀｀） ｱﾘｶﾞﾄｳ ぼくらのTextream! " + doc.Title.ToString() + Form1.csCrLf);

                    // テーブル内の文字列を構造体に格納する
                    // タイトル一覧はHTMLの四重にネストされたテーブル配下にある.
                    int tblCnt = 0;
                    int rowCnt = 0;
                    string className = "";
                    HtmlElement elm = null;
                    HtmlElement elm2 = null;
                    HtmlElement ttl = null;
                    HtmlElement commentTxt = null;
                    HtmlElement commentThm = null;
                    HtmlElementCollection tmp = null;
                    HtmlElementCollection elms = null;
                    HtmlElementCollection elms2 = null;

                    // title no :  .commentBox > .commentTxt cf > input type=hidden name=commentInfo
                    // title no :  .commentBox > .commentTxt cf > .textArea cf > .ttl > dtタグ > spanタグ
                    // title :  .commentBox > .commentTxt cf > .textArea cf > .ttl > .commentTitle
                    // sender :  .commentBox > .commentTxt cf > .textArea cf > .ttl > .name cf
                    // emotion :  .commentBox > .commentTxt cf > .textArea cf > .ttl > .name cf > .labelEmotion
                    // sendTime :  .commentBox > .commentTxt cf > .textArea cf > .ttl > .date
                    // content :  .commentBox > .commentTxt cf > .hideDetail > detail
                    // user : .commentBox > .commentThm > aタグ 属性href user=配下
                    // userIcon : .commentBox > .commentThm
                    //sw.Start();
                    System.Console.WriteLine(url);
                    foreach (HtmlElement e in doc.GetElementsByTagName("a")) {

                        className = e.GetAttribute("className");
                        // System.Console.WriteLine(className);
                        if (className == "commentTitle") {
                            ttl = e.Parent.Parent;
                            if (ttl.GetElementsByTagName("dt").Count > 0) {
                                if (ttl.GetElementsByTagName("dt")[0].GetElementsByTagName("span").Count > 0) {
                                    context.t[rowCnt].titleNo = ttl.GetElementsByTagName("dt")[0].GetElementsByTagName("span")[0].InnerText.Replace("No.", "");
                                }
                            }

                            elm = Utils.GetElementByClassName(ttl, "commentTitle");
                            if (elm != null) context.t[rowCnt].title = elm.InnerHtml;

                            elm = Utils.GetElementByClassName(ttl, "labelEmotion", "p");
                            if (elm != null) context.t[rowCnt].emotion = elm.InnerText;

                            elm = Utils.GetElementByClassName(ttl, "name cf");
                            if (elm != null) {
                                tmp = elm.GetElementsByTagName("a");
                                if (tmp.Count > 0) {
                                    context.t[rowCnt].sender = tmp[0].InnerText;
                                } else {
                                    // A tagに存在しない場合は p タグの場合もある
                                    tmp = elm.GetElementsByTagName("p");
                                    if (tmp.Count > 0) {
                                        context.t[rowCnt].sender = tmp[0].InnerText;
                                    }
                                }
                            }

                            elm = Utils.GetElementByClassName(ttl, "date");
                            if (elm != null) context.t[rowCnt].sendTime = elm.InnerHtml;

                            commentTxt = ttl.Parent.Parent;
                            elm = Utils.GetElementByClassName(commentTxt, "detail");
                            if (elm != null) context.t[rowCnt].content = elm.InnerHtml;

                            // userIcon, user
                            commentThm = commentTxt.Parent;
                            elm = Utils.GetElementByClassName(commentThm, "commentThm", "p");
                            if (elm != null) {
                                elms2 = elm.GetElementsByTagName("img");
                                if (elms2.Count > 0) {
                                    elm2 = elms2[0];
                                    if (elm2 != null) context.t[rowCnt].userIcon = elm2.GetAttribute("src");
                                }
                                elms2 = elm.GetElementsByTagName("a");
                                if (elms2.Count > 0) {
                                    elm2 = elms2[0];
                                    if (elm2 != null) context.t[rowCnt].user =
                                        elm2.GetAttribute("href").Replace("http://textream.yahoo.co.jp/personal/history/comment?user=", "");
                                }

                            } else {
                                context.t[rowCnt].userIcon = "http://i.yimg.jp/images/mb/textream/pc/thumb02.png";
                                context.t[rowCnt].user = "";
                            }
                            rowCnt++;
                        }
                    }
                    //sw.Stop();
                    //this.textBox2.AppendText("DOM解析時間：" + sw.ElapsedMilliseconds + csCrLf);
                    if (int.Parse(context.t[0].titleNo) > int.Parse(context.maxTilteNo)) {
                        context.maxTilteNo = context.t[0].titleNo;
                    }

                    //sw.Start();
                    foreach (HtmlElement e in doc.GetElementsByTagName("A")) {
                        string href = e.GetAttribute("href"); // HREF属性の値
                        string text = e.InnerText; // リンク文字列

                        if (e.InnerText == "前のページ") {
                            context.nextPage = e.GetAttribute("href");
                            itemCnt++;
                        }
                        if (e.InnerText == "次のページ") {
                            context.prevPage = e.GetAttribute("href");
                            itemCnt++;
                        }
                        if (itemCnt == 2) break;

                    }
                    //sw.Stop();
                    //this.textBox2.AppendText("次/前ページ検索時間：" + sw.ElapsedMilliseconds + csCrLf);

                    //yahoo掲示板のその他の情報を取得する
                    if (context.comapnyName == "") {
                        GetOtherInfo(context.GetCode(), doc);


                    }
                }
                finally {
                    context.UnLock();
                    ndbControl.DlControl = now;
                }
            } else // GetTopicId() の戻り値 not 0 
            {
                console.AppendText("( ・益・)　ﾉ > ﾖｲﾖｲわかんねぇよ。" + Form1.csCrLf);
            }
            return 0;
        }

    }
}
