﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Xml;
using System.Collections;
using System.Diagnostics;

namespace カブラウザもどき
{
    /// <summary>
    /// ローカルにキャッシュしたdatファイルから
    /// ヤフー掲示板にアクセスしたときと同様のメッセージを返す
    /// </summary>
    public class GetYahooLocal : GetYahoo
    {

        public GetYahooLocal(カブラウザもどき.CurrentContext context, TextBox console, ToolStripStatusLabel console2, WebBrowserController ndbControl, Hashtable edinetlist)
        {
            this.context = context;
            this.console = console;
            this.console2 = console2;
            this.ndbControl = ndbControl;
            this.edinetlist = edinetlist;
            this.context.SetYahooInstance(this);
        }
        
        public override string GetReplyUrl(string mid)
        {
            if (context.GetCode() == "") return "";
            return "http://textream.yahoo.co.jp/message/"+context.board+"/"+context.tid+"?comment="+mid;
        }
        public override string GetThreadUrl(string mid)
        {
            //textreamではスレッド表示は廃止されたため、空文字を返す
            return "";
        }
        public override string GetBaseUrl()
        {
            if (context.GetCode() == "") return "";
            return "http://textream.yahoo.co.jp/message/" + context.board + "/" + context.tid;
        }
        public override string GetMassageUrl(string mid)
        {
            if (context.GetCode() == "") return "";
            return "http://textream.yahoo.co.jp/message/" + context.board + "/" + context.tid + "?comment=" + mid;
        }
        public string GetPostedSelf()
        {
            return "http://textream.yahoo.co.jp/personal/history/comment";
        }
        public override string GetMessageListFromUserId(string sender)
        {
            if (sender == "") return "";
            foreach (TitleLists t in context.t) {
                if (t.sender == sender) {
                    return "http://textream.yahoo.co.jp/personal/history/comment?user=" + t.user;
                }
            }
            return "";
        }
        /// <summary>
        ///　無条件にtrueを返す
        /// </summary>
        /// <param name="code"></param>
        /// <returns></returns>
        public override bool IsValidYahooCode(string code)
        {
            return true;
        }

        /// <summary>
        /// 引数のURLのメッセージコンテンツを取得する 
        /// コンテンツの内容はあらかじめ取得している事
        /// </summary>
        /// <param name="mid"></param>
        /// <returns></returns>
        public override string GetContents(string mid)
        {
            YahooSkin skin = context.GetSkin();
            skin.ContextToSkin(context);
            TitleLists thisTitle = null;
            string s = "";

            foreach (TitleLists t in context.t) {
                if (t.titleNo == mid) {
                    thisTitle = t;
                    break;
                }
            }

            if (thisTitle != null) {
                skin.set("&MESSAGE", thisTitle.content);
                skin.set("&RESURL", GetReplyUrl(mid));
                skin.set("&NUMBER", thisTitle.titleNo);
                skin.set("&TITLE", thisTitle.title);
                skin.set("&NAME", thisTitle.sender);
                skin.set("&FEELINGS", thisTitle.emotion);
                skin.set("&DATE", thisTitle.sendTime);
                skin.set("&M_FINDMSG", GetMessageListFromUserId(thisTitle.sender));
                skin.set("&M_COMMENT_THM", thisTitle.userIcon);
                
            }
            //ニックネームはひとまず置いておく
            //                            skin.set("&M_NICKNAME", e.GetAttribute("HREF").Replace("http://search.messages.yahoo.co.jp/search/?p=", ""));
            return "";
        }


        ///<summary>
        /// HTMLから投稿タイトル一覧を全部取得してファイルに保存する
        /// ローカル版は何もしない
        ///</summary>
        public override int SaveAllTitleList(string code, ref TitleLists[] t)
        {
            return 0;
        }

        /// <summary>
        ///  Yahoo掲示板のTopic ID (tid=部分)、最大TitleNo を取得する.取得値は状態変数に格納する
        ///  この値は変則で、単に銘柄コード(ex.2432)もあれば、ランダム？(8136 -> a55a5sa5jaaa) 
        ///  パターンもある。
        ///  ・textreamの場合はどこからTIDを取ってくればいいのかわからない！
        ///  　とりあえず、固定値を使用する。
        ///  　存在しない場合は銘柄コードで推定する。
        /// </summary>
        /// <param name="isCheckLock">使用しない</param>
        /// <returns>0:正常 -1:異常</returns>
        public override int GetTopicId(string code, bool isCheckLock)
        {
            int ret = -1;
            if (edinetlist.ContainsKey(code)) {
                context.tid = ((string)edinetlist[code]).Split(',')[3];
            }
            if (context.tid != "") {
                ret = 0;
            } else {
                context.tid = code;
            }
            return ret;
        }

        /// <summary>
        ///  Yahoo掲示板のその他の情報を取得する
        ///  HtmlDocument docには正常なDocumentオブジェクトを渡すこと.
        ///  此処ではチェックしない
        ///  セットする値(context):  codeAndExchange, comapnyName
        ///  セットする値(yahoo):  &DATE, &CLOSE, &CHANGE 
        /// </summary>
        /// <returns>0:正常 -1:異常</returns>
        public override void GetOtherInfo(string code, HtmlDocument doc)
        {

            try {
                // IMG用の市場コードを含んだ銘柄コード
                foreach (HtmlElement e in doc.GetElementsByTagName("IMG")) {
                    string sLink = e.GetAttribute("src");
                    try {
                        if (sLink.Length >= 36 && (sLink.Substring(0, 30) == "http://rchart.yahoo.co.jp/t?s=" ||
                                                   sLink.Substring(0, 30) == "http://gchart.yahoo.co.jp/t?s=")) {
                            string tmp = sLink.ToString().Substring(30, sLink.Length - 30);
                            context.SetCodeAndExchange(tmp.Split('&')[0]);
                            break;
                        }
                    }
                    catch (NullReferenceException exp) {
                        context.SetCodeAndExchange("");
                    }
                }

            }
            catch (IndexOutOfRangeException e) {
                console.AppendText(e.ToString() + Form1.csCrLf);
            }
            catch (NullReferenceException e) {
                console.AppendText(e.ToString() + Form1.csCrLf);
            }
            return ;
        }
        public override int GetSid(string code)
        {
            int ret = -1;
            if (edinetlist.ContainsKey(code)) {
                context.sid = ((string)edinetlist[code]).Split(',')[2];
            }

            if (context.sid != "") {
                ret = 0;
            } else {
                context.sid = "100" + code;
            }
            return ret;
        }
        public override int GetBorad(string code)
        {
            int ret = -1;
            if (edinetlist.ContainsKey(code)) {
                context.board = ((string)edinetlist[code]).Split(',')[1];
            }
            if (context.board != "") {
                ret = 0;
            } else {
                context.board = "100" + code;
            }
            return ret;
        }

        /// <summary>
        /// contextを仲介せず直接TreeViewに書き込むため、Form1で実装
        /// </summary>
        /// <param name="longCode"></param>
        /// <param name="mid">中心となるMessageIdを指定する（前後20件を表示）</param>
        /// <returns></returns>
        public int GetTitleLists(string longCode, string mid)
        {
            return 0;
        }


    }
}
