﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Web;
using System.Threading;
using System.Xml;
using System.Collections;
using System.Diagnostics;

namespace カブラウザもどき
{
    /// <summary>
    /// このアプリケーションの実行には.NET Framework 3.5が必要です。
    /// http://www.microsoft.com/downloads/ja-jp/details.aspx?displaylang=ja&FamilyID=0a391abd-25c1-4fc0-919f-b21f31ab88b7
    /// </summary>
    public partial class Form1 : Form 
    {
        #region クラス変数
        /// <summary>
        /// このアプリ内の改行文字
        /// </summary>
        public const string csCrLf = "\r\n";
        /// <summary>
        /// タイトル一覧（xxxx.dat）ファイルの格納場所
        /// </summary>
        public const string csDatDir = @".\Logs\kabu\";  // datファイル格納
        /// <summary>
        /// 無視リスト一覧
        /// </summary>
        public const string csNGFile = @".\NGName.txt";  // 無視リスト
        /// <summary>
        /// カブラウザのコード一覧（code.lst）の場所
        /// </summary>
        public const string csCDFile = @".\code.lst";
        /// <summary>
        /// カブラウザのコード一覧（edinet.lst）の場所
        /// </summary>
        public const string csEDIFile = @".\edinet.lst";
        /// <summary>
        /// 初期設定ファイル（殆ど空）
        /// </summary>
        public const string csIniFile = @".\kabu.ini";
        /// <summary>
        /// 既読リスト
        /// </summary>
        public const string csSaveFile = @".\Logs\save.dat";

        public string needEdinetDoc = "";  // EDINET確認書類
        public int execMode = 0;
        private uint maxRow;
        // 2013.2.24 textream対応 start
        //private GetYahoo yahoo;
        private AbstractGetYahoo yahoo;
        // 2013.2.24 textream対応 end
        private KVisited visited = new KVisited();

        private static CurrentContext context = null;     // 表示中の銘柄を管理する構造体(このアプリの肝)
        private Hashtable edinetlist = new Hashtable();   // EDINETコードリスト
        private Hashtable ignorelist = new Hashtable();   // 無視リスト
        private Hashtable emphasislist = new Hashtable(); // ignorelistと同じ（灰色表示に使う）
        private Hashtable markline = new Hashtable();   // ここまで読んだ
        public static char delimiter = char.Parse(Char.ConvertFromUtf32(128));  // xxxx.datファイルの区切り文字(絶対に使用されていない文字)
        private static char tvdelimiter = '　';                  // TreeViewに表示した銘柄のコードと銘柄名称の区切り文字
        private static NonDispBrowser ndb = new NonDispBrowser();  // 裏で動く非表示のブラウザ(ActiveX制御あり)
        private WebBrowserController ndbControl = new WebBrowserController(ndb);

        private enum ImageList  // アイコンリスト
        {
            CloseFolder = 0, OpenFolder = 1, File = 2, Search = 3, Note = 4, Reply = 5, AllGet = 6,
            DailyRank = 7, WeeklyRank = 8, MonthlyRank = 9, TextSearch = 10, NGOn = 11, NGOff = 12
        };

        private enum ImageListSub  // アイコンリスト
        {
            Short = 0, Think = 1, Timely = 2, News = 3, Edinet= 4, Setting = 5,
            Back = 6, Ahead = 7
        };

        private Hashtable ColorList = new Hashtable(); // このシステムの色リスト

        private SettingForm child = null;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public Form1()
        {
            InitializeComponent();
        }

        #endregion

        #region 初期化

        /**
         * 
         * Formを初期化する
         * 
         */
        private void Form1_Load(object sender, EventArgs e)
        {
            this.Text = "カブラウザもどき";

            // メッセージ
            this.textBox2.AppendText("( ･∀･)ﾉ > きどうちゅうθ" + csCrLf);

            // メニューの初期化
            MenuInit();

            // kabu.iniファイル読込み
            //if (!LoadIniFile()) return ;
            LoadIniFile();

            // ツールストリップ初期化
            ToolStripInit();

            // リストビュー初期化
            ListViewInit();

            // TreeView初期化
            this.treeView1.Nodes.Clear();
            this.treeView1.ImageList = imageList1;
            LoadCodeList();
            this.treeView1.AllowDrop = true;
            this.treeView1.LabelEdit = true;
            // ダミーを最低1つはぶら下げる
            if (this.treeView1.Nodes.Count == 0)
            {
                TreeNode tn = new TreeNode("フォルダ１");
                tn.Name = "フォルダ１";
                tn.ImageIndex = (int)ImageList.CloseFolder;
                this.treeView1.Nodes.Add(tn);
            }

            // EDINETコード読込み
            LoadEDIList();

            // TextBox関連
            this.textBox3.Enabled = false;
            this.textBox4.Enabled = false;

            // Yahoo掲示板クラスをインスタンス化
            yahoo = new GetYahooTextream(context, this.textBox2, this.toolStripStatusLabel1, ndbControl, edinetlist);

        }

        private void SwitchBrowseAndNavigate(string url)
        {
            this.webBrowser2.Visible = false;
            this.webBrowser1.Visible = true;
            this.webBrowser1.NavigateAndWait(url);
        }

        /// <summary>
        /// StripMenuを初期化する
        /// </summary>
        private void MenuInit()
        {
            //  ListViewに表示するメニュー
            ContextMenuStrip menu_listview = new ContextMenuStrip();
            ToolStripMenuItem menu_listview_1 = new ToolStripMenuItem();
//            ToolStripMenuItem menu_listview_2 = new ToolStripMenuItem();
            ToolStripMenuItem menu_listview_3 = new ToolStripMenuItem();
            ToolStripMenuItem menu_listview_4 = new ToolStripMenuItem();
            ToolStripMenuItem menu_listview_5 = new ToolStripMenuItem();
            ToolStripMenuItem menu_listview_6 = new ToolStripMenuItem();
            ToolStripMenuItem menu_listview_7 = new ToolStripMenuItem();
            ToolStripMenuItem menu_listview_8 = new ToolStripMenuItem();
            ToolStripMenuItem menu_listview_9 = new ToolStripMenuItem();

            menu_listview_1.Text = "返信";
            menu_listview_1.Click += delegate
            {
                if (listView1.SelectedItems != null && listView1.SelectedItems.Count > 0)
                {
                    string mid = listView1.SelectedItems[0].Text;
                    SwitchBrowseAndNavigate(yahoo.GetReplyUrl(mid));
                }
            };
/* 2013.2.24 textream対応 start 
 * スレッド表示は廃止
            menu_listview_2.Text = "スレッドを表示";
            menu_listview_2.Click += delegate
            {
                if (listView1.SelectedItems != null && listView1.SelectedItems.Count > 0)
                {
                    string mid = listView1.SelectedItems[0].SubItems[0].Text;
                    SwitchBrowseAndNavigate(yahoo.GetThreadUrl(mid));
                }
            };
 */

            menu_listview_3.Text = "前のページを表示";
            menu_listview_3.Click += delegate
            {
                // 2013/2/24 textream対応 start
                //GetTitleListsFromHtml(context.GetCode(), -1);
                yahoo.GetTitleLists(context.GetCode(), -1);
                // 2013/2/24 textream対応 end
                RedisplayListView();
            };

            menu_listview_4.Text = "次のページを表示";
            menu_listview_4.Click += delegate
            {
                // 2013/2/24 textream対応 start
                //GetTitleListsFromHtml(context.GetCode(), 1);
                yahoo.GetTitleLists(context.GetCode(), 1);
                // 2013/2/24 textream対応 end
                RedisplayListView();
            };

            menu_listview_5.Text = "無視リストに入れる";
            menu_listview_5.Click += delegate
            {
                if (listView1.SelectedItems != null && listView1.SelectedItems.Count > 0)
                {
                    string tmpSender = listView1.SelectedItems[0].SubItems[2].Text;
                    InsertNGName(tmpSender);
                    LoadNGName();
                    this.toolStrip1.Items[0].ImageIndex = (int)ImageList.NGOn;
                    RedisplayListView();
                }
            };

            menu_listview_6.Text = "無視リストから消去する";
            menu_listview_6.Click += delegate
            {
                if (listView1.SelectedItems != null && listView1.SelectedItems.Count > 0)
                {
                    string tmpSender = listView1.SelectedItems[0].SubItems[2].Text;
                    RemoveNGName(tmpSender);
                    RedisplayListView();
                }
            };

            menu_listview_7.Text = "ブラウザで表示する";
            menu_listview_7.Click += delegate
            {
                if (listView1.SelectedItems != null && listView1.SelectedItems.Count > 0)
                {
                    string mid = listView1.SelectedItems[0].SubItems[0].Text;
                    // 2013/2/24 textream 対応 start
                    //string url = "http://messages.yahoo.co.jp/bbs?.mm=FN&action=m&board=1" + context.GetPad() + context.GetCode() + "&tid=" + context.tid + "&sid=1" + context.GetPad() + context.GetCode() + "&mid=" + mid;
                    string url = "http://textream.yahoo.co.jp/message/" + context.board + "/" + context.tid;
                    // 2013/2/24 textream 対応 end
                    Process.Start("IExplore.exe", url);
                }
            };

            menu_listview_8.Text = "ここまで読んだ";
            menu_listview_8.Click += delegate
            {
                if (listView1.SelectedItems != null && listView1.SelectedItems.Count > 0)
                {
                    string mid = listView1.SelectedItems[0].SubItems[0].Text;
                    markline[context.GetCode()] = mid;
                    listView1.SelectedItems[0].BackColor = Color.LightPink;
                    listView1.SelectedItems[0].SubItems[1].BackColor = Color.LightPink;
                    listView1.SelectedItems[0].SubItems[2].BackColor = Color.LightPink;
                    listView1.SelectedItems[0].SubItems[3].BackColor = Color.LightPink;
                    listView1.SelectedItems[0].SubItems[4].BackColor = Color.LightPink;
                    listView1.SelectedItems[0].SubItems[5].BackColor = Color.LightPink;
                }
            };

            menu_listview_9.Text = "他の投稿を検索する";
            menu_listview_9.Click += delegate
            {
                if (listView1.SelectedItems != null && listView1.SelectedItems.Count > 0) {

                    string mid = listView1.SelectedItems[0].Text;
                    //DisplaySelectedContents();
                    this.statusStrip1.ContextMenuStrip.Text = context.GetSkin().get("&M_FINDMSG");
                    if (context.GetSkin().get("&M_FINDMSG") != "") {
                        SwitchBrowseAndNavigate(context.GetSkin().get("&M_FINDMSG"));
                    } else {
                        MessageBox.Show("URLが取得できませんでした。");
                    }
                }
            };
            menu_listview.Items.Add(menu_listview_1);
//            menu_listview.Items.Add(menu_listview_2);
            menu_listview.Items.Add(menu_listview_3);
            menu_listview.Items.Add(menu_listview_4);
            menu_listview.Items.Add("-");
            menu_listview.Items.Add(menu_listview_5);
            menu_listview.Items.Add(menu_listview_6);
            menu_listview.Items.Add("-");
            menu_listview.Items.Add(menu_listview_8);
            menu_listview.Items.Add("-");
            menu_listview.Items.Add(menu_listview_7);
            menu_listview.Items.Add(menu_listview_9);

            //  TreeViewに表示するメニュー
            ContextMenuStrip menu_on_company = new ContextMenuStrip();
            ContextMenuStrip menu_on_folder = new ContextMenuStrip();
            ToolStripMenuItem menuCP1 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP2 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP3 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP4 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP5 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP6 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP7 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP8 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP9 = new ToolStripMenuItem();


            ToolStripMenuItem menuCP10 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP11 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP12 = new ToolStripMenuItem();

            menuCP1.Text = "銘柄コード作成";
            menuCP2.Text = "削除";
            menuCP2.Click += delegate
            {

                if (MessageBox.Show("削除しますがよろしいですか？",
                    "確認",
                    MessageBoxButtons.YesNo,
                    MessageBoxIcon.Question,
                    MessageBoxDefaultButton.Button2) == DialogResult.Yes)
                {
                    TreeNode tn = treeView1.SelectedNode;
                    tn.Remove();
                }
            };
            menuCP3.Text = "フォルダ作成";
            menuCP3.Click += delegate
            {
                TreeNode tn = new TreeNode();
                treeView1.Nodes.Add(tn);
                treeView1.SelectedNode = tn;
                treeView1.Focus();
                if (treeView1.SelectedNode != null)
                {
                    treeView1.LabelEdit = true;
                    treeView1.SelectedNode.BeginEdit();
                }
            };
            menuCP4.Text = "チャート表示";
            menuCP4.Click += delegate
            {
                if (treeView1.SelectedNode != null && treeView1.SelectedNode.ImageIndex == (int)ImageList.File && treeView1.SelectedNode.Name.Length >= 4)
                {
                    string code = treeView1.SelectedNode.Name;
                    SwitchBrowseAndNavigate(yahoo.GetHalfYearChartUrl());
                }
            };
            menuCP5.Text = "ニュース表示";
            menuCP5.Click += delegate
            {
                if (treeView1.SelectedNode != null && treeView1.SelectedNode.ImageIndex == (int)ImageList.File && treeView1.SelectedNode.Name.Length >= 4)
                {
                    string code = treeView1.SelectedNode.Name;
                    SwitchBrowseAndNavigate(yahoo.GetNewsUrl());
                }
            };
            menuCP6.Text = "企業情報を表示";
            menuCP6.Click += delegate
            {
                if (treeView1.SelectedNode != null && treeView1.SelectedNode.ImageIndex == (int)ImageList.File && treeView1.SelectedNode.Name.Length >= 4)
                {
                    string code = treeView1.SelectedNode.Name;
                    SwitchBrowseAndNavigate(yahoo.GetCompanyInfo());
                }
            };

            menuCP7.Text = "保存する";
            menuCP7.Click += delegate
            {
                SaveCodeList();
                MessageBox.Show("code.lstに保存しました。");
            };

            menuCP8.Text = "ブラウザで表示する";
            menuCP8.Click += delegate
            {
                if (treeView1.SelectedNode != null && treeView1.SelectedNode.ImageIndex == (int)ImageList.File && treeView1.SelectedNode.Name.Length >= 4)
                {
                    string code = this.treeView1.SelectedNode.Name;
                    // 2013/2/24 textream対応 start
                    //string url = "http://messages.yahoo.co.jp/bbs?action=topics&board=1" + context.GetPad() + code + "&sid=1" + context.GetPad() + code + "";
                    string url = "http://textream.yahoo.co.jp/message/" + context.board + "/" + context.tid ;
                    // 2013/2/24 textream対応 end
                    Process.Start("IExplore.exe", url);
                }
            };

            menuCP9.Text = "編集";
            menuCP9.Click += delegate
            {
                TreeNode tn = treeView1.SelectedNode;
                treeView1.LabelEdit = true;
                if (tn != null && treeView1.LabelEdit )
                {
                    tn.BeginEdit();
                }
            };

            menuCP10.Text = "全て展開する";
            menuCP10.Click += delegate
            {
                foreach (TreeNode tn in treeView1.Nodes)
                {
                    if (tn.Parent == null) tn.Expand();
                }
            };

            menuCP11.Text = "全て閉じる";
            menuCP11.Click += delegate
            {
                foreach (TreeNode tn in treeView1.Nodes)
                {
                    if (tn.Parent == null) tn.Collapse();
                }
            };

            menuCP12.Text = "自分の投稿";
            menuCP12.Click += delegate
            {
                string url = yahoo.GetPostedSelf();
                Process.Start("IExplore.exe", url);
            };

            menu_on_folder.Items.Add(menuCP1);
            menu_on_folder.Items.Add(menuCP2);

            menu_on_company.Items.Add(menuCP4);
            menu_on_company.Items.Add(menuCP5);
            menu_on_company.Items.Add(menuCP6);
            menu_on_company.Items.Add(menuCP8);

            menu_on_company.Items.Add("-");
            menu_on_company.Items.Add(menuCP3);
            menu_on_company.Items.Add(menuCP2);
            menu_on_company.Items.Add(menuCP9);

            menu_on_company.Items.Add("-");
            menu_on_company.Items.Add(menuCP10);
            menu_on_company.Items.Add(menuCP11);
            menu_on_company.Items.Add(menuCP7);

            menu_on_company.Items.Add("-");
            menu_on_company.Items.Add(menuCP12);


            ContextMenuStrip menu_on_status = new ContextMenuStrip();
            ToolStripMenuItem menuST1 = new ToolStripMenuItem();
            menuST1.Text = "URLをコピーする";
            menuST1.Click += delegate
            {
                Clipboard.SetText(this.toolStripStatusLabel1.Text);
            };
            menu_on_status.Items.Add(menuST1);

            this.contextMenuStrip1 = menu_on_company;
            this.contextMenuStrip2 = menu_listview;
            this.contextMenuStrip3 = menu_on_folder;
            this.contextMenuStrip4 = menu_on_status;
            this.treeView1.ContextMenuStrip = menu_on_company;
            this.listView1.ContextMenuStrip = menu_listview;
            this.statusStrip1.ContextMenuStrip = menu_on_status;

            return;
        }


        /// <summary>
        /// ToolStripを初期化する
        /// </summary>
        private void ToolStripInit()
        {
            // 
            // toolStripButton1
            //
            ToolStripButton toolStripButton1 = new System.Windows.Forms.ToolStripButton();
            toolStripButton1.Alignment = ToolStripItemAlignment.Left;
            toolStripButton1.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton1.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            toolStripButton1.ImageIndex = (int)ImageList.Search;
            toolStripButton1.Name = "toolStripButton1";
            toolStripButton1.Text = "検索";
            toolStripButton1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            toolStripButton1.Click += new System.EventHandler(this.toolStripButton1_Click);
            // 
            // toolStripButton2
            // 
            ToolStripButton toolStripButton2 = new System.Windows.Forms.ToolStripButton();
            toolStripButton2.Alignment = ToolStripItemAlignment.Right;
            toolStripButton2.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton2.ImageIndex = (int)ImageList.Note;
            toolStripButton2.Name = "toolStripButton2";
            toolStripButton2.Text = "書込";
            toolStripButton2.Click += new System.EventHandler(this.toolStripButton2_Click);
            // 
            // toolStripButton3
            // 
            ToolStripButton toolStripButton3 = new System.Windows.Forms.ToolStripButton();
            toolStripButton3.Alignment = ToolStripItemAlignment.Right;
            toolStripButton3.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton3.ImageIndex = (int)ImageList.Reply;
            toolStripButton3.Name = "toolStripButton3";
            toolStripButton3.Text = "返信";
            toolStripButton3.Click += new System.EventHandler(this.toolStripButton3_Click);
            // 
            // toolStripButton4
            // 
            ToolStripButton toolStripButton4 = new System.Windows.Forms.ToolStripButton();
            toolStripButton4.Alignment = ToolStripItemAlignment.Right;
            toolStripButton4.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton4.ImageIndex = (int)ImageList.TextSearch;
            toolStripButton4.Name = "toolStripButton4";
            toolStripButton4.Text = "全文検索";
            toolStripButton4.Click += new System.EventHandler(this.toolStripButton4_Click);

            // 
            // toolStripButton5
            // 
            ToolStripButton toolStripButton5 = new System.Windows.Forms.ToolStripButton();
            toolStripButton5.Alignment = ToolStripItemAlignment.Right;
            toolStripButton5.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton5.ImageIndex = (int)ImageList.AllGet;
            toolStripButton5.Name = "toolStripButton5";
            toolStripButton5.Text = "全タイトル取得";
            toolStripButton5.Click += new System.EventHandler(this.toolStripButton5_Click);

            // 
            // toolStripButton6
            // 
            ToolStripButton toolStripButton6 = new System.Windows.Forms.ToolStripButton();
            toolStripButton6.Alignment = ToolStripItemAlignment.Right;
            toolStripButton6.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton6.ImageIndex = (int)ImageList.DailyRank;
            toolStripButton6.Name = "toolStripButton6";
            toolStripButton6.Text = "日次ランキング";
            toolStripButton6.Click += new System.EventHandler(this.toolStripButton6_Click);
            // 
            // toolStripButton7
            // 
            ToolStripButton toolStripButton7 = new System.Windows.Forms.ToolStripButton();
            toolStripButton7.Alignment = ToolStripItemAlignment.Right;
            toolStripButton7.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton7.ImageIndex = (int)ImageList.WeeklyRank;
            toolStripButton7.Name = "toolStripButton7";
            toolStripButton7.Text = "週次ランキング";
            toolStripButton7.Click += new System.EventHandler(this.toolStripButton7_Click);
            // 
            // toolStripButton8
            // 
            ToolStripButton toolStripButton8 = new System.Windows.Forms.ToolStripButton();
            toolStripButton8.Alignment = ToolStripItemAlignment.Right;
            toolStripButton8.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton8.ImageIndex = (int)ImageList.MonthlyRank;
            toolStripButton8.Name = "toolStripButton8";
            toolStripButton8.Text = "月次ランキング";
            toolStripButton8.Click += new System.EventHandler(this.toolStripButton8_Click);

            // 
            // toolStripButton9
            // 
            ToolStripButton toolStripButton9 = new System.Windows.Forms.ToolStripButton();
            toolStripButton9.Alignment = ToolStripItemAlignment.Right;
            toolStripButton9.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton9.ImageIndex = (int)ImageList.NGOn;
            toolStripButton9.Name = "toolStripButton9";
            toolStripButton9.Text = "無視リストの表示を切替";
            toolStripButton9.Click += new System.EventHandler(this.toolStripButton9_Click);

            // 
            // toolStripButton10
            // 
            ToolStripButton toolStripButton10 = new System.Windows.Forms.ToolStripButton();
            toolStripButton10.Alignment = ToolStripItemAlignment.Right;
            toolStripButton10.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton10.ImageIndex = (int)ImageListSub.Short;
            toolStripButton10.Name = "toolStripButton10";
            toolStripButton10.Text = "空売り残高を表示";
            toolStripButton10.Click += new System.EventHandler(this.toolStripButton10_Click);

            // 
            // toolStripButton11
            // 
            ToolStripButton toolStripButton11 = new System.Windows.Forms.ToolStripButton();
            toolStripButton1.Alignment = ToolStripItemAlignment.Right;
            toolStripButton11.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton11.ImageIndex = (int)ImageListSub.Think;
            toolStripButton11.Name = "toolStripButton11";
            toolStripButton11.Text = "考える株式投資";
            toolStripButton11.Click += new System.EventHandler(this.toolStripButton11_Click);

            // 
            // toolStripButton12
            // 
            ToolStripButton toolStripButton12 = new System.Windows.Forms.ToolStripButton();
            toolStripButton1.Alignment = ToolStripItemAlignment.Right;
            toolStripButton12.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton12.ImageIndex = (int)ImageListSub.Timely;
            toolStripButton12.Name = "toolStripButton12";
            toolStripButton12.Text = "東証適時開示システム";
            toolStripButton12.Click += new System.EventHandler(this.toolStripButton12_Click);

            // 
            // toolStripButton13
            // 
            ToolStripButton toolStripButton13 = new System.Windows.Forms.ToolStripButton();
            toolStripButton13.Alignment = ToolStripItemAlignment.Right;
            toolStripButton13.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton13.ImageIndex = (int)ImageListSub.News;
            toolStripButton13.Name = "toolStripButton13";
            toolStripButton13.Text = "Yahooニュース検索";
            toolStripButton13.Click += new System.EventHandler(this.toolStripButton13_Click);

            // 
            // toolStripButton14
            // 
            ToolStripButton toolStripButton14 = new System.Windows.Forms.ToolStripButton();
            toolStripButton14.Alignment = ToolStripItemAlignment.Right;
            toolStripButton14.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton14.ImageIndex = (int)ImageListSub.Edinet;
            toolStripButton14.Name = "toolStripButton14";
            toolStripButton14.Text = "EDINET";
            toolStripButton14.Click += new System.EventHandler(this.toolStripButton14_Click);

            // 
            // toolStripButton15
            // 
            ToolStripButton toolStripButton15 = new System.Windows.Forms.ToolStripButton();
            toolStripButton15.Alignment = ToolStripItemAlignment.Right;
            toolStripButton15.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton15.ImageIndex = (int)ImageListSub.Setting;
            toolStripButton15.Name = "toolStripButton15";
            toolStripButton15.Text = "設定";
            toolStripButton15.Click += new System.EventHandler(this.toolStripButton15_Click);

            // 
            // toolStripButton16
            // 
            ToolStripButton toolStripButton16 = new System.Windows.Forms.ToolStripButton();
            toolStripButton16.Alignment = ToolStripItemAlignment.Right;
            toolStripButton16.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton16.ImageIndex = (int)ImageListSub.Back;
            toolStripButton16.Name = "toolStripButton16";
            toolStripButton16.Text = "前のページ";
            toolStripButton16.Click += new System.EventHandler(this.toolStripButton16_Click);

            // 
            // toolStripButton17
            // 
            ToolStripButton toolStripButton17 = new System.Windows.Forms.ToolStripButton();
            toolStripButton17.Alignment = ToolStripItemAlignment.Right;
            toolStripButton17.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton17.ImageIndex = (int)ImageListSub.Ahead;
            toolStripButton17.Name = "toolStripButton17";
            toolStripButton17.Text = "次のページ";
            toolStripButton17.Click += new System.EventHandler(this.toolStripButton17_Click);

            this.toolStrip1.ImageList = imageList1;
            toolStrip1.Items.Add(toolStripButton9);
            toolStrip1.Items.Add(toolStripButton8);
            toolStrip1.Items.Add(toolStripButton7);
            toolStrip1.Items.Add(toolStripButton6);
            toolStrip1.Items.Add(toolStripButton5);
            toolStrip1.Items.Add(toolStripButton4);
            toolStrip1.Items.Add(toolStripButton3);
            toolStrip1.Items.Add(toolStripButton2);
            toolStrip1.Items.Add(toolStripButton1);

            //上級モード
            if (execMode == 1) {
                this.toolStrip2.ImageList = imageList2;
                this.toolStrip2.Items.Add(toolStripButton14);
                //this.toolStrip2.Items.Add(toolStripButton13);
                this.toolStrip2.Items.Add(toolStripButton12);
                this.toolStrip2.Items.Add(toolStripButton10);
                this.toolStrip2.Items.Add(toolStripButton11);
                this.toolStrip2.Visible = true;
                this.textBox5.Visible = true;
                this.label4.Visible = true;

            } else {

                this.toolStrip2.Visible = false;
                this.textBox5.Visible = false;
                this.label4.Visible = false;
            }

            
            this.toolStrip3.ImageList = imageList2;
            this.toolStrip3.Items.Add(toolStripButton15);

            this.toolStrip4.ImageList = imageList2;
            this.toolStrip4.Items.Add(toolStripButton17);
            this.toolStrip4.Items.Add(toolStripButton16);

            
        }


        /// <summary>
        /// ListViewを初期化する
        /// </summary>
        private void ListViewInit()
        {
            // **************   ここからListviewの設定
            //一覧表示
            this.listView1.View = View.Details;
            this.listView1.GridLines = true;

            // ヘッダ追加
            this.listView1.Columns.Add("No.", 70, HorizontalAlignment.Left);
            this.listView1.Columns.Add("メッセージ", 300, HorizontalAlignment.Left);
            this.listView1.Columns.Add("投稿者", 150, HorizontalAlignment.Left);
            this.listView1.Columns.Add("投稿時の気持ち", 150, HorizontalAlignment.Left);
            this.listView1.Columns.Add("投稿時間", 150, HorizontalAlignment.Left);
            this.listView1.Columns.Add("", 300, HorizontalAlignment.Left);  // 右端ダミー
            this.listView1.FullRowSelect = true;

            // 無視リスト読込み
            LoadNGName();

            this.ColorList["Visited"] = Color.MediumVioletRed;
            this.ColorList["NonVisited"] = Color.Blue;
            this.ColorList["BackGround"] = Color.Cornsilk;
            this.ColorList["Ignore"] = Color.SlateGray;
        
        }

        #endregion

        # region 設定ファイル

        /// <summary>
        /// iniファイルを読み込む
        /// </summary>
        private bool LoadIniFile()
        {
            StringBuilder sb = new StringBuilder(1024);

            // 動作モード
            this.execMode = (int)IniFileHandler.GetPrivateProfileInt("Application", "ExecMode", 0, csIniFile);

            // タイトルリスト
            this.maxRow = IniFileHandler.GetPrivateProfileInt("TitleList", "PrefetchRow", 0, csIniFile);
            context = new CurrentContext(maxRow);

            // skin
            IniFileHandler.GetPrivateProfileString("Application", "Skin", "sample.html", sb, (uint)sb.Capacity, csIniFile);
            context.SetSkin(new YahooSkin(sb.ToString()));

            // EDINET確認書類
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument1", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + "," ;
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument2", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument3", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument4", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument5", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument6", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument7", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument8", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument9", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument10", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument11", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument12", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument13", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument14", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument15", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument16", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument17", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument18", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument19", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument20", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument21", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument22", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument23", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument24", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument25", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument26", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument27", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument28", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument29", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";

            // NGName.txt, code.lstファイルチェック
            if (!File.Exists( csNGFile ) && !File.Exists(csCDFile)) {

                if (MessageBox.Show("カレントフォルダにNGName.txtとcode.lstが存在しません。\n\nカブラウザをお使いだった場合は、この２ファイルをコピーして\n再立ち上げして下さい。お使いでない場合は、\n２ファイルを新規に作成します。\n\n作成しますか？",
                    "確認",
                    MessageBoxButtons.YesNo,
                    MessageBoxIcon.Question,
                    MessageBoxDefaultButton.Button2) == DialogResult.Yes) 
                {
                    File.Create(csNGFile).Close();
                    File.Create(csCDFile).Close();
                } else {
                    return false;
                }
            }
            return true;
        }

        /**
         * カブラウザの設定ファイルであるcode.lstを読み込んでTreeViewを作成する 
         */
        public void LoadCodeList()
        {
            string path = csCDFile;
            List<int> expandes = new List<int>(); 

            if (!File.Exists(path)) return;

            this.textBox2.AppendText("( ･∀･)ﾉ > code.lstよみ込み" + csCrLf);
            using (StreamReader sr = new StreamReader(path, Encoding.GetEncoding("Shift_JIS")))
            {
                string contents;
                string line;
                string folder = "";
                string[] column;
                int tnFolderIndex = 0;

                contents = sr.ReadToEnd();
                sr.Close();

                StringReader sr2 = new StringReader(contents);
                while ((line = sr2.ReadLine()) != null)
                {
                    column = line.Split('\t');
                    if (column.Length > 1 && column[0] != "" && column[1] != "") {

                        //フォルダ
                        if (column[0] == "1" || column[0] == "0")
                        {
                            tnFolderIndex = AddCompanyCodeList(column[1], "", "", false);
                            if ( column[0] == "1") {
                                expandes.Add(tnFolderIndex);
                            }
                            folder = column[1];
                        } else {

                            AddCompanyCodeList(folder, column[0] + tvdelimiter + column[1], column[0], false);
                        }
                    }
                }
                foreach (int exp in expandes)
                {
                    treeView1.Nodes[exp].Expand();
                }
                expandes = null;
            }
        }

        /**
         * 銘柄コードとＥＤＩＮＥＴコードを紐付けるedinet.lstを読み込む 
         * 
         * 2013/2/24　拡張 Yahoo掲示板の Board, Tid, Sidをここで持つ
         * フォーマット
         * code edicode,borad,sid,tid
         * 
         */
        public void LoadEDIList()
        {
            string path = csEDIFile;
            List<int> expandes = new List<int>();

            if (!File.Exists(path)) return;

            this.textBox2.AppendText("( ･∀･)ﾉ > edinet.lstよみ込み" + csCrLf);
            using (StreamReader sr = new StreamReader(path))
            {
                string contents;
                string line;
                string[] column;

                contents = sr.ReadToEnd();
                sr.Close();

                StringReader sr2 = new StringReader(contents);
                while ((line = sr2.ReadLine()) != null)
                {
                    column = line.Split('\t');
                    if (column.Length > 1 && column[0] != "" && column[1] != "")
                    {
                        edinetlist[column[0]] = column[1];
                    }
                }
            }
        }
        
        /**
         * カブラウザの設定ファイルであるcode.lstを保存する 
         */
        public void SaveCodeList()
        {
            string path = csCDFile;
            this.textBox2.AppendText("( ･∀･)ﾉ > code.lst書き込み" + csCrLf);

            using (StreamWriter sw = new StreamWriter(path, false, System.Text.Encoding.GetEncoding("Shift_JIS")))
            {
                string code = "";
                string name = "";
                foreach (TreeNode tn in treeView1.Nodes)
                {
                    // フォルダの場合は配下の銘柄コードを全て保存
                    if (tn.ImageIndex == (int)ImageList.OpenFolder || tn.ImageIndex == (int)ImageList.CloseFolder)
                    {
                        code = (tn.IsExpanded) ? "1": "0"; 
                        name = tn.Text;
                        sw.WriteLine(code + "\t" + name);

                        // コード＋銘柄名称
                        foreach (TreeNode child in tn.Nodes)
                        {
                            code = child.Name;
                            name = child.Text.Replace(child.Name, "");
                            name = name.Trim();
                            sw.WriteLine(code + "\t" + name);
                        }
                    } else {

                        // 銘柄コードがRootにダイレクトに配置されている
                        string result ;
                        if (IsRegularCode(tn.Name, out result))
                        {
                            code = tn.Name;
                            name = tn.Text.Replace(tn.Name, "");
                            name = name.Trim();
                            sw.WriteLine(code + "\t" + name);
                        }
                    }
                }
                sw.Close();
            }
        }

        #endregion

        # region メニューストリップ

        /// <summary>
        /// senderを無視リストに入れる
        /// </summary>
        /// <param name="sender"></param>
        private void InsertNGName(string sender)
        {
            if (!File.Exists(csNGFile))
            {
                MessageBox.Show("NGName.txtが存在しません。再度アプリケーションを立ち上げなおして、\nNGName.txtを作成してください。");
                return;
            }

            using (StreamWriter sw = new StreamWriter( csNGFile, true, Encoding.GetEncoding("Shift_JIS")))
            {  
                sw.WriteLine(sender);
                sw.Close();
            }
        }

        /// <summary>
        /// 無視リストを読み直す
        /// </summary>
        private void LoadNGName()
        {
            if (!File.Exists(csNGFile))
            {
                // MessageBox.Show("NGName.txtが存在しません。再度アプリケーションを立ち上げなおして、\nNGName.txtを作成してください。");
                return;
            }
            
            using (StreamReader sr = new StreamReader(csNGFile, Encoding.GetEncoding("Shift_JIS")))
            {
                string igname = "";
                while ((igname = sr.ReadLine()) != null )
                {
                    ignorelist[igname] = igname;
                    emphasislist[igname] = igname;
                }
            }
        }

        /// <summary>
        /// senderを無視リストから外す
        /// </summary>
        /// <param name="sender"></param>
        private void RemoveNGName(string sender)
        {
            StringReader ignores;

            if (!File.Exists(csNGFile))  {
                MessageBox.Show("NGName.txtが存在しません。再度アプリケーションを立ち上げなおして、\nNGName.txtを作成してください。");
                return;
            }

            using (StreamReader sr = new StreamReader(csNGFile, Encoding.GetEncoding("Shift_JIS")))
            {
                ignores = new StringReader(sr.ReadToEnd());
                sr.Close();
            }
            using (StreamWriter sw = new StreamWriter(csNGFile, false, Encoding.GetEncoding("Shift_JIS")))
            {

                string line;
                while ((line = ignores.ReadLine()) != null)
                {
                    if (line != sender)
                    {
                        sw.WriteLine(line);
                    }
                }
                sw.Close();
            }
            emphasislist.Remove(sender);
        }

        #endregion

        #region ツールストリップ

        /// <summary>
        /// 検索ボタン
        /// テキストボックスに入力されたコードをCompanyCodeListペインに追加する
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            string code = this.textBox1.Text.Trim();
            GetTitleList("", code);
        }

        /// <summary>
        /// 掲示板に新規書き込み
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton2_Click(object sender, EventArgs e)
        {
            this.textBox2.AppendText("( ･∀･)ﾉ > 書き込み！　 " + csCrLf);
            // write api url ilke this...
            //http://post.messages.yahoo.co.jp/bbs?.mm=FN&action=r&board=1006255&tid=6255&sid=1006255&mid=0
            string url = "";
            url = context.postUrl;
            toolStripStatusLabel1.Text = url;
            SwitchBrowseAndNavigate(url);
        }

        /// <summary>
        /// 返信 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton3_Click(object sender, EventArgs e)
        {
            if (listView1.SelectedItems.Count > 0)
            {
                string mid = listView1.SelectedItems[0].Text;
                SwitchBrowseAndNavigate(yahoo.GetReplyUrl(mid));
            }
        }

        /// <summary>
        /// 全文検索 ボタン押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton4_Click(object sender, EventArgs e)
        {
            if (textBox3.Text.Length == 0)
            {
                MessageBox.Show("検索ワードを入力してください。");
                return;
            }
            DoSearchAllTitles();
        }

        /// <summary>
        /// 全タイトルを取得 ボタン押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton5_Click(object sender, EventArgs e)
        {
            if (this.textBox1.Text == "" || this.textBox1.Text.Length != 4)
            {
                MessageBox.Show("テキストボックスに銘柄コードを入力してください");
                return;
            }
            int ret = yahoo.SaveAllTitleList(this.textBox1.Text, ref context.t);
            if (ret == 0) {
                this.textBox3.Enabled = true;
                this.textBox4.Enabled = true;
                this.toolStripStatusLabel1.Text = "";
            }
        }

        /// <summary>
        ///  ランキング表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton6_Click(object sender, EventArgs e)
        {
            SwitchBrowseAndNavigate(yahoo.GetDailyRankingUrl());
            this.Text = "カブラウザもどき - Yahoo!掲示板 - 銘柄別投稿数ランキング - デイリー";
        }

        /// <summary>
        /// ランキング表示（週次）
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton7_Click(object sender, EventArgs e)
        {
            SwitchBrowseAndNavigate(yahoo.GetWeeklyRankingUrl());
            this.Text = "カブラウザもどき - Yahoo!掲示板 - 銘柄別投稿数ランキング - ウィークリー";
        }

        /// <summary>
        /// ランキング表示（月次）
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton8_Click(object sender, EventArgs e)
        {
            SwitchBrowseAndNavigate(yahoo.GetMonthlyRankingUrl());
            this.Text = "カブラウザもどき - Yahoo!掲示板 - 銘柄別投稿数ランキング - マンスリー";
        }

        /// <summary>
        /// 無視リストを切替
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton9_Click(object sender, EventArgs e)
        {
            if (ignorelist.Count != 0)
            {
                ignorelist = new Hashtable();
                this.toolStrip1.Items[0].ImageIndex = (int)ImageList.NGOff;

            } else {
                LoadNGName();
                this.toolStrip1.Items[0].ImageIndex = (int)ImageList.NGOn;
            }
            RedisplayListView();
        }

        /// <summary>
        /// 空売り残高を表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton10_Click(object sender, EventArgs e)
        {
            if (context.GetCode() == "")
            {
                MessageBox.Show("銘柄コードを入力してください。");
            } else {
                SwitchBrowseAndNavigate("http://www.your-alert-service.com/shortselling/" + context.GetCode() + ".html");
                this.toolStripStatusLabel1.Text = "http://www.your-alert-service.com/shortselling/" + context.GetCode() + ".html";
                //GetShortInterest();
            }
        }

        /// <summary>
        /// 考える株式投資を表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton11_Click(object sender, EventArgs e)
        {
            if (context.GetCode() == "")
            {
                MessageBox.Show("銘柄コードを入力してください。");
            } else {
                SwitchBrowseAndNavigate("http://g2s.biz/tool/edinet/" + context.GetCode());
            }
        }

        /// <summary>
        /// 東証適時開示システムを表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton12_Click(object sender, EventArgs e)
        {
            if (context.GetCode() == "")
            {
                MessageBox.Show("銘柄コードを入力してください。");
                return;
            }
            SwitchBrowseAndNavigate("https://www.release.tdnet.info/index.html");


            HtmlDocument doc = webBrowser1.Document.Window.Frames[0].Document;
            HtmlElementCollection sels = doc.GetElementsByTagName("SELECT");
            if (sels.Count > 0)
            {
                HtmlElement el1 = (HtmlElement)sels[0];
                HtmlElement el2 = (HtmlElement)sels[1];
                string today = DateTime.Now.ToString("yyyyMMdd");
                string before1m = DateTime.Now.AddMonths(-1).AddDays(1).ToString("yyyyMMdd");
                el1.SetAttribute("value", before1m);
                el2.SetAttribute("value", today);
                doc.GetElementById("q").SetAttribute("value", context.GetCode() + "0");
                doc.Forms[0].InvokeMember("submit");
                toolStripStatusLabel1.Text = "https://www.release.tdnet.info/index.html";
            }

            //      doc.DomDocument.frams[0].Document.form1.t0.Value = "20120531"; 

        }

        /// <summary>
        /// Yahooニュースを表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton13_Click(object sender, EventArgs e)
        {
            if (context.GetCode() == "")
            {
                MessageBox.Show("銘柄コードを入力してください。");
                return;
            }
            SwitchBrowseAndNavigate(yahoo.GetColum());
            HtmlDocument doc = webBrowser1.Document;
            HtmlElementCollection elms = doc.GetElementsByTagName("LI");
            listView1.Items.Clear();

            string t_tilte = "";
            string t_sender = "";
            string t_pubDate = "";
            bool b_title = false;
            bool b_sender = false;

            foreach (HtmlElement el in elms)
            {

                if (el.GetAttribute("className") == "yjMt ymuiArrow1L")
                {
                    t_tilte = el.InnerText;
                    b_title = true;

                }
                else if (el.GetAttribute("className") == "yjSt marB2 ymuiDate padL10")
                {


                    t_pubDate = el.InnerText;
                    if (el.GetElementsByTagName("A").Count > 0)
                    {
                        t_sender = el.GetElementsByTagName("A")[0].InnerText;
                    }
                    b_sender = true;
                }

                if (b_title && b_sender)
                {
                    ListViewItem item = new ListViewItem();
                    item.Text = "　　　・";
                    item.SubItems.Add(t_tilte);
                    item.SubItems.Add(t_sender);
                    item.SubItems.Add("");
                    item.SubItems.Add(t_pubDate);
                    item.SubItems.Add("");
                    listView1.Items.Add(item);
                    b_title = false;
                    b_sender = false;
                }
            }
            PaintBackgrounColorListView();
            return;
        }

        /// <summary>
        /// EDINETを表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton14_Click(object sender, EventArgs e)
        {
            HtmlDocument doc;
            if (context.GetCode() == "" && this.textBox5.Text == "" )
            {
                MessageBox.Show("銘柄コードを入力してください。");
            }
            else if (edinetlist[this.textBox1.Text] != null)
            {
                // string edi = edinetlist[this.textBox1.Text].ToString();
                string edi = this.textBox5.Text;
                this.webBrowser1.Visible = false;
                this.webBrowser2.Visible = true;
                this.webBrowser2.NavigateAndWait("https://info.edinet-fsa.go.jp/E01EW/BLMainController.jsp?uji.verb=W1E62010YuKaBtn&uji.bean=ee.bean.EEW1E62030IBean&PID=currentPage&TID=W1E62030");
                doc = this.webBrowser2.Document;
                if ( doc != null && doc.Title == "EDINET")
                {
                    string[] targetdoc = needEdinetDoc.Split(',');
                    doc.GetElementById("edinetCode").SetAttribute("value", edi);
                    HtmlElementCollection elms = doc.All.GetElementsByName("documentsKind");
                    for (int i = 0; i < elms[0].All.Count; i++)
                    {
                        for (int j = 0; j < targetdoc.Length; j++)
                        {
                            if (elms[0].All[i].InnerText == targetdoc[j])
                            {
                                elms[0].All[i].SetAttribute("selected", "true");
                            }
                        }
                    }
                    doc.GetElementById("show3").SetAttribute("checked", "true"); // 100件表示
                    HtmlElementCollection buttons = doc.GetElementsByTagName("input");
                    foreach (HtmlElement b in buttons)
                    {
                        if (b.GetAttribute("type") == "button" && b.OuterHtml.IndexOf("検索") != -1)
                        {
                            b.InvokeMember("click");
                        }
                    }

                    Sleep s = new Sleep(1);
                    doc = this.webBrowser2.Document;
                    doc.GetElementById("show3").SetAttribute("checked", "true");  // 100件表示

                    elms = doc.GetElementsByTagName("a");
                    string tmpedi = (string)edinetlist[this.textBox1.Text];
                    tmpedi = tmpedi.Split(',')[0];
                    foreach (HtmlElement a in elms)
                    {
                        if (a.InnerText == tmpedi + " ")
                        {
                            a.InvokeMember("click");
                        }
                    }


                }

                //this.textBox5.Text = edi;
                this.toolStripStatusLabel1.Text = "https://info.edinet-fsa.go.jp/E01EW/BLMainController.jsp?uji.verb=W1E62010YuKaBtn&uji.bean=ee.bean.EEW1E62030IBean&PID=currentPage&TID=W1E62030";

            } else {

                MessageBox.Show("EDINETコードが不明でした");
            }
            return;
        }

        /// <summary>
        /// 設定を表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton15_Click(object sender, EventArgs e)
        {
            SettingForm sf = new SettingForm(execMode, needEdinetDoc, this);
            this.child = sf;
            //Console.WriteLine(needEdinetDoc);
            sf.needEdinetDoc = needEdinetDoc;
            sf.ShowDialog();
            this.needEdinetDoc = sf.needEdinetDoc;
            //Console.WriteLine(needEdinetDoc);
        }

        /// <summary>
        /// 前の40件を表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton16_Click(object sender, EventArgs e)
        {
            // 2013/2/24 textream対応 start
            //GetTitleListsFromHtml(context.GetCode(), -1);
            yahoo.GetTitleLists(context.GetCode(), -1);
            // 2013/2/24 textream対応 end
            RedisplayListView();
        }

        /// <summary>
        /// 次の40件を表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton17_Click(object sender, EventArgs e)
        {
            // 2013/2/24 textream対応 start
            //GetTitleListsFromHtml(context.GetCode(), 1);
            yahoo.GetTitleLists(context.GetCode(), 1);
            // 2013/2/24 textream対応 end
            RedisplayListView();
        }

        #endregion

        #region リストビュー

        /// <summary>
        /// CompanyCodeList(TreeView)ペインにフォルダ、または銘柄コードを加える
        /// folder, short_code, long_code には空でも必ず""(空文字)を渡すこと.
        /// </summary>
        /// <param name="folder"></param>
        /// <param name="long_code">銘柄コード＋銘柄名称( 5214　日本電気硝子 )</param>
        /// <param name="short_code">銘柄コードのみ(例 5214)</param>
        /// <param name="bChkNecessary"></param>
        /// <returns>登録したTreeNodeのIndex。失敗した場合は-1</returns>
        private int AddCompanyCodeList(string folder, string long_code, string short_code, bool bChkNecessary)
        {
            int ret = -1;

            //想定外
            if (folder == null || short_code == null || long_code == null 
                || (folder == "" && short_code == "" && long_code == "")) { return ret; }
            if (short_code == "" )
            {
                short_code = GetRegularCode(long_code);
            }
            
            // 銘柄コードがヤフー掲示板に存在するかチェックする
            if ( bChkNecessary )
            {
                bool isValid;
                isValid = yahoo.IsValidYahooCode(short_code);
                if (isValid && (long_code == "" || long_code == null)) {

                    long_code = short_code + tvdelimiter + context.comapnyName;

                } else {
                    return ret;
                }
            }
            // folderを追加する
            if (folder != "" && short_code == "")
            {
                TreeNode tnFolder = new TreeNode(folder, (int)ImageList.CloseFolder, (int)ImageList.OpenFolder);
                tnFolder.Name = folder;
                ret = treeView1.Nodes.Add(tnFolder);
            }
            // root直下にコードを追加する
            else if (folder == "" && short_code != "")
            {
                try
                {
                    TreeNodeCollection tnc = treeView1.Nodes;
                    if (tnc == null) return -1;
                    bool isNew = true;
                    foreach (TreeNode n in tnc)
                    {
                        // 自ノード調査
                        if (n.Name != null && n.Name == short_code)
                        {
                            //すでに登録済み
                            treeView1.SelectedNode = n;
                            treeView1.Focus();
                            isNew = false;
                            break;
                        }
                        // 子ノード調査
                        foreach (TreeNode child in n.Nodes)
                        {
                            if (child.Name != null && child.Name == short_code)
                            {
                                // すでに追加済み
                                treeView1.SelectedNode = child;
                                treeView1.Focus();
                                isNew = false;
                                break;
                            }
                        }
                        if (!isNew) break;
                    }
                    if (isNew)
                    {
                        // 親ノードを選択させて、ぶら下げる
                        TreeNode tn = new TreeNode(long_code.Trim(), (int)ImageList.File, (int)ImageList.File);
                        tn.Name = short_code;
                        ret = treeView1.Nodes.Add(tn);

                        // ダイアログ
                        /* 銘柄コードを入れる度に一々聞いてくるのはウザったいのでやめる。
                         * 親のいない銘柄コードを警告するのはアプリ終了時で十分。
                        ParentNodeList nodelist =  new ParentNodeList();
                        Hashtable param = new Hashtable();
                        for (int i = 0; i < this.treeView1.Nodes.Count; i++)
                        {
                            if (this.treeView1.Nodes[i].Parent == null && this.treeView1.Nodes[i].ImageIndex != (int)ImageList.File)
                            {
                                param[this.treeView1.Nodes[i].Index] = this.treeView1.Nodes[i].Text;
                            }
                        }
                        nodelist.Show(this.Owner, param);
                        TreeNode target = this.treeView1.Nodes[nodelist.resTnIndex];
                        TreeNode tnclone = (TreeNode)tn.Clone();
                        target.Nodes.Add(tnclone);
                        tn.Remove();
                        this.treeView1.SelectedNode = tnclone;
                        nodelist.Dispose();
                        */
                    }
                    else { ret = 0; }
                    
                }
                catch (NullReferenceException e)
                {
                    this.textBox2.AppendText(folder + "," + long_code + "," + bChkNecessary);
                    this.textBox2.AppendText(e.ToString() + csCrLf);
                }

            }
            // フォルダを指定してコード登録
            else if (folder != "" && short_code != "")
            {
                TreeNodeCollection tnc = treeView1.Nodes;
                TreeNode parent = null;
                foreach (TreeNode n in tnc)
                {
                    if (n.Text == folder)
                    {
                        parent = n;
                        break;
                    }
                }
                TreeNode tnCode = new TreeNode(long_code.Trim(), (int)ImageList.File, (int)ImageList.File);
                tnCode.Name = short_code;
                // 親ノードに追加
                if (parent != null)
                {
                    parent.Nodes.Add(tnCode);
                }
                // 親ノードと一緒に作成
                else
                {
                    TreeNode[] tnCodes = { tnCode } ;
                    TreeNode tnFolder = new TreeNode(folder, tnCodes);
                    ret = treeView1.Nodes.Add(tnFolder);
                }
            }
            return ret;
        }


        /// <summary>
        /// 銘柄コードのロック状態を確認して、タイトル一覧を表示する
        /// 銘柄コードが登録済みでなければ、TreeViewに登録する
        /// 呼び出し側は使わないcodeをnullでは無く、空文字("")で渡すこと
        /// </summary>
        /// <param name="long_code">銘柄コード＋銘柄名称(例 5214　日本電気硝子)
        ///   ※左側ペインのダブルクリック
        /// </param>
        /// <param name="short_code">銘柄コードのみ(例 5214)
        ///   ※銘柄コード入力
        /// </param>
        private void GetTitleList(string long_code, string short_code)
        {
            string chkedcode = null;

            
            this.textBox2.AppendText("( ･∀･)ﾉ > けんさく！　 " + short_code + csCrLf);

            if (short_code == null || long_code == null) return;
            if (short_code == "" && long_code != "")
            {
                short_code = GetRegularCode(long_code);
            }

            int ret = 0;
            if (IsRegularCode(short_code, out chkedcode))
            {
                // TitleListペインを再表示
                listView1.Items.Clear();

                // 2013/2/24 textream対応 start
                // ret = GetTitleListsFromRSS(code);
                // ret = GetTitleListsFromHtml(chkedcode, 0);
                ret = yahoo.GetTitleLists(chkedcode, 0);
                // 2013/2/24 textream対応 end
                if (ret != -1)
                {
                    RedisplayListView();
                }
                AddCompanyCodeList("", long_code, short_code, true);
            }
        }


        /// <summary>
        /// 投稿タイトル一覧をローカルファイルから取得して配列に格納する.
        /// contextを介さないので直接Form1に実装する。
        /// </summary>
        /// <param name="longCode"></param>
        /// <param name="mid">中心となるMessageIdを指定する（前後20件を表示）</param>
        /// <returns></returns>
        public int GetTitleListsFromLocal(string longCode, string mid)
        {
            if (longCode == "") { return -1; }
            //string code = longCode.Substring(0, 4);
            string code = GetRegularCode(longCode);
            string[] lines = null;
            string line = "";
            int iMid = int.Parse(mid);

            if (context.tid == null || context.tid == "") {
                yahoo.GetTopicId(code, true);
            }

            listView1.Items.Clear();
            if (!File.Exists(csDatDir + context.GetCode() + ".dat")) return -1;

            ListViewItem item = new ListViewItem();
            item.Text = "次のページ（ローカル）";  // ローカルから取得する場合は"次のページ（ローカル）"と表示する 
            item.SubItems.Add("");  // title
            item.SubItems.Add("");  // sender
            item.SubItems.Add("");  // pubdate
            item.SubItems.Add("");  // emotion
            item.SubItems.Add("");  // dummy
            listView1.Items.Add(item);

            using (context.topicSr = new StreamReader(csDatDir + context.GetCode() + ".dat")) {
                // 既読リスト
                Hashtable ht = this.visited.GetMessagesHt(context.GetCode());

                while ((line = context.topicSr.ReadLine()) != null) {
                    lines = line.Split(Form1.delimiter);
                    if (iMid > 20 && int.Parse(lines[0]) > (iMid - 20) && int.Parse(lines[0]) < (iMid + 20)) {

                        item = new ListViewItem();
                        item.UseItemStyleForSubItems = false;
                        item.Text = lines[0];  // title id 
                        item.SubItems.Add(lines[1]);  // title
                        item.SubItems.Add(lines[2]);  // sender
                        item.SubItems.Add(lines[3]);  // pubdate
                        item.SubItems.Add(lines[4]);  // emotion
                        item.SubItems.Add("");  // dummy
                        listView1.Items.Add(item);

                        // 未読処理(2)
                        if (ht[lines[0]] == null) {
                            item.SubItems[1].ForeColor = (Color)ColorList["NonVisited"];
                        } else {
                            item.SubItems[1].ForeColor = (Color)ColorList["Visited"];
                        }

                        if (int.Parse(lines[0]) < (iMid - 20)) break;
                    }
                }
                lines = null;
            }

            item = new ListViewItem();
            item.Text = "前のページ（ローカル）";  // ローカルから取得する場合は"前のページ（ローカル）"と表示する 
            item.SubItems.Add("");  // title
            item.SubItems.Add("");  // sender
            item.SubItems.Add("");  // pubdate
            item.SubItems.Add("");  // emotion
            item.SubItems.Add("");  // dummy
            listView1.Items.Add(item);

            PaintBackgrounColorListView();
            return 0;
        }

        /// <summary>
        /// 引数の銘柄コードのタイトル一覧を表示する
        /// </summary>
        /// <param name="e">4ケタの銘柄コード</param>
        private void DisplayTitleList(string code)
        {
            if (code == null || code == "" || code.Length < 4) { return; }
            this.textBox2.AppendText("( ･∀･)ﾉ > 表示するよ！　 " + code + csCrLf);
            int ret = 0;

            // 2013/2/24 textream対応 start
            //ret = GetTitleListsFromHtml(code, 0);
            ret = yahoo.GetTitleLists(code, 0);
            // 2013/2/24 textream対応 end

            //int ret = GetTitleListsFromRSS(code, ref context.t);
            if (ret != -1) {

                this.textBox1.Text = code;

                // TitleListペインを再表示
                listView1.Items.Clear();
                RedisplayListView();

                foreach (TreeNode tn in treeView1.Nodes)
                {
                    if (tn.Name == code)
                    {
                        treeView1.SelectedNode = tn;
                    }
                }
                TextboxConditionChange(code);
            }
        }

        /// <summary>
        /// ListViewで選択されたメッセージを表示する
        /// </summary>
        private void DisplaySelectedContents()
        {
            if (listView1.SelectedItems.Count == 0) { return; }
            string mid = listView1.SelectedItems[0].Text;
            context.selectedTitle = listView1.SelectedItems[0].SubItems[1].Text;        
            switch (mid)
            {
                case "次のページ（ローカル）":
                    mid = listView1.Items[1].Text;
                    GetTitleListsFromLocal(context.GetCode(), mid);
                    break;

                case "前のページ（ローカル）":
                    mid = listView1.Items[listView1.Items.Count - 2].Text;
                    GetTitleListsFromLocal(context.GetCode(), mid);
                    break;

                case "次のページ":
                    // 2013/2/24 textream対応 start
                    //GetTitleListsFromHtml(mid, 1);
                    yahoo.GetTitleLists(mid, 1);
                    // 2013/2/24 textream対応 end
                    RedisplayListView();
                    break;

                case "前のページ":
                    // 2013/2/24 textream対応 start
                    //GetTitleListsFromHtml(mid, -1);
                    yahoo.GetTitleLists(mid, -1);
                    // 2013/2/24 textream対応 end
                    RedisplayListView();
                    break;

                default:
                    if (listView1.SelectedItems.Count > 0)
                    {
                        listView1.SelectedItems[0].Font = new Font(listView1.SelectedItems[0].Font, FontStyle.Regular);
                        //listView1.SelectedItems[0].ForeColor = (Color)ColorList["Visited"];
                        listView1.SelectedItems[0].SubItems[1].ForeColor = (Color)ColorList["Visited"];
                        // 2013/2/24 textream対応 start
                        //DisplayContents(mid);
                        DisplayContentsFromLocal(mid);
                        // 2013/2/24 textream対応 end
                    }
                    break;
            }
            return;
        }

        /// <summary>
        /// 該当銘柄コードのTitle一覧の取得を行う
        /// 投稿タイトル一覧を取得して配列に格納する
        /// </summary>
        /// <param name="pageNo">ぺジー番号 0:最新 -1:前の40件 1:次の40件</param>
        /*
        public int GetTitleListsFromHtml(string longCode, int pageNo)
        {
            string url = "";
            int ret = 0;

            switch (pageNo)
            {
                case 1:
                    if (context.nextPage == null || context.nextPage == "")
                    {
                        ret = -1;
                    } else {
                        url = context.nextPage;
                        context.ClearTitleList();
                    }
                    break;
                case -1:
                    if (context.prevPage == null || context.prevPage == "")
                    {
                        ret = -1;
                    } else {
                        context.ClearTitleList();
                        url = context.prevPage;
                    }
                    break;
                case 0:
                default:
                    if (!context.Lock()) { MessageBox.Show("銘柄コードは現在ロックされています\nしばらくお待ちください"); return -1; }
                    try
                    {
                        url = yahoo.GetBaseUrl();
                        ret = yahoo.GetTopicId(context.GetCode(), false);
                    }
                    finally
                    {
                        context.UnLock();
                    }
                    break;
            }

            ComConstants now = ndbControl.DlControl;

            if (ret == 0)
            {
                if (!context.Lock()) { MessageBox.Show("銘柄コードは現在ロックされています\nしばらくお待ちください"); return -1; }
                try
                {
                    ComConstants filter = ComConstants.DLCTL_NO_JAVA
                                        | ComConstants.DLCTL_NO_SCRIPTS
                                        | ComConstants.DLCTL_NO_DLACTIVEXCTLS
                                        | ComConstants.DLCTL_NO_RUNACTIVEXCTLS
                                        | ComConstants.DLCTL_DLIMAGES;
                    ndbControl.DlControl = filter;

                    // URLパターン
                    // Page1: http://messages.yahoo.co.jp/bbs?.mm=FN&action=l&board=1006758&sid=1006758&tid=a5bda5ka1bc&start=281236
                    // Page2: http://messages.yahoo.co.jp/bbs?.mm=FN&action=l&board=1006758&sid=1006758&tid=a5bda5ka1bc&start=281196
                    //  ※tidあり、tidを入れたら、startは必須？
                    //または、
                    // Page(最新): http://messages.yahoo.co.jp/bbs?.mm=FN&action=topic&board=1006758&sid=1006758

                    //Stopwatch sw = new Stopwatch();
                    //sw.Start();
                    if (!ndb.NavigateAndWait(url))
                    {
                        this.textBox2.AppendText("（｡・-・）失敗ｼﾀﾖｳﾀﾞ...もう一回やって！" + csCrLf);
                    }
                    //sw.Stop();
                    //this.textBox2.AppendText("DL時間：" + sw.ElapsedMilliseconds + csCrLf);
                    this.textBox2.AppendText("( ･∀･)ﾉ > げっと！　 " + context.GetCode() + csCrLf);
                    HtmlDocument doc = ndb.Document;
                    if (doc.Title.ToString().Equals("Yahoo!掲示板 - エラー")) {
                        this.textBox2.AppendText("（｡・-・）ﾖｲﾖｲ...変な値が返ってるよ..." + Form1.csCrLf);
                        return -1;
                    } 

                    // テーブル内の文字列を構造体に格納する
                    // タイトル一覧はHTMLの四重にネストされたテーブル配下にある.
                    int tblCnt = 0;
                    int rowCnt = 0;
                    foreach (HtmlElement e in doc.GetElementsByTagName("TABLE"))
                    {
                        if (e.InnerText != null && e.InnerText.IndexOf("投稿時間") != -1)
                        {
                            tblCnt++;
                            if (tblCnt == 4)
                            {
                                HtmlElementCollection rows = e.GetElementsByTagName("TR");
                                foreach (HtmlElement row in rows)
                                {
                                    HtmlElementCollection cols = row.GetElementsByTagName("TD");
                                    int chkelm = 0;
                                    bool bChk = int.TryParse(cols[0].InnerText, out chkelm);
                                    if (cols.Count == 9 && bChk && chkelm > 1 && chkelm <= context.GetMaxTitleNo())
                                    {
                                        context.t[rowCnt].titleNo = chkelm.ToString();
                                        context.t[rowCnt].title = cols[1].InnerText;
                                        context.t[rowCnt].sender = cols[4].InnerText;
                                        context.t[rowCnt].emotion = cols[5].InnerText;
                                        context.t[rowCnt].sendTime = cols[8].InnerText;
                                        rowCnt++;
                                    }
                                }
                            }
                        }
                    }

                    foreach (HtmlElement e in doc.GetElementsByTagName("A"))
                    {
                        string href = e.GetAttribute("href"); // HREF属性の値
                        string text = e.InnerText; // リンク文字列

                        if (e.InnerText == "前の40件") context.prevPage = e.GetAttribute("href");
                        if (e.InnerText == "次の40件") context.nextPage = e.GetAttribute("href");

                    }
                    
                    // yahoo掲示板その他の情報の取得
                    if (context.comapnyName == "") {
                        yahoo.GetOtherInfo(context.GetCode(), doc);
                    }
                }
                finally
                {
                    context.UnLock();
                    ndbControl.DlControl = now;
                }
            } else // GetTopicId() の戻り値 not 0 
            {
                this.textBox2.AppendText("( ・益・)　ﾉ > ﾖｲﾖｲわかんねぇよ。" + csCrLf);
            }
            return 0;
        }
        */

        /// <summary>
        /// YahooTextreamから該当銘柄コードのTitle一覧の取得を行う
        /// 投稿タイトル一覧を取得して配列に格納する
        /// 履歴：
        /// </summary>
        /// <param name="pageNo">ぺジー番号 0:最新 -1:前の40件 1:次の40件</param>
        /// 
        /*
        public int GetTitleListsFromTextream(string longCode, int pageNo)
        {
            string url = "";
            int ret = 0;
            int itemCnt = 0;
            //Stopwatch sw = new Stopwatch();

            switch (pageNo) {
                case 1:
                    if (context.nextPage == null || context.nextPage == "") {
                        ret = -1;
                    } else {
                        url = context.nextPage;
                        context.ClearTitleList();
                    }
                    break;
                case -1:
                    if (context.prevPage == null || context.prevPage == "") {
                        ret = -1;
                    } else {
                        context.ClearTitleList();
                        url = context.prevPage;
                    }
                    break;
                case 0:
                default:
                    url = yahoo.GetBaseUrl();
                    ret = yahoo.GetTopicId(context.GetCode(), false);
                    //yahoo.GetOtherInfo(context.GetCode(), false);
                    break;
            }

            ComConstants now = ndbControl.DlControl;
            this.textBox2.AppendText("( ･∀･)ﾉ > げっと！　 " + context.GetCode() + csCrLf);

            if (ret == 0) {
                if (!context.Lock()) { MessageBox.Show("銘柄コードは現在ロックされています\nしばらくお待ちください"); return -1; }
                try {
                    ComConstants filter = ComConstants.DLCTL_NO_JAVA
                                        | ComConstants.DLCTL_NO_SCRIPTS
                                        | ComConstants.DLCTL_NO_DLACTIVEXCTLS
                                        | ComConstants.DLCTL_NO_RUNACTIVEXCTLS
                                        | ComConstants.DLCTL_DLIMAGES;
                    ndbControl.DlControl = filter;

                    // URLパターン
                    // Page1: http://textream.yahoo.co.jp/message/1002432/2432?page=2&sort=d&feel=99
                    // Page2: http://textream.yahoo.co.jp/message/1008136/a55a5sa5ja5aa?page=2&sort=d&feel=99
                    //または、
                    // Page(最新): http://textream.yahoo.co.jp/message/1002432/2432

                    //sw.Start();
                    if (!ndb.NavigateAndWait(url)) {
                        this.textBox2.AppendText("（｡・-・）失敗ｼﾀﾖｳﾀﾞ...もう一回やって！" + csCrLf);
                        return -1;
                    }
                    //sw.Stop();
                    //this.textBox2.AppendText("DL時間2：" + sw.ElapsedMilliseconds + csCrLf);
                    HtmlDocument doc = ndb.Document;

                    this.textBox2.AppendText("（ *´∀｀） ｱﾘｶﾞﾄｳ ぼくらのTextream! " + doc.Title.ToString() + Form1.csCrLf);

                    // テーブル内の文字列を構造体に格納する
                    // タイトル一覧はHTMLの四重にネストされたテーブル配下にある.
                    int tblCnt = 0;
                    int rowCnt = 0;
                    string className = "";
                    HtmlElement elm = null;
                    HtmlElement elm2 = null;
                    HtmlElement ttl = null;
                    HtmlElement commentTxt = null;
                    HtmlElement commentThm = null;
                    HtmlElementCollection tmp = null;
                    HtmlElementCollection elms = null;
                    HtmlElementCollection elms2 = null;

                    // title no :  .commentBox > .commentTxt cf > input type=hidden name=commentInfo
                    // title no :  .commentBox > .commentTxt cf > .textArea cf > .ttl > dtタグ > spanタグ
                    // title :  .commentBox > .commentTxt cf > .textArea cf > .ttl > .commentTitle
                    // sender :  .commentBox > .commentTxt cf > .textArea cf > .ttl > .name cf
                    // emotion :  .commentBox > .commentTxt cf > .textArea cf > .ttl > .name cf > .labelEmotion
                    // sendTime :  .commentBox > .commentTxt cf > .textArea cf > .ttl > .date
                    // content :  .commentBox > .commentTxt cf > .hideDetail > detail
                    // user : .commentBox > .commentThm > aタグ 属性href user=配下
                    // userIcon : .commentBox > .commentThm
                    //sw.Start();
                    System.Console.WriteLine(url);
                    foreach (HtmlElement e in doc.GetElementsByTagName("a")) {
                        
                        className = e.GetAttribute("className");
                        // System.Console.WriteLine(className);
                        if (className == "commentTitle") {
                            ttl = e.Parent.Parent;
                            if (ttl.GetElementsByTagName("dt").Count > 0) {
                                if (ttl.GetElementsByTagName("dt")[0].GetElementsByTagName("span").Count > 0) {
                                    context.t[rowCnt].titleNo = ttl.GetElementsByTagName("dt")[0].GetElementsByTagName("span")[0].InnerText.Replace("No.","");
                                }
                            }

                            elm = Utils.GetElementByClassName(ttl, "commentTitle");
                            if ( elm != null ) context.t[rowCnt].title = elm.InnerHtml;

                            elm = Utils.GetElementByClassName(ttl, "labelEmotion", "p");
                            if (elm != null) context.t[rowCnt].emotion = elm.InnerText;

                            elm = Utils.GetElementByClassName(ttl, "name cf");
                            if (elm != null) {
                                tmp = elm.GetElementsByTagName("a");
                                if (tmp.Count > 0) {
                                    context.t[rowCnt].sender = tmp[0].InnerText;
                                } else {
                                    // A tagに存在しない場合は p タグの場合もある
                                    tmp = elm.GetElementsByTagName("p");
                                    if (tmp.Count > 0) {
                                        context.t[rowCnt].sender = tmp[0].InnerText;
                                    }
                                }
                            }

                            elm = Utils.GetElementByClassName(ttl, "date");
                            if (elm != null) context.t[rowCnt].sendTime = elm.InnerHtml;
                            
                            commentTxt = ttl.Parent.Parent;
                            elm = Utils.GetElementByClassName(commentTxt, "detail");
                            if (elm != null) context.t[rowCnt].content = elm.InnerHtml;

                            // userIcon, user
                            commentThm = commentTxt.Parent;
                            elm = Utils.GetElementByClassName(commentThm, "commentThm", "p");
                            if (elm != null) {
                                elms2 = elm.GetElementsByTagName("img");
                                if (elms2.Count > 0) {
                                    elm2 = elms2[0];
                                    if (elm2 != null) context.t[rowCnt].userIcon = elm2.GetAttribute("src");
                                }
                                elms2 = elm.GetElementsByTagName("a");
                                if (elms2.Count > 0) {
                                    elm2 = elms2[0];
                                    if (elm2 != null) context.t[rowCnt].user = 
                                        elm2.GetAttribute("href").Replace("http://textream.yahoo.co.jp/personal/history/comment?user=", "");
                                }

                            } else {
                                context.t[rowCnt].userIcon = "http://i.yimg.jp/images/mb/textream/pc/thumb02.png";
                                context.t[rowCnt].user = "";
                            }
                            rowCnt++;
                        }
                    }
                    //sw.Stop();
                    //this.textBox2.AppendText("DOM解析時間：" + sw.ElapsedMilliseconds + csCrLf);
                    if (int.Parse(context.t[0].titleNo) > int.Parse(context.maxTilteNo)) {
                        context.maxTilteNo = context.t[0].titleNo;
                    }

                    //sw.Start();
                    foreach (HtmlElement e in doc.GetElementsByTagName("A")) {
                        string href = e.GetAttribute("href"); // HREF属性の値
                        string text = e.InnerText; // リンク文字列

                        if (e.InnerText == "前のページ") {
                            context.nextPage = e.GetAttribute("href");
                            itemCnt++;
                        }
                        if (e.InnerText == "次のページ") {
                            context.prevPage = e.GetAttribute("href");
                            itemCnt++;
                        }
                        if (itemCnt == 2) break;

                    }
                    //sw.Stop();
                    //this.textBox2.AppendText("次/前ページ検索時間：" + sw.ElapsedMilliseconds + csCrLf);

                    //yahoo掲示板のその他の情報を取得する
                    if (context.comapnyName == "") {
                        yahoo.GetOtherInfo(context.GetCode(), doc);


                    }
                }
                finally {
                    context.UnLock();
                    ndbControl.DlControl = now;
                }
            } else // GetTopicId() の戻り値 not 0 
            {
                this.textBox2.AppendText("( ・益・)　ﾉ > ﾖｲﾖｲわかんねぇよ。" + csCrLf);
            }
            return 0;
        }
        */

        /// <summary>
        /// 投稿タイトル一覧をRSSから取得して配列に格納する
        /// 取得は高速だが、最新しか取得できない。前の頁以前は取得不可。
        /// GetTitleListsFromHtmlを使用する事。
        /// </summary>
        /// <param name="longCode"></param>
        /// <param name="t"></param>
        /// <returns></returns>
        public int GetTitleListsFromRSS(string longCode)
        {
            if (longCode == "") { return -1; }
            string code = longCode.Substring(0, 4);
            context.SetCode(code);
            yahoo.GetTopicId(code, true);
            TitleLists[] t = context.t;
            NonDispBrowser ndb = (NonDispBrowser)ndbControl.GetBrowser();

            // RSSフィードURLを取得する
            string chkUrl = "http://messages.yahoo.co.jp/bbs?action=topics&board=1" + context.GetPad() + code + "&sid=1" + context.GetPad() + code + "";
            string rssUrl = "http://messages.yahoo.co.jp/bbs?action=4&board=1" + context.GetPad() + code + "&sid=1" + context.GetPad() + code + "&tid=" + code;
            ndb.NavigateAndWait(chkUrl);
            HtmlDocument doc = ndb.Document;
            context.title = doc.Title;

            bool breakFlag = false;
            //
            // TopicIdを取得する
            foreach (HtmlElement e in doc.GetElementsByTagName("LINK")) {
                string text = e.OuterHtml.Replace("&amp;", "&"); // リンク文字列
                string[] aTmp;
                if (text.IndexOf("rel=alternate") != -1) {
                    aTmp = text.Split('&');
                    foreach (string s in aTmp) {
                        if (s.Length > 3 && s.Substring(0, 3) == "tid") {
                            string regularTid = s.Split('=')[1];
                            regularTid = regularTid.Split('"')[0];
                            context.tid = regularTid;
                            rssUrl = "http://messages.yahoo.co.jp/bbs?action=4&board=1" + context.GetPad() + code + "&sid=1" + context.GetPad() + code + "&tid=" + context.tid;
                            breakFlag = true;
                        }
                        if (breakFlag) break;
                    }

                }
                if (breakFlag) break;
            }
            // ndb = null;
            this.textBox2.AppendText("( ･∀･)ﾉ > げっと！　 " + code + Form1.csCrLf);

            // タイトル一覧取得
            XmlDocument xmlDoc = new XmlDocument();
            try {
                xmlDoc.Load(rssUrl);
            }
            catch (XmlException e) {
                this.textBox2.AppendText("　( ・益・)　ﾉ > そんなもん、ねぇよ　 " + Form1.csCrLf);
                return -1;
            }
            context.ClearTitleList();
            XmlNodeList nodes = xmlDoc.GetElementsByTagName("item");

            string[] aUrl;
            for (int i = 0; i < nodes.Count; i++) {
                XmlNodeList titleNodes = nodes[i].SelectNodes("title");
                XmlNodeList dateNodes = nodes[i].SelectNodes("pubDate");
                XmlNodeList linkNodes = nodes[i].SelectNodes("link");
                XmlNodeList descNodes = nodes[i].SelectNodes("description");

                context.t[i].title = titleNodes[0].InnerText;
                context.t[i].sendTime = dateNodes[0].InnerText;
                context.t[i].url = linkNodes[0].InnerText;

                aUrl = descNodes[0].InnerText.Split(',');
                for (int j = 0; j < aUrl.Length; j++) {
                    if (aUrl[j].Length > 4 && aUrl[j].Substring(0, 4) == "投稿者:") context.t[i].sender = aUrl[j].Replace("投稿者:", "");
                    if (aUrl[j].Length > 5 && aUrl[j].Substring(0, 5) == "投稿番号:") context.t[i].titleNo = aUrl[j].Replace("投稿番号:", "");
                    if (aUrl[j].Length > 5 && aUrl[j].Substring(0, 5) == "投稿日時:") context.t[i].sendTime = aUrl[j].Replace("投稿日時:", "");
                }

                if (aUrl.Length == 5) {
                    context.t[i].emotion = aUrl[4];
                }

                //                context.ht[context.t[i].titleNo] = context.t[i];
            }
            context.SetCode(code);
            context.maxTilteNo = context.t[0].titleNo;
            // context.Save();
            return 0;
        }


        /// <summary>
        /// 指定語句による全文検索 
        /// </summary>
        private void DoSearchAllTitles()
        {

            if (context.GetCode() == "") return;
            string contents = "";
            string line = "";
            int iCnt = 0;
            if (!File.Exists(csDatDir + context.GetCode() + ".dat")) { textBox2.AppendText("（`皿）> ファイルがねぇ"); return; }

            // 既読リスト
            Hashtable ht = this.visited.GetMessagesHt(context.GetCode());

            using (StreamReader sr = new StreamReader(csDatDir + context.GetCode() + ".dat")) {

                contents = sr.ReadToEnd();
                sr.Close();
                line = "";
                StringReader sr2 = new StringReader(contents);
                while ((line = sr2.ReadLine()) != null) {
                    string[] splittedline;
                    if (line.IndexOf(textBox3.Text) != -1) {
                        if (iCnt == 0) listView1.Items.Clear();
                        splittedline = line.Split(Form1.delimiter);
                        ListViewItem item = new ListViewItem();
                        item.UseItemStyleForSubItems = false;
                        item.Text = splittedline[0];  // no
                        item.SubItems.Add(splittedline[1]);  // title
                        item.SubItems.Add(splittedline[2]);  // sender
                        item.SubItems.Add(splittedline[3]);  // pubdate
                        item.SubItems.Add(splittedline[4]);  // emotion
                        item.SubItems.Add("");  // dummy

                        // 未読処理(2)
                        if (ht[splittedline[0]] == null) {
                            item.SubItems[1].ForeColor = (Color)ColorList["NonVisited"];
                        } else {
                            item.SubItems[1].ForeColor = (Color)ColorList["Visited"];
                        }

                        listView1.Items.Add(item);
                        iCnt++;
                    }
                }
                sr2 = null;
            }
            PaintBackgrounColorListView();
            if (iCnt == 0) MessageBox.Show("検索結果が０件でした。");
        }

        /// <summary>
        /// 銘柄コードを選択されたタイミングでその銘柄に対するキャッシュデータを
        ///  読み込んでハッシュマップに格納する
        ///  戻り値：-1 ファイル無し
        /// </summary>
        /// <param name="code"></param>
        /// <returns></returns>
        private int ReadCache(string code)
        {
            string path = csDatDir + code + ".dat";
            if (!File.Exists(path)) return -1;

            // キャッシュデータフォーマット
            // [titleNo],[Title],[Sender],[upDate],[Emotion],[Status]
            this.textBox2.AppendText("( ･∀･)ﾉ > キャッシュよみ込み" + csCrLf);
            string[] aLine;
            using (StreamReader sr = new StreamReader(path))
            {
                string line;
                while ((line = sr.ReadLine()) != null)
                {
                    aLine = line.Split(Form1.delimiter);
                }
            }
            return 0;
        }

        /// <summary>
        ///  TreeView等に表示された、長いコード(long_code) 
        ///  例）　"1605 国際石油開発帝石", "998407 日経平均株価", "AUDJPY オーストラリアドル"
        ///  (4桁に限定されない)の銘柄コード部分を返す
        /// </summary>
        /// <param name="long_code"></param>
        /// <returns></returns>
        public static string GetRegularCode(string long_code)
        {
            // 正規化された銘柄コード
            string short_code = "";
            char[] delim = { ' ', '\t', tvdelimiter };
            if (long_code.Split(delim).Length > 0)
            {
                short_code = long_code.Split(delim)[0];
            } else {

                if (short_code.Length >= 6)
                {
                    short_code = short_code.Substring(0, 6);
                }
                else if (short_code.Length >= 4)
                {
                    short_code = short_code.Substring(0, 4);
                } else {

                    short_code = long_code;
                }
            }
            return short_code;
        }

        /// <summary>
        /// ListView1のバックグラウンドを偶数行=空色
        /// 奇数行=白に塗る
        /// </summary>
        private void PaintBackgrounColorListView()
        {
            for (int i = 0; i < listView1.Items.Count; i++)
            {
                if (i % 2 == 0)
                {
                    listView1.Items[i].BackColor = (Color)ColorList["BackGround"];
                    listView1.Items[i].SubItems[1].BackColor = (Color)ColorList["BackGround"];
                    listView1.Items[i].SubItems[2].BackColor = (Color)ColorList["BackGround"];
                    listView1.Items[i].SubItems[3].BackColor = (Color)ColorList["BackGround"];
                    listView1.Items[i].SubItems[4].BackColor = (Color)ColorList["BackGround"];
                    listView1.Items[i].SubItems[5].BackColor = (Color)ColorList["BackGround"];
                } else {

                    listView1.Items[i].BackColor = Color.White;
                    listView1.Items[i].SubItems[1].BackColor = Color.White;
                    listView1.Items[i].SubItems[2].BackColor = Color.White;
                    listView1.Items[i].SubItems[3].BackColor = Color.White;
                    listView1.Items[i].SubItems[4].BackColor = Color.White;
                    listView1.Items[i].SubItems[5].BackColor = Color.White;
                }
                if (markline[context.GetCode()] != null)
                {
                    if (listView1.Items[i].Text == (string)markline[context.GetCode()])
                    {
                        listView1.Items[i].BackColor = Color.LightPink;
                        listView1.Items[i].SubItems[1].BackColor = Color.LightPink;
                        listView1.Items[i].SubItems[2].BackColor = Color.LightPink;
                        listView1.Items[i].SubItems[3].BackColor = Color.LightPink;
                        listView1.Items[i].SubItems[4].BackColor = Color.LightPink;
                        listView1.Items[i].SubItems[5].BackColor = Color.LightPink;
                    }
                }
            }
            return;
        }

        /// <summary>
        /// TitleListペインを再描画する
        /// </summary>
        private void RedisplayListView()
        {
            listView1.Items.Clear();

            // 既読リスト
            Hashtable ht = this.visited.GetMessagesHt(context.GetCode());

            //次の40件
            if (context.nextPage != "")
            {
                ListViewItem item = new ListViewItem();
                item.Text = "次のページ";
                item.SubItems.Add("");
                item.SubItems.Add("");
                item.SubItems.Add("");
                item.SubItems.Add("");
                item.SubItems.Add("");

                listView1.Items.Add(item);
            }

            for (int i = 0; i < maxRow; i++)
            {
                // 無視リスト
                bool isIgnore = false;
                try {
                    if (ignorelist[context.t[i].sender] == null) {
                        isIgnore = false ;
                    } else isIgnore = true;
                } catch ( NullReferenceException e ) {
                    isIgnore = false;
                }

                if (context.t[i] != null && context.t[i].title != "" && !isIgnore)
                {
                    ListViewItem item = new ListViewItem();
                    item.UseItemStyleForSubItems = false;
                    item.Text = context.t[i].titleNo;
                    item.SubItems.Add(context.t[i].title);
                    item.SubItems.Add(context.t[i].sender);
                    item.SubItems.Add(context.t[i].emotion);
                    item.SubItems.Add(context.t[i].sendTime);
                    item.SubItems.Add("");
                    
                    if (context.t[i].status == "0")  // 未読(これは事情があって未実装)
                    {
                        // 未読処理(2)
                        if (ht[context.t[i].titleNo] == null) {
                            item.SubItems[1].ForeColor = (Color)ColorList["NonVisited"];
                            //item.ForeColor = (Color)ColorList["NonVisited"];
                        } else {
                            item.SubItems[1].ForeColor = (Color)ColorList["Visited"];
                            //item.ForeColor = (Color)ColorList["Visited"];
                        }
                    }
                    if (emphasislist[context.t[i].sender] != null)
                    {
                        item.SubItems[0].ForeColor = (Color)ColorList["Ignore"];
                        item.SubItems[1].ForeColor = (Color)ColorList["Ignore"];
                        item.SubItems[2].ForeColor = (Color)ColorList["Ignore"];
                        item.SubItems[3].ForeColor = (Color)ColorList["Ignore"];
                        item.SubItems[4].ForeColor = (Color)ColorList["Ignore"];
                        item.SubItems[5].ForeColor = (Color)ColorList["Ignore"];
                    }
                    
                    listView1.Items.Add(item);
                }
            }
            //前の40件
            if (context.prevPage != "")
            {
                ListViewItem item = new ListViewItem();
                item.Text = "前のページ";
                item.SubItems.Add("");
                item.SubItems.Add("");
                item.SubItems.Add("");
                item.SubItems.Add("");
                item.SubItems.Add("");
                listView1.Items.Add(item);
            }
            PaintBackgrounColorListView();
            this.Text = "カブラウザもどき - " + context.title + "　" +  context.close + "　" +  context.change;
        }

        /*
         * RSSから投稿タイトル一覧を全部取得してファイルに保存する
         * 最新titleIDからmaxRow分はTitleListsクラスに格納する
         * 
         */
        /*** RSSフィードから過去分の記事を取得する方法が未定。本関数は暫くコメントアウトする
        public void SaveAllTitleListFromRSS(string longCode, ref TitleLists[] t)
        {
            if (longCode == "") { return ; }
            string code = longCode.Substring(0, 4);

            // RSSフィードURLを取得する
            string chkUrl = "http://messages.yahoo.co.jp/bbs?action=topics&board=100" + code + "&sid=100" + code + "";
            string rssUrl = "http://messages.yahoo.co.jp/bbs?action=4&board=100" + code + "&sid=100" + code + "&tid=" + code;
            ndb.NavigateAndWait(chkUrl);
            HtmlDocument doc = ndb.Document;
            bool breakFlag = false;
            foreach (HtmlElement e in doc.GetElementsByTagName("LINK"))
            {
                string text = e.OuterHtml.Replace("&amp;", "&"); // リンク文字列
                string[] aTmp;
                if (text.IndexOf("rel=alternate") != -1)
                {
                    aTmp = text.Split('&');
                    foreach (string s in aTmp)
                    {
                        if (s.Length > 3 && s.Substring(0, 3) == "tid")
                        {
                            string regularTid = s.Split('=')[1];
                            regularTid = regularTid.Split('"')[0];
                            context.tid = regularTid;
                            rssUrl = "http://messages.yahoo.co.jp/bbs?action=4&board=100" + code + "&sid=100" + code + "&tid=" + context.tid;
                            breakFlag = true;
                        }
                        if (breakFlag) break;
                    }

                }
                if (breakFlag) break;
            }
            ndb = null;
            this.textBox2.AppendText("( ･∀･)ﾉ > ぶっこ抜き！　 " + rssUrl + csCrLf);

            //-----------------------------------------------------------------------------------------
            // URLパターン：
            // Page1: http://messages.yahoo.co.jp/bbs?.mm=FN&action=4&board=1006758&sid=1006758&tid=a5bda5ka1bc&start=281236
            // Page2: http://messages.yahoo.co.jp/bbs?.mm=FN&action=4&board=1006758&sid=1006758&tid=a5bda5ka1bc&start=281196
            // 最新のNo.を記憶して、50ずつ減少しながら構造体に格納する
            //-----------------------------------------------------------------------------------------

            // maxTitleNoを取得
        }
         */
        #endregion

        #region 投稿内容取得

        /// <summary>
        /// 引数のコードがYahoo掲示板のコードとして正しいか評価する
        /// 
        /// </summary>
        /// <param name="code"></param>
        /// <returns></returns>
        private bool IsRegularCode(string code, out string result) {
            bool ret = false;
            string[] tmp ;

            if (code.IndexOf(tvdelimiter) > 0)
            {
                tmp = code.Split(tvdelimiter);
                result = tmp[0];
            } else {

                result = code;
            }

            if (result.Length < 4 || result.Length > 6)
            {
                result = null;
                ret = false;
            } else {

                if (result.Length == 4)
                {
                    int test;
                    ret = int.TryParse(result, out test);
                    if (!ret)
                    {
                        result = null;
                    }
                } else {

                    ret = true;
                }
            }
            return ret;
        }
        #endregion

        #region イベントハンドラ

        /// <summary>
        /// ListViewダブルクリック イベント制御
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void listView1_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            DisplaySelectedContents();
        }

        private void listView1_KeyPress(object sender, KeyPressEventArgs e)
        {
            switch (e.KeyChar)
            {
                case (char)Keys.Enter: // enterキー押下
                    DisplaySelectedContents();
                    break;
                default:
                    break;
            }
        }

        /// <summary>
        /// 指定されたMessageIdをブラウズする
        /// </summary>
        /// <param name="mid"></param>
        private void DisplayContents(string mid)
        {
            // EDINETブラウザが活性状態なら消す
            // (※裏で動かれると鬱陶しい)
            if (this.webBrowser2.DocumentTitle != "empty") {
                this.webBrowser2.DocumentText = "<html><head><title>empty</title></head><body></body></html>";
            }

            // 投稿を表示
            string s = "";

            // 表示するチャート描画
            string chartHtml = "";
            chartHtml = yahoo.GetChartHtml(this.webBrowser1);

            // 投稿内容を取得
            s = yahoo.GetContents(mid);
            toolStripStatusLabel1.Text = yahoo.GetMassageUrl(mid);
            //s = GetContentsFromMobileSite(mid);

            // webBrowser1(通常版)に表示を切り替える
            this.webBrowser2.Visible = false;
            this.webBrowser1.Visible = true;

            // 既読リストに入れる
            visited.AddMessage(context.GetCode(), mid);

            // ブラウズするだけ（広告表示）
            //string url = yahoo.GetMassageUrl(mid);
            //webBrowser1.NavigateAndWait(url);

            context.mid = mid;

            // skinを変数で書き換えて表示
            webBrowser1.DocumentText = context.GetSkin().getConvertedHtml();
            this.listView1.Focus();

            return;
        }

        /// <summary>
        /// 指定されたMessageIdをブラウズする
        /// </summary>
        /// <param name="mid"></param>
        private void DisplayContentsFromLocal(string mid)
        {
            // EDINETブラウザが活性状態なら消す
            // (※裏で動かれると鬱陶しい)
            if (this.webBrowser2.DocumentTitle != "empty") {
                this.webBrowser2.DocumentText = "<html><head><title>empty</title></head><body></body></html>";
            }

            // 投稿を表示
            string s = "";

            // 表示するチャート描画
            string chartHtml = "";
            chartHtml = yahoo.GetChartHtml(this.webBrowser1);

            // 投稿内容を取得
            s = yahoo.GetContents(mid);
            toolStripStatusLabel1.Text = yahoo.GetMassageUrl(mid);
            toolStripStatusLabel1.Text = yahoo.GetMassageUrl(mid);
            //s = GetContentsFromMobileSite(mid);

            // webBrowser1(通常版)に表示を切り替える
            this.webBrowser2.Visible = false;
            this.webBrowser1.Visible = true;

            // 既読リストに入れる
            visited.AddMessage(context.GetCode(), mid);

            // ブラウズするだけ（広告表示）
            //string url = yahoo.GetMassageUrl(mid);
            //webBrowser1.NavigateAndWait(url);

            context.mid = mid;

            // skinを変数で書き換えて表示
            webBrowser1.DocumentText = context.GetSkin().getConvertedHtml();
            this.listView1.Focus();

            return;
        }


        /// <summary>
        /// Skinを変更してMessageIdを再表示する
        /// </summary>
        /// <param name="mid"></param>
        public void ReDisplayContents(string skin)
        {
            // 投稿を表示
            string s = "";
            string mid = "";

            mid = context.mid;
            // 表示するチャート描画
            string chartHtml = "";
            chartHtml = yahoo.GetChartHtml(this.webBrowser1);

            // 投稿内容を取得
            s = yahoo.GetContents(mid);
            toolStripStatusLabel1.Text = yahoo.GetMassageUrl(mid);
            //s = GetContentsFromMobileSite(mid);

            // skinを変数で書き換えて表示
            context.GetSkin().setSkinHtml(@".\skin\" + skin);
            webBrowser1.DocumentText = context.GetSkin().getConvertedHtml();
            this.listView1.Focus();

            return;
        }
        
        /// <summary>
        /// 銘柄コードでキー押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void textBox1_KeyPress(object sender, KeyPressEventArgs e)
        {
            switch (e.KeyChar)
            {
                case (char)Keys.Enter:
                    this.textBox1.Text = this.textBox1.Text.Trim();
                    context.Clear();
                    context.SetCode(this.textBox1.Text);
                    GetTitleList("", this.textBox1.Text);
                    
                    TextboxConditionChange(this.textBox1.Text);

                    break;
                default:
                    break;
            }
        }

        /// <summary>
        /// メッセージID でキー押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void textBox4_KeyPress(object sender, KeyPressEventArgs e)
        {
            switch (e.KeyChar)
            {
                case (char)Keys.Enter:
                    if (textBox4.Text != "" && textBox1.Text != "")
                    {
                        GetTitleListsFromLocal(textBox1.Text, textBox4.Text);
                        if (listView1.Items.Count > 19)
                        {
                            listView1.Items[19].Selected = true;
                            listView1.EnsureVisible(listView1.SelectedIndices[0]);
                            listView1.FocusedItem = listView1.SelectedItems[0];
                            listView1.Focus();
                        }
                    }
                    break;
                default:
                    break;
            }
        }

        /// <summary>
        ///  TreeViewでドラッグ＆ドロップ　制御
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void treeView1_ItemDrag(object sender, ItemDragEventArgs e)
        {
            TreeView tv = (TreeView)sender;
            tv.SelectedNode = (TreeNode)e.Item;
            tv.Focus();
            //ノードのドラッグを開始する
            DragDropEffects dde =
                tv.DoDragDrop(e.Item, DragDropEffects.All);
            //移動した時は、ドラッグしたノードを削除する
            if ((dde & DragDropEffects.Move) == DragDropEffects.Move)
                tv.Nodes.Remove((TreeNode)e.Item);
        }

        /// <summary>
        ///  TreeViewでドラッグ＆ドロップ　制御
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void treeView1_DragDrop(object sender, DragEventArgs e)
        {
            //ドロップされたデータがTreeNodeか調べる
            if (e.Data.GetDataPresent(typeof(TreeNode)))
            {
                TreeView tv = (TreeView)sender;
                //ドロップされたデータ(TreeNode)を取得
                TreeNode source =
                    (TreeNode)e.Data.GetData(typeof(TreeNode));
                //ドロップ先のTreeNodeを取得する
                TreeNode target =
                    tv.GetNodeAt(tv.PointToClient(new Point(e.X, e.Y)));
                //マウス下のNodeがドロップ先として適切か調べる
                if (target != null && target != source &&
                    IsDruggable(source, target)) {
                    //ドロップされたNodeのコピーを作成
                    TreeNode cln = (TreeNode)source.Clone();
                    //Nodeを追加
                    if (target.Parent != null && source.ImageIndex == (int)ImageList.File) {
                        target.Parent.Nodes.Insert(target.Index, cln);
                    } else if (target.Parent == null && source.ImageIndex == (int)ImageList.File) {
                        target.Nodes.Insert(target.Index, cln);
                    } else if (target.Parent == null) {
                        this.treeView1.Nodes.Insert(target.Index, cln);
                    } else {

                        target.Nodes.Add(cln);
                    }
                    //ドロップ先のNodeを展開
                    target.Expand();
                    //追加されたNodeを選択
                    tv.SelectedNode = cln;
                } else {
                    e.Effect = DragDropEffects.None;
                }
            }
            else
                e.Effect = DragDropEffects.None;
        }

        /// <summary>
        /// あるTreeNodeがDrop先として適切か調べる
        /// </summary>
        /// <param name="source">移動元</param>
        /// <param name="target">移動先</param>
        /// <returns>Drop可能ならTrue</returns>
        private static bool IsDruggable(TreeNode source, TreeNode target)
        {
            if (target.Parent != null && (source.ImageIndex == (int)ImageList.CloseFolder 
                || source.ImageIndex == (int)ImageList.OpenFolder)) return false;  // フォルダを子ノードには追加できない
            if (source.Parent == source) return false; // 自ノードには追加できない
            return true;
        }

        /// <summary>
        /// TreeViewでドラッグ＆ドロップ　制御
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void treeView1_DragOver(object sender, DragEventArgs e)
        {
            //ドラッグされているデータがTreeNodeか調べる
            if (e.Data.GetDataPresent(typeof(TreeNode)))
            {
                if ((e.KeyState & 8) == 8 &&
                    (e.AllowedEffect & DragDropEffects.Copy) ==
                    DragDropEffects.Copy)
                    //Ctrlキーが押されていればCopy
                    //"8"はCtrlキーを表す
                    e.Effect = DragDropEffects.Copy;
                else if ((e.AllowedEffect & DragDropEffects.Move) ==
                    DragDropEffects.Move)
                    //何も押されていなければMove
                    e.Effect = DragDropEffects.Move;
                else
                    e.Effect = DragDropEffects.None;
            }
            else
                //TreeNodeでなければ受け入れない
                e.Effect = DragDropEffects.None;

            //マウス下のNodeを選択する
            if (e.Effect != DragDropEffects.None)
            {
                TreeView tv = (TreeView)sender;
                //マウスのあるNodeを取得する
                TreeNode target =
                    tv.GetNodeAt(tv.PointToClient(new Point(e.X, e.Y)));
                //ドラッグされているNodeを取得する
                TreeNode source =
                    (TreeNode)e.Data.GetData(typeof(TreeNode));
                //マウス下のNodeがドロップ先として適切か調べる
//                if (target != null && target != source &&
//                        IsDruggable(source, target))
                if (target != null && target != source)
                {
                    //Nodeを選択する
                    if (target.IsSelected == false)
                        tv.SelectedNode = target;
                }
                else
                    e.Effect = DragDropEffects.None;
            }
        }

        /// <summary>
        /// 銘柄コードを変えた場合の制御
        /// </summary>
        /// <param name="code"></param>
        private void TextboxConditionChange(string code)
        {

            if (File.Exists(csDatDir + code + ".dat"))
            {
                this.textBox3.Enabled = true;
                this.textBox4.Enabled = true;
            } else {

                this.textBox3.Text = "";
                this.textBox4.Text = "";
                this.textBox3.Enabled = false;
                this.textBox4.Enabled = false;
            }
            if (edinetlist.ContainsKey(this.textBox1.Text)) {
                this.textBox5.Text = edinetlist[this.textBox1.Text].ToString().Split(',')[0];
            }
            return;
        }

        /// <summary>
        /// TreeViewでキーを押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void treeView1_KeyUp(object sender, KeyEventArgs e)
        {
            switch (e.KeyCode)
            {
                case Keys.Enter:
                    string short_code = "";
                    if (e == null) { return; }
                    if (!string.IsNullOrEmpty(treeView1.SelectedNode.Name) && treeView1.SelectedNode.Parent != null)
                    {
                        short_code = GetRegularCode(treeView1.SelectedNode.Name);
                        if (yahoo.IsValidYahooCode(short_code)) {
                            DisplayTitleList(short_code);
                        }
                    }
                    break;
                case Keys.F2:
                    TreeNode tn = treeView1.SelectedNode;
                    treeView1.LabelEdit = true;
                    if (tn != null && treeView1.LabelEdit && tn.IsEditing)
                    {
                        tn.BeginEdit();
                    }
                    break;
                case Keys.Delete:
                    TreeNode tntmp = treeView1.SelectedNode;
                    tntmp.Remove();
                    break;
                default:
                    break;
            }
        }

        /// <summary>
        /// TreeViewで選択されたオブジェクトがフォルダか確認する
        /// </summary>
        /// <param name="tn"></param>
        /// <returns></returns>
        private bool IsFolder(TreeNode tn)
        {
            bool ret = false;
            if (tn.Parent == null && (tn.ImageIndex == (int)ImageList.CloseFolder || tn.ImageIndex == (int)ImageList.OpenFolder))
            {
                ret = true;
            }
            return ret;
        }

        /// <summary>
        /// TreeViewでダブルクリック
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void treeView1_MouseDoubleClick_1(object sender, MouseEventArgs e)
        {
            string short_code = "";
            if (e == null) { return; }
            TreeNode select = treeView1.SelectedNode ;
            // ファイルの場合はタイトル一覧を表示
            if (!string.IsNullOrEmpty(select.Name) && !IsFolder(select) && select.Name.Length >= 4)
            {
                short_code = treeView1.SelectedNode.Name;
                context.Clear();
                context.SetCode(short_code);
                if (yahoo.IsValidYahooCode(short_code)) {
                    DisplayTitleList(short_code);
                }
            }
            // フォルダの場合はリネーム
            else if (!string.IsNullOrEmpty(select.Name) && IsFolder(select))
            {
                TreeNode tn = treeView1.SelectedNode;
                treeView1.LabelEdit = true;
                if (tn != null && treeView1.LabelEdit && tn.IsEditing)
                {
                    tn.BeginEdit();
                }
            }
        }

        /// <summary>
        /// このアプリを閉じる前の処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if ((MessageBox.Show("アプリケーションを終了する前にcode.lstファイルを保存しますか？", "確認",
                    MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.Yes)) {
                        SaveCodeList();
                        this.visited.Save();
            }
        }

        /// <summary>
        /// 全文検索テキストボックスでキー押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void textBox3_KeyPress(object sender, KeyPressEventArgs e)
        {
            switch( e.KeyChar ) {
            case (char)Keys.Enter:
                if (textBox3.Text.Length == 0)
                {
                    MessageBox.Show("検索ワードを入力してください。");
                    return;
                }
                DoSearchAllTitles();
                break;
            default:
                break;
            }
        }

        /// <summary>
        /// TreeViewで名称変更後の処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void treeView1_AfterLabelEdit(object sender, NodeLabelEditEventArgs e)
        {
            try
            {
                bool editOk = true;
                if (e.Node.Parent == null)
                { // フォルダ
                    treeView1.SelectedNode.Text = e.Node.Text;
                    treeView1.SelectedNode.Name = e.Node.Text;
                    treeView1.SelectedNode.ImageIndex = (int)ImageList.CloseFolder;
                    e.Node.EndEdit(false);
                } else {

                    string outCode = "";
                    if (e.Label.Length > 0)
                    {
                        if (e.Label.IndexOf(tvdelimiter) == -1) editOk = false;
                        if (!IsRegularCode(e.Label, out outCode)) editOk = false;
                        if (!editOk)
                        {
                            MessageBox.Show("銘柄名称を変更する場合は、コードと名称の間を全角スペースで空けて下さい.");
                            e.CancelEdit = true;
                            e.Node.EndEdit(true);
                        } else {

                            treeView1.SelectedNode.Text = e.Label;
                            e.Node.EndEdit(false);
                        }
                    }
                }
                this.treeView1.LabelEdit = false;
            }
            catch (NullReferenceException exp)
            {
                e.CancelEdit = true;
                e.Node.EndEdit(true);
            }
        }

        private void webBrowser2_StartNewWindow(object sender, BrowserExtendedNavigatingEventArgs e)
        {
            this.textBox2.AppendText("( ･∀･)ﾉ > StartNewWindowイベント補足" + csCrLf);
            FormBrowser fb = new FormBrowser();
            e.AutomationObject = fb.getBrowser().ApplicationAx;
        }

        private void webBrowser2_NewWindow(object sender, CancelEventArgs e)
        {
            this.textBox2.AppendText("( ･∀･)ﾉ > NewWindowイベント補足" + csCrLf);
            
        }

        #endregion

        private void button1_Click(object sender, EventArgs e)
        {
            string[]  t;
            t = new string[5352];

            t[0] = "0001";
            t[1] = "1301";
            t[2] = "1305";
            t[3] = "1306";
            t[4] = "1308";
            t[5] = "1309";
            t[6] = "1310";
            t[7] = "1311";
            t[8] = "1312";
            t[9] = "1313";
            t[10] = "1314";
            t[11] = "1316";
            t[12] = "1317";
            t[13] = "1318";
            t[14] = "1319";
            t[15] = "1319";
            t[16] = "1320";
            t[17] = "1321";
            t[18] = "1322";
            t[19] = "1323";
            t[20] = "1324";
            t[21] = "1325";
            t[22] = "1326";
            t[23] = "1327";
            t[24] = "1328";
            t[25] = "1329";
            t[26] = "1330";
            t[27] = "1331";
            t[28] = "1332";
            t[29] = "1332";
            t[30] = "1334";
            t[31] = "1343";
            t[32] = "1344";
            t[33] = "1345";
            t[34] = "1346";
            t[35] = "1347";
            t[36] = "1348";
            t[37] = "1349";
            t[38] = "1352";
            t[39] = "1376";
            t[40] = "1377";
            t[41] = "1378";
            t[42] = "1379";
            t[43] = "1380";
            t[44] = "1381";
            t[45] = "1382";
            t[46] = "1383";
            t[47] = "1400";
            t[48] = "1400";
            t[49] = "1401";
            t[50] = "1405";
            t[51] = "1407";
            t[52] = "1408";
            t[53] = "1408";
            t[54] = "1412";
            t[55] = "1413";
            t[56] = "1414";
            t[57] = "1416";
            t[58] = "1417";
            t[59] = "1417";
            t[60] = "1418";
            t[61] = "1491";
            t[62] = "1491";
            t[63] = "1503";
            t[64] = "1514";
            t[65] = "1515";
            t[66] = "1518";
            t[67] = "1540";
            t[68] = "1541";
            t[69] = "1542";
            t[70] = "1543";
            t[71] = "1544";
            t[72] = "1545";
            t[73] = "1546";
            t[74] = "1547";
            t[75] = "1548";
            t[76] = "1549";
            t[77] = "1550";
            t[78] = "1551";
            t[79] = "1552";
            t[80] = "1553";
            t[81] = "1554";
            t[82] = "1555";
            t[83] = "1556";
            t[84] = "1557";
            t[85] = "1559";
            t[86] = "1560";
            t[87] = "1561";
            t[88] = "1562";
            t[89] = "1565";
            t[90] = "1566";
            t[91] = "1567";
            t[92] = "1568";
            t[93] = "1569";
            t[94] = "1570";
            t[95] = "1571";
            t[96] = "1601";
            t[97] = "1604";
            t[98] = "1605";
            t[99] = "1606";
            t[100] = "1610";
            t[101] = "1612";
            t[102] = "1613";
            t[103] = "1615";
            t[104] = "1617";
            t[105] = "1618";
            t[106] = "1619";
            t[107] = "1620";
            t[108] = "1621";
            t[109] = "1622";
            t[110] = "1623";
            t[111] = "1624";
            t[112] = "1625";
            t[113] = "1626";
            t[114] = "1627";
            t[115] = "1628";
            t[116] = "1629";
            t[117] = "1630";
            t[118] = "1631";
            t[119] = "1632";
            t[120] = "1633";
            t[121] = "1634";
            t[122] = "1635";
            t[123] = "1636";
            t[124] = "1637";
            t[125] = "1638";
            t[126] = "1639";
            t[127] = "1640";
            t[128] = "1641";
            t[129] = "1642";
            t[130] = "1643";
            t[131] = "1644";
            t[132] = "1645";
            t[133] = "1646";
            t[134] = "1647";
            t[135] = "1648";
            t[136] = "1649";
            t[137] = "1650";
            t[138] = "1661";
            t[139] = "1662";
            t[140] = "1670";
            t[141] = "1671";
            t[142] = "1672";
            t[143] = "1673";
            t[144] = "1674";
            t[145] = "1675";
            t[146] = "1676";
            t[147] = "1677";
            t[148] = "1678";
            t[149] = "1679";
            t[150] = "1680";
            t[151] = "1681";
            t[152] = "1682";
            t[153] = "1683";
            t[154] = "1684";
            t[155] = "1685";
            t[156] = "1686";
            t[157] = "1687";
            t[158] = "1688";
            t[159] = "1689";
            t[160] = "1690";
            t[161] = "1691";
            t[162] = "1692";
            t[163] = "1693";
            t[164] = "1694";
            t[165] = "1695";
            t[166] = "1696";
            t[167] = "1697";
            t[168] = "1698";
            t[169] = "1699";
            t[170] = "1701";
            t[171] = "1702";
            t[172] = "1710";
            t[173] = "1711";
            t[174] = "1712";
            t[175] = "1715";
            t[176] = "1716";
            t[177] = "1717";
            t[178] = "1718";
            t[179] = "1719";
            t[180] = "1720";
            t[181] = "1721";
            t[182] = "1721";
            t[183] = "1722";
            t[184] = "1722";
            t[185] = "1723";
            t[186] = "1724";
            t[187] = "1725";
            t[188] = "1726";
            t[189] = "1728";
            t[190] = "1729";
            t[191] = "1730";
            t[192] = "1731";
            t[193] = "1734";
            t[194] = "1735";
            t[195] = "1736";
            t[196] = "1737";
            t[197] = "1738";
            t[198] = "1739";
            t[199] = "1739";
            t[200] = "1741";
            t[201] = "1742";
            t[202] = "1743";
            t[203] = "1744";
            t[204] = "1748";
            t[205] = "1750";
            t[206] = "1751";
            t[207] = "1753";
            t[208] = "1754";
            t[209] = "1756";
            t[210] = "1757";
            t[211] = "1758";
            t[212] = "1762";
            t[213] = "1762";
            t[214] = "1763";
            t[215] = "1764";
            t[216] = "1766";
            t[217] = "1767";
            t[218] = "1768";
            t[219] = "1770";
            t[220] = "1771";
            t[221] = "1773";
            t[222] = "1775";
            t[223] = "1776";
            t[224] = "1777";
            t[225] = "1778";
            t[226] = "1779";
            t[227] = "1780";
            t[228] = "1781";
            t[229] = "1782";
            t[230] = "1783";
            t[231] = "1786";
            t[232] = "1787";
            t[233] = "1788";
            t[234] = "1789";
            t[235] = "1792";
            t[236] = "1793";
            t[237] = "1795";
            t[238] = "1798";
            t[239] = "1799";
            t[240] = "1800";
            t[241] = "1801";
            t[242] = "1801";
            t[243] = "1802";
            t[244] = "1802";
            t[245] = "1803";
            t[246] = "1803";
            t[247] = "1805";
            t[248] = "1807";
            t[249] = "1808";
            t[250] = "1808";
            t[251] = "1810";
            t[252] = "1811";
            t[253] = "1812";
            t[254] = "1812";
            t[255] = "1813";
            t[256] = "1813";
            t[257] = "1814";
            t[258] = "1814";
            t[259] = "1815";
            t[260] = "1816";
            t[261] = "1819";
            t[262] = "1820";
            t[263] = "1821";
            t[264] = "1822";
            t[265] = "1824";
            t[266] = "1826";
            t[267] = "1827";
            t[268] = "1828";
            t[269] = "1828";
            t[270] = "1832";
            t[271] = "1833";
            t[272] = "1833";
            t[273] = "1834";
            t[274] = "1835";
            t[275] = "1839";
            t[276] = "1840";
            t[277] = "1841";
            t[278] = "1844";
            t[279] = "1846";
            t[280] = "1847";
            t[281] = "1848";
            t[282] = "1850";
            t[283] = "1852";
            t[284] = "1852";
            t[285] = "1853";
            t[286] = "1854";
            t[287] = "1858";
            t[288] = "1860";
            t[289] = "1860";
            t[290] = "1861";
            t[291] = "1862";
            t[292] = "1865";
            t[293] = "1866";
            t[294] = "1867";
            t[295] = "1868";
            t[296] = "1869";
            t[297] = "1870";
            t[298] = "1871";
            t[299] = "1872";
            t[300] = "1873";
            t[301] = "1875";
            t[302] = "1876";
            t[303] = "1877";
            t[304] = "1878";
            t[305] = "1879";
            t[306] = "1880";
            t[307] = "1881";
            t[308] = "1882";
            t[309] = "1883";
            t[310] = "1884";
            t[311] = "1885";
            t[312] = "1887";
            t[313] = "1888";
            t[314] = "1889";
            t[315] = "1890";
            t[316] = "1890";
            t[317] = "1892";
            t[318] = "1893";
            t[319] = "1895";
            t[320] = "1896";
            t[321] = "1897";
            t[322] = "1898";
            t[323] = "1899";
            t[324] = "1900";
            t[325] = "1902";
            t[326] = "1904";
            t[327] = "1905";
            t[328] = "1906";
            t[329] = "1907";
            t[330] = "1908";
            t[331] = "1909";
            t[332] = "1911";
            t[333] = "1911";
            t[334] = "1913";
            t[335] = "1914";
            t[336] = "1914";
            t[337] = "1916";
            t[338] = "1919";
            t[339] = "1921";
            t[340] = "1924";
            t[341] = "1924";
            t[342] = "1925";
            t[343] = "1925";
            t[344] = "1926";
            t[345] = "1928";
            t[346] = "1928";
            t[347] = "1929";
            t[348] = "1930";
            t[349] = "1931";
            t[350] = "1932";
            t[351] = "1933";
            t[352] = "1934";
            t[353] = "1935";
            t[354] = "1936";
            t[355] = "1937";
            t[356] = "1937";
            t[357] = "1938";
            t[358] = "1939";
            t[359] = "1940";
            t[360] = "1941";
            t[361] = "1942";
            t[362] = "1943";
            t[363] = "1944";
            t[364] = "1944";
            t[365] = "1945";
            t[366] = "1946";
            t[367] = "1948";
            t[368] = "1949";
            t[369] = "1949";
            t[370] = "1950";
            t[371] = "1951";
            t[372] = "1952";
            t[373] = "1953";
            t[374] = "1954";
            t[375] = "1955";
            t[376] = "1956";
            t[377] = "1957";
            t[378] = "1959";
            t[379] = "1960";
            t[380] = "1961";
            t[381] = "1963";
            t[382] = "1964";
            t[383] = "1964";
            t[384] = "1965";
            t[385] = "1966";
            t[386] = "1967";
            t[387] = "1968";
            t[388] = "1969";
            t[389] = "1970";
            t[390] = "1971";
            t[391] = "1972";
            t[392] = "1972";
            t[393] = "1973";
            t[394] = "1975";
            t[395] = "1975";
            t[396] = "1976";
            t[397] = "1978";
            t[398] = "1978";
            t[399] = "1979";
            t[400] = "1980";
            t[401] = "1980";
            t[402] = "1981";
            t[403] = "1982";
            t[404] = "1983";
            t[405] = "1984";
            t[406] = "1985";
            t[407] = "1986";
            t[408] = "1987";
            t[409] = "1988";
            t[410] = "1989";
            t[411] = "1990";
            t[412] = "1991";
            t[413] = "1992";
            t[414] = "1994";
            t[415] = "1995";
            t[416] = "1997";
            t[417] = "1998";
            t[418] = "1999";
            t[419] = "2001";
            t[420] = "2001";
            t[421] = "2002";
            t[422] = "2002";
            t[423] = "2003";
            t[424] = "2004";
            t[425] = "2004";
            t[426] = "2006";
            t[427] = "2008";
            t[428] = "2009";
            t[429] = "2026";
            t[430] = "2030";
            t[431] = "2051";
            t[432] = "2052";
            t[433] = "2053";
            t[434] = "2055";
            t[435] = "2056";
            t[436] = "2057";
            t[437] = "2058";
            t[438] = "2059";
            t[439] = "2107";
            t[440] = "2108";
            t[441] = "2109";
            t[442] = "2109";
            t[443] = "2112";
            t[444] = "2113";
            t[445] = "2114";
            t[446] = "2116";
            t[447] = "2117";
            t[448] = "2120";
            t[449] = "2121";
            t[450] = "2122";
            t[451] = "2123";
            t[452] = "2124";
            t[453] = "2126";
            t[454] = "2127";
            t[455] = "2128";
            t[456] = "2130";
            t[457] = "2131";
            t[458] = "2132";
            t[459] = "2132";
            t[460] = "2133";
            t[461] = "2134";
            t[462] = "2134";
            t[463] = "2135";
            t[464] = "2136";
            t[465] = "2137";
            t[466] = "2138";
            t[467] = "2138";
            t[468] = "2139";
            t[469] = "2140";
            t[470] = "2142";
            t[471] = "2144";
            t[472] = "2144";
            t[473] = "2145";
            t[474] = "2146";
            t[475] = "2147";
            t[476] = "2148";
            t[477] = "2149";
            t[478] = "2150";
            t[479] = "2151";
            t[480] = "2152";
            t[481] = "2152";
            t[482] = "2153";
            t[483] = "2154";
            t[484] = "2155";
            t[485] = "2156";
            t[486] = "2157";
            t[487] = "2158";
            t[488] = "2159";
            t[489] = "2160";
            t[490] = "2162";
            t[491] = "2163";
            t[492] = "2164";
            t[493] = "2164";
            t[494] = "2165";
            t[495] = "2166";
            t[496] = "2167";
            t[497] = "2168";
            t[498] = "2169";
            t[499] = "2169";
            t[500] = "2169";
            t[501] = "2170";
            t[502] = "2172";
            t[503] = "2173";
            t[504] = "2173";
            t[505] = "2174";
            t[506] = "2175";
            t[507] = "2176";
            t[508] = "2177";
            t[509] = "2177";
            t[510] = "2178";
            t[511] = "2179";
            t[512] = "2180";
            t[513] = "2180";
            t[514] = "2181";
            t[515] = "2182";
            t[516] = "2182";
            t[517] = "2183";
            t[518] = "2185";
            t[519] = "2186";
            t[520] = "2190";
            t[521] = "2190";
            t[522] = "2191";
            t[523] = "2193";
            t[524] = "2195";
            t[525] = "2196";
            t[526] = "2198";
            t[527] = "2198";
            t[528] = "2201";
            t[529] = "2202";
            t[530] = "2204";
            t[531] = "2204";
            t[532] = "2206";
            t[533] = "2206";
            t[534] = "2207";
            t[535] = "2208";
            t[536] = "2209";
            t[537] = "2211";
            t[538] = "2212";
            t[539] = "2212";
            t[540] = "2215";
            t[541] = "2216";
            t[542] = "2217";
            t[543] = "2217";
            t[544] = "2218";
            t[545] = "2220";
            t[546] = "2221";
            t[547] = "2222";
            t[548] = "2224";
            t[549] = "2226";
            t[550] = "2228";
            t[551] = "2229";
            t[552] = "2230";
            t[553] = "2261";
            t[554] = "2262";
            t[555] = "2264";
            t[556] = "2264";
            t[557] = "2266";
            t[558] = "2267";
            t[559] = "2268";
            t[560] = "2269";
            t[561] = "2270";
            t[562] = "2281";
            t[563] = "2281";
            t[564] = "2282";
            t[565] = "2282";
            t[566] = "2284";
            t[567] = "2284";
            t[568] = "2286";
            t[569] = "2288";
            t[570] = "2288";
            t[571] = "2289";
            t[572] = "2290";
            t[573] = "2291";
            t[574] = "2292";
            t[575] = "2292";
            t[576] = "2293";
            t[577] = "2294";
            t[578] = "2300";
            t[579] = "2301";
            t[580] = "2301";
            t[581] = "2303";
            t[582] = "2303";
            t[583] = "2304";
            t[584] = "2305";
            t[585] = "2306";
            t[586] = "2307";
            t[587] = "2309";
            t[588] = "2310";
            t[589] = "2311";
            t[590] = "2315";
            t[591] = "2316";
            t[592] = "2317";
            t[593] = "2318";
            t[594] = "2318";
            t[595] = "2320";
            t[596] = "2321";
            t[597] = "2321";
            t[598] = "2322";
            t[599] = "2323";
            t[600] = "2323";
            t[601] = "2324";
            t[602] = "2325";
            t[603] = "2326";
            t[604] = "2326";
            t[605] = "2326";
            t[606] = "2327";
            t[607] = "2328";
            t[608] = "2329";
            t[609] = "2330";
            t[610] = "2331";
            t[611] = "2332";
            t[612] = "2333";
            t[613] = "2335";
            t[614] = "2335";
            t[615] = "2337";
            t[616] = "2337";
            t[617] = "2338";
            t[618] = "2340";
            t[619] = "2341";
            t[620] = "2342";
            t[621] = "2344";
            t[622] = "2345";
            t[623] = "2347";
            t[624] = "2349";
            t[625] = "2350";
            t[626] = "2351";
            t[627] = "2352";
            t[628] = "2353";
            t[629] = "2353";
            t[630] = "2354";
            t[631] = "2355";
            t[632] = "2356";
            t[633] = "2359";
            t[634] = "2360";
            t[635] = "2361";
            t[636] = "2362";
            t[637] = "2362";
            t[638] = "2363";
            t[639] = "2366";
            t[640] = "2369";
            t[641] = "2370";
            t[642] = "2371";
            t[643] = "2372";
            t[644] = "2372";
            t[645] = "2373";
            t[646] = "2373";
            t[647] = "2374";
            t[648] = "2375";
            t[649] = "2376";
            t[650] = "2376";
            t[651] = "2377";
            t[652] = "2378";
            t[653] = "2378";
            t[654] = "2379";
            t[655] = "2383";
            t[656] = "2384";
            t[657] = "2385";
            t[658] = "2386";
            t[659] = "2387";
            t[660] = "2388";
            t[661] = "2388";
            t[662] = "2389";
            t[663] = "2391";
            t[664] = "2392";
            t[665] = "2393";
            t[666] = "2394";
            t[667] = "2394";
            t[668] = "2395";
            t[669] = "2396";
            t[670] = "2397";
            t[671] = "2398";
            t[672] = "2398";
            t[673] = "2399";
            t[674] = "2400";
            t[675] = "2402";
            t[676] = "2403";
            t[677] = "2404";
            t[678] = "2405";
            t[679] = "2406";
            t[680] = "2408";
            t[681] = "2409";
            t[682] = "2410";
            t[683] = "2411";
            t[684] = "2412";
            t[685] = "2412";
            t[686] = "2413";
            t[687] = "2414";
            t[688] = "2415";
            t[689] = "2416";
            t[690] = "2417";
            t[691] = "2417";
            t[692] = "2418";
            t[693] = "2419";
            t[694] = "2419";
            t[695] = "2420";
            t[696] = "2420";
            t[697] = "2421";
            t[698] = "2423";
            t[699] = "2425";
            t[700] = "2425";
            t[701] = "2426";
            t[702] = "2427";
            t[703] = "2427";
            t[704] = "2428";
            t[705] = "2429";
            t[706] = "2430";
            t[707] = "2431";
            t[708] = "2432";
            t[709] = "2433";
            t[710] = "2434";
            t[711] = "2435";
            t[712] = "2436";
            t[713] = "2437";
            t[714] = "2437";
            t[715] = "2438";
            t[716] = "2440";
            t[717] = "2440";
            t[718] = "2444";
            t[719] = "2444";
            t[720] = "2445";
            t[721] = "2445";
            t[722] = "2446";
            t[723] = "2447";
            t[724] = "2449";
            t[725] = "2450";
            t[726] = "2451";
            t[727] = "2453";
            t[728] = "2454";
            t[729] = "2458";
            t[730] = "2459";
            t[731] = "2461";
            t[732] = "2462";
            t[733] = "2463";
            t[734] = "2464";
            t[735] = "2465";
            t[736] = "2466";
            t[737] = "2467";
            t[738] = "2468";
            t[739] = "2469";
            t[740] = "2471";
            t[741] = "2471";
            t[742] = "2473";
            t[743] = "2475";
            t[744] = "2475";
            t[745] = "2476";
            t[746] = "2477";
            t[747] = "2478";
            t[748] = "2479";
            t[749] = "2479";
            t[750] = "2480";
            t[751] = "2481";
            t[752] = "2483";
            t[753] = "2483";
            t[754] = "2484";
            t[755] = "2484";
            t[756] = "2485";
            t[757] = "2486";
            t[758] = "2487";
            t[759] = "2488";
            t[760] = "2489";
            t[761] = "2490";
            t[762] = "2491";
            t[763] = "2492";
            t[764] = "2493";
            t[765] = "2493";
            t[766] = "2494";
            t[767] = "2495";
            t[768] = "2496";
            t[769] = "2497";
            t[770] = "2498";
            t[771] = "2499";
            t[772] = "2499";
            t[773] = "2501";
            t[774] = "2502";
            t[775] = "2502";
            t[776] = "2503";
            t[777] = "2503";
            t[778] = "2531";
            t[779] = "2531";
            t[780] = "2533";
            t[781] = "2533";
            t[782] = "2536";
            t[783] = "2538";
            t[784] = "2540";
            t[785] = "2551";
            t[786] = "2572";
            t[787] = "2573";
            t[788] = "2578";
            t[789] = "2579";
            t[790] = "2579";
            t[791] = "2580";
            t[792] = "2589";
            t[793] = "2590";
            t[794] = "2591";
            t[795] = "2593";
            t[796] = "25935";
            t[797] = "2594";
            t[798] = "2596";
            t[799] = "2597";
            t[800] = "2598";
            t[801] = "2599";
            t[802] = "2602";
            t[803] = "2602";
            t[804] = "2607";
            t[805] = "2607";
            t[806] = "2608";
            t[807] = "2611";
            t[808] = "2612";
            t[809] = "2612";
            t[810] = "2613";
            t[811] = "2613";
            t[812] = "2650";
            t[813] = "2651";
            t[814] = "2651";
            t[815] = "2652";
            t[816] = "2653";
            t[817] = "2654";
            t[818] = "2655";
            t[819] = "2656";
            t[820] = "2656";
            t[821] = "2657";
            t[822] = "2658";
            t[823] = "2659";
            t[824] = "2659";
            t[825] = "2660";
            t[826] = "2660";
            t[827] = "2661";
            t[828] = "2662";
            t[829] = "2662";
            t[830] = "2664";
            t[831] = "2665";
            t[832] = "2666";
            t[833] = "2667";
            t[834] = "2667";
            t[835] = "2668";
            t[836] = "2669";
            t[837] = "2670";
            t[838] = "2673";
            t[839] = "2674";
            t[840] = "2675";
            t[841] = "2676";
            t[842] = "2678";
            t[843] = "2680";
            t[844] = "2681";
            t[845] = "2682";
            t[846] = "2683";
            t[847] = "2684";
            t[848] = "2685";
            t[849] = "2686";
            t[850] = "2687";
            t[851] = "2688";
            t[852] = "2689";
            t[853] = "2690";
            t[854] = "2692";
            t[855] = "2693";
            t[856] = "2694";
            t[857] = "2695";
            t[858] = "2696";
            t[859] = "2697";
            t[860] = "2698";
            t[861] = "2700";
            t[862] = "2702";
            t[863] = "2703";
            t[864] = "2705";
            t[865] = "2706";
            t[866] = "2708";
            t[867] = "2709";
            t[868] = "2710";
            t[869] = "2710";
            t[870] = "2712";
            t[871] = "2712";
            t[872] = "2714";
            t[873] = "2715";
            t[874] = "2717";
            t[875] = "2718";
            t[876] = "2719";
            t[877] = "2719";
            t[878] = "2721";
            t[879] = "2722";
            t[880] = "2723";
            t[881] = "2724";
            t[882] = "2724";
            t[883] = "2725";
            t[884] = "2725";
            t[885] = "2726";
            t[886] = "2727";
            t[887] = "2729";
            t[888] = "2730";
            t[889] = "2731";
            t[890] = "2733";
            t[891] = "2733";
            t[892] = "2734";
            t[893] = "2735";
            t[894] = "2736";
            t[895] = "2737";
            t[896] = "2738";
            t[897] = "2738";
            t[898] = "2742";
            t[899] = "2743";
            t[900] = "2744";
            t[901] = "2746";
            t[902] = "2747";
            t[903] = "2749";
            t[904] = "2749";
            t[905] = "2750";
            t[906] = "2751";
            t[907] = "2752";
            t[908] = "2752";
            t[909] = "2753";
            t[910] = "2754";
            t[911] = "2756";
            t[912] = "2757";
            t[913] = "2759";
            t[914] = "2760";
            t[915] = "2761";
            t[916] = "2762";
            t[917] = "2763";
            t[918] = "2764";
            t[919] = "2766";
            t[920] = "2767";
            t[921] = "2768";
            t[922] = "2768";
            t[923] = "2769";
            t[924] = "2772";
            t[925] = "2773";
            t[926] = "2774";
            t[927] = "2775";
            t[928] = "2776";
            t[929] = "2777";
            t[930] = "2778";
            t[931] = "2779";
            t[932] = "2780";
            t[933] = "2780";
            t[934] = "2781";
            t[935] = "2782";
            t[936] = "2784";
            t[937] = "2784";
            t[938] = "2786";
            t[939] = "2788";
            t[940] = "2789";
            t[941] = "2790";
            t[942] = "2791";
            t[943] = "2791";
            t[944] = "2792";
            t[945] = "2792";
            t[946] = "2793";
            t[947] = "2794";
            t[948] = "2794";
            t[949] = "2795";
            t[950] = "2796";
            t[951] = "2797";
            t[952] = "2798";
            t[953] = "2799";
            t[954] = "2801";
            t[955] = "2801";
            t[956] = "2802";
            t[957] = "2802";
            t[958] = "2804";
            t[959] = "2805";
            t[960] = "2806";
            t[961] = "2809";
            t[962] = "2810";
            t[963] = "2810";
            t[964] = "2811";
            t[965] = "2812";
            t[966] = "2813";
            t[967] = "2814";
            t[968] = "2815";
            t[969] = "2816";
            t[970] = "2817";
            t[971] = "2818";
            t[972] = "2819";
            t[973] = "2830";
            t[974] = "2831";
            t[975] = "2871";
            t[976] = "2872";
            t[977] = "2873";
            t[978] = "2874";
            t[979] = "2875";
            t[980] = "2876";
            t[981] = "2877";
            t[982] = "2878";
            t[983] = "2879";
            t[984] = "2882";
            t[985] = "2891";
            t[986] = "2892";
            t[987] = "2893";
            t[988] = "2894";
            t[989] = "2897";
            t[990] = "2897";
            t[991] = "2898";
            t[992] = "2899";
            t[993] = "2900";
            t[994] = "2901";
            t[995] = "2902";
            t[996] = "2903";
            t[997] = "2904";
            t[998] = "2905";
            t[999] = "2906";
            t[1000] = "2907";
            t[1001] = "2907";
            t[1002] = "2908";
            t[1003] = "2908";
            t[1004] = "2909";
            t[1005] = "2910";
            t[1006] = "2910";
            t[1007] = "2911";
            t[1008] = "2912";
            t[1009] = "2913";
            t[1010] = "2914";
            t[1011] = "2914";
            t[1012] = "2915";
            t[1013] = "2915";
            t[1014] = "2916";
            t[1015] = "2917";
            t[1016] = "2918";
            t[1017] = "2919";
            t[1018] = "2921";
            t[1019] = "2922";
            t[1020] = "2923";
            t[1021] = "2924";
            t[1022] = "2924";
            t[1023] = "2925";
            t[1024] = "2926";
            t[1025] = "2927";
            t[1026] = "2928";
            t[1027] = "2929";
            t[1028] = "2931";
            t[1029] = "3001";
            t[1030] = "3002";
            t[1031] = "3002";
            t[1032] = "3003";
            t[1033] = "3004";
            t[1034] = "3004";
            t[1035] = "3009";
            t[1036] = "3010";
            t[1037] = "3011";
            t[1038] = "3020";
            t[1039] = "3021";
            t[1040] = "3022";
            t[1041] = "3023";
            t[1042] = "3024";
            t[1043] = "3027";
            t[1044] = "3028";
            t[1045] = "3030";
            t[1046] = "3030";
            t[1047] = "3031";
            t[1048] = "3032";
            t[1049] = "3033";
            t[1050] = "3034";
            t[1051] = "3034";
            t[1052] = "3034";
            t[1053] = "3035";
            t[1054] = "3036";
            t[1055] = "3036";
            t[1056] = "3037";
            t[1057] = "3037";
            t[1058] = "3038";
            t[1059] = "3040";
            t[1060] = "3041";
            t[1061] = "3042";
            t[1062] = "3042";
            t[1063] = "3043";
            t[1064] = "3043";
            t[1065] = "3044";
            t[1066] = "3045";
            t[1067] = "3046";
            t[1068] = "3046";
            t[1069] = "3047";
            t[1070] = "3048";
            t[1071] = "3048";
            t[1072] = "3049";
            t[1073] = "3050";
            t[1074] = "3051";
            t[1075] = "3052";
            t[1076] = "3053";
            t[1077] = "3054";
            t[1078] = "3055";
            t[1079] = "3057";
            t[1080] = "3058";
            t[1081] = "3059";
            t[1082] = "3060";
            t[1083] = "3061";
            t[1084] = "3062";
            t[1085] = "3063";
            t[1086] = "3064";
            t[1087] = "3065";
            t[1088] = "3066";
            t[1089] = "3067";
            t[1090] = "3068";
            t[1091] = "3069";
            t[1092] = "3069";
            t[1093] = "3070";
            t[1094] = "3070";
            t[1095] = "3071";
            t[1096] = "3073";
            t[1097] = "3073";
            t[1098] = "3074";
            t[1099] = "3075";
            t[1100] = "3076";
            t[1101] = "3077";
            t[1102] = "3078";
            t[1103] = "3079";
            t[1104] = "3080";
            t[1105] = "3080";
            t[1106] = "3082";
            t[1107] = "3082";
            t[1108] = "3083";
            t[1109] = "3083";
            t[1110] = "3085";
            t[1111] = "3086";
            t[1112] = "3086";
            t[1113] = "3087";
            t[1114] = "3088";
            t[1115] = "3089";
            t[1116] = "3089";
            t[1117] = "3090";
            t[1118] = "3090";
            t[1119] = "3091";
            t[1120] = "3091";
            t[1121] = "3092";
            t[1122] = "3093";
            t[1123] = "3094";
            t[1124] = "3095";
            t[1125] = "3096";
            t[1126] = "3097";
            t[1127] = "3097";
            t[1128] = "3098";
            t[1129] = "3099";
            t[1130] = "3101";
            t[1131] = "3101";
            t[1132] = "3103";
            t[1133] = "3103";
            t[1134] = "3104";
            t[1135] = "3104";
            t[1136] = "3105";
            t[1137] = "3105";
            t[1138] = "3106";
            t[1139] = "3106";
            t[1140] = "3107";
            t[1141] = "3107";
            t[1142] = "3109";
            t[1143] = "3109";
            t[1144] = "3110";
            t[1145] = "3110";
            t[1146] = "3111";
            t[1147] = "3111";
            t[1148] = "3113";
            t[1149] = "3114";
            t[1150] = "3116";
            t[1151] = "3117";
            t[1152] = "3121";
            t[1153] = "3123";
            t[1154] = "3125";
            t[1155] = "3128";
            t[1156] = "3129";
            t[1157] = "3140";
            t[1158] = "3140";
            t[1159] = "3141";
            t[1160] = "3143";
            t[1161] = "3146";
            t[1162] = "3147";
            t[1163] = "3147";
            t[1164] = "3148";
            t[1165] = "3150";
            t[1166] = "3151";
            t[1167] = "3153";
            t[1168] = "3154";
            t[1169] = "3156";
            t[1170] = "3157";
            t[1171] = "3159";
            t[1172] = "3160";
            t[1173] = "3161";
            t[1174] = "3163";
            t[1175] = "3165";
            t[1176] = "3166";
            t[1177] = "3167";
            t[1178] = "3168";
            t[1179] = "3169";
            t[1180] = "3170";
            t[1181] = "3171";
            t[1182] = "3172";
            t[1183] = "3173";
            t[1184] = "3174";
            t[1185] = "3175";
            t[1186] = "3176";
            t[1187] = "3177";
            t[1188] = "3178";
            t[1189] = "3179";
            t[1190] = "3180";
            t[1191] = "3181";
            t[1192] = "3201";
            t[1193] = "3201";
            t[1194] = "3202";
            t[1195] = "3204";
            t[1196] = "3204";
            t[1197] = "3205";
            t[1198] = "3207";
            t[1199] = "3209";
            t[1200] = "3216";
            t[1201] = "3225";
            t[1202] = "3226";
            t[1203] = "3227";
            t[1204] = "3228";
            t[1205] = "3228";
            t[1206] = "3229";
            t[1207] = "3230";
            t[1208] = "3230";
            t[1209] = "3231";
            t[1210] = "3232";
            t[1211] = "3233";
            t[1212] = "3234";
            t[1213] = "3235";
            t[1214] = "3236";
            t[1215] = "3237";
            t[1216] = "3238";
            t[1217] = "3239";
            t[1218] = "3240";
            t[1219] = "3241";
            t[1220] = "3242";
            t[1221] = "3243";
            t[1222] = "3244";
            t[1223] = "3244";
            t[1224] = "3245";
            t[1225] = "3246";
            t[1226] = "3246";
            t[1227] = "3247";
            t[1228] = "3248";
            t[1229] = "3249";
            t[1230] = "3250";
            t[1231] = "3251";
            t[1232] = "3252";
            t[1233] = "3254";
            t[1234] = "3258";
            t[1235] = "3259";
            t[1236] = "3260";
            t[1237] = "3263";
            t[1238] = "3264";
            t[1239] = "3265";
            t[1240] = "3266";
            t[1241] = "3268";
            t[1242] = "3269";
            t[1243] = "3271";
            t[1244] = "3272";
            t[1245] = "3274";
            t[1246] = "3275";
            t[1247] = "3276";
            t[1248] = "3277";
            t[1249] = "3278";
            t[1250] = "3279";
            t[1251] = "3280";
            t[1252] = "3281";
            t[1253] = "3282";
            t[1254] = "3283";
            t[1255] = "3302";
            t[1256] = "3304";
            t[1257] = "3306";
            t[1258] = "3310";
            t[1259] = "3311";
            t[1260] = "3313";
            t[1261] = "3315";
            t[1262] = "3316";
            t[1263] = "3317";
            t[1264] = "3318";
            t[1265] = "3319";
            t[1266] = "3320";
            t[1267] = "3321";
            t[1268] = "3322";
            t[1269] = "3323";
            t[1270] = "3323";
            t[1271] = "3325";
            t[1272] = "3326";
            t[1273] = "3328";
            t[1274] = "3329";
            t[1275] = "3330";
            t[1276] = "3331";
            t[1277] = "3332";
            t[1278] = "3332";
            t[1279] = "3333";
            t[1280] = "3333";
            t[1281] = "3335";
            t[1282] = "3337";
            t[1283] = "3338";
            t[1284] = "3339";
            t[1285] = "3340";
            t[1286] = "3341";
            t[1287] = "3343";
            t[1288] = "3344";
            t[1289] = "3346";
            t[1290] = "3347";
            t[1291] = "3348";
            t[1292] = "3349";
            t[1293] = "3350";
            t[1294] = "3352";
            t[1295] = "3353";
            t[1296] = "3354";
            t[1297] = "3355";
            t[1298] = "3356";
            t[1299] = "3358";
            t[1300] = "3359";
            t[1301] = "3360";
            t[1302] = "3361";
            t[1303] = "3362";
            t[1304] = "3362";
            t[1305] = "3364";
            t[1306] = "3366";
            t[1307] = "3366";
            t[1308] = "3367";
            t[1309] = "3370";
            t[1310] = "3371";
            t[1311] = "3371";
            t[1312] = "3372";
            t[1313] = "3373";
            t[1314] = "3374";
            t[1315] = "3375";
            t[1316] = "3376";
            t[1317] = "3376";
            t[1318] = "3377";
            t[1319] = "3377";
            t[1320] = "3381";
            t[1321] = "3382";
            t[1322] = "3383";
            t[1323] = "3384";
            t[1324] = "3385";
            t[1325] = "3386";
            t[1326] = "3387";
            t[1327] = "3388";
            t[1328] = "3390";
            t[1329] = "3391";
            t[1330] = "3392";
            t[1331] = "3393";
            t[1332] = "3394";
            t[1333] = "3395";
            t[1334] = "3396";
            t[1335] = "3397";
            t[1336] = "3398";
            t[1337] = "3399";
            t[1338] = "3401";
            t[1339] = "3401";
            t[1340] = "3402";
            t[1341] = "3402";
            t[1342] = "3403";
            t[1343] = "3404";
            t[1344] = "3405";
            t[1345] = "3407";
            t[1346] = "3407";
            t[1347] = "3408";
            t[1348] = "3409";
            t[1349] = "3409";
            t[1350] = "3411";
            t[1351] = "3420";
            t[1352] = "3421";
            t[1353] = "3422";
            t[1354] = "3423";
            t[1355] = "3424";
            t[1356] = "3425";
            t[1357] = "3426";
            t[1358] = "3428";
            t[1359] = "3429";
            t[1360] = "3431";
            t[1361] = "3432";
            t[1362] = "3433";
            t[1363] = "3434";
            t[1364] = "3435";
            t[1365] = "3436";
            t[1366] = "3437";
            t[1367] = "3439";
            t[1368] = "3440";
            t[1369] = "3441";
            t[1370] = "3442";
            t[1371] = "3443";
            t[1372] = "3443";
            t[1373] = "3444";
            t[1374] = "3501";
            t[1375] = "3501";
            t[1376] = "3512";
            t[1377] = "3513";
            t[1378] = "3514";
            t[1379] = "3515";
            t[1380] = "3521";
            t[1381] = "3524";
            t[1382] = "3524";
            t[1383] = "3526";
            t[1384] = "3526";
            t[1385] = "3528";
            t[1386] = "3529";
            t[1387] = "3529";
            t[1388] = "3532";
            t[1389] = "3534";
            t[1390] = "3551";
            t[1391] = "3552";
            t[1392] = "3553";
            t[1393] = "3569";
            t[1394] = "3570";
            t[1395] = "3571";
            t[1396] = "3577";
            t[1397] = "3578";
            t[1398] = "3580";
            t[1399] = "3583";
            t[1400] = "3587";
            t[1401] = "3588";
            t[1402] = "3591";
            t[1403] = "3591";
            t[1404] = "3592";
            t[1405] = "3593";
            t[1406] = "3594";
            t[1407] = "3595";
            t[1408] = "3597";
            t[1409] = "3598";
            t[1410] = "3599";
            t[1411] = "3600";
            t[1412] = "3604";
            t[1413] = "3604";
            t[1414] = "3605";
            t[1415] = "3606";
            t[1416] = "3607";
            t[1417] = "3607";
            t[1418] = "3608";
            t[1419] = "3620";
            t[1420] = "3622";
            t[1421] = "3623";
            t[1422] = "3624";
            t[1423] = "3625";
            t[1424] = "3625";
            t[1425] = "3626";
            t[1426] = "3627";
            t[1427] = "3628";
            t[1428] = "3629";
            t[1429] = "3630";
            t[1430] = "3632";
            t[1431] = "3633";
            t[1432] = "3634";
            t[1433] = "3635";
            t[1434] = "3636";
            t[1435] = "3639";
            t[1436] = "3640";
            t[1437] = "3641";
            t[1438] = "3644";
            t[1439] = "3644";
            t[1440] = "3645";
            t[1441] = "3646";
            t[1442] = "3647";
            t[1443] = "3648";
            t[1444] = "3649";
            t[1445] = "3652";
            t[1446] = "3653";
            t[1447] = "3654";
            t[1448] = "3654";
            t[1449] = "3655";
            t[1450] = "3656";
            t[1451] = "3657";
            t[1452] = "3658";
            t[1453] = "3659";
            t[1454] = "3660";
            t[1455] = "3661";
            t[1456] = "3662";
            t[1457] = "3663";
            t[1458] = "3664";
            t[1459] = "3665";
            t[1460] = "3666";
            t[1461] = "3667";
            t[1462] = "3668";
            t[1463] = "3669";
            t[1464] = "3706";
            t[1465] = "3708";
            t[1466] = "3710";
            t[1467] = "3710";
            t[1468] = "3711";
            t[1469] = "3712";
            t[1470] = "3713";
            t[1471] = "3715";
            t[1472] = "3716";
            t[1473] = "3719";
            t[1474] = "3720";
            t[1475] = "3722";
            t[1476] = "3723";
            t[1477] = "3724";
            t[1478] = "3725";
            t[1479] = "3726";
            t[1480] = "3727";
            t[1481] = "3730";
            t[1482] = "3731";
            t[1483] = "3732";
            t[1484] = "3733";
            t[1485] = "3733";
            t[1486] = "3734";
            t[1487] = "3735";
            t[1488] = "3736";
            t[1489] = "3738";
            t[1490] = "3739";
            t[1491] = "3740";
            t[1492] = "3741";
            t[1493] = "3742";
            t[1494] = "3744";
            t[1495] = "3745";
            t[1496] = "3746";
            t[1497] = "3747";
            t[1498] = "3749";
            t[1499] = "3749";
            t[1500] = "3750";
            t[1501] = "3751";
            t[1502] = "3752";
            t[1503] = "3753";
            t[1504] = "3754";
            t[1505] = "3755";
            t[1506] = "3756";
            t[1507] = "3758";
            t[1508] = "3758";
            t[1509] = "3760";
            t[1510] = "3760";
            t[1511] = "3762";
            t[1512] = "3762";
            t[1513] = "3763";
            t[1514] = "3764";
            t[1515] = "3765";
            t[1516] = "3765";
            t[1517] = "3766";
            t[1518] = "3767";
            t[1519] = "3768";
            t[1520] = "3768";
            t[1521] = "3769";
            t[1522] = "3770";
            t[1523] = "3771";
            t[1524] = "3772";
            t[1525] = "3773";
            t[1526] = "3774";
            t[1527] = "3775";
            t[1528] = "3776";
            t[1529] = "3776";
            t[1530] = "3777";
            t[1531] = "3777";
            t[1532] = "3778";
            t[1533] = "3779";
            t[1534] = "3780";
            t[1535] = "3781";
            t[1536] = "3782";
            t[1537] = "3783";
            t[1538] = "3784";
            t[1539] = "3785";
            t[1540] = "3786";
            t[1541] = "3787";
            t[1542] = "3788";
            t[1543] = "3789";
            t[1544] = "3790";
            t[1545] = "3791";
            t[1546] = "3793";
            t[1547] = "3794";
            t[1548] = "3796";
            t[1549] = "3798";
            t[1550] = "3799";
            t[1551] = "3799";
            t[1552] = "3800";
            t[1553] = "3802";
            t[1554] = "3803";
            t[1555] = "3803";
            t[1556] = "3804";
            t[1557] = "3804";
            t[1558] = "3807";
            t[1559] = "3807";
            t[1560] = "3808";
            t[1561] = "3809";
            t[1562] = "3810";
            t[1563] = "3811";
            t[1564] = "3811";
            t[1565] = "3812";
            t[1566] = "3813";
            t[1567] = "3813";
            t[1568] = "3814";
            t[1569] = "3814";
            t[1570] = "3815";
            t[1571] = "3816";
            t[1572] = "3817";
            t[1573] = "3818";
            t[1574] = "3819";
            t[1575] = "3820";
            t[1576] = "3822";
            t[1577] = "3823";
            t[1578] = "3824";
            t[1579] = "3825";
            t[1580] = "3826";
            t[1581] = "3827";
            t[1582] = "3828";
            t[1583] = "3829";
            t[1584] = "3830";
            t[1585] = "3831";
            t[1586] = "3832";
            t[1587] = "3832";
            t[1588] = "3834";
            t[1589] = "3835";
            t[1590] = "3835";
            t[1591] = "3836";
            t[1592] = "3836";
            t[1593] = "3837";
            t[1594] = "3838";
            t[1595] = "3838";
            t[1596] = "3839";
            t[1597] = "3839";
            t[1598] = "3840";
            t[1599] = "3841";
            t[1600] = "3842";
            t[1601] = "3842";
            t[1602] = "3843";
            t[1603] = "3844";
            t[1604] = "3845";
            t[1605] = "3845";
            t[1606] = "3846";
            t[1607] = "3847";
            t[1608] = "3848";
            t[1609] = "3849";
            t[1610] = "3850";
            t[1611] = "3851";
            t[1612] = "3852";
            t[1613] = "3853";
            t[1614] = "3854";
            t[1615] = "3854";
            t[1616] = "3856";
            t[1617] = "3857";
            t[1618] = "3858";
            t[1619] = "3859";
            t[1620] = "3859";
            t[1621] = "3861";
            t[1622] = "3861";
            t[1623] = "3864";
            t[1624] = "3864";
            t[1625] = "3865";
            t[1626] = "3872";
            t[1627] = "3877";
            t[1628] = "3878";
            t[1629] = "3880";
            t[1630] = "3881";
            t[1631] = "3882";
            t[1632] = "3890";
            t[1633] = "3891";
            t[1634] = "3892";
            t[1635] = "3893";
            t[1636] = "3893";
            t[1637] = "3895";
            t[1638] = "3896";
            t[1639] = "3941";
            t[1640] = "3941";
            t[1641] = "3943";
            t[1642] = "3944";
            t[1643] = "3945";
            t[1644] = "3946";
            t[1645] = "3947";
            t[1646] = "3948";
            t[1647] = "3950";
            t[1648] = "3950";
            t[1649] = "3951";
            t[1650] = "3952";
            t[1651] = "3953";
            t[1652] = "3954";
            t[1653] = "3955";
            t[1654] = "3955";
            t[1655] = "3956";
            t[1656] = "3971";
            t[1657] = "4003";
            t[1658] = "4004";
            t[1659] = "4005";
            t[1660] = "4005";
            t[1661] = "4007";
            t[1662] = "4008";
            t[1663] = "4008";
            t[1664] = "4021";
            t[1665] = "4022";
            t[1666] = "4023";
            t[1667] = "4025";
            t[1668] = "4026";
            t[1669] = "4027";
            t[1670] = "4027";
            t[1671] = "4028";
            t[1672] = "4028";
            t[1673] = "4031";
            t[1674] = "4033";
            t[1675] = "4041";
            t[1676] = "4042";
            t[1677] = "4043";
            t[1678] = "4044";
            t[1679] = "4044";
            t[1680] = "4045";
            t[1681] = "4046";
            t[1682] = "4046";
            t[1683] = "4047";
            t[1684] = "4061";
            t[1685] = "4062";
            t[1686] = "4063";
            t[1687] = "4063";
            t[1688] = "4064";
            t[1689] = "4064";
            t[1690] = "4065";
            t[1691] = "4078";
            t[1692] = "4078";
            t[1693] = "4080";
            t[1694] = "4082";
            t[1695] = "4088";
            t[1696] = "4088";
            t[1697] = "4091";
            t[1698] = "4092";
            t[1699] = "4093";
            t[1700] = "4094";
            t[1701] = "4095";
            t[1702] = "4096";
            t[1703] = "4097";
            t[1704] = "4097";
            t[1705] = "4098";
            t[1706] = "4099";
            t[1707] = "4100";
            t[1708] = "4102";
            t[1709] = "4105";
            t[1710] = "4106";
            t[1711] = "4107";
            t[1712] = "4109";
            t[1713] = "4109";
            t[1714] = "4112";
            t[1715] = "4113";
            t[1716] = "4114";
            t[1717] = "4114";
            t[1718] = "4115";
            t[1719] = "4116";
            t[1720] = "4117";
            t[1721] = "4118";
            t[1722] = "4118";
            t[1723] = "4119";
            t[1724] = "4120";
            t[1725] = "4151";
            t[1726] = "4182";
            t[1727] = "4183";
            t[1728] = "4185";
            t[1729] = "4185";
            t[1730] = "4186";
            t[1731] = "4187";
            t[1732] = "4187";
            t[1733] = "4188";
            t[1734] = "4188";
            t[1735] = "4201";
            t[1736] = "4201";
            t[1737] = "4202";
            t[1738] = "4202";
            t[1739] = "4203";
            t[1740] = "4203";
            t[1741] = "4204";
            t[1742] = "4204";
            t[1743] = "4205";
            t[1744] = "4206";
            t[1745] = "4208";
            t[1746] = "4212";
            t[1747] = "4212";
            t[1748] = "4213";
            t[1749] = "4215";
            t[1750] = "4215";
            t[1751] = "4216";
            t[1752] = "4217";
            t[1753] = "4217";
            t[1754] = "4218";
            t[1755] = "4218";
            t[1756] = "4220";
            t[1757] = "4221";
            t[1758] = "4222";
            t[1759] = "4224";
            t[1760] = "4225";
            t[1761] = "4226";
            t[1762] = "4228";
            t[1763] = "4228";
            t[1764] = "4229";
            t[1765] = "4231";
            t[1766] = "4231";
            t[1767] = "4233";
            t[1768] = "4234";
            t[1769] = "4235";
            t[1770] = "4237";
            t[1771] = "4238";
            t[1772] = "4238";
            t[1773] = "4239";
            t[1774] = "4240";
            t[1775] = "4240";
            t[1776] = "4241";
            t[1777] = "4242";
            t[1778] = "4243";
            t[1779] = "4244";
            t[1780] = "4271";
            t[1781] = "4272";
            t[1782] = "4274";
            t[1783] = "4281";
            t[1784] = "4281";
            t[1785] = "4282";
            t[1786] = "4283";
            t[1787] = "4284";
            t[1788] = "4286";
            t[1789] = "4287";
            t[1790] = "4288";
            t[1791] = "4289";
            t[1792] = "4289";
            t[1793] = "4290";
            t[1794] = "4290";
            t[1795] = "4291";
            t[1796] = "4293";
            t[1797] = "4295";
            t[1798] = "4296";
            t[1799] = "4297";
            t[1800] = "4298";
            t[1801] = "4299";
            t[1802] = "4301";
            t[1803] = "4302";
            t[1804] = "4304";
            t[1805] = "4304";
            t[1806] = "4305";
            t[1807] = "4305";
            t[1808] = "4306";
            t[1809] = "4307";
            t[1810] = "4308";
            t[1811] = "4309";
            t[1812] = "4309";
            t[1813] = "4310";
            t[1814] = "4311";
            t[1815] = "4312";
            t[1816] = "4313";
            t[1817] = "4314";
            t[1818] = "4315";
            t[1819] = "4316";
            t[1820] = "4316";
            t[1821] = "4317";
            t[1822] = "4318";
            t[1823] = "4319";
            t[1824] = "4320";
            t[1825] = "4321";
            t[1826] = "4322";
            t[1827] = "4323";
            t[1828] = "4324";
            t[1829] = "4325";
            t[1830] = "4326";
            t[1831] = "4326";
            t[1832] = "4327";
            t[1833] = "4327";
            t[1834] = "4329";
            t[1835] = "4330";
            t[1836] = "4330";
            t[1837] = "4331";
            t[1838] = "4332";
            t[1839] = "4333";
            t[1840] = "4333";
            t[1841] = "4334";
            t[1842] = "4334";
            t[1843] = "4335";
            t[1844] = "4336";
            t[1845] = "4337";
            t[1846] = "4339";
            t[1847] = "4340";
            t[1848] = "4341";
            t[1849] = "4342";
            t[1850] = "4343";
            t[1851] = "4344";
            t[1852] = "4345";
            t[1853] = "4346";
            t[1854] = "4346";
            t[1855] = "4347";
            t[1856] = "4347";
            t[1857] = "4348";
            t[1858] = "4349";
            t[1859] = "4350";
            t[1860] = "4351";
            t[1861] = "4352";
            t[1862] = "4355";
            t[1863] = "4355";
            t[1864] = "4356";
            t[1865] = "4357";
            t[1866] = "4357";
            t[1867] = "4358";
            t[1868] = "4359";
            t[1869] = "4361";
            t[1870] = "4362";
            t[1871] = "4362";
            t[1872] = "4364";
            t[1873] = "4365";
            t[1874] = "4366";
            t[1875] = "4367";
            t[1876] = "4368";
            t[1877] = "4369";
            t[1878] = "4369";
            t[1879] = "4401";
            t[1880] = "4403";
            t[1881] = "4404";
            t[1882] = "4406";
            t[1883] = "4409";
            t[1884] = "4410";
            t[1885] = "4410";
            t[1886] = "4452";
            t[1887] = "4461";
            t[1888] = "4462";
            t[1889] = "4462";
            t[1890] = "4463";
            t[1891] = "4464";
            t[1892] = "4465";
            t[1893] = "4471";
            t[1894] = "4471";
            t[1895] = "4502";
            t[1896] = "4502";
            t[1897] = "4503";
            t[1898] = "4503";
            t[1899] = "4506";
            t[1900] = "4506";
            t[1901] = "4507";
            t[1902] = "4507";
            t[1903] = "4508";
            t[1904] = "4508";
            t[1905] = "4512";
            t[1906] = "4514";
            t[1907] = "4516";
            t[1908] = "4516";
            t[1909] = "4517";
            t[1910] = "4518";
            t[1911] = "4519";
            t[1912] = "4520";
            t[1913] = "4521";
            t[1914] = "4523";
            t[1915] = "4523";
            t[1916] = "4524";
            t[1917] = "4524";
            t[1918] = "4526";
            t[1919] = "4527";
            t[1920] = "4527";
            t[1921] = "4528";
            t[1922] = "4528";
            t[1923] = "4530";
            t[1924] = "4531";
            t[1925] = "4534";
            t[1926] = "4535";
            t[1927] = "4536";
            t[1928] = "4536";
            t[1929] = "4537";
            t[1930] = "4538";
            t[1931] = "4538";
            t[1932] = "4539";
            t[1933] = "4540";
            t[1934] = "4541";
            t[1935] = "4541";
            t[1936] = "4542";
            t[1937] = "4543";
            t[1938] = "4544";
            t[1939] = "4547";
            t[1940] = "4548";
            t[1941] = "4549";
            t[1942] = "4550";
            t[1943] = "4551";
            t[1944] = "4552";
            t[1945] = "4552";
            t[1946] = "4553";
            t[1947] = "4554";
            t[1948] = "4554";
            t[1949] = "4555";
            t[1950] = "4556";
            t[1951] = "4557";
            t[1952] = "4558";
            t[1953] = "4559";
            t[1954] = "4561";
            t[1955] = "4563";
            t[1956] = "4564";
            t[1957] = "4565";
            t[1958] = "4566";
            t[1959] = "4567";
            t[1960] = "4568";
            t[1961] = "4568";
            t[1962] = "4569";
            t[1963] = "4570";
            t[1964] = "4570";
            t[1965] = "4571";
            t[1966] = "4572";
            t[1967] = "4573";
            t[1968] = "4573";
            t[1969] = "4574";
            t[1970] = "4575";
            t[1971] = "4576";
            t[1972] = "4577";
            t[1973] = "4578";
            t[1974] = "4579";
            t[1975] = "4580";
            t[1976] = "4581";
            t[1977] = "4582";
            t[1978] = "4583";
            t[1979] = "4584";
            t[1980] = "4585";
            t[1981] = "4586";
            t[1982] = "4611";
            t[1983] = "4611";
            t[1984] = "4612";
            t[1985] = "4612";
            t[1986] = "4613";
            t[1987] = "4613";
            t[1988] = "4614";
            t[1989] = "4614";
            t[1990] = "4615";
            t[1991] = "4616";
            t[1992] = "4617";
            t[1993] = "4619";
            t[1994] = "4620";
            t[1995] = "4621";
            t[1996] = "4622";
            t[1997] = "4623";
            t[1998] = "4624";
            t[1999] = "4625";
            t[2000] = "4626";
            t[2001] = "4627";
            t[2002] = "4628";
            t[2003] = "4629";
            t[2004] = "4631";
            t[2005] = "4633";
            t[2006] = "4633";
            t[2007] = "4634";
            t[2008] = "4635";
            t[2009] = "4636";
            t[2010] = "4636";
            t[2011] = "4640";
            t[2012] = "4641";
            t[2013] = "4642";
            t[2014] = "4644";
            t[2015] = "4645";
            t[2016] = "4649";
            t[2017] = "4650";
            t[2018] = "4651";
            t[2019] = "4651";
            t[2020] = "4652";
            t[2021] = "4653";
            t[2022] = "4653";
            t[2023] = "4654";
            t[2024] = "4655";
            t[2025] = "4656";
            t[2026] = "4657";
            t[2027] = "4658";
            t[2028] = "4658";
            t[2029] = "4659";
            t[2030] = "4661";
            t[2031] = "4662";
            t[2032] = "4663";
            t[2033] = "4664";
            t[2034] = "4665";
            t[2035] = "4665";
            t[2036] = "4666";
            t[2037] = "4667";
            t[2038] = "4668";
            t[2039] = "4669";
            t[2040] = "4670";
            t[2041] = "4671";
            t[2042] = "4671";
            t[2043] = "4672";
            t[2044] = "4673";
            t[2045] = "4674";
            t[2046] = "4675";
            t[2047] = "4676";
            t[2048] = "4678";
            t[2049] = "4679";
            t[2050] = "4680";
            t[2051] = "4680";
            t[2052] = "4681";
            t[2053] = "4682";
            t[2054] = "4684";
            t[2055] = "4685";
            t[2056] = "4686";
            t[2057] = "4687";
            t[2058] = "4689";
            t[2059] = "4689";
            t[2060] = "4690";
            t[2061] = "4692";
            t[2062] = "4694";
            t[2063] = "4695";
            t[2064] = "4696";
            t[2065] = "4696";
            t[2066] = "4699";
            t[2067] = "4700";
            t[2068] = "4701";
            t[2069] = "4702";
            t[2070] = "4704";
            t[2071] = "4705";
            t[2072] = "4707";
            t[2073] = "4708";
            t[2074] = "4709";
            t[2075] = "4711";
            t[2076] = "4712";
            t[2077] = "4713";
            t[2078] = "4714";
            t[2079] = "4716";
            t[2080] = "4718";
            t[2081] = "4718";
            t[2082] = "4719";
            t[2083] = "4720";
            t[2084] = "4721";
            t[2085] = "4722";
            t[2086] = "4723";
            t[2087] = "4724";
            t[2088] = "4725";
            t[2089] = "4726";
            t[2090] = "4726";
            t[2091] = "4727";
            t[2092] = "4728";
            t[2093] = "4728";
            t[2094] = "4731";
            t[2095] = "4732";
            t[2096] = "4733";
            t[2097] = "4734";
            t[2098] = "4735";
            t[2099] = "4736";
            t[2100] = "4738";
            t[2101] = "4739";
            t[2102] = "4740";
            t[2103] = "4741";
            t[2104] = "4742";
            t[2105] = "4743";
            t[2106] = "4743";
            t[2107] = "4744";
            t[2108] = "4745";
            t[2109] = "4746";
            t[2110] = "4747";
            t[2111] = "4748";
            t[2112] = "4749";
            t[2113] = "4750";
            t[2114] = "4751";
            t[2115] = "4752";
            t[2116] = "4753";
            t[2117] = "4754";
            t[2118] = "4755";
            t[2119] = "4756";
            t[2120] = "4757";
            t[2121] = "4759";
            t[2122] = "4760";
            t[2123] = "4761";
            t[2124] = "4762";
            t[2125] = "4763";
            t[2126] = "4763";
            t[2127] = "4764";
            t[2128] = "4764";
            t[2129] = "4765";
            t[2130] = "4765";
            t[2131] = "4766";
            t[2132] = "4767";
            t[2133] = "4767";
            t[2134] = "4768";
            t[2135] = "4769";
            t[2136] = "4770";
            t[2137] = "4771";
            t[2138] = "4771";
            t[2139] = "4772";
            t[2140] = "4772";
            t[2141] = "4775";
            t[2142] = "4776";
            t[2143] = "4777";
            t[2144] = "4777";
            t[2145] = "4778";
            t[2146] = "4779";
            t[2147] = "4780";
            t[2148] = "4781";
            t[2149] = "4782";
            t[2150] = "4783";
            t[2151] = "4784";
            t[2152] = "4784";
            t[2153] = "4787";
            t[2154] = "4788";
            t[2155] = "4789";
            t[2156] = "4792";
            t[2157] = "4792";
            t[2158] = "4793";
            t[2159] = "4794";
            t[2160] = "4795";
            t[2161] = "4797";
            t[2162] = "4798";
            t[2163] = "4799";
            t[2164] = "4800";
            t[2165] = "4800";
            t[2166] = "4801";
            t[2167] = "4809";
            t[2168] = "4812";
            t[2169] = "4813";
            t[2170] = "4814";
            t[2171] = "4814";
            t[2172] = "4815";
            t[2173] = "4816";
            t[2174] = "4817";
            t[2175] = "4819";
            t[2176] = "4820";
            t[2177] = "4822";
            t[2178] = "4822";
            t[2179] = "4823";
            t[2180] = "4824";
            t[2181] = "4825";
            t[2182] = "4826";
            t[2183] = "4827";
            t[2184] = "4828";
            t[2185] = "4829";
            t[2186] = "4831";
            t[2187] = "4832";
            t[2188] = "4833";
            t[2189] = "4833";
            t[2190] = "4834";
            t[2191] = "4835";
            t[2192] = "4837";
            t[2193] = "4838";
            t[2194] = "4839";
            t[2195] = "4840";
            t[2196] = "4840";
            t[2197] = "4841";
            t[2198] = "4842";
            t[2199] = "4842";
            t[2200] = "4843";
            t[2201] = "4845";
            t[2202] = "4845";
            t[2203] = "4846";
            t[2204] = "4847";
            t[2205] = "4848";
            t[2206] = "4849";
            t[2207] = "4849";
            t[2208] = "4850";
            t[2209] = "4863";
            t[2210] = "4875";
            t[2211] = "4875";
            t[2212] = "4901";
            t[2213] = "4901";
            t[2214] = "4902";
            t[2215] = "4902";
            t[2216] = "4911";
            t[2217] = "4912";
            t[2218] = "4914";
            t[2219] = "4915";
            t[2220] = "4916";
            t[2221] = "4916";
            t[2222] = "4917";
            t[2223] = "4918";
            t[2224] = "4919";
            t[2225] = "4920";
            t[2226] = "4921";
            t[2227] = "4922";
            t[2228] = "4923";
            t[2229] = "4924";
            t[2230] = "4924";
            t[2231] = "4925";
            t[2232] = "4926";
            t[2233] = "4926";
            t[2234] = "4927";
            t[2235] = "4928";
            t[2236] = "4929";
            t[2237] = "4951";
            t[2238] = "4952";
            t[2239] = "4952";
            t[2240] = "4953";
            t[2241] = "4954";
            t[2242] = "4955";
            t[2243] = "4956";
            t[2244] = "4956";
            t[2245] = "4957";
            t[2246] = "4958";
            t[2247] = "4960";
            t[2248] = "4961";
            t[2249] = "4962";
            t[2250] = "4963";
            t[2251] = "4965";
            t[2252] = "4966";
            t[2253] = "4967";
            t[2254] = "4967";
            t[2255] = "4968";
            t[2256] = "4968";
            t[2257] = "4970";
            t[2258] = "4971";
            t[2259] = "4972";
            t[2260] = "4973";
            t[2261] = "4974";
            t[2262] = "4975";
            t[2263] = "4976";
            t[2264] = "4977";
            t[2265] = "4985";
            t[2266] = "4987";
            t[2267] = "4989";
            t[2268] = "4990";
            t[2269] = "4992";
            t[2270] = "4994";
            t[2271] = "4995";
            t[2272] = "4996";
            t[2273] = "4997";
            t[2274] = "4998";
            t[2275] = "4999";
            t[2276] = "5001";
            t[2277] = "5002";
            t[2278] = "5007";
            t[2279] = "5007";
            t[2280] = "5008";
            t[2281] = "5009";
            t[2282] = "5010";
            t[2283] = "5011";
            t[2284] = "5012";
            t[2285] = "5013";
            t[2286] = "5015";
            t[2287] = "5016";
            t[2288] = "5017";
            t[2289] = "5018";
            t[2290] = "5018";
            t[2291] = "5019";
            t[2292] = "5020";
            t[2293] = "5020";
            t[2294] = "5051";
            t[2295] = "5101";
            t[2296] = "5101";
            t[2297] = "5103";
            t[2298] = "5104";
            t[2299] = "5105";
            t[2300] = "5105";
            t[2301] = "5108";
            t[2302] = "5108";
            t[2303] = "5110";
            t[2304] = "5110";
            t[2305] = "5121";
            t[2306] = "5122";
            t[2307] = "5142";
            t[2308] = "5161";
            t[2309] = "5162";
            t[2310] = "5184";
            t[2311] = "5185";
            t[2312] = "5186";
            t[2313] = "5186";
            t[2314] = "5187";
            t[2315] = "5188";
            t[2316] = "5189";
            t[2317] = "5191";
            t[2318] = "5192";
            t[2319] = "5192";
            t[2320] = "5194";
            t[2321] = "5195";
            t[2322] = "5195";
            t[2323] = "5196";
            t[2324] = "5199";
            t[2325] = "5201";
            t[2326] = "5201";
            t[2327] = "5202";
            t[2328] = "5202";
            t[2329] = "5204";
            t[2330] = "5208";
            t[2331] = "5210";
            t[2332] = "5210";
            t[2333] = "5212";
            t[2334] = "5213";
            t[2335] = "5214";
            t[2336] = "5214";
            t[2337] = "5216";
            t[2338] = "5217";
            t[2339] = "5218";
            t[2340] = "5220";
            t[2341] = "5232";
            t[2342] = "5232";
            t[2343] = "5233";
            t[2344] = "5234";
            t[2345] = "5237";
            t[2346] = "5261";
            t[2347] = "5262";
            t[2348] = "5267";
            t[2349] = "5268";
            t[2350] = "5269";
            t[2351] = "5271";
            t[2352] = "5273";
            t[2353] = "5274";
            t[2354] = "5276";
            t[2355] = "5277";
            t[2356] = "5278";
            t[2357] = "5279";
            t[2358] = "5280";
            t[2359] = "5281";
            t[2360] = "5282";
            t[2361] = "5283";
            t[2362] = "5284";
            t[2363] = "5285";
            t[2364] = "5286";
            t[2365] = "5287";
            t[2366] = "5288";
            t[2367] = "5288";
            t[2368] = "5289";
            t[2369] = "5301";
            t[2370] = "5302";
            t[2371] = "5304";
            t[2372] = "5310";
            t[2373] = "5331";
            t[2374] = "5332";
            t[2375] = "5333";
            t[2376] = "5333";
            t[2377] = "5334";
            t[2378] = "5337";
            t[2379] = "5337";
            t[2380] = "5341";
            t[2381] = "5342";
            t[2382] = "5343";
            t[2383] = "5344";
            t[2384] = "5345";
            t[2385] = "5345";
            t[2386] = "5351";
            t[2387] = "5351";
            t[2388] = "5352";
            t[2389] = "5355";
            t[2390] = "5356";
            t[2391] = "5357";
            t[2392] = "5358";
            t[2393] = "5363";
            t[2394] = "5367";
            t[2395] = "5367";
            t[2396] = "5380";
            t[2397] = "5381";
            t[2398] = "5383";
            t[2399] = "5384";
            t[2400] = "5384";
            t[2401] = "5386";
            t[2402] = "5387";
            t[2403] = "5388";
            t[2404] = "5389";
            t[2405] = "5390";
            t[2406] = "5391";
            t[2407] = "5393";
            t[2408] = "5395";
            t[2409] = "5398";
            t[2410] = "5401";
            t[2411] = "5401";
            t[2412] = "5405";
            t[2413] = "5405";
            t[2414] = "5406";
            t[2415] = "5406";
            t[2416] = "5407";
            t[2417] = "5407";
            t[2418] = "5408";
            t[2419] = "5408";
            t[2420] = "5410";
            t[2421] = "5411";
            t[2422] = "5411";
            t[2423] = "5412";
            t[2424] = "5413";
            t[2425] = "5423";
            t[2426] = "5440";
            t[2427] = "5440";
            t[2428] = "5444";
            t[2429] = "5444";
            t[2430] = "5445";
            t[2431] = "5446";
            t[2432] = "5448";
            t[2433] = "5449";
            t[2434] = "5449";
            t[2435] = "5451";
            t[2436] = "5451";
            t[2437] = "5453";
            t[2438] = "5453";
            t[2439] = "5456";
            t[2440] = "5457";
            t[2441] = "5458";
            t[2442] = "5461";
            t[2443] = "5463";
            t[2444] = "5463";
            t[2445] = "5464";
            t[2446] = "5464";
            t[2447] = "5471";
            t[2448] = "5476";
            t[2449] = "5479";
            t[2450] = "5480";
            t[2451] = "5481";
            t[2452] = "5482";
            t[2453] = "5484";
            t[2454] = "5486";
            t[2455] = "5486";
            t[2456] = "5491";
            t[2457] = "5541";
            t[2458] = "5541";
            t[2459] = "5542";
            t[2460] = "5563";
            t[2461] = "5566";
            t[2462] = "5602";
            t[2463] = "5602";
            t[2464] = "5603";
            t[2465] = "5605";
            t[2466] = "5606";
            t[2467] = "5607";
            t[2468] = "5608";
            t[2469] = "5609";
            t[2470] = "5610";
            t[2471] = "5612";
            t[2472] = "5613";
            t[2473] = "5614";
            t[2474] = "5631";
            t[2475] = "5631";
            t[2476] = "5632";
            t[2477] = "5641";
            t[2478] = "5644";
            t[2479] = "5645";
            t[2480] = "5657";
            t[2481] = "5658";
            t[2482] = "5659";
            t[2483] = "5659";
            t[2484] = "5660";
            t[2485] = "5695";
            t[2486] = "5697";
            t[2487] = "5701";
            t[2488] = "5701";
            t[2489] = "5702";
            t[2490] = "5702";
            t[2491] = "5703";
            t[2492] = "5703";
            t[2493] = "5706";
            t[2494] = "5707";
            t[2495] = "5707";
            t[2496] = "5711";
            t[2497] = "5711";
            t[2498] = "5713";
            t[2499] = "5713";
            t[2500] = "5714";
            t[2501] = "5714";
            t[2502] = "5715";
            t[2503] = "5715";
            t[2504] = "5721";
            t[2505] = "5721";
            t[2506] = "5724";
            t[2507] = "5726";
            t[2508] = "5727";
            t[2509] = "5729";
            t[2510] = "5738";
            t[2511] = "5738";
            t[2512] = "5739";
            t[2513] = "5741";
            t[2514] = "5742";
            t[2515] = "5753";
            t[2516] = "5753";
            t[2517] = "5756";
            t[2518] = "5757";
            t[2519] = "5758";
            t[2520] = "5758";
            t[2521] = "5771";
            t[2522] = "5781";
            t[2523] = "5801";
            t[2524] = "5801";
            t[2525] = "5802";
            t[2526] = "5802";
            t[2527] = "5803";
            t[2528] = "5803";
            t[2529] = "5804";
            t[2530] = "5805";
            t[2531] = "5807";
            t[2532] = "5808";
            t[2533] = "5809";
            t[2534] = "5809";
            t[2535] = "5811";
            t[2536] = "5812";
            t[2537] = "5812";
            t[2538] = "5815";
            t[2539] = "5816";
            t[2540] = "5816";
            t[2541] = "5817";
            t[2542] = "5819";
            t[2543] = "5819";
            t[2544] = "5820";
            t[2545] = "5821";
            t[2546] = "5851";
            t[2547] = "5852";
            t[2548] = "5855";
            t[2549] = "5856";
            t[2550] = "5857";
            t[2551] = "5900";
            t[2552] = "5901";
            t[2553] = "5901";
            t[2554] = "5902";
            t[2555] = "5903";
            t[2556] = "5905";
            t[2557] = "5906";
            t[2558] = "5907";
            t[2559] = "5908";
            t[2560] = "5909";
            t[2561] = "5911";
            t[2562] = "5912";
            t[2563] = "5912";
            t[2564] = "5913";
            t[2565] = "5915";
            t[2566] = "5915";
            t[2567] = "5916";
            t[2568] = "5917";
            t[2569] = "5918";
            t[2570] = "5919";
            t[2571] = "5921";
            t[2572] = "5922";
            t[2573] = "5923";
            t[2574] = "5923";
            t[2575] = "5928";
            t[2576] = "5929";
            t[2577] = "5930";
            t[2578] = "5931";
            t[2579] = "5932";
            t[2580] = "5933";
            t[2581] = "5933";
            t[2582] = "5934";
            t[2583] = "5935";
            t[2584] = "5936";
            t[2585] = "5936";
            t[2586] = "5938";
            t[2587] = "5938";
            t[2588] = "5939";
            t[2589] = "5940";
            t[2590] = "5941";
            t[2591] = "5942";
            t[2592] = "5943";
            t[2593] = "5943";
            t[2594] = "5944";
            t[2595] = "5945";
            t[2596] = "5946";
            t[2597] = "5947";
            t[2598] = "5949";
            t[2599] = "5950";
            t[2600] = "5951";
            t[2601] = "5952";
            t[2602] = "5953";
            t[2603] = "5954";
            t[2604] = "5955";
            t[2605] = "5956";
            t[2606] = "5957";
            t[2607] = "5957";
            t[2608] = "5958";
            t[2609] = "5959";
            t[2610] = "5962";
            t[2611] = "5963";
            t[2612] = "5963";
            t[2613] = "5964";
            t[2614] = "5965";
            t[2615] = "5966";
            t[2616] = "5967";
            t[2617] = "5969";
            t[2618] = "5970";
            t[2619] = "5971";
            t[2620] = "5973";
            t[2621] = "5974";
            t[2622] = "5975";
            t[2623] = "5976";
            t[2624] = "5977";
            t[2625] = "5979";
            t[2626] = "5980";
            t[2627] = "5981";
            t[2628] = "5981";
            t[2629] = "5982";
            t[2630] = "5983";
            t[2631] = "5984";
            t[2632] = "5985";
            t[2633] = "5986";
            t[2634] = "5987";
            t[2635] = "5988";
            t[2636] = "5989";
            t[2637] = "5990";
            t[2638] = "5991";
            t[2639] = "5992";
            t[2640] = "5993";
            t[2641] = "5994";
            t[2642] = "5995";
            t[2643] = "5996";
            t[2644] = "5997";
            t[2645] = "5998";
            t[2646] = "5999";
            t[2647] = "6005";
            t[2648] = "6005";
            t[2649] = "6013";
            t[2650] = "6013";
            t[2651] = "6016";
            t[2652] = "6018";
            t[2653] = "6021";
            t[2654] = "6022";
            t[2655] = "6023";
            t[2656] = "6041";
            t[2657] = "6042";
            t[2658] = "6050";
            t[2659] = "6051";
            t[2660] = "6052";
            t[2661] = "6053";
            t[2662] = "6054";
            t[2663] = "6055";
            t[2664] = "6055";
            t[2665] = "6056";
            t[2666] = "6058";
            t[2667] = "6059";
            t[2668] = "6060";
            t[2669] = "6061";
            t[2670] = "6062";
            t[2671] = "6063";
            t[2672] = "6064";
            t[2673] = "6065";
            t[2674] = "6066";
            t[2675] = "6067";
            t[2676] = "6068";
            t[2677] = "6069";
            t[2678] = "6070";
            t[2679] = "6071";
            t[2680] = "6072";
            t[2681] = "6101";
            t[2682] = "6103";
            t[2683] = "6104";
            t[2684] = "6111";
            t[2685] = "6112";
            t[2686] = "6113";
            t[2687] = "6113";
            t[2688] = "6118";
            t[2689] = "6121";
            t[2690] = "6125";
            t[2691] = "6130";
            t[2692] = "6131";
            t[2693] = "6134";
            t[2694] = "6135";
            t[2695] = "6136";
            t[2696] = "6137";
            t[2697] = "6138";
            t[2698] = "6138";
            t[2699] = "6140";
            t[2700] = "6141";
            t[2701] = "6141";
            t[2702] = "6142";
            t[2703] = "6143";
            t[2704] = "6144";
            t[2705] = "6144";
            t[2706] = "6145";
            t[2707] = "6146";
            t[2708] = "6147";
            t[2709] = "6149";
            t[2710] = "6150";
            t[2711] = "6151";
            t[2712] = "6155";
            t[2713] = "6155";
            t[2714] = "6156";
            t[2715] = "6157";
            t[2716] = "6158";
            t[2717] = "6159";
            t[2718] = "6160";
            t[2719] = "6160";
            t[2720] = "6161";
            t[2721] = "6162";
            t[2722] = "6163";
            t[2723] = "6164";
            t[2724] = "6165";
            t[2725] = "6201";
            t[2726] = "6201";
            t[2727] = "6203";
            t[2728] = "6205";
            t[2729] = "6205";
            t[2730] = "6208";
            t[2731] = "6210";
            t[2732] = "6210";
            t[2733] = "6211";
            t[2734] = "6213";
            t[2735] = "6213";
            t[2736] = "6217";
            t[2737] = "6218";
            t[2738] = "6222";
            t[2739] = "6222";
            t[2740] = "6242";
            t[2741] = "6245";
            t[2742] = "6246";
            t[2743] = "6247";
            t[2744] = "6247";
            t[2745] = "6249";
            t[2746] = "6250";
            t[2747] = "6252";
            t[2748] = "6253";
            t[2749] = "6254";
            t[2750] = "6255";
            t[2751] = "6256";
            t[2752] = "6257";
            t[2753] = "6258";
            t[2754] = "6259";
            t[2755] = "6260";
            t[2756] = "6261";
            t[2757] = "6262";
            t[2758] = "6263";
            t[2759] = "6264";
            t[2760] = "6265";
            t[2761] = "6266";
            t[2762] = "6267";
            t[2763] = "6268";
            t[2764] = "6269";
            t[2765] = "6271";
            t[2766] = "6272";
            t[2767] = "6273";
            t[2768] = "6274";
            t[2769] = "6276";
            t[2770] = "6277";
            t[2771] = "6277";
            t[2772] = "6278";
            t[2773] = "6279";
            t[2774] = "6280";
            t[2775] = "6281";
            t[2776] = "6282";
            t[2777] = "6284";
            t[2778] = "6286";
            t[2779] = "6287";
            t[2780] = "6289";
            t[2781] = "6290";
            t[2782] = "6291";
            t[2783] = "6292";
            t[2784] = "6293";
            t[2785] = "6294";
            t[2786] = "6295";
            t[2787] = "6297";
            t[2788] = "6298";
            t[2789] = "6298";
            t[2790] = "6299";
            t[2791] = "6300";
            t[2792] = "6301";
            t[2793] = "6301";
            t[2794] = "6302";
            t[2795] = "6302";
            t[2796] = "6303";
            t[2797] = "6304";
            t[2798] = "6305";
            t[2799] = "6305";
            t[2800] = "6306";
            t[2801] = "6306";
            t[2802] = "6307";
            t[2803] = "6309";
            t[2804] = "6310";
            t[2805] = "6312";
            t[2806] = "6313";
            t[2807] = "6314";
            t[2808] = "6315";
            t[2809] = "6315";
            t[2810] = "6316";
            t[2811] = "6317";
            t[2812] = "6318";
            t[2813] = "6319";
            t[2814] = "6320";
            t[2815] = "6321";
            t[2816] = "6322";
            t[2817] = "6323";
            t[2818] = "6324";
            t[2819] = "6325";
            t[2820] = "6326";
            t[2821] = "6326";
            t[2822] = "6327";
            t[2823] = "6328";
            t[2824] = "6330";
            t[2825] = "6331";
            t[2826] = "6331";
            t[2827] = "6332";
            t[2828] = "6332";
            t[2829] = "6333";
            t[2830] = "6333";
            t[2831] = "6334";
            t[2832] = "6335";
            t[2833] = "6336";
            t[2834] = "6337";
            t[2835] = "6338";
            t[2836] = "6339";
            t[2837] = "6340";
            t[2838] = "6342";
            t[2839] = "6343";
            t[2840] = "6344";
            t[2841] = "6345";
            t[2842] = "6346";
            t[2843] = "6347";
            t[2844] = "6349";
            t[2845] = "6351";
            t[2846] = "6351";
            t[2847] = "6352";
            t[2848] = "6355";
            t[2849] = "6355";
            t[2850] = "6356";
            t[2851] = "6356";
            t[2852] = "6357";
            t[2853] = "6358";
            t[2854] = "6360";
            t[2855] = "6361";
            t[2856] = "6362";
            t[2857] = "6363";
            t[2858] = "6363";
            t[2859] = "6364";
            t[2860] = "6365";
            t[2861] = "6366";
            t[2862] = "6367";
            t[2863] = "6367";
            t[2864] = "6368";
            t[2865] = "6369";
            t[2866] = "6370";
            t[2867] = "6370";
            t[2868] = "6371";
            t[2869] = "6371";
            t[2870] = "6373";
            t[2871] = "6374";
            t[2872] = "6375";
            t[2873] = "6375";
            t[2874] = "6376";
            t[2875] = "6378";
            t[2876] = "6378";
            t[2877] = "6379";
            t[2878] = "6380";
            t[2879] = "6381";
            t[2880] = "6382";
            t[2881] = "6383";
            t[2882] = "6383";
            t[2883] = "6384";
            t[2884] = "6386";
            t[2885] = "6387";
            t[2886] = "6390";
            t[2887] = "6391";
            t[2888] = "6392";
            t[2889] = "6393";
            t[2890] = "6395";
            t[2891] = "6396";
            t[2892] = "6397";
            t[2893] = "6400";
            t[2894] = "6401";
            t[2895] = "6402";
            t[2896] = "6403";
            t[2897] = "6405";
            t[2898] = "6406";
            t[2899] = "6406";
            t[2900] = "6407";
            t[2901] = "6408";
            t[2902] = "6409";
            t[2903] = "6411";
            t[2904] = "6412";
            t[2905] = "6413";
            t[2906] = "6413";
            t[2907] = "6414";
            t[2908] = "6415";
            t[2909] = "6416";
            t[2910] = "6417";
            t[2911] = "6418";
            t[2912] = "6418";
            t[2913] = "6419";
            t[2914] = "6420";
            t[2915] = "6420";
            t[2916] = "6421";
            t[2917] = "6423";
            t[2918] = "6424";
            t[2919] = "6425";
            t[2920] = "6428";
            t[2921] = "6429";
            t[2922] = "6430";
            t[2923] = "6432";
            t[2924] = "6433";
            t[2925] = "6436";
            t[2926] = "6436";
            t[2927] = "6437";
            t[2928] = "6439";
            t[2929] = "6440";
            t[2930] = "6443";
            t[2931] = "6444";
            t[2932] = "6445";
            t[2933] = "6448";
            t[2934] = "6453";
            t[2935] = "6454";
            t[2936] = "6455";
            t[2937] = "6455";
            t[2938] = "6457";
            t[2939] = "6457";
            t[2940] = "6458";
            t[2941] = "6459";
            t[2942] = "6459";
            t[2943] = "6460";
            t[2944] = "6461";
            t[2945] = "6462";
            t[2946] = "6463";
            t[2947] = "6465";
            t[2948] = "6466";
            t[2949] = "6466";
            t[2950] = "6467";
            t[2951] = "6469";
            t[2952] = "6470";
            t[2953] = "6471";
            t[2954] = "6471";
            t[2955] = "6472";
            t[2956] = "6472";
            t[2957] = "6473";
            t[2958] = "6473";
            t[2959] = "6474";
            t[2960] = "6476";
            t[2961] = "6477";
            t[2962] = "6478";
            t[2963] = "6479";
            t[2964] = "6479";
            t[2965] = "6480";
            t[2966] = "6481";
            t[2967] = "6482";
            t[2968] = "6482";
            t[2969] = "6484";
            t[2970] = "6485";
            t[2971] = "6486";
            t[2972] = "6487";
            t[2973] = "6488";
            t[2974] = "6489";
            t[2975] = "6490";
            t[2976] = "6490";
            t[2977] = "6492";
            t[2978] = "6493";
            t[2979] = "6494";
            t[2980] = "6495";
            t[2981] = "6496";
            t[2982] = "6497";
            t[2983] = "6498";
            t[2984] = "6501";
            t[2985] = "6501";
            t[2986] = "6502";
            t[2987] = "6502";
            t[2988] = "6503";
            t[2989] = "6504";
            t[2990] = "6504";
            t[2991] = "6505";
            t[2992] = "6506";
            t[2993] = "6507";
            t[2994] = "6508";
            t[2995] = "6508";
            t[2996] = "6513";
            t[2997] = "6516";
            t[2998] = "6517";
            t[2999] = "6518";
            t[3000] = "6519";
            t[3001] = "6581";
            t[3002] = "6581";
            t[3003] = "6584";
            t[3004] = "6585";
            t[3005] = "6586";
            t[3006] = "6588";
            t[3007] = "6590";
            t[3008] = "6591";
            t[3009] = "6591";
            t[3010] = "6592";
            t[3011] = "6593";
            t[3012] = "6594";
            t[3013] = "6594";
            t[3014] = "6617";
            t[3015] = "6618";
            t[3016] = "6619";
            t[3017] = "6620";
            t[3018] = "6620";
            t[3019] = "6621";
            t[3020] = "6622";
            t[3021] = "6622";
            t[3022] = "6623";
            t[3023] = "6624";
            t[3024] = "6625";
            t[3025] = "6626";
            t[3026] = "6627";
            t[3027] = "6628";
            t[3028] = "6629";
            t[3029] = "6630";
            t[3030] = "6630";
            t[3031] = "6632";
            t[3032] = "6633";
            t[3033] = "6634";
            t[3034] = "6635";
            t[3035] = "6636";
            t[3036] = "6637";
            t[3037] = "6638";
            t[3038] = "6639";
            t[3039] = "6640";
            t[3040] = "6640";
            t[3041] = "6641";
            t[3042] = "6641";
            t[3043] = "6643";
            t[3044] = "6644";
            t[3045] = "6645";
            t[3046] = "6645";
            t[3047] = "6646";
            t[3048] = "6647";
            t[3049] = "6648";
            t[3050] = "6650";
            t[3051] = "6651";
            t[3052] = "6652";
            t[3053] = "6652";
            t[3054] = "6653";
            t[3055] = "6654";
            t[3056] = "6654";
            t[3057] = "6655";
            t[3058] = "6656";
            t[3059] = "6657";
            t[3060] = "6658";
            t[3061] = "6659";
            t[3062] = "6660";
            t[3063] = "6661";
            t[3064] = "6661";
            t[3065] = "6662";
            t[3066] = "6662";
            t[3067] = "6663";
            t[3068] = "6664";
            t[3069] = "6665";
            t[3070] = "6666";
            t[3071] = "6667";
            t[3072] = "6668";
            t[3073] = "6669";
            t[3074] = "6670";
            t[3075] = "6671";
            t[3076] = "6672";
            t[3077] = "6674";
            t[3078] = "6674";
            t[3079] = "6675";
            t[3080] = "6676";
            t[3081] = "6677";
            t[3082] = "6678";
            t[3083] = "6678";
            t[3084] = "6679";
            t[3085] = "6687";
            t[3086] = "6701";
            t[3087] = "6701";
            t[3088] = "6702";
            t[3089] = "6702";
            t[3090] = "6703";
            t[3091] = "6703";
            t[3092] = "6704";
            t[3093] = "6706";
            t[3094] = "6707";
            t[3095] = "6708";
            t[3096] = "6709";
            t[3097] = "6715";
            t[3098] = "6716";
            t[3099] = "6717";
            t[3100] = "6718";
            t[3101] = "6719";
            t[3102] = "6720";
            t[3103] = "6721";
            t[3104] = "6722";
            t[3105] = "6723";
            t[3106] = "6724";
            t[3107] = "6726";
            t[3108] = "6727";
            t[3109] = "6727";
            t[3110] = "6728";
            t[3111] = "6729";
            t[3112] = "6730";
            t[3113] = "6730";
            t[3114] = "6731";
            t[3115] = "6734";
            t[3116] = "6735";
            t[3117] = "6736";
            t[3118] = "6737";
            t[3119] = "6738";
            t[3120] = "6741";
            t[3121] = "6741";
            t[3122] = "6742";
            t[3123] = "6742";
            t[3124] = "6743";
            t[3125] = "6744";
            t[3126] = "6745";
            t[3127] = "6747";
            t[3128] = "6748";
            t[3129] = "6749";
            t[3130] = "6750";
            t[3131] = "6751";
            t[3132] = "6752";
            t[3133] = "6752";
            t[3134] = "6753";
            t[3135] = "6753";
            t[3136] = "6754";
            t[3137] = "6755";
            t[3138] = "6756";
            t[3139] = "6756";
            t[3140] = "6757";
            t[3141] = "6758";
            t[3142] = "6758";
            t[3143] = "6759";
            t[3144] = "6760";
            t[3145] = "6762";
            t[3146] = "6763";
            t[3147] = "6764";
            t[3148] = "6765";
            t[3149] = "6766";
            t[3150] = "6766";
            t[3151] = "6767";
            t[3152] = "6767";
            t[3153] = "6768";
            t[3154] = "6769";
            t[3155] = "6770";
            t[3156] = "6771";
            t[3157] = "6772";
            t[3158] = "6773";
            t[3159] = "6775";
            t[3160] = "6776";
            t[3161] = "6777";
            t[3162] = "6777";
            t[3163] = "6778";
            t[3164] = "6779";
            t[3165] = "6784";
            t[3166] = "6785";
            t[3167] = "6786";
            t[3168] = "6787";
            t[3169] = "6788";
            t[3170] = "6789";
            t[3171] = "6790";
            t[3172] = "6791";
            t[3173] = "6792";
            t[3174] = "6793";
            t[3175] = "6794";
            t[3176] = "6796";
            t[3177] = "6796";
            t[3178] = "6797";
            t[3179] = "6798";
            t[3180] = "6800";
            t[3181] = "6801";
            t[3182] = "6803";
            t[3183] = "6804";
            t[3184] = "6804";
            t[3185] = "6806";
            t[3186] = "6807";
            t[3187] = "6809";
            t[3188] = "6809";
            t[3189] = "6810";
            t[3190] = "6811";
            t[3191] = "6812";
            t[3192] = "6814";
            t[3193] = "6815";
            t[3194] = "6816";
            t[3195] = "6817";
            t[3196] = "6818";
            t[3197] = "6819";
            t[3198] = "6820";
            t[3199] = "6820";
            t[3200] = "6821";
            t[3201] = "6822";
            t[3202] = "6823";
            t[3203] = "6824";
            t[3204] = "6825";
            t[3205] = "6826";
            t[3206] = "6827";
            t[3207] = "6828";
            t[3208] = "6830";
            t[3209] = "6832";
            t[3210] = "6833";
            t[3211] = "6834";
            t[3212] = "6835";
            t[3213] = "6836";
            t[3214] = "6837";
            t[3215] = "6838";
            t[3216] = "6839";
            t[3217] = "6839";
            t[3218] = "6840";
            t[3219] = "6841";
            t[3220] = "6842";
            t[3221] = "6844";
            t[3222] = "6845";
            t[3223] = "6846";
            t[3224] = "6848";
            t[3225] = "6849";
            t[3226] = "6850";
            t[3227] = "6852";
            t[3228] = "6853";
            t[3229] = "6855";
            t[3230] = "6855";
            t[3231] = "6856";
            t[3232] = "6856";
            t[3233] = "6857";
            t[3234] = "6858";
            t[3235] = "6859";
            t[3236] = "6859";
            t[3237] = "6860";
            t[3238] = "6861";
            t[3239] = "6861";
            t[3240] = "6862";
            t[3241] = "6863";
            t[3242] = "6864";
            t[3243] = "6866";
            t[3244] = "6867";
            t[3245] = "6868";
            t[3246] = "6869";
            t[3247] = "6869";
            t[3248] = "6870";
            t[3249] = "6871";
            t[3250] = "6874";
            t[3251] = "6875";
            t[3252] = "6876";
            t[3253] = "6877";
            t[3254] = "6877";
            t[3255] = "6878";
            t[3256] = "6879";
            t[3257] = "6881";
            t[3258] = "6882";
            t[3259] = "6883";
            t[3260] = "6885";
            t[3261] = "6886";
            t[3262] = "6888";
            t[3263] = "6889";
            t[3264] = "6890";
            t[3265] = "6891";
            t[3266] = "6892";
            t[3267] = "6893";
            t[3268] = "6894";
            t[3269] = "6895";
            t[3270] = "6896";
            t[3271] = "6897";
            t[3272] = "6898";
            t[3273] = "6899";
            t[3274] = "6900";
            t[3275] = "6901";
            t[3276] = "6902";
            t[3277] = "6904";
            t[3278] = "6905";
            t[3279] = "6907";
            t[3280] = "6908";
            t[3281] = "6910";
            t[3282] = "6911";
            t[3283] = "6912";
            t[3284] = "6914";
            t[3285] = "6915";
            t[3286] = "6916";
            t[3287] = "6917";
            t[3288] = "6918";
            t[3289] = "6919";
            t[3290] = "6920";
            t[3291] = "6920";
            t[3292] = "6921";
            t[3293] = "6922";
            t[3294] = "6923";
            t[3295] = "6924";
            t[3296] = "6925";
            t[3297] = "6926";
            t[3298] = "6927";
            t[3299] = "6927";
            t[3300] = "6928";
            t[3301] = "6929";
            t[3302] = "6929";
            t[3303] = "6930";
            t[3304] = "6932";
            t[3305] = "6934";
            t[3306] = "6934";
            t[3307] = "6935";
            t[3308] = "6937";
            t[3309] = "6938";
            t[3310] = "6939";
            t[3311] = "6941";
            t[3312] = "6942";
            t[3313] = "6943";
            t[3314] = "6944";
            t[3315] = "6945";
            t[3316] = "6946";
            t[3317] = "6947";
            t[3318] = "6950";
            t[3319] = "6951";
            t[3320] = "6952";
            t[3321] = "6954";
            t[3322] = "6955";
            t[3323] = "6956";
            t[3324] = "6957";
            t[3325] = "6958";
            t[3326] = "6960";
            t[3327] = "6961";
            t[3328] = "6962";
            t[3329] = "6963";
            t[3330] = "6963";
            t[3331] = "6964";
            t[3332] = "6965";
            t[3333] = "6966";
            t[3334] = "6967";
            t[3335] = "6968";
            t[3336] = "6969";
            t[3337] = "6971";
            t[3338] = "6971";
            t[3339] = "6972";
            t[3340] = "6973";
            t[3341] = "6974";
            t[3342] = "6975";
            t[3343] = "6976";
            t[3344] = "6977";
            t[3345] = "6981";
            t[3346] = "6981";
            t[3347] = "6982";
            t[3348] = "6985";
            t[3349] = "6986";
            t[3350] = "6988";
            t[3351] = "6988";
            t[3352] = "6989";
            t[3353] = "6991";
            t[3354] = "6992";
            t[3355] = "6993";
            t[3356] = "6994";
            t[3357] = "6994";
            t[3358] = "6995";
            t[3359] = "6996";
            t[3360] = "6996";
            t[3361] = "6997";
            t[3362] = "6998";
            t[3363] = "6999";
            t[3364] = "7003";
            t[3365] = "7003";
            t[3366] = "7004";
            t[3367] = "7004";
            t[3368] = "7007";
            t[3369] = "7011";
            t[3370] = "7011";
            t[3371] = "7012";
            t[3372] = "7012";
            t[3373] = "7013";
            t[3374] = "7013";
            t[3375] = "7014";
            t[3376] = "7018";
            t[3377] = "7018";
            t[3378] = "7020";
            t[3379] = "7021";
            t[3380] = "7022";
            t[3381] = "7102";
            t[3382] = "7105";
            t[3383] = "7105";
            t[3384] = "7122";
            t[3385] = "7122";
            t[3386] = "7148";
            t[3387] = "7148";
            t[3388] = "7150";
            t[3389] = "7157";
            t[3390] = "7161";
            t[3391] = "7162";
            t[3392] = "7164";
            t[3393] = "7201";
            t[3394] = "7202";
            t[3395] = "7203";
            t[3396] = "7203";
            t[3397] = "7205";
            t[3398] = "7208";
            t[3399] = "7210";
            t[3400] = "7211";
            t[3401] = "7212";
            t[3402] = "7213";
            t[3403] = "7213";
            t[3404] = "7214";
            t[3405] = "7215";
            t[3406] = "7217";
            t[3407] = "7218";
            t[3408] = "7219";
            t[3409] = "7220";
            t[3410] = "7221";
            t[3411] = "7222";
            t[3412] = "7223";
            t[3413] = "7224";
            t[3414] = "7224";
            t[3415] = "7226";
            t[3416] = "7226";
            t[3417] = "7227";
            t[3418] = "7228";
            t[3419] = "7229";
            t[3420] = "7230";
            t[3421] = "7231";
            t[3422] = "7231";
            t[3423] = "7233";
            t[3424] = "7235";
            t[3425] = "7236";
            t[3426] = "7238";
            t[3427] = "7239";
            t[3428] = "7240";
            t[3429] = "7241";
            t[3430] = "7242";
            t[3431] = "7243";
            t[3432] = "7244";
            t[3433] = "7245";
            t[3434] = "7246";
            t[3435] = "7247";
            t[3436] = "7248";
            t[3437] = "7249";
            t[3438] = "7250";
            t[3439] = "7251";
            t[3440] = "7252";
            t[3441] = "7254";
            t[3442] = "7255";
            t[3443] = "7256";
            t[3444] = "7259";
            t[3445] = "7260";
            t[3446] = "7261";
            t[3447] = "7262";
            t[3448] = "7262";
            t[3449] = "7263";
            t[3450] = "7264";
            t[3451] = "7265";
            t[3452] = "7266";
            t[3453] = "7267";
            t[3454] = "7267";
            t[3455] = "7268";
            t[3456] = "7269";
            t[3457] = "7270";
            t[3458] = "7271";
            t[3459] = "7272";
            t[3460] = "7273";
            t[3461] = "7274";
            t[3462] = "7276";
            t[3463] = "7277";
            t[3464] = "7278";
            t[3465] = "7278";
            t[3466] = "7279";
            t[3467] = "7280";
            t[3468] = "7282";
            t[3469] = "7283";
            t[3470] = "7284";
            t[3471] = "7287";
            t[3472] = "7288";
            t[3473] = "7289";
            t[3474] = "7291";
            t[3475] = "7291";
            t[3476] = "7292";
            t[3477] = "7294";
            t[3478] = "7295";
            t[3479] = "7296";
            t[3480] = "7297";
            t[3481] = "7298";
            t[3482] = "7299";
            t[3483] = "7301";
            t[3484] = "7305";
            t[3485] = "7305";
            t[3486] = "7308";
            t[3487] = "7309";
            t[3488] = "7309";
            t[3489] = "7311";
            t[3490] = "7312";
            t[3491] = "7313";
            t[3492] = "7314";
            t[3493] = "7399";
            t[3494] = "7404";
            t[3495] = "7408";
            t[3496] = "7410";
            t[3497] = "7412";
            t[3498] = "7413";
            t[3499] = "7414";
            t[3500] = "7415";
            t[3501] = "7416";
            t[3502] = "7417";
            t[3503] = "7419";
            t[3504] = "7420";
            t[3505] = "7421";
            t[3506] = "7422";
            t[3507] = "7425";
            t[3508] = "7426";
            t[3509] = "7427";
            t[3510] = "7427";
            t[3511] = "7428";
            t[3512] = "7429";
            t[3513] = "7430";
            t[3514] = "7432";
            t[3515] = "7433";
            t[3516] = "7434";
            t[3517] = "7435";
            t[3518] = "7438";
            t[3519] = "7438";
            t[3520] = "7440";
            t[3521] = "7441";
            t[3522] = "7442";
            t[3523] = "7442";
            t[3524] = "7443";
            t[3525] = "7444";
            t[3526] = "7445";
            t[3527] = "7446";
            t[3528] = "7447";
            t[3529] = "7448";
            t[3530] = "7449";
            t[3531] = "7450";
            t[3532] = "7451";
            t[3533] = "7452";
            t[3534] = "7453";
            t[3535] = "7455";
            t[3536] = "7456";
            t[3537] = "7457";
            t[3538] = "7458";
            t[3539] = "7459";
            t[3540] = "7460";
            t[3541] = "7461";
            t[3542] = "7462";
            t[3543] = "7463";
            t[3544] = "7464";
            t[3545] = "7465";
            t[3546] = "7466";
            t[3547] = "7467";
            t[3548] = "7468";
            t[3549] = "7472";
            t[3550] = "7473";
            t[3551] = "7474";
            t[3552] = "7475";
            t[3553] = "7476";
            t[3554] = "7476";
            t[3555] = "7477";
            t[3556] = "7478";
            t[3557] = "7480";
            t[3558] = "7480";
            t[3559] = "7481";
            t[3560] = "7481";
            t[3561] = "7482";
            t[3562] = "7483";
            t[3563] = "7483";
            t[3564] = "7485";
            t[3565] = "7486";
            t[3566] = "7487";
            t[3567] = "7488";
            t[3568] = "7490";
            t[3569] = "7491";
            t[3570] = "7493";
            t[3571] = "7494";
            t[3572] = "7495";
            t[3573] = "7498";
            t[3574] = "7500";
            t[3575] = "7501";
            t[3576] = "7502";
            t[3577] = "7503";
            t[3578] = "7504";
            t[3579] = "7505";
            t[3580] = "7506";
            t[3581] = "7506";
            t[3582] = "7508";
            t[3583] = "7508";
            t[3584] = "7509";
            t[3585] = "7510";
            t[3586] = "7511";
            t[3587] = "7512";
            t[3588] = "7513";
            t[3589] = "7514";
            t[3590] = "7515";
            t[3591] = "7516";
            t[3592] = "7516";
            t[3593] = "7517";
            t[3594] = "7517";
            t[3595] = "7518";
            t[3596] = "7519";
            t[3597] = "7520";
            t[3598] = "7521";
            t[3599] = "7522";
            t[3600] = "7523";
            t[3601] = "7524";
            t[3602] = "7524";
            t[3603] = "7525";
            t[3604] = "7527";
            t[3605] = "7530";
            t[3606] = "7531";
            t[3607] = "7532";
            t[3608] = "7533";
            t[3609] = "7535";
            t[3610] = "7537";
            t[3611] = "7538";
            t[3612] = "7539";
            t[3613] = "7541";
            t[3614] = "7542";
            t[3615] = "7544";
            t[3616] = "7545";
            t[3617] = "7545";
            t[3618] = "7548";
            t[3619] = "7550";
            t[3620] = "7551";
            t[3621] = "7552";
            t[3622] = "7553";
            t[3623] = "7554";
            t[3624] = "7555";
            t[3625] = "7556";
            t[3626] = "7558";
            t[3627] = "7559";
            t[3628] = "7560";
            t[3629] = "7561";
            t[3630] = "7561";
            t[3631] = "7562";
            t[3632] = "7563";
            t[3633] = "7564";
            t[3634] = "7565";
            t[3635] = "7566";
            t[3636] = "7567";
            t[3637] = "7568";
            t[3638] = "7569";
            t[3639] = "7570";
            t[3640] = "7571";
            t[3641] = "7574";
            t[3642] = "7575";
            t[3643] = "7577";
            t[3644] = "7578";
            t[3645] = "7579";
            t[3646] = "7581";
            t[3647] = "7582";
            t[3648] = "7583";
            t[3649] = "7584";
            t[3650] = "7585";
            t[3651] = "7586";
            t[3652] = "7587";
            t[3653] = "7590";
            t[3654] = "7591";
            t[3655] = "7592";
            t[3656] = "7593";
            t[3657] = "7593";
            t[3658] = "7594";
            t[3659] = "7595";
            t[3660] = "7596";
            t[3661] = "7597";
            t[3662] = "7598";
            t[3663] = "7599";
            t[3664] = "7600";
            t[3665] = "7601";
            t[3666] = "7602";
            t[3667] = "7603";
            t[3668] = "7604";
            t[3669] = "7605";
            t[3670] = "7606";
            t[3671] = "7607";
            t[3672] = "7608";
            t[3673] = "7608";
            t[3674] = "7609";
            t[3675] = "7609";
            t[3676] = "7610";
            t[3677] = "7611";
            t[3678] = "7611";
            t[3679] = "7612";
            t[3680] = "7613";
            t[3681] = "7613";
            t[3682] = "7614";
            t[3683] = "7615";
            t[3684] = "7616";
            t[3685] = "7617";
            t[3686] = "7617";
            t[3687] = "7618";
            t[3688] = "7619";
            t[3689] = "7620";
            t[3690] = "7621";
            t[3691] = "7622";
            t[3692] = "7623";
            t[3693] = "7624";
            t[3694] = "7625";
            t[3695] = "7626";
            t[3696] = "7627";
            t[3697] = "7628";
            t[3698] = "7630";
            t[3699] = "7631";
            t[3700] = "7632";
            t[3701] = "7633";
            t[3702] = "7634";
            t[3703] = "7635";
            t[3704] = "7636";
            t[3705] = "7637";
            t[3706] = "7638";
            t[3707] = "7640";
            t[3708] = "7641";
            t[3709] = "7642";
            t[3710] = "7643";
            t[3711] = "7644";
            t[3712] = "7645";
            t[3713] = "7646";
            t[3714] = "7647";
            t[3715] = "7648";
            t[3716] = "7649";
            t[3717] = "7661";
            t[3718] = "7701";
            t[3719] = "7701";
            t[3720] = "7702";
            t[3721] = "7703";
            t[3722] = "7704";
            t[3723] = "7705";
            t[3724] = "7705";
            t[3725] = "7706";
            t[3726] = "7707";
            t[3727] = "7707";
            t[3728] = "7708";
            t[3729] = "7708";
            t[3730] = "7709";
            t[3731] = "7711";
            t[3732] = "7713";
            t[3733] = "7714";
            t[3734] = "7715";
            t[3735] = "7715";
            t[3736] = "7716";
            t[3737] = "7717";
            t[3738] = "7718";
            t[3739] = "7719";
            t[3740] = "7720";
            t[3741] = "7721";
            t[3742] = "7722";
            t[3743] = "7723";
            t[3744] = "7724";
            t[3745] = "7725";
            t[3746] = "7726";
            t[3747] = "7727";
            t[3748] = "7728";
            t[3749] = "7729";
            t[3750] = "7730";
            t[3751] = "7730";
            t[3752] = "7731";
            t[3753] = "7732";
            t[3754] = "7733";
            t[3755] = "7734";
            t[3756] = "7735";
            t[3757] = "7735";
            t[3758] = "7736";
            t[3759] = "7739";
            t[3760] = "7740";
            t[3761] = "7740";
            t[3762] = "7741";
            t[3763] = "7743";
            t[3764] = "7744";
            t[3765] = "7744";
            t[3766] = "7745";
            t[3767] = "7745";
            t[3768] = "7746";
            t[3769] = "7747";
            t[3770] = "7747";
            t[3771] = "7748";
            t[3772] = "7749";
            t[3773] = "7750";
            t[3774] = "7751";
            t[3775] = "7751";
            t[3776] = "7752";
            t[3777] = "7752";
            t[3778] = "7756";
            t[3779] = "7757";
            t[3780] = "7758";
            t[3781] = "7760";
            t[3782] = "7762";
            t[3783] = "7765";
            t[3784] = "7768";
            t[3785] = "7769";
            t[3786] = "7770";
            t[3787] = "7771";
            t[3788] = "7773";
            t[3789] = "7774";
            t[3790] = "7775";
            t[3791] = "7776";
            t[3792] = "7777";
            t[3793] = "7817";
            t[3794] = "7818";
            t[3795] = "7819";
            t[3796] = "7819";
            t[3797] = "7820";
            t[3798] = "7821";
            t[3799] = "7822";
            t[3800] = "7823";
            t[3801] = "7824";
            t[3802] = "7825";
            t[3803] = "7826";
            t[3804] = "7827";
            t[3805] = "7828";
            t[3806] = "7829";
            t[3807] = "7830";
            t[3808] = "7831";
            t[3809] = "7832";
            t[3810] = "7833";
            t[3811] = "7834";
            t[3812] = "7834";
            t[3813] = "7835";
            t[3814] = "7836";
            t[3815] = "7837";
            t[3816] = "7838";
            t[3817] = "7838";
            t[3818] = "7839";
            t[3819] = "7839";
            t[3820] = "7840";
            t[3821] = "7841";
            t[3822] = "7842";
            t[3823] = "7843";
            t[3824] = "7844";
            t[3825] = "7844";
            t[3826] = "7845";
            t[3827] = "7846";
            t[3828] = "7846";
            t[3829] = "7847";
            t[3830] = "7849";
            t[3831] = "7850";
            t[3832] = "7851";
            t[3833] = "7853";
            t[3834] = "7855";
            t[3835] = "7855";
            t[3836] = "7856";
            t[3837] = "7857";
            t[3838] = "7858";
            t[3839] = "7859";
            t[3840] = "7860";
            t[3841] = "7861";
            t[3842] = "7862";
            t[3843] = "7863";
            t[3844] = "7864";
            t[3845] = "7865";
            t[3846] = "7866";
            t[3847] = "7867";
            t[3848] = "7868";
            t[3849] = "7868";
            t[3850] = "7869";
            t[3851] = "7870";
            t[3852] = "7871";
            t[3853] = "7872";
            t[3854] = "7873";
            t[3855] = "7873";
            t[3856] = "7874";
            t[3857] = "7875";
            t[3858] = "7877";
            t[3859] = "7878";
            t[3860] = "7879";
            t[3861] = "7880";
            t[3862] = "7882";
            t[3863] = "7883";
            t[3864] = "7884";
            t[3865] = "7885";
            t[3866] = "7886";
            t[3867] = "7887";
            t[3868] = "7888";
            t[3869] = "7889";
            t[3870] = "7890";
            t[3871] = "7891";
            t[3872] = "7893";
            t[3873] = "7894";
            t[3874] = "7895";
            t[3875] = "7896";
            t[3876] = "7897";
            t[3877] = "7898";
            t[3878] = "7898";
            t[3879] = "7899";
            t[3880] = "7900";
            t[3881] = "7901";
            t[3882] = "7902";
            t[3883] = "7903";
            t[3884] = "7904";
            t[3885] = "7905";
            t[3886] = "7905";
            t[3887] = "7906";
            t[3888] = "7907";
            t[3889] = "7908";
            t[3890] = "7908";
            t[3891] = "7909";
            t[3892] = "7911";
            t[3893] = "7912";
            t[3894] = "7912";
            t[3895] = "7913";
            t[3896] = "7914";
            t[3897] = "7915";
            t[3898] = "7915";
            t[3899] = "7916";
            t[3900] = "7917";
            t[3901] = "7918";
            t[3902] = "7919";
            t[3903] = "7919";
            t[3904] = "7920";
            t[3905] = "7921";
            t[3906] = "7922";
            t[3907] = "7923";
            t[3908] = "7925";
            t[3909] = "7926";
            t[3910] = "7927";
            t[3911] = "7928";
            t[3912] = "7929";
            t[3913] = "7931";
            t[3914] = "7932";
            t[3915] = "7933";
            t[3916] = "7934";
            t[3917] = "7935";
            t[3918] = "7936";
            t[3919] = "7936";
            t[3920] = "7937";
            t[3921] = "7938";
            t[3922] = "7939";
            t[3923] = "7940";
            t[3924] = "7942";
            t[3925] = "7943";
            t[3926] = "7944";
            t[3927] = "7944";
            t[3928] = "7945";
            t[3929] = "7946";
            t[3930] = "7947";
            t[3931] = "7947";
            t[3932] = "7948";
            t[3933] = "7949";
            t[3934] = "7950";
            t[3935] = "7951";
            t[3936] = "7952";
            t[3937] = "7953";
            t[3938] = "7954";
            t[3939] = "7955";
            t[3940] = "7956";
            t[3941] = "7957";
            t[3942] = "7958";
            t[3943] = "7959";
            t[3944] = "7960";
            t[3945] = "7961";
            t[3946] = "7962";
            t[3947] = "7963";
            t[3948] = "7965";
            t[3949] = "7966";
            t[3950] = "7968";
            t[3951] = "7970";
            t[3952] = "7971";
            t[3953] = "7971";
            t[3954] = "7972";
            t[3955] = "7972";
            t[3956] = "7974";
            t[3957] = "7974";
            t[3958] = "7975";
            t[3959] = "7976";
            t[3960] = "7979";
            t[3961] = "7979";
            t[3962] = "7980";
            t[3963] = "7981";
            t[3964] = "7981";
            t[3965] = "7983";
            t[3966] = "7984";
            t[3967] = "7984";
            t[3968] = "7985";
            t[3969] = "7986";
            t[3970] = "7987";
            t[3971] = "7987";
            t[3972] = "7988";
            t[3973] = "7989";
            t[3974] = "7990";
            t[3975] = "7991";
            t[3976] = "7992";
            t[3977] = "7993";
            t[3978] = "7994";
            t[3979] = "7994";
            t[3980] = "7995";
            t[3981] = "7997";
            t[3982] = "7999";
            t[3983] = "8000";
            t[3984] = "8001";
            t[3985] = "8001";
            t[3986] = "8002";
            t[3987] = "8002";
            t[3988] = "8005";
            t[3989] = "8006";
            t[3990] = "8007";
            t[3991] = "8008";
            t[3992] = "8011";
            t[3993] = "8012";
            t[3994] = "8012";
            t[3995] = "8013";
            t[3996] = "8014";
            t[3997] = "8014";
            t[3998] = "8015";
            t[3999] = "8016";
            t[4000] = "8016";
            t[4001] = "8018";
            t[4002] = "8018";
            t[4003] = "8019";
            t[4004] = "8020";
            t[4005] = "8022";
            t[4006] = "8022";
            t[4007] = "8023";
            t[4008] = "8024";
            t[4009] = "8025";
            t[4010] = "8027";
            t[4011] = "8028";
            t[4012] = "8029";
            t[4013] = "8030";
            t[4014] = "8031";
            t[4015] = "8031";
            t[4016] = "8032";
            t[4017] = "8035";
            t[4018] = "8036";
            t[4019] = "8036";
            t[4020] = "8037";
            t[4021] = "8038";
            t[4022] = "8039";
            t[4023] = "8040";
            t[4024] = "8041";
            t[4025] = "8042";
            t[4026] = "8043";
            t[4027] = "8044";
            t[4028] = "8045";
            t[4029] = "8046";
            t[4030] = "8048";
            t[4031] = "8050";
            t[4032] = "8051";
            t[4033] = "8051";
            t[4034] = "8052";
            t[4035] = "8052";
            t[4036] = "8053";
            t[4037] = "8053";
            t[4038] = "8056";
            t[4039] = "8057";
            t[4040] = "8057";
            t[4041] = "8058";
            t[4042] = "8058";
            t[4043] = "8059";
            t[4044] = "8060";
            t[4045] = "8061";
            t[4046] = "8064";
            t[4047] = "8065";
            t[4048] = "8066";
            t[4049] = "8066";
            t[4050] = "8067";
            t[4051] = "8068";
            t[4052] = "8070";
            t[4053] = "8071";
            t[4054] = "8072";
            t[4055] = "8073";
            t[4056] = "8074";
            t[4057] = "8075";
            t[4058] = "8075";
            t[4059] = "8076";
            t[4060] = "8077";
            t[4061] = "8078";
            t[4062] = "8078";
            t[4063] = "8079";
            t[4064] = "8080";
            t[4065] = "8081";
            t[4066] = "8083";
            t[4067] = "8084";
            t[4068] = "8085";
            t[4069] = "8086";
            t[4070] = "8086";
            t[4071] = "8087";
            t[4072] = "8087";
            t[4073] = "8088";
            t[4074] = "8088";
            t[4075] = "8089";
            t[4076] = "8090";
            t[4077] = "8091";
            t[4078] = "8092";
            t[4079] = "8093";
            t[4080] = "8095";
            t[4081] = "8096";
            t[4082] = "8097";
            t[4083] = "8098";
            t[4084] = "8098";
            t[4085] = "8101";
            t[4086] = "8101";
            t[4087] = "8103";
            t[4088] = "8104";
            t[4089] = "8105";
            t[4090] = "8107";
            t[4091] = "8108";
            t[4092] = "8109";
            t[4093] = "8110";
            t[4094] = "8111";
            t[4095] = "8112";
            t[4096] = "8113";
            t[4097] = "8114";
            t[4098] = "8114";
            t[4099] = "8115";
            t[4100] = "8117";
            t[4101] = "8118";
            t[4102] = "8119";
            t[4103] = "8120";
            t[4104] = "8123";
            t[4105] = "8125";
            t[4106] = "8126";
            t[4107] = "8127";
            t[4108] = "8127";
            t[4109] = "8128";
            t[4110] = "8129";
            t[4111] = "8130";
            t[4112] = "8131";
            t[4113] = "8132";
            t[4114] = "8133";
            t[4115] = "8134";
            t[4116] = "8135";
            t[4117] = "8136";
            t[4118] = "8137";
            t[4119] = "8138";
            t[4120] = "8139";
            t[4121] = "8140";
            t[4122] = "8141";
            t[4123] = "8142";
            t[4124] = "8142";
            t[4125] = "8143";
            t[4126] = "8143";
            t[4127] = "8144";
            t[4128] = "8145";
            t[4129] = "8146";
            t[4130] = "8147";
            t[4131] = "8148";
            t[4132] = "8150";
            t[4133] = "8151";
            t[4134] = "8152";
            t[4135] = "8153";
            t[4136] = "8154";
            t[4137] = "8155";
            t[4138] = "8157";
            t[4139] = "8158";
            t[4140] = "8159";
            t[4141] = "8159";
            t[4142] = "8160";
            t[4143] = "8163";
            t[4144] = "8164";
            t[4145] = "8165";
            t[4146] = "8165";
            t[4147] = "8166";
            t[4148] = "8167";
            t[4149] = "8167";
            t[4150] = "8168";
            t[4151] = "8170";
            t[4152] = "8171";
            t[4153] = "8173";
            t[4154] = "8173";
            t[4155] = "8174";
            t[4156] = "8175";
            t[4157] = "8178";
            t[4158] = "8179";
            t[4159] = "8181";
            t[4160] = "8182";
            t[4161] = "8183";
            t[4162] = "8184";
            t[4163] = "8185";
            t[4164] = "8186";
            t[4165] = "8187";
            t[4166] = "8190";
            t[4167] = "8191";
            t[4168] = "8192";
            t[4169] = "8193";
            t[4170] = "8194";
            t[4171] = "8194";
            t[4172] = "8196";
            t[4173] = "8197";
            t[4174] = "8198";
            t[4175] = "8200";
            t[4176] = "8201";
            t[4177] = "8202";
            t[4178] = "8203";
            t[4179] = "8205";
            t[4180] = "8206";
            t[4181] = "8207";
            t[4182] = "8208";
            t[4183] = "8209";
            t[4184] = "8211";
            t[4185] = "8214";
            t[4186] = "8214";
            t[4187] = "8215";
            t[4188] = "8216";
            t[4189] = "8217";
            t[4190] = "8217";
            t[4191] = "8218";
            t[4192] = "8219";
            t[4193] = "8219";
            t[4194] = "8225";
            t[4195] = "8226";
            t[4196] = "8227";
            t[4197] = "8228";
            t[4198] = "8229";
            t[4199] = "8230";
            t[4200] = "8230";
            t[4201] = "8233";
            t[4202] = "8233";
            t[4203] = "8234";
            t[4204] = "8236";
            t[4205] = "8237";
            t[4206] = "8238";
            t[4207] = "8242";
            t[4208] = "8242";
            t[4209] = "8244";
            t[4210] = "8245";
            t[4211] = "8247";
            t[4212] = "8247";
            t[4213] = "8248";
            t[4214] = "8248";
            t[4215] = "8249";
            t[4216] = "8249";
            t[4217] = "8251";
            t[4218] = "8252";
            t[4219] = "8253";
            t[4220] = "8254";
            t[4221] = "8255";
            t[4222] = "8256";
            t[4223] = "8257";
            t[4224] = "8258";
            t[4225] = "8260";
            t[4226] = "8263";
            t[4227] = "8266";
            t[4228] = "8266";
            t[4229] = "8267";
            t[4230] = "8268";
            t[4231] = "8270";
            t[4232] = "8273";
            t[4233] = "8273";
            t[4234] = "8274";
            t[4235] = "8275";
            t[4236] = "8276";
            t[4237] = "8276";
            t[4238] = "8278";
            t[4239] = "8278";
            t[4240] = "8279";
            t[4241] = "8281";
            t[4242] = "8282";
            t[4243] = "8283";
            t[4244] = "8283";
            t[4245] = "8283";
            t[4246] = "8285";
            t[4247] = "8287";
            t[4248] = "8289";
            t[4249] = "8290";
            t[4250] = "8291";
            t[4251] = "8293";
            t[4252] = "8298";
            t[4253] = "8301";
            t[4254] = "8302";
            t[4255] = "8303";
            t[4256] = "8304";
            t[4257] = "8306";
            t[4258] = "8306";
            t[4259] = "8308";
            t[4260] = "8308";
            t[4261] = "8309";
            t[4262] = "8309";
            t[4263] = "8311";
            t[4264] = "8312";
            t[4265] = "8314";
            t[4266] = "8316";
            t[4267] = "8316";
            t[4268] = "8317";
            t[4269] = "8320";
            t[4270] = "8324";
            t[4271] = "8325";
            t[4272] = "8326";
            t[4273] = "8327";
            t[4274] = "8327";
            t[4275] = "8328";
            t[4276] = "8331";
            t[4277] = "8332";
            t[4278] = "8333";
            t[4279] = "8334";
            t[4280] = "8336";
            t[4281] = "8337";
            t[4282] = "8338";
            t[4283] = "8339";
            t[4284] = "8340";
            t[4285] = "8341";
            t[4286] = "8342";
            t[4287] = "8343";
            t[4288] = "8344";
            t[4289] = "8345";
            t[4290] = "8346";
            t[4291] = "8347";
            t[4292] = "8349";
            t[4293] = "8350";
            t[4294] = "8354";
            t[4295] = "8354";
            t[4296] = "8355";
            t[4297] = "8356";
            t[4298] = "8358";
            t[4299] = "8359";
            t[4300] = "8360";
            t[4301] = "8361";
            t[4302] = "8362";
            t[4303] = "8363";
            t[4304] = "8364";
            t[4305] = "8365";
            t[4306] = "8366";
            t[4307] = "8366";
            t[4308] = "8367";
            t[4309] = "8367";
            t[4310] = "8368";
            t[4311] = "8369";
            t[4312] = "8369";
            t[4313] = "8372";
            t[4314] = "8374";
            t[4315] = "8375";
            t[4316] = "8377";
            t[4317] = "8378";
            t[4318] = "8379";
            t[4319] = "8381";
            t[4320] = "8382";
            t[4321] = "8382";
            t[4322] = "8383";
            t[4323] = "8383";
            t[4324] = "8384";
            t[4325] = "8385";
            t[4326] = "8385";
            t[4327] = "8386";
            t[4328] = "8386";
            t[4329] = "8387";
            t[4330] = "8387";
            t[4331] = "8388";
            t[4332] = "8388";
            t[4333] = "8390";
            t[4334] = "8392";
            t[4335] = "8393";
            t[4336] = "8394";
            t[4337] = "8394";
            t[4338] = "8395";
            t[4339] = "8396";
            t[4340] = "8397";
            t[4341] = "8398";
            t[4342] = "8399";
            t[4343] = "8402";
            t[4344] = "8403";
            t[4345] = "8404";
            t[4346] = "8404";
            t[4347] = "8409";
            t[4348] = "8410";
            t[4349] = "8410";
            t[4350] = "8411";
            t[4351] = "8411";
            t[4352] = "8415";
            t[4353] = "8416";
            t[4354] = "8418";
            t[4355] = "8423";
            t[4356] = "8424";
            t[4357] = "8425";
            t[4358] = "8426";
            t[4359] = "8432";
            t[4360] = "8439";
            t[4361] = "8458";
            t[4362] = "8462";
            t[4363] = "8462";
            t[4364] = "8473";
            t[4365] = "8473";
            t[4366] = "8489";
            t[4367] = "8493";
            t[4368] = "8508";
            t[4369] = "8511";
            t[4370] = "8512";
            t[4371] = "8512";
            t[4372] = "8513";
            t[4373] = "8514";
            t[4374] = "8515";
            t[4375] = "8518";
            t[4376] = "8518";
            t[4377] = "8519";
            t[4378] = "8520";
            t[4379] = "8521";
            t[4380] = "8522";
            t[4381] = "8524";
            t[4382] = "8527";
            t[4383] = "8529";
            t[4384] = "8530";
            t[4385] = "8536";
            t[4386] = "8537";
            t[4387] = "8537";
            t[4388] = "8540";
            t[4389] = "8541";
            t[4390] = "8541";
            t[4391] = "8542";
            t[4392] = "8542";
            t[4393] = "8543";
            t[4394] = "8543";
            t[4395] = "8544";
            t[4396] = "8545";
            t[4397] = "8545";
            t[4398] = "8546";
            t[4399] = "8547";
            t[4400] = "8550";
            t[4401] = "8551";
            t[4402] = "8552";
            t[4403] = "8554";
            t[4404] = "8556";
            t[4405] = "8558";
            t[4406] = "8559";
            t[4407] = "8560";
            t[4408] = "8561";
            t[4409] = "8562";
            t[4410] = "8563";
            t[4411] = "8564";
            t[4412] = "8565";
            t[4413] = "8566";
            t[4414] = "8567";
            t[4415] = "8568";
            t[4416] = "8569";
            t[4417] = "8570";
            t[4418] = "8571";
            t[4419] = "8572";
            t[4420] = "8573";
            t[4421] = "8574";
            t[4422] = "8577";
            t[4423] = "8579";
            t[4424] = "8581";
            t[4425] = "8583";
            t[4426] = "8584";
            t[4427] = "8585";
            t[4428] = "8585";
            t[4429] = "8586";
            t[4430] = "8588";
            t[4431] = "8589";
            t[4432] = "8591";
            t[4433] = "8591";
            t[4434] = "8592";
            t[4435] = "8593";
            t[4436] = "8594";
            t[4437] = "8595";
            t[4438] = "8596";
            t[4439] = "8597";
            t[4440] = "8599";
            t[4441] = "8600";
            t[4442] = "8601";
            t[4443] = "8601";
            t[4444] = "8602";
            t[4445] = "8603";
            t[4446] = "8604";
            t[4447] = "8604";
            t[4448] = "8605";
            t[4449] = "8606";
            t[4450] = "8606";
            t[4451] = "8607";
            t[4452] = "8607";
            t[4453] = "8609";
            t[4454] = "8609";
            t[4455] = "8611";
            t[4456] = "8613";
            t[4457] = "8613";
            t[4458] = "8614";
            t[4459] = "8614";
            t[4460] = "8615";
            t[4461] = "8616";
            t[4462] = "8616";
            t[4463] = "8617";
            t[4464] = "8617";
            t[4465] = "8622";
            t[4466] = "8624";
            t[4467] = "8624";
            t[4468] = "8625";
            t[4469] = "8625";
            t[4470] = "8628";
            t[4471] = "8630";
            t[4472] = "8630";
            t[4473] = "8634";
            t[4474] = "8640";
            t[4475] = "8642";
            t[4476] = "8648";
            t[4477] = "8657";
            t[4478] = "8665";
            t[4479] = "8666";
            t[4480] = "8675";
            t[4481] = "8685";
            t[4482] = "8686";
            t[4483] = "8689";
            t[4484] = "8692";
            t[4485] = "8692";
            t[4486] = "8697";
            t[4487] = "8697";
            t[4488] = "8698";
            t[4489] = "8699";
            t[4490] = "8699";
            t[4491] = "8700";
            t[4492] = "8701";
            t[4493] = "8702";
            t[4494] = "8702";
            t[4495] = "8703";
            t[4496] = "8704";
            t[4497] = "8704";
            t[4498] = "8705";
            t[4499] = "8706";
            t[4500] = "8707";
            t[4501] = "8707";
            t[4502] = "8708";
            t[4503] = "8709";
            t[4504] = "8709";
            t[4505] = "8710";
            t[4506] = "8711";
            t[4507] = "8713";
            t[4508] = "8714";
            t[4509] = "8714";
            t[4510] = "8715";
            t[4511] = "8718";
            t[4512] = "8718";
            t[4513] = "8720";
            t[4514] = "8721";
            t[4515] = "8725";
            t[4516] = "8725";
            t[4517] = "8728";
            t[4518] = "8728";
            t[4519] = "8729";
            t[4520] = "8732";
            t[4521] = "8732";
            t[4522] = "8734";
            t[4523] = "8735";
            t[4524] = "8737";
            t[4525] = "8738";
            t[4526] = "8739";
            t[4527] = "8740";
            t[4528] = "8742";
            t[4529] = "8744";
            t[4530] = "8746";
            t[4531] = "8747";
            t[4532] = "8748";
            t[4533] = "8749";
            t[4534] = "8750";
            t[4535] = "8752";
            t[4536] = "8754";
            t[4537] = "8755";
            t[4538] = "8759";
            t[4539] = "8761";
            t[4540] = "8763";
            t[4541] = "8763";
            t[4542] = "8766";
            t[4543] = "8766";
            t[4544] = "8767";
            t[4545] = "8769";
            t[4546] = "8769";
            t[4547] = "8771";
            t[4548] = "8771";
            t[4549] = "8772";
            t[4550] = "8774";
            t[4551] = "8783";
            t[4552] = "8787";
            t[4553] = "8789";
            t[4554] = "8793";
            t[4555] = "8795";
            t[4556] = "8795";
            t[4557] = "8798";
            t[4558] = "8798";
            t[4559] = "8801";
            t[4560] = "8801";
            t[4561] = "8802";
            t[4562] = "8802";
            t[4563] = "8803";
            t[4564] = "8803";
            t[4565] = "8804";
            t[4566] = "8805";
            t[4567] = "8806";
            t[4568] = "8806";
            t[4569] = "8809";
            t[4570] = "8809";
            t[4571] = "8810";
            t[4572] = "8815";
            t[4573] = "8818";
            t[4574] = "8818";
            t[4575] = "8821";
            t[4576] = "8830";
            t[4577] = "8830";
            t[4578] = "8832";
            t[4579] = "8833";
            t[4580] = "8834";
            t[4581] = "8835";
            t[4582] = "8836";
            t[4583] = "8838";
            t[4584] = "8839";
            t[4585] = "8840";
            t[4586] = "8841";
            t[4587] = "8842";
            t[4588] = "8844";
            t[4589] = "8848";
            t[4590] = "8850";
            t[4591] = "8851";
            t[4592] = "8853";
            t[4593] = "8854";
            t[4594] = "8858";
            t[4595] = "8860";
            t[4596] = "8860";
            t[4597] = "8864";
            t[4598] = "8866";
            t[4599] = "8867";
            t[4600] = "8868";
            t[4601] = "8869";
            t[4602] = "8870";
            t[4603] = "8871";
            t[4604] = "8872";
            t[4605] = "8874";
            t[4606] = "8875";
            t[4607] = "8876";
            t[4608] = "8876";
            t[4609] = "8877";
            t[4610] = "8877";
            t[4611] = "8878";
            t[4612] = "8879";
            t[4613] = "8880";
            t[4614] = "8881";
            t[4615] = "8882";
            t[4616] = "8884";
            t[4617] = "8885";
            t[4618] = "8885";
            t[4619] = "8886";
            t[4620] = "8887";
            t[4621] = "8888";
            t[4622] = "8889";
            t[4623] = "8889";
            t[4624] = "8890";
            t[4625] = "8891";
            t[4626] = "8892";
            t[4627] = "8893";
            t[4628] = "8894";
            t[4629] = "8895";
            t[4630] = "8896";
            t[4631] = "8897";
            t[4632] = "8898";
            t[4633] = "8899";
            t[4634] = "8900";
            t[4635] = "8901";
            t[4636] = "8902";
            t[4637] = "8903";
            t[4638] = "8904";
            t[4639] = "8905";
            t[4640] = "8906";
            t[4641] = "8907";
            t[4642] = "8908";
            t[4643] = "8909";
            t[4644] = "8910";
            t[4645] = "8911";
            t[4646] = "8911";
            t[4647] = "8912";
            t[4648] = "8913";
            t[4649] = "8913";
            t[4650] = "8914";
            t[4651] = "8915";
            t[4652] = "8917";
            t[4653] = "8918";
            t[4654] = "8918";
            t[4655] = "8919";
            t[4656] = "8920";
            t[4657] = "8921";
            t[4658] = "8921";
            t[4659] = "8922";
            t[4660] = "8923";
            t[4661] = "8923";
            t[4662] = "8924";
            t[4663] = "8925";
            t[4664] = "8927";
            t[4665] = "8928";
            t[4666] = "8929";
            t[4667] = "8931";
            t[4668] = "8933";
            t[4669] = "8934";
            t[4670] = "8934";
            t[4671] = "8935";
            t[4672] = "8935";
            t[4673] = "8936";
            t[4674] = "8937";
            t[4675] = "8938";
            t[4676] = "8938";
            t[4677] = "8939";
            t[4678] = "8939";
            t[4679] = "8940";
            t[4680] = "8940";
            t[4681] = "8942";
            t[4682] = "8944";
            t[4683] = "8944";
            t[4684] = "8945";
            t[4685] = "8946";
            t[4686] = "8947";
            t[4687] = "8947";
            t[4688] = "8948";
            t[4689] = "8951";
            t[4690] = "8952";
            t[4691] = "8953";
            t[4692] = "8954";
            t[4693] = "8955";
            t[4694] = "8956";
            t[4695] = "8957";
            t[4696] = "8958";
            t[4697] = "8959";
            t[4698] = "8960";
            t[4699] = "8961";
            t[4700] = "8962";
            t[4701] = "8963";
            t[4702] = "8964";
            t[4703] = "8965";
            t[4704] = "8966";
            t[4705] = "8967";
            t[4706] = "8968";
            t[4707] = "8969";
            t[4708] = "8970";
            t[4709] = "8972";
            t[4710] = "8973";
            t[4711] = "8974";
            t[4712] = "8975";
            t[4713] = "8976";
            t[4714] = "8977";
            t[4715] = "8978";
            t[4716] = "8979";
            t[4717] = "8979";
            t[4718] = "8981";
            t[4719] = "8982";
            t[4720] = "8983";
            t[4721] = "8984";
            t[4722] = "8985";
            t[4723] = "8986";
            t[4724] = "8987";
            t[4725] = "8991";
            t[4726] = "8992";
            t[4727] = "8993";
            t[4728] = "8993";
            t[4729] = "8995";
            t[4730] = "8996";
            t[4731] = "8997";
            t[4732] = "8998";
            t[4733] = "8999";
            t[4734] = "9001";
            t[4735] = "9003";
            t[4736] = "9005";
            t[4737] = "9006";
            t[4738] = "9007";
            t[4739] = "9008";
            t[4740] = "9009";
            t[4741] = "9010";
            t[4742] = "9012";
            t[4743] = "9014";
            t[4744] = "9017";
            t[4745] = "9020";
            t[4746] = "9020";
            t[4747] = "9021";
            t[4748] = "9021";
            t[4749] = "9022";
            t[4750] = "9022";
            t[4751] = "9027";
            t[4752] = "9028";
            t[4753] = "9029";
            t[4754] = "9029";
            t[4755] = "9030";
            t[4756] = "9030";
            t[4757] = "9031";
            t[4758] = "9033";
            t[4759] = "9034";
            t[4760] = "9035";
            t[4761] = "9036";
            t[4762] = "9037";
            t[4763] = "9039";
            t[4764] = "9039";
            t[4765] = "9040";
            t[4766] = "9041";
            t[4767] = "9041";
            t[4768] = "9042";
            t[4769] = "9042";
            t[4770] = "9043";
            t[4771] = "9043";
            t[4772] = "9044";
            t[4773] = "9044";
            t[4774] = "9045";
            t[4775] = "9045";
            t[4776] = "9046";
            t[4777] = "9047";
            t[4778] = "9048";
            t[4779] = "9049";
            t[4780] = "9051";
            t[4781] = "9052";
            t[4782] = "9053";
            t[4783] = "9054";
            t[4784] = "9055";
            t[4785] = "9056";
            t[4786] = "9057";
            t[4787] = "9058";
            t[4788] = "9059";
            t[4789] = "9060";
            t[4790] = "9061";
            t[4791] = "9062";
            t[4792] = "9062";
            t[4793] = "9063";
            t[4794] = "9064";
            t[4795] = "9065";
            t[4796] = "9066";
            t[4797] = "9066";
            t[4798] = "9067";
            t[4799] = "9068";
            t[4800] = "9069";
            t[4801] = "9069";
            t[4802] = "9070";
            t[4803] = "9070";
            t[4804] = "9072";
            t[4805] = "9073";
            t[4806] = "9074";
            t[4807] = "9075";
            t[4808] = "9075";
            t[4809] = "9076";
            t[4810] = "9077";
            t[4811] = "9078";
            t[4812] = "9081";
            t[4813] = "9082";
            t[4814] = "9083";
            t[4815] = "9085";
            t[4816] = "9086";
            t[4817] = "9087";
            t[4818] = "9089";
            t[4819] = "9101";
            t[4820] = "9101";
            t[4821] = "9104";
            t[4822] = "9104";
            t[4823] = "9107";
            t[4824] = "9107";
            t[4825] = "9110";
            t[4826] = "9110";
            t[4827] = "9113";
            t[4828] = "9113";
            t[4829] = "9115";
            t[4830] = "9115";
            t[4831] = "9119";
            t[4832] = "9119";
            t[4833] = "9123";
            t[4834] = "9127";
            t[4835] = "9130";
            t[4836] = "9132";
            t[4837] = "9132";
            t[4838] = "9133";
            t[4839] = "9152";
            t[4840] = "9171";
            t[4841] = "9173";
            t[4842] = "9174";
            t[4843] = "9176";
            t[4844] = "9179";
            t[4845] = "9180";
            t[4846] = "9193";
            t[4847] = "9201";
            t[4848] = "9202";
            t[4849] = "9202";
            t[4850] = "9203";
            t[4851] = "9204";
            t[4852] = "9205";
            t[4853] = "9206";
            t[4854] = "9231";
            t[4855] = "9232";
            t[4856] = "9233";
            t[4857] = "9234";
            t[4858] = "9301";
            t[4859] = "9301";
            t[4860] = "9302";
            t[4861] = "9302";
            t[4862] = "9303";
            t[4863] = "9303";
            t[4864] = "9304";
            t[4865] = "9305";
            t[4866] = "9306";
            t[4867] = "9307";
            t[4868] = "9308";
            t[4869] = "9310";
            t[4870] = "9311";
            t[4871] = "9312";
            t[4872] = "9313";
            t[4873] = "9314";
            t[4874] = "9317";
            t[4875] = "9318";
            t[4876] = "9319";
            t[4877] = "9320";
            t[4878] = "9321";
            t[4879] = "9322";
            t[4880] = "9323";
            t[4881] = "9324";
            t[4882] = "9351";
            t[4883] = "9353";
            t[4884] = "9355";
            t[4885] = "9357";
            t[4886] = "9358";
            t[4887] = "9359";
            t[4888] = "9360";
            t[4889] = "9361";
            t[4890] = "9362";
            t[4891] = "9363";
            t[4892] = "9364";
            t[4893] = "9364";
            t[4894] = "9365";
            t[4895] = "9366";
            t[4896] = "9367";
            t[4897] = "9368";
            t[4898] = "9369";
            t[4899] = "9370";
            t[4900] = "9370";
            t[4901] = "9373";
            t[4902] = "9374";
            t[4903] = "9375";
            t[4904] = "9376";
            t[4905] = "9377";
            t[4906] = "9378";
            t[4907] = "9378";
            t[4908] = "9379";
            t[4909] = "9380";
            t[4910] = "9381";
            t[4911] = "9382";
            t[4912] = "9384";
            t[4913] = "9385";
            t[4914] = "9385";
            t[4915] = "9399";
            t[4916] = "9401";
            t[4917] = "9402";
            t[4918] = "9404";
            t[4919] = "9405";
            t[4920] = "9407";
            t[4921] = "9408";
            t[4922] = "9409";
            t[4923] = "9411";
            t[4924] = "9412";
            t[4925] = "9413";
            t[4926] = "9419";
            t[4927] = "9421";
            t[4928] = "9422";
            t[4929] = "9423";
            t[4930] = "9424";
            t[4931] = "9424";
            t[4932] = "9425";
            t[4933] = "9427";
            t[4934] = "9428";
            t[4935] = "9430";
            t[4936] = "9432";
            t[4937] = "9432";
            t[4938] = "9433";
            t[4939] = "9435";
            t[4940] = "9436";
            t[4941] = "9437";
            t[4942] = "9438";
            t[4943] = "9439";
            t[4944] = "9441";
            t[4945] = "9442";
            t[4946] = "9444";
            t[4947] = "9444";
            t[4948] = "9445";
            t[4949] = "9446";
            t[4950] = "9447";
            t[4951] = "9448";
            t[4952] = "9449";
            t[4953] = "9470";
            t[4954] = "9471";
            t[4955] = "9472";
            t[4956] = "9474";
            t[4957] = "9475";
            t[4958] = "9476";
            t[4959] = "9477";
            t[4960] = "9478";
            t[4961] = "9479";
            t[4962] = "9481";
            t[4963] = "9496";
            t[4964] = "9501";
            t[4965] = "9501";
            t[4966] = "9502";
            t[4967] = "9502";
            t[4968] = "9503";
            t[4969] = "9503";
            t[4970] = "9504";
            t[4971] = "9504";
            t[4972] = "9505";
            t[4973] = "9505";
            t[4974] = "9506";
            t[4975] = "9506";
            t[4976] = "9507";
            t[4977] = "9507";
            t[4978] = "9508";
            t[4979] = "9508";
            t[4980] = "9509";
            t[4981] = "9509";
            t[4982] = "9511";
            t[4983] = "9513";
            t[4984] = "9514";
            t[4985] = "9531";
            t[4986] = "9531";
            t[4987] = "9532";
            t[4988] = "9532";
            t[4989] = "9533";
            t[4990] = "9533";
            t[4991] = "9534";
            t[4992] = "9535";
            t[4993] = "9536";
            t[4994] = "9536";
            t[4995] = "9537";
            t[4996] = "9539";
            t[4997] = "9540";
            t[4998] = "9541";
            t[4999] = "9542";
            t[5000] = "9543";
            t[5001] = "9544";
            t[5002] = "9600";
            t[5003] = "9601";
            t[5004] = "9601";
            t[5005] = "9602";
            t[5006] = "9602";
            t[5007] = "9603";
            t[5008] = "9604";
            t[5009] = "9605";
            t[5010] = "9605";
            t[5011] = "9607";
            t[5012] = "9608";
            t[5013] = "9609";
            t[5014] = "9610";
            t[5015] = "9611";
            t[5016] = "9612";
            t[5017] = "9612";
            t[5018] = "9613";
            t[5019] = "9615";
            t[5020] = "9616";
            t[5021] = "9619";
            t[5022] = "9619";
            t[5023] = "9621";
            t[5024] = "9622";
            t[5025] = "9623";
            t[5026] = "9624";
            t[5027] = "9625";
            t[5028] = "9626";
            t[5029] = "9627";
            t[5030] = "9627";
            t[5031] = "9628";
            t[5032] = "9628";
            t[5033] = "9629";
            t[5034] = "9630";
            t[5035] = "9631";
            t[5036] = "9632";
            t[5037] = "9632";
            t[5038] = "9633";
            t[5039] = "9634";
            t[5040] = "9635";
            t[5041] = "9636";
            t[5042] = "9637";
            t[5043] = "9638";
            t[5044] = "9639";
            t[5045] = "9640";
            t[5046] = "9641";
            t[5047] = "9643";
            t[5048] = "9644";
            t[5049] = "9647";
            t[5050] = "9648";
            t[5051] = "9650";
            t[5052] = "9651";
            t[5053] = "9652";
            t[5054] = "9653";
            t[5055] = "9654";
            t[5056] = "9656";
            t[5057] = "9657";
            t[5058] = "9658";
            t[5059] = "9661";
            t[5060] = "9663";
            t[5061] = "9664";
            t[5062] = "9665";
            t[5063] = "9665";
            t[5064] = "9667";
            t[5065] = "9668";
            t[5066] = "9669";
            t[5067] = "9671";
            t[5068] = "9672";
            t[5069] = "9674";
            t[5070] = "9675";
            t[5071] = "9677";
            t[5072] = "9678";
            t[5073] = "9679";
            t[5074] = "9680";
            t[5075] = "9681";
            t[5076] = "9682";
            t[5077] = "9684";
            t[5078] = "9685";
            t[5079] = "9686";
            t[5080] = "9687";
            t[5081] = "9689";
            t[5082] = "9691";
            t[5083] = "9692";
            t[5084] = "9694";
            t[5085] = "9695";
            t[5086] = "9696";
            t[5087] = "9697";
            t[5088] = "9697";
            t[5089] = "9698";
            t[5090] = "9699";
            t[5091] = "9701";
            t[5092] = "9702";
            t[5093] = "9702";
            t[5094] = "9704";
            t[5095] = "9706";
            t[5096] = "9707";
            t[5097] = "9708";
            t[5098] = "9709";
            t[5099] = "9711";
            t[5100] = "9712";
            t[5101] = "9713";
            t[5102] = "9715";
            t[5103] = "9716";
            t[5104] = "9717";
            t[5105] = "9718";
            t[5106] = "9719";
            t[5107] = "9720";
            t[5108] = "9722";
            t[5109] = "9722";
            t[5110] = "9723";
            t[5111] = "9726";
            t[5112] = "9726";
            t[5113] = "9728";
            t[5114] = "9728";
            t[5115] = "9729";
            t[5116] = "9730";
            t[5117] = "9731";
            t[5118] = "9732";
            t[5119] = "9733";
            t[5120] = "9734";
            t[5121] = "9735";
            t[5122] = "9735";
            t[5123] = "9736";
            t[5124] = "9737";
            t[5125] = "9739";
            t[5126] = "9740";
            t[5127] = "9741";
            t[5128] = "9742";
            t[5129] = "9743";
            t[5130] = "9744";
            t[5131] = "9746";
            t[5132] = "9747";
            t[5133] = "9748";
            t[5134] = "9749";
            t[5135] = "9750";
            t[5136] = "9751";
            t[5137] = "9753";
            t[5138] = "9755";
            t[5139] = "9756";
            t[5140] = "9757";
            t[5141] = "9757";
            t[5142] = "9758";
            t[5143] = "9759";
            t[5144] = "9760";
            t[5145] = "9761";
            t[5146] = "9761";
            t[5147] = "9763";
            t[5148] = "9764";
            t[5149] = "9765";
            t[5150] = "9766";
            t[5151] = "9767";
            t[5152] = "9768";
            t[5153] = "9769";
            t[5154] = "9776";
            t[5155] = "9778";
            t[5156] = "9779";
            t[5157] = "9780";
            t[5158] = "9781";
            t[5159] = "9782";
            t[5160] = "9783";
            t[5161] = "9783";
            t[5162] = "9784";
            t[5163] = "9785";
            t[5164] = "9787";
            t[5165] = "9787";
            t[5166] = "9788";
            t[5167] = "9789";
            t[5168] = "9790";
            t[5169] = "9790";
            t[5170] = "9791";
            t[5171] = "9791";
            t[5172] = "9792";
            t[5173] = "9793";
            t[5174] = "9794";
            t[5175] = "9795";
            t[5176] = "9795";
            t[5177] = "9796";
            t[5178] = "9797";
            t[5179] = "9799";
            t[5180] = "9810";
            t[5181] = "9812";
            t[5182] = "9813";
            t[5183] = "9814";
            t[5184] = "9814";
            t[5185] = "9815";
            t[5186] = "9816";
            t[5187] = "9817";
            t[5188] = "9818";
            t[5189] = "9818";
            t[5190] = "9819";
            t[5191] = "9820";
            t[5192] = "9822";
            t[5193] = "9823";
            t[5194] = "9824";
            t[5195] = "9824";
            t[5196] = "9826";
            t[5197] = "9827";
            t[5198] = "9828";
            t[5199] = "9829";
            t[5200] = "9830";
            t[5201] = "9830";
            t[5202] = "9831";
            t[5203] = "9832";
            t[5204] = "9832";
            t[5205] = "9833";
            t[5206] = "9835";
            t[5207] = "9836";
            t[5208] = "9837";
            t[5209] = "9838";
            t[5210] = "9841";
            t[5211] = "9842";
            t[5212] = "9843";
            t[5213] = "9844";
            t[5214] = "9845";
            t[5215] = "9845";
            t[5216] = "9846";
            t[5217] = "9846";
            t[5218] = "9847";
            t[5219] = "9849";
            t[5220] = "9850";
            t[5221] = "9850";
            t[5222] = "9852";
            t[5223] = "9853";
            t[5224] = "9854";
            t[5225] = "9854";
            t[5226] = "9855";
            t[5227] = "9856";
            t[5228] = "9857";
            t[5229] = "9858";
            t[5230] = "9859";
            t[5231] = "9861";
            t[5232] = "9862";
            t[5233] = "9864";
            t[5234] = "9865";
            t[5235] = "9866";
            t[5236] = "9867";
            t[5237] = "9869";
            t[5238] = "9869";
            t[5239] = "9870";
            t[5240] = "9872";
            t[5241] = "9873";
            t[5242] = "9875";
            t[5243] = "9876";
            t[5244] = "9877";
            t[5245] = "9878";
            t[5246] = "9880";
            t[5247] = "9880";
            t[5248] = "9882";
            t[5249] = "9883";
            t[5250] = "9884";
            t[5251] = "9885";
            t[5252] = "9887";
            t[5253] = "9888";
            t[5254] = "9889";
            t[5255] = "9890";
            t[5256] = "9892";
            t[5257] = "9895";
            t[5258] = "9896";
            t[5259] = "9897";
            t[5260] = "9898";
            t[5261] = "9899";
            t[5262] = "9900";
            t[5263] = "9901";
            t[5264] = "9902";
            t[5265] = "9902";
            t[5266] = "9903";
            t[5267] = "9904";
            t[5268] = "9905";
            t[5269] = "9906";
            t[5270] = "9907";
            t[5271] = "9908";
            t[5272] = "9909";
            t[5273] = "9911";
            t[5274] = "9912";
            t[5275] = "9913";
            t[5276] = "9914";
            t[5277] = "9916";
            t[5278] = "9919";
            t[5279] = "9919";
            t[5280] = "9922";
            t[5281] = "9923";
            t[5282] = "9924";
            t[5283] = "9927";
            t[5284] = "9928";
            t[5285] = "9929";
            t[5286] = "9930";
            t[5287] = "9931";
            t[5288] = "9932";
            t[5289] = "9932";
            t[5290] = "9934";
            t[5291] = "9934";
            t[5292] = "9936";
            t[5293] = "9937";
            t[5294] = "9938";
            t[5295] = "9938";
            t[5296] = "9939";
            t[5297] = "9941";
            t[5298] = "9942";
            t[5299] = "9943";
            t[5300] = "9944";
            t[5301] = "9945";
            t[5302] = "9946";
            t[5303] = "9947";
            t[5304] = "9947";
            t[5305] = "9948";
            t[5306] = "9949";
            t[5307] = "9950";
            t[5308] = "9952";
            t[5309] = "9955";
            t[5310] = "9956";
            t[5311] = "9957";
            t[5312] = "9959";
            t[5313] = "9960";
            t[5314] = "9961";
            t[5315] = "9962";
            t[5316] = "9963";
            t[5317] = "9963";
            t[5318] = "9964";
            t[5319] = "9966";
            t[5320] = "9967";
            t[5321] = "9968";
            t[5322] = "9969";
            t[5323] = "9971";
            t[5324] = "9972";
            t[5325] = "9973";
            t[5326] = "9974";
            t[5327] = "9974";
            t[5328] = "9975";
            t[5329] = "9976";
            t[5330] = "9977";
            t[5331] = "9978";
            t[5332] = "9979";
            t[5333] = "9980";
            t[5334] = "9982";
            t[5335] = "9983";
            t[5336] = "9984";
            t[5337] = "998405";
            t[5338] = "998407";
            t[5339] = "9986";
            t[5340] = "9986";
            t[5341] = "9987";
            t[5342] = "9989";
            t[5343] = "9990";
            t[5344] = "9990";
            t[5345] = "9991";
            t[5346] = "9992";
            t[5347] = "9993";
            t[5348] = "9994";
            t[5349] = "9995";
            t[5350] = "9996";
            t[5351] = "9997";

            foreach ( string tmp in t) {
                yahoo.GetTopicId(tmp, false);
            }
        }




    }

    /// <summary>
    ///投稿タイトルリスト
    /// </summary>
    public class TitleLists
    {
        public string titleNo;
        public string url;
        public string title;
        public string sender;
        public string emotion;
        public string sendTime;
        public string status;  // 0:未読, 1:既読, null:未読
        private string delimiter = Char.ConvertFromUtf32(128);
        // 2013.2.24 textream対応 start
        public string content;
        public string user;  // like this "ofo9hpRxpi4jag2kUo2qOd4-" senderとは異なる
        public string userIcon;
        // 2013.2.24 textream対応 end

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public TitleLists() { 
            this.titleNo = ""; 
            this.title = ""; 
            this.url = ""; 
            this.sendTime = ""; 
            this.sender = ""; 
            this.emotion = ""; 
            this.status = "0"; 
            this.content = "";
            this.user = "";
        }
        public TitleLists(string[] p)
        {
            if (p.Length < 6) { return;  }
            titleNo = p[0];
            this.url = p[1];
            this.title = p[2];
            this.sender = p[3];
            this.emotion = p[4];
            this.sendTime = p[5];
            this.status = "0";
            this.content = "";
            this.user = "";
        }
        public void Clear()
        {
            this.titleNo = "";
            this.url = "";
            this.title = "";
            this.sender = "";
            this.emotion = "";
            this.sendTime = "";
            this.status = "0";
            this.content = "";
            this.user = "";
        }
        // 2013.2.14 textream以前の旧バージョン
        public TitleLists(string p1, string p2, string p3, string p4, string p5, string p6, string p7)
        {
            this.titleNo = p1;
            this.url = p2;
            this.title = p3;
            this.sender = p4;
            this.emotion = p5;
            this.sendTime = p6;
            this.status = p7;
        }

        public TitleLists(string p1, string p2, string p3, string p4, string p5, string p6, string p7, string p8, string p9)
        {
            this.titleNo = p1;
            this.url = p2;
            this.title = p3;
            this.sender = p4;
            this.emotion = p5;
            this.sendTime = p6;
            this.status = p7;
            this.content = p8;
            this.user = p9;
        }
        public override string ToString()
        {
            return titleNo + delimiter + title + delimiter + sender + delimiter + sendTime + delimiter + emotion + delimiter + status ;
        }
        public string ToStringNew()
        {
            return titleNo + delimiter + title + delimiter + sender + delimiter + sendTime + delimiter 
                    + emotion + delimiter + status + delimiter + user;
        }
        //パスを指定して内容を書き込み
        public int WriteLine(string path)
        {
            using (StreamWriter sw = new StreamWriter(path))
            {
                    sw.WriteLine(this.ToString());
            }
            return 0;
        }

        //StreamWriteを指定して書き込み
        public int WriteLine(StreamWriter sw)
        {
            sw.WriteLine(this.ToString());
            return 0;
        }
        public int WriteLine(StreamWriter sw, bool newFlag)
        {
            if (!newFlag) {
                sw.WriteLine(this.ToString());
            } else {
                sw.WriteLine(this.ToStringNew());
            }
            return 0;
        }        /// <summary>
        /// TitleNoをint型で返す
        /// </summary>
        /// <returns></returns>
        public int GetTitleNo(){
            return int.Parse(titleNo);
        }
    }

    /// <summary>
    /// 状態変数 - このアプリの核
    /// 本来なら全てprivate->getter/setter とすべきだが、コーディングが面倒なので
    /// 明確な理由が在るもののみprivateプロパティにする。
    ///  
    /// </summary>
    public class CurrentContext
    {
        public string nextPage = "";
        public string prevPage = "";

        private string codeAndExchange = ""; // 市場コードつき銘柄コード ( 5202,t )
        private string code = "";            // 銘柄コード  ( 5202 ) ※padと対になる為、直接アクセスは許さない
        private string pad;                  // "0" パディング用のコード 
        public string comapnyName = "";      // 会社名
        public string title;                 // タイトル(カブラウザもどき+銘柄名称)
        public string tid;                   // 掲示板のTopic ID
        public string sid;                   // 掲示板のSID
        public string board;                 // 掲示板のBoard
        public string postUrl;               // 新規投稿するためのURL
        public string maxTilteNo;            // 最新のタイトルNo
        public string mid;                   // 現在表示している message id
        public uint maxRow;
        public string close = "";            // 終値
        public string change = "";           // 前日比
        private AbstractGetYahoo yahoo;
        private YahooSkin skin;              // スキン用の情報


        public StreamReader topicSr;
        public StreamWriter topicSw;
        public TitleLists[] t;
        public string selectedTitle = ""; // 表示中メッセージのタイトル(非常に古いメッセージを表示する為に必要)
        private bool lockflag = false;       // ロック中
        /// <summary>
        /// コンストラクタ - 画面に表示する最大件数を渡してオブジェクト生成
        /// </summary>
        /// <param name="maxRow"></param>
        public CurrentContext(uint maxRow)
        {
            this.maxRow = maxRow;
            this.lockflag = false;
            TitleLists[] instance = new TitleLists[maxRow];
            for (int i = 0; i < maxRow; i++)
            {
                instance[i] = new TitleLists();
            }
            this.t = instance;
        }
        /// <summary>
        /// 表示中のタイトルリストをファイルに保存する
        /// </summary>
        /// <returns></returns>
        public int Save()
        {
            string path = Form1.csDatDir + code + ".dat";
            topicSw = new StreamWriter(path);
            foreach (TitleLists tmp in t)
            {
                tmp.WriteLine(topicSw);
            }
            topicSw.Close();
            topicSw = null;
            return 0;
        }
        /// <summary>
        /// パディング文字列を返す
        /// </summary>
        /// <returns></returns>
        public string GetPad()
        {
            return this.pad;
        }
        /// <summary>
        /// 銘柄コードを返す
        /// </summary>
        /// <returns></returns>
        public string GetCode()
        {
            return this.code;
        }
        /// <summary>
        /// 銘柄コードをセットする、と同時にゼロ埋め用の
        /// pad変数をセットする。
        /// </summary>
        /// <param name="code"></param>
        public void SetCode(string code)
        {
            int ret = 0;
            this.code = code.Trim();
            if (code.Length == 6) pad = "";
            if (code.Length == 5) pad = "0";
            if (code.Length == 4) pad = "00";

            ret = yahoo.GetTopicId(code, false);
            ret = yahoo.GetBorad(code);
            ret = yahoo.GetSid(code);
        
        }

        /// <summary>
        /// TitleNoの最大値をint型で返す
        /// </summary>
        /// <returns></returns>
        public int GetMaxTitleNo()
        {
            return int.Parse(maxTilteNo);
        }
        /// <summary>
        /// オブジェクトの保有するTitle List一覧をクリアする。
        /// 次のページを表示する場合呼び出す。
        /// </summary>
        public void ClearTitleList()  {
            for (int i = 0; i < maxRow; i++)
            {
                t[i].Clear();
            }
        }
        public YahooSkin GetSkin()
        {
            return this.skin;
        }
        public void SetSkin(YahooSkin skin)
        {
            this.skin = skin;
        }
        public void SetYahooInstance(AbstractGetYahoo yahoo)
        {
            this.yahoo = yahoo;
        }
        
        public string GetCodeAndExchange()
        {
            return this.codeAndExchange;
        }
        public void SetCodeAndExchange(string codeAndExchange)
        {
            this.codeAndExchange = codeAndExchange;
        }
        /// <summary>
        /// このオブジェクトの内容をクリアする
        /// 別の銘柄コードを選択時に呼び出す事。
        /// </summary>
        public void Clear()
        {
            this.tid = "";
            this.pad = "";
            this.code = "";
            this.comapnyName = "";
            this.postUrl = "";
            this.prevPage = "";
            this.nextPage = "";
            this.maxTilteNo = "0";
            this.ClearTitleList();
            this.topicSr = null;
            this.topicSw = null;
            this.lockflag = false;
        }
        
        /// <summary>
        /// このオブジェクトのロックを取得する
        /// </summary>
        /// <returns></returns>
        public bool Lock() {
            bool ret ;
            if (lockflag) {
                ret = false;
            } else {
                lockflag = true;
                ret = true;
            }
            return ret ;
        }
        /// <summary>
        /// このオブジェクトのロックを解放する
        /// </summary>
        /// <returns></returns>
        public void UnLock()
        {
            lockflag = false;
        }
    }

    /// <summary>
    /// 既読/未読制御クラス
    /// 銘柄コードをASCIIコードで、MIDをバイナリで保存
    /// ※いい加減な実装である
    /// </summary>
    public class KVisited
    {
        public Hashtable codes = new Hashtable();   // 銘柄コード
        
        public KVisited() {
            if (!File.Exists(Form1.csSaveFile)) {
                File.Create(Form1.csSaveFile);
            } else {
                byte[] readbuf = new byte[10];
                string code = "";
                using (FileStream fs = new FileStream(Form1.csSaveFile, FileMode.Open, FileAccess.Read))
                {
                    BinaryReader br = new BinaryReader(fs);
                    try {
                        int mid = 0;
                        int mid_plus = 0;
                        bool odd_byte = true;
                        for (; ; ) {
                            int i = br.ReadInt32();
                            if (i == -2 ) {
                                if (mid_plus == -1) {
                                    byte[] bb;
                                    bb = BitConverter.GetBytes(mid);
                                    code = Encoding.ASCII.GetString(bb);
                                } else {
                                    byte[] bb;
                                    bb = BitConverter.GetBytes(mid_plus);
                                    code = Encoding.ASCII.GetString(bb);
                                    bb = BitConverter.GetBytes(mid);
                                    code += Encoding.ASCII.GetString(bb,0,2);
                                }
                                codes[code] = new List<int>();
                                odd_byte = true;
                            } else if (i == -1) {
                                ((List<int>)(codes[code])).Add(mid);
                                odd_byte = true;
                            } else {
                                // 区切り文字以外のコードが連続
                                mid_plus = (odd_byte) ?  -1 :  mid;
                                mid = i;
                                odd_byte = false;
                            }
                        }
                    }
                    catch (EndOfStreamException eof) {
                        br.Close();
                        fs.Dispose();
                    }
                }
            }
        }        
        
        public Hashtable GetCodes()
        {
            return this.codes;
        }
        public List<int> GetMessages(string code)
        {
            return (List<int>)codes[code];
        }
        public Hashtable GetMessagesHt(string code)
        {
            Hashtable ht = new Hashtable();
            if (codes[code] != null) {
                foreach (int msg in (List<int>)codes[code]) {
                    string s = msg.ToString();
                    ht[s] = msg;
                }
            }
            return ht;
        }
        public void AddMessage( string code, string mid ){
            if ( codes[code] == null ) {
                codes[code] = new List<int>();
            }
            ((List<int>)(codes[code])).Add(int.Parse(mid));
        }
        public byte[] ToStream(ref int size)
        {
            const int BUFSIZE = 1000000;
            int offset = 0;
            string ret = "";
            byte[] b = new byte[BUFSIZE];
            for (int i = 0; i < BUFSIZE; i++) {
                b[i] = 0x00;
            }
            foreach ( string key in codes.Keys ) {
                int keylength = key.Length;
                // 銘柄コード
                foreach (byte bb in Encoding.ASCII.GetBytes(key)) {
                    b[offset] = bb;
                    offset++;
                }
                switch (keylength % 4) {
                    case 1:
                        b[offset] = 0xff;
                        b[++offset] = 0x00;
                        b[++offset] = 0x00;
                        offset++;
                        break;
                    case 2:
                        b[offset] = 0x00;
                        b[++offset] = 0x00;
                        offset++;
                        break;
                    case 3:
                        b[offset] = 0x00;
                        offset++;
                        break;
                    default:
                        break;
                }
                foreach (byte bb in BitConverter.GetBytes(-2)) {
                    b[offset] = bb;
                    offset++;
                }

                // 銘柄コードに紐づくメッセージID
                List<int> msgs = (List<int>)codes[key];
                foreach (int val in msgs) {
                    foreach (byte bb in BitConverter.GetBytes(val)) {
                        b[offset] = bb;
                        offset++;
                    }
                    foreach (byte bb in BitConverter.GetBytes(-1)) {
                        b[offset] = bb;
                        offset++;
                    }
                }
            }
            size = offset;
            return b;
        }
        public void Save()
        {
            if (!File.Exists(Form1.csSaveFile)) {
                File.Create(Form1.csSaveFile);
            }
            using (FileStream fs = new FileStream(Form1.csSaveFile, FileMode.Open, FileAccess.Write)) {
                int size = 0;
                byte[] b = ToStream(ref size);
                fs.Write(b, 0, size);
                //foreach (byte bb in b) {
                //}
                //fs.Close();
                fs.Dispose();
            }
            return ;
        }
    }

    /// <summary>
    /// Yahooスキン
    /// </summary>
    public class YahooSkin
    {
        private Hashtable yTemplate = new Hashtable();   // メッセージ表示置き換え用のテンプレー
        private string skinfile = "";
        private string skinHtml = "";

        public YahooSkin(string skin) {
            yTemplate["&TITLE"] = "";
            yTemplate["&DATE"] = "";
            yTemplate["&NUMBER"] = "";
            yTemplate["&COUNT"] = "";
            yTemplate["&FEELINGS"] = "";
            yTemplate["&NAME"] = "";
            yTemplate["&MESSAGE"] = "";
            yTemplate["&RESURL"] = "";
            yTemplate["&RESNUMBER"] = "";
            yTemplate["&RESNAME"] = "";
            yTemplate["&ABUSEURL"] = "";
            yTemplate["&COMPANYNAME"] = "";
            yTemplate["&COMPANYURL"] = "";
            yTemplate["&CHARTURL"] = "";
            yTemplate["&CHARTIMG"] = "";
            yTemplate["&CHARTDATE"] = "";
            yTemplate["&CHANGE"] = "";
            yTemplate["&CLOSE"] = "";
            yTemplate["&CODE"] = "";

            // これ以降はカブラウザもどき独自
            yTemplate["&M_FINDMSG"] = "";    // 投稿者の投稿一覧
            yTemplate["&M_NICKNAME"] = "";   // USERニックネーム
            yTemplate["&M_COMMENT_THM"] = ""; // USERサムネイル
            this.skinfile = @".\skin\" + skin;
            setSkinHtml(this.skinfile);
        }

        public string get(string key)
        {
            return (string)yTemplate[key];
        }
        public void set(string key, string value)
        {
            this.yTemplate[key] = value;
        }
        public string getConvertedHtml() {
            string afterconvert = skinHtml;
            foreach (string name in yTemplate.Keys)
            {
                afterconvert= afterconvert.Replace(name, yTemplate[name].ToString());
            }
            return afterconvert;
        }
        public void Clear()
        {
            /*
            try
            {
                for (int i = 0; i < yTemplate.Count; i++ )
                {
                    yTemplate[i] = "";
                }
            }
            catch (InvalidOperationException e)
            {
            }*/
        }
        public void setSkinHtml(string skinfile){
            using (StreamReader sr = new StreamReader(skinfile, Encoding.GetEncoding("Shift_JIS")))
            {
                this.skinHtml = sr.ReadToEnd();
                sr.Close();
            }
        }

        /// <summary>
        ///  YahooSkinに銘柄独自の情報をセットする
        ///  メッセーに紐づく情報はGetContentsFromPCSite()でセット
        /// </summary>
        /// <param name="context"></param>
        public void ContextToSkin(CurrentContext context){
            this.Clear();

            yTemplate["&TITLE"] = context.selectedTitle;
            yTemplate["&CODE"] = context.GetCodeAndExchange();
            yTemplate["&COUNT"] = context.GetMaxTitleNo().ToString();
            yTemplate["&COMPANYNAME"] = context.comapnyName;
            yTemplate["&CHARTURL"] = "http://stocks.finance.yahoo.co.jp/stocks/chart/?code=" + context.GetCodeAndExchange();
            yTemplate["&CHARTIMG"] = "http://rchart.yahoo.co.jp/t?s=" + context.GetCodeAndExchange();
            //yTemplate["&CHARTDATE"] = "";
            //yTemplate["&CHANGE"] = "";
            //yTemplate["&CLOSE"] = "";
            //yTemplate["&M_NICKNAME"] = "";
            //yTemplate["&M_FINDMSG"] = "";
            //yTemplate["&M_COMMENT_THM"] = context.
        }

    }

    /// <summary>
    /// 比較クラス
    /// </summary>
    class ListViewItemComparer : IComparer
    {
        private int col;
        private int sortOrder;

        // コンストラクタ
        public ListViewItemComparer(int col, int sortOrder)
        {
            this.col = col;
            this.sortOrder = sortOrder;
        }
        // 比較メソッド
        public int Compare(object x, object y)
        {
            int ret = 0;
            switch (col)
            {
                case 0:    // 文字列でソート
                    ret = String.Compare(((ListViewItem)x).SubItems[col].Text,
                        ((ListViewItem)y).SubItems[col].Text);
                    break;
                case 1:    // 数値でソート
                    ret = int.Parse(((ListViewItem)x).SubItems[col].Text) <
                       int.Parse(((ListViewItem)y).SubItems[col].Text) ? -1 : 1;
                    break;
            }
            return ret * sortOrder;
        }
    }


}