package org.junitdoc.ui.events;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.junitdoc.JUnitDocPlugin;

public class TreeMouseAdapter extends MouseAdapter {

	private Tree tree;

	public TreeMouseAdapter(Tree tree) {
		this.tree = tree;
	}

	@Override
	public void mouseDown(MouseEvent e) {
		TreeMouseEvent event = toTreeTableEvent(e);

		if (event != null) {
			mouseDown(event);
		}
	}

	@Override
	public void mouseUp(MouseEvent e) {
		TreeMouseEvent event = toTreeTableEvent(e);

		if (event != null) {
			mouseUp(event);
		}
	}

	@Override
	public void mouseDoubleClick(MouseEvent e) {
		TreeMouseEvent event = toTreeTableEvent(e);

		if (event != null) {
			mouseDoubleClick(event);
		}
	}

	public void mouseUp(TreeMouseEvent event) {
	}

	public void mouseDown(TreeMouseEvent event) {
	}

	public void mouseDoubleClick(TreeMouseEvent event) {
	}

	private TreeMouseEvent toTreeTableEvent(MouseEvent e) {
		int index = tree.getSelectionCount();
		if (index == -1) {
			return null;
		}

		JUnitDocPlugin.debugLog("event:" + e);

		Point point = new Point(e.x, e.y);
		TreeItem treeItem = tree.getItem(point);
		if (treeItem == null) {
			return null;
		}

		for (int columnIndex = 0; columnIndex < tree.getColumnCount(); columnIndex++) {
			if (treeItem.getBounds(columnIndex).contains(point)) {
				if (treeItem.getText(columnIndex) == null) {
					return null;
				}

				TreeColumn selectedColumn = tree.getColumn(columnIndex);

				TreeMouseEvent event = new TreeMouseEvent(e, treeItem,
						selectedColumn, columnIndex);
				return event;
			}
		}
		return null;
	}
}
