package org.junitdoc.ui.dialogs;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.dialogs.IInputValidator;
import org.junitdoc.core.util.JavaNameChecker;
import org.junitdoc.ui.UIMessages;

public class JavaInputValidator implements IInputValidator {

	public static enum ValidationType {
		LENGTH_ZERO, JAVA_IDENTIFIER
	}

	private Map<ValidationType, String> messages = new HashMap<ValidationType, String>();

	public JavaInputValidator() {
		setValidationMessage(ValidationType.LENGTH_ZERO, "Input");
		setValidationMessage(ValidationType.JAVA_IDENTIFIER, UIMessages
				.getString("DecisionTableViewPart.javavalidmessage"));
	}

	public void setValidationMessage(ValidationType type, String message) {
		messages.put(type, message);
	}

	public String isValid(String value) {

		if (value.length() == 0) {
			return messages.get(ValidationType.LENGTH_ZERO);
		}

		if (JavaNameChecker.isJavaIdentifier(value)) {
			return messages.get(ValidationType.JAVA_IDENTIFIER);
		}
		return null; // OK
	}
}